/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyEmailAccountAdmins;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyUseServerDefault;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseThreatDetectionPolicy;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlDatabaseThreatDetectionPolicyImpl
extends ExternalChildResourceImpl<SqlDatabaseThreatDetectionPolicy, DatabaseSecurityAlertPolicyInner, SqlDatabaseImpl, SqlDatabase>
implements SqlDatabaseThreatDetectionPolicy,
SqlDatabaseThreatDetectionPolicy.SqlDatabaseThreatDetectionPolicyDefinition,
SqlDatabaseThreatDetectionPolicy.Update {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    protected SqlDatabaseThreatDetectionPolicyImpl(String name, SqlDatabaseImpl parent, DatabaseSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withLocation(parent.regionName());
    }

    public String name() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).name();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).id();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).location());
    }

    @Override
    public String kind() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).kind();
    }

    @Override
    public SecurityAlertPolicyState currentState() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).state();
    }

    @Override
    public String disabledAlerts() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).disabledAlerts();
    }

    @Override
    public String emailAddresses() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).emailAddresses();
    }

    @Override
    public boolean emailAccountAdmins() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).emailAccountAdmins() == SecurityAlertPolicyEmailAccountAdmins.ENABLED;
    }

    @Override
    public String storageEndpoint() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).retentionDays();
    }

    @Override
    public boolean isDefaultSecurityAlertPolicy() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).useServerDefault() == SecurityAlertPolicyUseServerDefault.ENABLED;
    }

    protected Mono<DatabaseSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseThreatDetectionPolicies().getAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), SecurityAlertPolicyName.DEFAULT);
    }

    public Mono<SqlDatabaseThreatDetectionPolicy> createResourceAsync() {
        SqlDatabaseThreatDetectionPolicyImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseThreatDetectionPolicies().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), SecurityAlertPolicyName.DEFAULT, (DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).map(databaseSecurityAlertPolicyInner -> {
            self.setInner(databaseSecurityAlertPolicyInner);
            return self;
        });
    }

    public Mono<SqlDatabaseThreatDetectionPolicy> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public SqlDatabaseThreatDetectionPolicy.Update update() {
        super.prepareUpdate();
        return this;
    }

    public Mono<Void> deleteResourceAsync() {
        return null;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyEnabled() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withState(SecurityAlertPolicyState.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyDisabled() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withState(SecurityAlertPolicyState.DISABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyNew() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withState(SecurityAlertPolicyState.NEW);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withDefaultSecurityAlertPolicy() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageEndpoint(String storageEndpoint) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageEndpoint(storageEndpoint);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageAccountAccessKey(String storageAccountAccessKey) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(String alertsFilter) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withDisabledAlerts(alertsFilter);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(String addresses) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAddresses(addresses);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withRetentionDays(int retentionDays) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withRetentionDays(retentionDays);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAccountAdmins(SecurityAlertPolicyEmailAccountAdmins.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withoutEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAccountAdmins(SecurityAlertPolicyEmailAccountAdmins.DISABLED);
        return this;
    }
}

