/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.DatabaseEdition;
import com.azure.resourcemanager.sql.models.ExportRequest;
import com.azure.resourcemanager.sql.models.ServiceObjectiveName;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImportRequest
extends ExportRequest {
    @JsonProperty(value="databaseName", required=true)
    private String databaseName;
    @JsonProperty(value="edition", required=true)
    private DatabaseEdition edition;
    @JsonProperty(value="serviceObjectiveName", required=true)
    private ServiceObjectiveName serviceObjectiveName;
    @JsonProperty(value="maxSizeBytes", required=true)
    private String maxSizeBytes;
    private static final ClientLogger LOGGER = new ClientLogger(ImportRequest.class);

    public String databaseName() {
        return this.databaseName;
    }

    public ImportRequest withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public DatabaseEdition edition() {
        return this.edition;
    }

    public ImportRequest withEdition(DatabaseEdition edition) {
        this.edition = edition;
        return this;
    }

    public ServiceObjectiveName serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    public ImportRequest withServiceObjectiveName(ServiceObjectiveName serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ImportRequest withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    @Override
    public ImportRequest withStorageKeyType(StorageKeyType storageKeyType) {
        super.withStorageKeyType(storageKeyType);
        return this;
    }

    @Override
    public ImportRequest withStorageKey(String storageKey) {
        super.withStorageKey(storageKey);
        return this;
    }

    @Override
    public ImportRequest withStorageUri(String storageUri) {
        super.withStorageUri(storageUri);
        return this;
    }

    @Override
    public ImportRequest withAdministratorLogin(String administratorLogin) {
        super.withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public ImportRequest withAdministratorLoginPassword(String administratorLoginPassword) {
        super.withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public ImportRequest withAuthenticationType(AuthenticationType authenticationType) {
        super.withAuthenticationType(authenticationType);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.databaseName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model ImportRequest"));
        }
        if (this.edition() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property edition in model ImportRequest"));
        }
        if (this.serviceObjectiveName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property serviceObjectiveName in model ImportRequest"));
        }
        if (this.maxSizeBytes() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property maxSizeBytes in model ImportRequest"));
        }
    }
}

