/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client;

import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.rpc.proxy.JDKProxyFactory;
import com.baidu.cloud.starlight.springcloud.client.annotation.RpcProxy;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RpcProxyFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    private Class<?> type;
    private Object proxy;
    private RpcProxy annotationInfos;
    private StarlightClient client;
    private StarlightClientProperties clientProperties;
    private ServiceConfig serviceConfig;

    public Object getObject() throws Exception {
        if (this.proxy != null) {
            return this.proxy;
        }
        this.proxy = this.getProxy();
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public void afterPropertiesSet() throws Exception {
        this.serviceConfig = new ServiceConfig();
        this.serviceConfig.setProtocol(this.getProtocol());
        this.serviceConfig.setCompressType(this.getCompressType());
        this.serviceConfig.setFilters(this.getFilters());
        this.serviceConfig.setServiceId(this.annotationInfos.serviceId());
        this.serviceConfig.setInvokeTimeoutMills(this.getRequestTimeout());
        this.serviceConfig.setSerializeMode(this.serializeMode());
        this.proxy = this.getProxy();
    }

    private <T> T getProxy() {
        JDKProxyFactory proxyFactory = new JDKProxyFactory();
        return (T)proxyFactory.getProxy(this.type, this.serviceConfig, this.client);
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setAnnotationInfos(RpcProxy annotationInfos) {
        this.annotationInfos = annotationInfos;
    }

    public void setClient(StarlightClient client) {
        this.client = client;
    }

    public void setClientProperties(StarlightClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    private String getProtocol() {
        if (!StringUtils.isEmpty((String)this.annotationInfos.protocol())) {
            return this.annotationInfos.protocol();
        }
        return this.clientProperties.getProtocol(this.annotationInfos.name());
    }

    private String getCompressType() {
        return this.clientProperties.getCompressType(this.annotationInfos.name());
    }

    private String getFilters() {
        return this.clientProperties.getFilters(this.annotationInfos.name());
    }

    private Integer getRequestTimeout() {
        return this.clientProperties.getRequestTimeoutMills(this.annotationInfos.name(), this.type.getName());
    }

    private String serializeMode() {
        return this.clientProperties.getSerializeMode(this.annotationInfos.name());
    }
}

