/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.outlier;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.heartbeat.Heartbeat;
import com.baidu.cloud.starlight.api.heartbeat.HeartbeatRpcRequestHolder;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.ResultFuture;
import com.baidu.cloud.starlight.api.model.RpcRequest;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.core.rpc.callback.FutureCallback;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.OutlierConfig;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightServerListFilter;
import com.baidu.cloud.starlight.springcloud.common.ClusterLogUtils;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.baidu.cloud.thirdparty.netty.util.TimerTask;
import com.netflix.loadbalancer.Server;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class OutlierEjectServerListFilter
implements StarlightServerListFilter<Server> {
    private static final Integer OUTLIER_LOG_RECORD_DURATION = 30000;
    private static final String FORCED_RECOVERY_HEALTH = "forced recovery as configured";
    private static final String RECOVERY_HEALTH = "recovery because detected health";
    private static final String RECOVERY_FAIL = "3 consecutive tests failed";
    private final SingleStarlightClientManager singleStarlightClientManager;
    private final StarlightClientProperties clientProperties;
    private final Map<String, Timeout> outlierRecoverTasks;
    private final String clientName;

    public OutlierEjectServerListFilter(SingleStarlightClientManager clientManager, StarlightClientProperties clientProperties, String clientName) {
        this.singleStarlightClientManager = clientManager;
        this.clientProperties = clientProperties;
        this.clientName = clientName;
        this.outlierRecoverTasks = new ConcurrentHashMap<String, Timeout>();
    }

    @Override
    public List<Server> getFilteredList(List<Server> originList) {
        long startTime = System.currentTimeMillis();
        int originSize = originList.size();
        if (originSize <= 1) {
            LOGGER.info("Original server instance size is {}, less than or equals 1 will not eject.", originList);
            return originList;
        }
        String clientName = this.getClientName();
        OutlierConfig outlierConfig = this.clientProperties.getOutlierConfig(clientName);
        if (!outlierConfig.getEnabled().booleanValue()) {
            return originList;
        }
        LinkedList<Server> filtered = new LinkedList<Server>(originList);
        try {
            double maxEjectCountDouble = (double)outlierConfig.getMaxEjectPercent().intValue() / 100.0 * (double)originSize;
            if (maxEjectCountDouble < 0.5) {
                LOGGER.info("Max eject count of {} is 0, max eject double {}, origin size {}, maxEjectPercent {}", new Object[]{this.getClientName(), maxEjectCountDouble, originSize, outlierConfig.getMaxEjectPercent()});
            }
            int maxEjectCount = (int)Math.round(maxEjectCountDouble);
            int ejectCount = 0;
            for (Server server : originList) {
                if (ejectCount >= maxEjectCount) {
                    LOGGER.info("Reach the max eject count {}, will not eject.", (Object)maxEjectCount);
                    break;
                }
                SingleStarlightClient client = this.singleStarlightClientManager.getSingleClient(server.getHost(), server.getPort());
                if (client == null || client.getStatus() == null || !PeerStatus.Status.OUTLIER.equals((Object)client.getStatus().getStatus())) continue;
                filtered.remove(server);
                ++ejectCount;
                if (System.currentTimeMillis() - client.getStatus().getStatusRecordTime() < (long)OUTLIER_LOG_RECORD_DURATION.intValue()) {
                    ClusterLogUtils.logOutlierInstanceEject(LOGGER, this.getClientName(), server, client.getStatus());
                }
                this.submitTimerTask(server, outlierConfig.getBaseEjectTime());
            }
            if (ejectCount > 0) {
                ClusterLogUtils.logOutlierAppEject(LOGGER, this.getClientName(), originSize, ejectCount, maxEjectCount);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("OutlierEjectServerListFilter getFilteredList failed, will use all instances, caused by ", e);
        }
        LOGGER.debug("OutlierEjectServerListFilter getFilteredList cost {}", (Object)(System.currentTimeMillis() - startTime));
        return filtered;
    }

    @Override
    public SingleStarlightClientManager getSingleClientManager() {
        return this.singleStarlightClientManager;
    }

    public int getOrder() {
        return SpringCloudConstants.OUTLIER_SEVER_LIST_FILTER_ORDER;
    }

    @Override
    public Map<String, Timeout> getServerListFilterTasks() {
        return this.outlierRecoverTasks;
    }

    @Override
    public synchronized void submitTimerTask(Server server, Integer ejectTime) {
        String clientName = this.getClientName();
        OutlierConfig outlierConfig = this.clientProperties.getOutlierConfig(clientName);
        if (this.outlierRecoverTasks.get(server.getHostPort()) != null && outlierConfig.getBaseEjectTime().equals(ejectTime)) {
            return;
        }
        LOGGER.debug("Add new detect timer server {}, eject time {}s", (Object)server.getHostPort(), (Object)ejectTime);
        Timeout timeout = SERVER_LIST_FILTER_TIMER.newTimeout((TimerTask)new OutlierRecoverTask(server, ejectTime, outlierConfig), (long)ejectTime.intValue(), TimeUnit.SECONDS);
        this.outlierRecoverTasks.put(server.getHostPort(), timeout);
    }

    @Override
    public void destroy() {
        if (this.outlierRecoverTasks.size() > 0) {
            for (Map.Entry<String, Timeout> task : this.outlierRecoverTasks.entrySet()) {
                if (task == null || task.getValue() == null) continue;
                task.getValue().cancel();
            }
        }
    }

    private String getClientName() {
        return this.clientName;
    }

    private class OutlierRecoverTask
    implements TimerTask {
        private final Server server;
        private final OutlierConfig outlierConfig;
        private final Integer lastEjectTime;

        public OutlierRecoverTask(Server server, Integer lastEjectTime, OutlierConfig outlierConfig) {
            this.server = server;
            this.outlierConfig = outlierConfig;
            this.lastEjectTime = lastEjectTime;
        }

        public void run(Timeout timeout) throws Exception {
            SingleStarlightClient singleClient = OutlierEjectServerListFilter.this.singleStarlightClientManager.getSingleClient(this.server.getHost(), this.server.getPort());
            if (singleClient == null) {
                return;
            }
            if (!PeerStatus.Status.OUTLIER.equals((Object)singleClient.getStatus().getStatus())) {
                return;
            }
            if (!this.outlierConfig.getRecoverByCheckEnabled().booleanValue()) {
                singleClient.updateStatus(new PeerStatus(PeerStatus.Status.ACTIVE, Long.valueOf(System.currentTimeMillis())));
                OutlierEjectServerListFilter.this.getServerListFilterTasks().remove(this.server.getHostPort());
                ClusterLogUtils.logOutlierRecoverySucc(StarlightServerListFilter.LOGGER, OutlierEjectServerListFilter.this.getClientName(), this.server, OutlierEjectServerListFilter.FORCED_RECOVERY_HEALTH, this.lastEjectTime);
                return;
            }
            ServiceConfig serviceConfig = new ServiceConfig();
            serviceConfig.setInvokeTimeoutMills(SpringCloudConstants.HEARTBEAT_REQUEST_TIMEOUT);
            int heartbeatSucCount = 0;
            for (int i = 0; i < 3; ++i) {
                RpcRequest heartbeatReq = HeartbeatRpcRequestHolder.heartbeatRequest();
                heartbeatReq.setServiceConfig(serviceConfig);
                try {
                    ResultFuture resultFuture = new ResultFuture();
                    FutureCallback rpcCallback = new FutureCallback(resultFuture, (Request)heartbeatReq);
                    singleClient.request((Request)heartbeatReq, (RpcCallback)rpcCallback);
                    Object result = resultFuture.get();
                    if (result instanceof Heartbeat && "PONG".equals(((Heartbeat)result).getMessage())) {
                        ++heartbeatSucCount;
                        continue;
                    }
                    StarlightServerListFilter.LOGGER.warn("Outlier recover heartbeat receive response from {} success, but message is not correct {}", (Object)this.server.getHostPort(), result);
                    continue;
                }
                catch (Throwable exp) {
                    StarlightRpcException rpcException;
                    if (!(exp instanceof StarlightRpcException) || !StarlightRpcException.SERVICE_NOT_FOUND_EXCEPTION.equals((rpcException = (StarlightRpcException)exp).getCode())) continue;
                    ++heartbeatSucCount;
                }
            }
            if (heartbeatSucCount >= 3) {
                singleClient.updateStatus(new PeerStatus(PeerStatus.Status.ACTIVE, Long.valueOf(System.currentTimeMillis())));
                OutlierEjectServerListFilter.this.getServerListFilterTasks().remove(this.server.getHostPort());
                ClusterLogUtils.logOutlierRecoverySucc(StarlightServerListFilter.LOGGER, OutlierEjectServerListFilter.this.getClientName(), this.server, OutlierEjectServerListFilter.RECOVERY_HEALTH, this.lastEjectTime);
            } else {
                int nextEjectTime = this.lastEjectTime + this.outlierConfig.getBaseEjectTime();
                if (nextEjectTime > this.outlierConfig.getMaxEjectTime()) {
                    nextEjectTime = this.outlierConfig.getMaxEjectTime();
                }
                ClusterLogUtils.logOutlierRecoveryFail(StarlightServerListFilter.LOGGER, OutlierEjectServerListFilter.this.getClientName(), this.server, OutlierEjectServerListFilter.RECOVERY_FAIL, this.lastEjectTime, nextEjectTime);
                OutlierEjectServerListFilter.this.submitTimerTask(this.server, (Integer)nextEjectTime);
            }
        }
    }
}

