/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.properties;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.springcloud.client.properties.ClientConfig;
import com.baidu.cloud.starlight.springcloud.client.properties.OutlierConfig;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="starlight.client")
public class StarlightClientProperties {
    static final String PREFIX = "starlight.client";
    private String defaultConfig = "default";
    private Integer bizThreadNum;
    private Integer ioRatio;
    private Map<String, ClientConfig> config = new HashMap<String, ClientConfig>();

    public Map<String, ClientConfig> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, ClientConfig> config) {
        this.config = config;
    }

    public ClientConfig getClientConfig(String clientName) {
        return this.config.get(clientName);
    }

    public String getDefaultConfig() {
        return this.defaultConfig;
    }

    public Integer getBizThreadNum() {
        return this.bizThreadNum;
    }

    public void setBizThreadNum(Integer bizThreadNum) {
        this.bizThreadNum = bizThreadNum;
    }

    public Integer getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(Integer ioRatio) {
        this.ioRatio = ioRatio;
    }

    public StarlightClientProperties() {
        this.config.putIfAbsent(this.defaultConfig, new ClientConfig());
    }

    public TransportConfig transportConfig(String name) {
        TransportConfig transportConfig = new TransportConfig();
        transportConfig.setIoThreadNum(this.getIoThreadNum(name));
        transportConfig.setConnectTimeoutMills(this.getConnectTimeoutMills(name));
        transportConfig.setMaxHeartbeatTimes(this.getMaxHeartbeatTimes(name));
        transportConfig.setWriteTimeoutMills(this.getWriteTimeoutMills(name));
        transportConfig.setReadIdleTimeout(this.getReadIdleTimeout(name));
        transportConfig.setRequestTimeoutMills(this.getRequestTimeoutMills(name));
        transportConfig.setChannelType(this.getChannelType(name));
        transportConfig.setMaxConnections(this.getMaxConnections(name));
        transportConfig.setMaxIdleConnections(this.getMaxIdleConnections(name));
        transportConfig.setMinIdleConnections(this.getMinIdleConnections(name));
        transportConfig.setConnectKeepAliveEnable(this.getConnectKeepAliveEnable(name));
        transportConfig.setBizWorkThreadNum(this.bizThreadNum);
        transportConfig.setIoRatio(this.ioRatio);
        return transportConfig;
    }

    public Integer getIoThreadNum(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getIoThreadNum() != null) {
            return clientConfig.getIoThreadNum();
        }
        if (globalConfig != null && globalConfig.getIoThreadNum() != null) {
            return globalConfig.getIoThreadNum();
        }
        return Constants.DEFAULT_IO_THREADS_VALUE;
    }

    public Integer getConnectTimeoutMills(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getConnectTimeoutMills() != null) {
            return clientConfig.getConnectTimeoutMills();
        }
        if (globalConfig != null && globalConfig.getConnectTimeoutMills() != null) {
            return globalConfig.getConnectTimeoutMills();
        }
        return Constants.CONNECT_TIMEOUT_VALUE;
    }

    public Integer getMaxHeartbeatTimes(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getMaxHeartbeatTimes() != null) {
            return clientConfig.getMaxHeartbeatTimes();
        }
        if (globalConfig != null && globalConfig.getMaxHeartbeatTimes() != null) {
            return globalConfig.getMaxHeartbeatTimes();
        }
        return 3;
    }

    public Integer getWriteTimeoutMills(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getWriteTimeoutMills() != null) {
            return clientConfig.getWriteTimeoutMills();
        }
        if (globalConfig != null && globalConfig.getWriteTimeoutMills() != null) {
            return globalConfig.getWriteTimeoutMills();
        }
        return Constants.WRITE_TIMEOUT_VALUE;
    }

    public Integer getReadIdleTimeout(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getReadIdleTimeout() != null) {
            return clientConfig.getReadIdleTimeout();
        }
        if (globalConfig != null && globalConfig.getReadIdleTimeout() != null) {
            return globalConfig.getReadIdleTimeout();
        }
        return 60;
    }

    public Integer getRequestTimeoutMills(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getRequestTimeoutMills() != null) {
            return clientConfig.getRequestTimeoutMills();
        }
        if (globalConfig != null && globalConfig.getRequestTimeoutMills() != null) {
            return globalConfig.getRequestTimeoutMills();
        }
        return Constants.REQUEST_TIMEOUT_VALUE;
    }

    public Integer getRequestTimeoutMills(String clientName, String className) {
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getRequestTimeoutMills(className) != null) {
            return clientConfig.getRequestTimeoutMills(className);
        }
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        if (globalConfig != null && globalConfig.getRequestTimeoutMills(className) != null) {
            return globalConfig.getRequestTimeoutMills(className);
        }
        return Constants.REQUEST_TIMEOUT_VALUE;
    }

    public Integer getWarmUpRatio(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getWarmUpRatio() != null) {
            return clientConfig.getWarmUpRatio();
        }
        if (globalConfig != null && globalConfig.getWarmUpRatio() != null) {
            return globalConfig.getWarmUpRatio();
        }
        return SpringCloudConstants.DEFAULT_WARM_UP_RATIO;
    }

    public Integer getWarmUpCount(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getWarmUpCount() != null) {
            return clientConfig.getWarmUpCount();
        }
        if (globalConfig != null && globalConfig.getWarmUpCount() != null) {
            return globalConfig.getWarmUpCount();
        }
        return null;
    }

    public String getChannelType(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getChannelType() != null) {
            return clientConfig.getChannelType();
        }
        if (globalConfig != null && globalConfig.getChannelType() != null) {
            return globalConfig.getChannelType();
        }
        return "long";
    }

    public String getClusterModel(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getClusterModel() != null) {
            return clientConfig.getClusterModel();
        }
        if (globalConfig != null && globalConfig.getClusterModel() != null) {
            return globalConfig.getClusterModel();
        }
        return "failfast";
    }

    public Integer getMaxConnections(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getMaxConnections() != null) {
            return clientConfig.getMaxConnections();
        }
        if (globalConfig != null && globalConfig.getMaxConnections() != null) {
            return globalConfig.getMaxConnections();
        }
        return Constants.MAX_TOTAL_CONNECTIONS;
    }

    public Integer getMaxIdleConnections(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getMaxIdleConnections() != null) {
            return clientConfig.getMaxIdleConnections();
        }
        if (globalConfig != null && globalConfig.getMaxIdleConnections() != null) {
            return globalConfig.getMaxIdleConnections();
        }
        return Constants.MAX_IDLE_CONNECTIONS;
    }

    public Integer getMinIdleConnections(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getMinIdleConnections() != null) {
            return clientConfig.getMinIdleConnections();
        }
        if (globalConfig != null && globalConfig.getMinIdleConnections() != null) {
            return globalConfig.getMinIdleConnections();
        }
        return Constants.MIN_IDLE_CONNECTIONS;
    }

    public String getProtocol(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getProtocol() != null) {
            return clientConfig.getProtocol();
        }
        if (globalConfig != null && globalConfig.getProtocol() != null) {
            return globalConfig.getProtocol();
        }
        return "brpc";
    }

    public String getCompressType(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getCompressType() != null) {
            return clientConfig.getCompressType();
        }
        if (globalConfig != null && globalConfig.getCompressType() != null) {
            return globalConfig.getCompressType();
        }
        return "none";
    }

    public String getFilters(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getFilters() != null) {
            return "outlierdetect,clientcontext,clientmonitor," + clientConfig.getFilters();
        }
        if (globalConfig != null && globalConfig.getFilters() != null) {
            return "outlierdetect,clientcontext,clientmonitor," + globalConfig.getFilters();
        }
        return "outlierdetect,clientcontext,clientmonitor";
    }

    public Integer getRetryTimes(String clientName, String className) {
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getRetryTimes(className) != null) {
            return clientConfig.getRetryTimes(className);
        }
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        if (globalConfig != null && globalConfig.getRetryTimes(className) != null) {
            return globalConfig.getRetryTimes(className);
        }
        return SpringCloudConstants.DEFAULT_RETRY_TIMES;
    }

    public Integer getRetryDelayTimeUnitMills(String clientName, String className) {
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getRetryDelayTimeUnitMills(className) != null) {
            return clientConfig.getRetryDelayTimeUnitMills(className);
        }
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        if (globalConfig != null && globalConfig.getRetryDelayTimeUnitMills(className) != null) {
            return globalConfig.getRetryDelayTimeUnitMills(className);
        }
        return SpringCloudConstants.DEFAULT_RETRY_DELAY_MILLS;
    }

    public String getRetryMethods(String clientName, String className) {
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getRetryMethods(className) != null) {
            return clientConfig.getRetryMethods(className);
        }
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        if (globalConfig != null && globalConfig.getRetryMethods(className) != null) {
            return globalConfig.getRetryMethods(className);
        }
        return null;
    }

    public String getRetryErrorCodes(String clientName, String className) {
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getRetryErrorCodes(className) != null) {
            return clientConfig.getRetryErrorCodes(className);
        }
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        if (globalConfig != null && globalConfig.getRetryErrorCodes(className) != null) {
            return globalConfig.getRetryErrorCodes(className);
        }
        return null;
    }

    public String getSerializeMode(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getSerializeMode() != null) {
            return clientConfig.getSerializeMode();
        }
        if (globalConfig != null && globalConfig.getSerializeMode() != null) {
            return globalConfig.getSerializeMode();
        }
        return "pb2-std";
    }

    public Boolean getConnectKeepAliveEnable(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getConnectKeepAliveEnable() != null) {
            return clientConfig.getConnectKeepAliveEnable();
        }
        if (globalConfig != null && globalConfig.getConnectKeepAliveEnable() != null) {
            return globalConfig.getConnectKeepAliveEnable();
        }
        return false;
    }

    public OutlierConfig getOutlierConfig(String clientName) {
        OutlierConfig outlierConfig = new OutlierConfig();
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        OutlierConfig globalOutlierConfig = null;
        if (globalConfig != null && globalConfig.getOutlier() != null) {
            globalOutlierConfig = globalConfig.getOutlier();
        }
        outlierConfig.merge(globalOutlierConfig);
        OutlierConfig clientOutlierConfig = null;
        if (clientConfig != null && clientConfig.getOutlier() != null) {
            clientOutlierConfig = clientConfig.getOutlier();
        }
        outlierConfig.merge(clientOutlierConfig);
        if (outlierConfig.getEnabled() == null) {
            outlierConfig.setEnabled(SpringCloudConstants.OUTLIER_DETECT_ENABLED);
        }
        if (outlierConfig.getDetectInterval() == null) {
            outlierConfig.setDetectInterval(SpringCloudConstants.OUTLIER_DETECT_INTERVAL);
        }
        if (outlierConfig.getFailurePercentMinRequest() == null) {
            outlierConfig.setFailurePercentMinRequest(SpringCloudConstants.OUTLIER_DETECT_MINI_REQUEST_NUM);
        }
        if (outlierConfig.getFailurePercentThreshold() == null) {
            outlierConfig.setFailurePercentThreshold(SpringCloudConstants.OUTLIER_DETECT_FAIL_PERCENT_THRESHOLD);
        }
        if (outlierConfig.getBaseEjectTime() == null) {
            outlierConfig.setBaseEjectTime(SpringCloudConstants.OUTLIER_DETECT_BASE_EJECT_TIME);
        }
        if (outlierConfig.getMaxEjectTime() == null) {
            outlierConfig.setMaxEjectTime(SpringCloudConstants.OUTLIER_DETECT_MAX_EJECT_TIME);
        }
        if (outlierConfig.getMaxEjectPercent() == null) {
            outlierConfig.setMaxEjectPercent(SpringCloudConstants.OUTLIER_DETECT_MAX_EJECT_PERCENT);
        }
        if (outlierConfig.getRecoverByCheckEnabled() == null) {
            outlierConfig.setRecoverByCheckEnabled(SpringCloudConstants.OUTLIER_RECOVER_BY_CHECK_ENABLED);
        }
        return outlierConfig;
    }

    public Integer getNetworkErrorRetryTimes(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getNetworkErrorRetryTimes() != null) {
            return clientConfig.getNetworkErrorRetryTimes();
        }
        if (globalConfig != null && globalConfig.getNetworkErrorRetryTimes() != null) {
            return globalConfig.getNetworkErrorRetryTimes();
        }
        return SpringCloudConstants.NETWORK_ERROR_RETRY_TIMES;
    }

    public Boolean getLocalCacheEnabled(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getLocalCacheEnabled() != null) {
            return clientConfig.getLocalCacheEnabled();
        }
        if (globalConfig != null && globalConfig.getLocalCacheEnabled() != null) {
            return globalConfig.getLocalCacheEnabled();
        }
        return SpringCloudConstants.LOCAL_CACHE_ENABLED;
    }

    public Boolean getStoreLocalCacheAsync(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getStoreLocalCacheAsync() != null) {
            return clientConfig.getStoreLocalCacheAsync();
        }
        if (globalConfig != null && globalConfig.getStoreLocalCacheAsync() != null) {
            return globalConfig.getStoreLocalCacheAsync();
        }
        return SpringCloudConstants.STORE_LOCAL_CACHE_ASYNC;
    }

    public Boolean getFetchInstancesWhenInitEnabled(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getFetchInstancesWhenInitEnabled() != null) {
            return clientConfig.getFetchInstancesWhenInitEnabled();
        }
        if (globalConfig != null && globalConfig.getFetchInstancesWhenInitEnabled() != null) {
            return globalConfig.getFetchInstancesWhenInitEnabled();
        }
        return true;
    }

    public Boolean getWarmUpEnabled(String clientName) {
        ClientConfig globalConfig = this.config.get(this.defaultConfig);
        ClientConfig clientConfig = this.config.get(clientName);
        if (clientConfig != null && clientConfig.getWarmUpEnabled() != null) {
            return clientConfig.getWarmUpEnabled();
        }
        if (globalConfig != null && globalConfig.getWarmUpEnabled() != null) {
            return globalConfig.getWarmUpEnabled();
        }
        return true;
    }
}

