/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.acl;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.acl.AclClientConfiguration;
import com.baidubce.services.acl.model.AclRule;
import com.baidubce.services.acl.model.CreateAclRequest;
import com.baidubce.services.acl.model.DeleteAclRequest;
import com.baidubce.services.acl.model.GetAclRequest;
import com.baidubce.services.acl.model.GetAclResponse;
import com.baidubce.services.acl.model.ListAclRequest;
import com.baidubce.services.acl.model.ListAclResponse;
import com.baidubce.services.acl.model.ModifyAclRuleAttributesRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AclClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "acl";
    private static final String RULE_PREFIX = "rule";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static final HttpResponseHandler[] aclHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AclClient() {
        this(new AclClientConfiguration());
    }

    public AclClient(AclClientConfiguration clientConfiguration) {
        super(clientConfiguration, aclHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public void createAcl(List<AclRule> aclRules) {
        CreateAclRequest request = new CreateAclRequest();
        request.setAclRules(aclRules);
        this.createAcl(request);
    }

    public void createAcl(CreateAclRequest createAclRequest) {
        Preconditions.checkNotNull((Object)createAclRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)createAclRequest.getClientToken())) {
            createAclRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull(createAclRequest.getAclRules(), (Object)"aclRules should not be null.");
        InternalRequest internalRequest = this.createRequest(createAclRequest, HttpMethodName.POST, PREFIX, RULE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, createAclRequest.getClientToken());
        this.fillPayload(internalRequest, createAclRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListAclResponse listAclRules(String subnetId) {
        return this.listAclRules(new ListAclRequest().withSubnetId(subnetId));
    }

    public ListAclResponse listAclRules(ListAclRequest listAclRequest) {
        Preconditions.checkNotNull((Object)listAclRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(listAclRequest.getSubnetId(), "request subnetId should not be null");
        InternalRequest internalRequest = this.createRequest(listAclRequest, HttpMethodName.GET, PREFIX, RULE_PREFIX);
        internalRequest.addParameter("subnetId", listAclRequest.getSubnetId());
        if (listAclRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listAclRequest.getMarker());
        }
        if (listAclRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listAclRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAclResponse.class);
    }

    public GetAclResponse getAcl(String vpcId) {
        return this.getAcl(new GetAclRequest().withVpcId(vpcId));
    }

    public GetAclResponse getAcl(GetAclRequest getAclRequest) {
        Preconditions.checkNotNull((Object)getAclRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(getAclRequest.getVpcId(), "request vpcId should not be null");
        InternalRequest internalRequest = this.createRequest(getAclRequest, HttpMethodName.GET, PREFIX);
        internalRequest.addParameter("vpcId", getAclRequest.getVpcId());
        return this.invokeHttpClient(internalRequest, GetAclResponse.class);
    }

    public void deleteAcl(String aclRuleId) {
        this.deleteAcl(new DeleteAclRequest().withAclRuleId(aclRuleId));
    }

    public void deleteAcl(DeleteAclRequest deleteAclRequest) {
        Preconditions.checkNotNull((Object)deleteAclRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(deleteAclRequest.getAclRuleId(), "request aclRuleId should not be null.");
        if (Strings.isNullOrEmpty((String)deleteAclRequest.getClientToken())) {
            deleteAclRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteAclRequest, HttpMethodName.DELETE, PREFIX, RULE_PREFIX, deleteAclRequest.getAclRuleId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteAclRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyAclRuleAttributes(String aclRuleId, AclRule aclRule) {
        ModifyAclRuleAttributesRequest request = new ModifyAclRuleAttributesRequest().withAclRuleId(aclRuleId).withDescription(aclRule.getDescription()).withProtocol(aclRule.getProtocol()).withSourceIpAddress(aclRule.getSourceIpAddress()).withDestinationIpAddress(aclRule.getDestinationIpAddress()).withSourcePort(aclRule.getSourcePort()).withDestinationPort(aclRule.getDestinationPort()).withPosition(aclRule.getPosition()).withAction(aclRule.getAction());
        this.modifyAclRuleAttributes(request);
    }

    public void modifyAclRuleAttributes(ModifyAclRuleAttributesRequest modifyAclRuleAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyAclRuleAttributesRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(modifyAclRuleAttributesRequest.getAclRuleId(), "request aclRuleId should not be null.");
        if (Strings.isNullOrEmpty((String)modifyAclRuleAttributesRequest.getClientToken())) {
            modifyAclRuleAttributesRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(modifyAclRuleAttributesRequest, HttpMethodName.PUT, PREFIX, RULE_PREFIX, modifyAclRuleAttributesRequest.getAclRuleId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, modifyAclRuleAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyAclRuleAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

