/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.media;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.media.model.Audio;
import com.baidubce.services.media.model.Clip;
import com.baidubce.services.media.model.CreateJobRequest;
import com.baidubce.services.media.model.CreateJobResponse;
import com.baidubce.services.media.model.CreatePipelineRequest;
import com.baidubce.services.media.model.CreatePipelineResponse;
import com.baidubce.services.media.model.CreatePresetRequest;
import com.baidubce.services.media.model.CreatePresetResponse;
import com.baidubce.services.media.model.CreateThumbnailJobRequest;
import com.baidubce.services.media.model.CreateThumbnailJobResponse;
import com.baidubce.services.media.model.CreateTranscodingJobRequest;
import com.baidubce.services.media.model.CreateTranscodingJobResponse;
import com.baidubce.services.media.model.CreateWaterMarkRequest;
import com.baidubce.services.media.model.CreateWaterMarkResponse;
import com.baidubce.services.media.model.DeletePipelineRequest;
import com.baidubce.services.media.model.DeletePresetRequest;
import com.baidubce.services.media.model.DeletePresetResponse;
import com.baidubce.services.media.model.DeleteWaterMarkRequest;
import com.baidubce.services.media.model.DeleteWaterMarkResponse;
import com.baidubce.services.media.model.DelogoArea;
import com.baidubce.services.media.model.Encryption;
import com.baidubce.services.media.model.GetJobRequest;
import com.baidubce.services.media.model.GetJobResponse;
import com.baidubce.services.media.model.GetMediaInfoOfFileRequest;
import com.baidubce.services.media.model.GetMediaInfoOfFileResponse;
import com.baidubce.services.media.model.GetPipelineRequest;
import com.baidubce.services.media.model.GetPipelineResponse;
import com.baidubce.services.media.model.GetPresetRequest;
import com.baidubce.services.media.model.GetPresetResponse;
import com.baidubce.services.media.model.GetThumbnailJobRequest;
import com.baidubce.services.media.model.GetThumbnailJobResponse;
import com.baidubce.services.media.model.GetTranscodingJobRequest;
import com.baidubce.services.media.model.GetTranscodingJobResponse;
import com.baidubce.services.media.model.GetWaterMarkRequest;
import com.baidubce.services.media.model.GetWaterMarkResponse;
import com.baidubce.services.media.model.ListJobsRequest;
import com.baidubce.services.media.model.ListJobsResponse;
import com.baidubce.services.media.model.ListPipelinesRequest;
import com.baidubce.services.media.model.ListPipelinesResponse;
import com.baidubce.services.media.model.ListPresetsRequest;
import com.baidubce.services.media.model.ListPresetsResponse;
import com.baidubce.services.media.model.ListThumbnailJobsRequest;
import com.baidubce.services.media.model.ListThumbnailJobsResponse;
import com.baidubce.services.media.model.ListTranscodingJobsRequest;
import com.baidubce.services.media.model.ListTranscodingJobsResponse;
import com.baidubce.services.media.model.ListWaterMarkRequest;
import com.baidubce.services.media.model.ListWaterMarkResponse;
import com.baidubce.services.media.model.PipelineConfig;
import com.baidubce.services.media.model.Source;
import com.baidubce.services.media.model.SourceClip;
import com.baidubce.services.media.model.Target;
import com.baidubce.services.media.model.ThumbnailCapture;
import com.baidubce.services.media.model.ThumbnailSource;
import com.baidubce.services.media.model.ThumbnailTarget;
import com.baidubce.services.media.model.Video;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MediaClient
extends AbstractBceClient {
    private static final String VERSION = "v3";
    private static final String TRANSCODE_JOB = "job/transcoding";
    private static final String PIPELINE = "pipeline";
    private static final String PRESET = "preset";
    private static final String MEDIAINFO = "mediainfo";
    private static final String WATER_MARK = "watermark";
    private static final String THUMBNAIL = "job/thumbnail";
    private static final int DEFAULT_PIPELINE_CAPACITY = 20;
    private static final HttpResponseHandler[] mediaHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public MediaClient() {
        this(new BceClientConfiguration());
    }

    public MediaClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, mediaHandlers);
    }

    @Deprecated
    public CreateJobResponse createJob(String pipelineName, String sourceKey, String targetKey, String presetName) {
        CreateJobRequest request = new CreateJobRequest();
        request.setPipelineName(pipelineName);
        Source source = new Source();
        source.setSourceKey(sourceKey);
        request.setSource(source);
        Target target = new Target();
        target.setTargetKey(targetKey);
        target.setPresetName(presetName);
        request.setTarget(target);
        return this.createJob(request);
    }

    @Deprecated
    public CreateJobResponse createJob(CreateJobRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        Validate.checkNotNull(request.getSource(), "The parameter source should NOT be null.");
        Validate.checkStringNotEmpty(request.getSource().getSourceKey(), "The parameter sourceKey should NOT be null or empty string.");
        Validate.checkNotNull(request.getTarget(), "The parameter target should NOT be null.");
        Validate.checkStringNotEmpty(request.getTarget().getTargetKey(), "The parameter targetKey should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getTarget().getPresetName(), "The parameter presetName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, TRANSCODE_JOB);
        return this.invokeHttpClient(internalRequest, CreateJobResponse.class);
    }

    @Deprecated
    public ListJobsResponse listJobs(String pipelineName) {
        ListJobsRequest request = new ListJobsRequest();
        request.setPipelineName(pipelineName);
        return this.listJobs(request);
    }

    @Deprecated
    public ListJobsResponse listJobs(ListJobsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB);
        internalRequest.addParameter("pipelineName", request.getPipelineName());
        return this.invokeHttpClient(internalRequest, ListJobsResponse.class);
    }

    @Deprecated
    public GetJobResponse getJob(String jobId) {
        GetJobRequest request = new GetJobRequest();
        request.setJobId(jobId);
        return this.getJob(request);
    }

    @Deprecated
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getJobId(), "The parameter jobId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetJobResponse.class);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, String sourceKey, String targetKey, String presetName) {
        return this.createTranscodingJob(pipelineName, sourceKey, targetKey, presetName, null, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, String sourceKey, String targetKey, String presetName, String watermarkId, DelogoArea delogoArea) {
        CreateTranscodingJobRequest request = new CreateTranscodingJobRequest();
        request.setPipelineName(pipelineName);
        Source source = new Source();
        source.setSourceKey(sourceKey);
        request.setSource(source);
        Target target = new Target();
        target.setTargetKey(targetKey);
        target.setPresetName(presetName);
        if (!Strings.isNullOrEmpty((String)watermarkId)) {
            List<String> watermarkIds = Collections.singletonList(watermarkId);
            target.setWatermarkIds(watermarkIds);
        }
        if (delogoArea != null) {
            target.setDelogoArea(delogoArea);
        }
        request.setTarget(target);
        return this.createTranscodingJob(request);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName) {
        return this.createTranscodingJob(pipelineName, clips, targetKey, presetName, null, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName, String watermarkId) {
        return this.createTranscodingJob(pipelineName, clips, targetKey, presetName, watermarkId, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName, String watermarkId, DelogoArea delogoArea) {
        CreateTranscodingJobRequest request = new CreateTranscodingJobRequest();
        request.setPipelineName(pipelineName);
        Source source = new Source();
        for (SourceClip clip : clips) {
            source.addClip(clip);
        }
        request.setSource(source);
        Target target = new Target();
        target.setTargetKey(targetKey);
        target.setPresetName(presetName);
        if (!Strings.isNullOrEmpty((String)watermarkId)) {
            List<String> watermarkIds = Collections.singletonList(watermarkId);
            target.setWatermarkIds(watermarkIds);
        }
        if (delogoArea != null) {
            target.setDelogoArea(delogoArea);
        }
        request.setTarget(target);
        return this.createTranscodingJob(request);
    }

    public CreateTranscodingJobResponse createTranscodingJob(CreateTranscodingJobRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        Validate.checkNotNull(request.getSource(), "The parameter source should NOT be null.");
        Validate.checkNotNull(request.getTarget(), "The parameter target should NOT be null.");
        Validate.checkStringNotEmpty(request.getTarget().getTargetKey(), "The parameter targetKey should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getTarget().getPresetName(), "The parameter presetName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, TRANSCODE_JOB);
        return this.invokeHttpClient(internalRequest, CreateTranscodingJobResponse.class);
    }

    public ListTranscodingJobsResponse listTranscodingJobs(String pipelineName) {
        ListTranscodingJobsRequest request = new ListTranscodingJobsRequest();
        request.setPipelineName(pipelineName);
        return this.listTranscodingJobs(request);
    }

    public ListTranscodingJobsResponse listTranscodingJobs(ListTranscodingJobsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB);
        internalRequest.addParameter("pipelineName", request.getPipelineName());
        return this.invokeHttpClient(internalRequest, ListTranscodingJobsResponse.class);
    }

    public GetTranscodingJobResponse getTranscodingJob(String jobId) {
        GetTranscodingJobRequest request = new GetTranscodingJobRequest();
        request.setJobId(jobId);
        return this.getTranscodingJob(request);
    }

    public GetTranscodingJobResponse getTranscodingJob(GetTranscodingJobRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getJobId(), "The parameter jobId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetTranscodingJobResponse.class);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String sourceBucket, String targetBucket, int capacity) {
        return this.createPipeline(pipelineName, null, sourceBucket, targetBucket, capacity);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String sourceBucket, String targetBucket) {
        return this.createPipeline(pipelineName, null, sourceBucket, targetBucket, 20);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String description, String sourceBucket, String targetBucket, int capacity) {
        return this.createPipeline(pipelineName, description, sourceBucket, targetBucket, capacity, null);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String description, String sourceBucket, String targetBucket, int capacity, String notification) {
        CreatePipelineRequest request = new CreatePipelineRequest();
        request.setPipelineName(pipelineName);
        request.setDescription(description);
        request.setSourceBucket(sourceBucket);
        request.setTargetBucket(targetBucket);
        PipelineConfig config = new PipelineConfig();
        config.setCapacity(capacity);
        config.setNotification(notification);
        request.setConfig(config);
        return this.createPipeline(request);
    }

    public CreatePipelineResponse createPipeline(CreatePipelineRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getSourceBucket(), "The parameter sourceBucket should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getTargetBucket(), "The parameter targetBucket should NOT be null or empty string.");
        if (request.getConfig() == null || request.getConfig().getCapacity() == null) {
            PipelineConfig config = new PipelineConfig();
            config.setCapacity(20);
            request.setConfig(config);
        }
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PIPELINE);
        return this.invokeHttpClient(internalRequest, CreatePipelineResponse.class);
    }

    public ListPipelinesResponse listPipelines() {
        ListPipelinesRequest request = new ListPipelinesRequest();
        return this.listPipelines(request);
    }

    public ListPipelinesResponse listPipelines(ListPipelinesRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PIPELINE);
        return this.invokeHttpClient(internalRequest, ListPipelinesResponse.class);
    }

    public GetPipelineResponse getPipeline(String pipelineName) {
        GetPipelineRequest request = new GetPipelineRequest();
        request.setPipelineName(pipelineName);
        return this.getPipeline(request);
    }

    public GetPipelineResponse getPipeline(GetPipelineRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PIPELINE, request.getPipelineName());
        return this.invokeHttpClient(internalRequest, GetPipelineResponse.class);
    }

    public void deletePipeline(String pipelineName) {
        DeletePipelineRequest request = new DeletePipelineRequest();
        request.setPipelineName(pipelineName);
        this.deletePipeline(request);
    }

    public void deletePipeline(DeletePipelineRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PIPELINE, request.getPipelineName());
        this.invokeHttpClient(internalRequest, CreatePipelineResponse.class);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Audio audio) {
        return this.createPreset(presetName, null, container, false, null, audio, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Audio audio) {
        return this.createPreset(presetName, description, container, false, null, audio, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Clip clip, Audio audio, Encryption encryption) {
        return this.createPreset(presetName, null, container, false, clip, audio, null, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Clip clip, Audio audio, Encryption encryption) {
        return this.createPreset(presetName, description, container, false, clip, audio, null, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Audio audio, Video video) {
        return this.createPreset(presetName, null, container, false, null, audio, video, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Audio audio, Video video) {
        return this.createPreset(presetName, description, container, false, null, audio, video, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Clip clip, Audio audio, Video video, Encryption encryption) {
        return this.createPreset(presetName, null, container, false, clip, audio, video, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Clip clip, Audio audio, Video video, Encryption encryption) {
        return this.createPreset(presetName, description, container, false, clip, audio, video, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Clip clip, Audio audio, Video video, Encryption encryption, String watermarkId) {
        return this.createPreset(presetName, null, container, false, clip, audio, video, encryption, watermarkId);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Clip clip, Audio audio, Video video, Encryption encryption, String watermarkId) {
        return this.createPreset(presetName, description, container, false, clip, audio, video, encryption, watermarkId);
    }

    public CreatePresetResponse createPreset(String presetName, String container) {
        return this.createPreset(presetName, null, container, true, null, null, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container) {
        return this.createPreset(presetName, description, container, true, null, null, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, boolean transmux, Clip clip, Audio audio, Video video, Encryption encryption) {
        return this.createPreset(presetName, description, container, false, clip, audio, video, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, boolean transmux, Clip clip, Audio audio, Video video, Encryption encryption, String watermarkId) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setPresetName(presetName);
        request.setDescription(description);
        request.setContainer(container);
        request.setTransmux(transmux);
        request.setClip(clip);
        request.setAudio(audio);
        request.setVideo(video);
        request.setEncryption(encryption);
        request.setWatermarkId(watermarkId);
        return this.createPreset(request);
    }

    public CreatePresetResponse createPreset(CreatePresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PRESET);
        return this.invokeHttpClient(internalRequest, CreatePresetResponse.class);
    }

    public ListPresetsResponse listPresets() {
        ListPresetsRequest request = new ListPresetsRequest();
        return this.listPresets(request);
    }

    public ListPresetsResponse listPresets(ListPresetsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PRESET);
        return this.invokeHttpClient(internalRequest, ListPresetsResponse.class);
    }

    public GetPresetResponse getPreset(String presetName) {
        GetPresetRequest request = new GetPresetRequest();
        request.setPresetName(presetName);
        return this.getPreset(request);
    }

    public GetPresetResponse getPreset(GetPresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPresetName(), "The parameter presetName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PRESET, request.getPresetName());
        return this.invokeHttpClient(internalRequest, GetPresetResponse.class);
    }

    public void deletePreset(String presetName) {
        DeletePresetRequest request = new DeletePresetRequest();
        request.setPresetName(presetName);
        this.deletePreset(request);
    }

    public void deletePreset(DeletePresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPresetName(), "The parameter presetName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PRESET, request.getPresetName());
        this.invokeHttpClient(internalRequest, DeletePresetResponse.class);
    }

    public GetMediaInfoOfFileResponse getMediaInfoOfFile(String bucket, String key) {
        GetMediaInfoOfFileRequest request = new GetMediaInfoOfFileRequest();
        request.setBucket(bucket);
        request.setKey(key);
        return this.getMediaInfoOfFile(request);
    }

    public GetMediaInfoOfFileResponse getMediaInfoOfFile(GetMediaInfoOfFileRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getBucket(), "The parameter bucket should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getKey(), "The parameter key should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, MEDIAINFO);
        internalRequest.addParameter("bucket", request.getBucket());
        internalRequest.addParameter("key", request.getKey());
        return this.invokeHttpClient(internalRequest, GetMediaInfoOfFileResponse.class);
    }

    @Deprecated
    public CreateWaterMarkResponse createWaterMark(String bucket, String key, int horizontalOffsetInPixel, int verticalOffsetInPixel) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalOffsetInPixel(horizontalOffsetInPixel).withVerticalOffsetInPixel(verticalOffsetInPixel);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(String bucket, String key, String horizontalAlignment, String verticalAlignment) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalAlignment(horizontalAlignment).withVerticalAlignment(verticalAlignment);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(String bucket, String key, String horizontalAlignment, String verticalAlignment, int horizontalOffsetInPixel, int verticalOffsetInPixel) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalAlignment(horizontalAlignment).withVerticalAlignment(verticalAlignment).withHorizontalOffsetInPixel(horizontalOffsetInPixel).withVerticalOffsetInPixel(verticalOffsetInPixel);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(CreateWaterMarkRequest request) {
        Validate.checkStringNotEmpty(request.getBucket(), "The parameter bucket should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getKey(), "The parameter key should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, WATER_MARK);
        return this.invokeHttpClient(internalRequest, CreateWaterMarkResponse.class);
    }

    public GetWaterMarkResponse getWaterMark(String watermarkId) {
        GetWaterMarkRequest request = new GetWaterMarkRequest().withWatermarkId(watermarkId);
        return this.getWaterMark(request);
    }

    public GetWaterMarkResponse getWaterMark(GetWaterMarkRequest request) {
        Validate.checkStringNotEmpty(request.getWatermarkId(), "The parameter watermarkId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, WATER_MARK, request.getWatermarkId());
        return this.invokeHttpClient(internalRequest, GetWaterMarkResponse.class);
    }

    public ListWaterMarkResponse listWaterMark() {
        ListWaterMarkRequest request = new ListWaterMarkRequest();
        return this.listWaterMark(request);
    }

    public ListWaterMarkResponse listWaterMark(ListWaterMarkRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, WATER_MARK);
        return this.invokeHttpClient(internalRequest, ListWaterMarkResponse.class);
    }

    public void deleteWaterMark(String watermarkId) {
        DeleteWaterMarkRequest request = new DeleteWaterMarkRequest().withWatermarkId(watermarkId);
        this.deleteWaterMark(request);
    }

    public void deleteWaterMark(DeleteWaterMarkRequest request) {
        Validate.checkStringNotEmpty(request.getWatermarkId(), "The parameter watermarkId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, WATER_MARK, request.getWatermarkId());
        this.invokeHttpClient(internalRequest, DeleteWaterMarkResponse.class);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey, ThumbnailTarget target, ThumbnailCapture capture) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target).withCapture(capture);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey, ThumbnailTarget target, ThumbnailCapture capture, DelogoArea delogoArea) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target).withCapture(capture).withDelogoArea(delogoArea);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(CreateThumbnailJobRequest request) {
        Validate.checkStringNotEmpty(request.getPipelineName(), "The parameter pipelineName should NOT be null or empty string.");
        Validate.checkNotNull(request.getSource(), "The parameter source should NOT be null.");
        Validate.checkStringNotEmpty(request.getSource().getKey(), "The parameter source key should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, THUMBNAIL);
        return this.invokeHttpClient(internalRequest, CreateThumbnailJobResponse.class);
    }

    public GetThumbnailJobResponse getThumbnailJob(String jobId) {
        GetThumbnailJobRequest request = new GetThumbnailJobRequest().withJobId(jobId);
        return this.getThumbnailJob(request);
    }

    public GetThumbnailJobResponse getThumbnailJob(GetThumbnailJobRequest request) {
        Validate.checkStringNotEmpty(request.getJobId(), "The parameter jobId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, THUMBNAIL, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetThumbnailJobResponse.class);
    }

    public ListThumbnailJobsResponse listThumbnailJobs(String pipelineName) {
        ListThumbnailJobsRequest request = new ListThumbnailJobsRequest().withPipeline(pipelineName);
        return this.listThumbnailJobs(request);
    }

    public ListThumbnailJobsResponse listThumbnailJobs(ListThumbnailJobsRequest request) {
        Validate.checkStringNotEmpty(request.getPipeline(), "The parameter pipelineName should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, THUMBNAIL);
        internalRequest.addParameter("pipelineName", request.getPipeline());
        return this.invokeHttpClient(internalRequest, ListThumbnailJobsResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

