/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class Datapoint {
    private String metric;
    private String field;
    private Map<String, String> tags;
    private String type;
    private List<List<JsonNode>> values;

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getType() {
        return this.type;
    }

    public List<List<JsonNode>> getValues() {
        return this.values;
    }

    public void setValues(List<List<JsonNode>> values) {
        this.values = values;
    }

    public Datapoint withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    public Datapoint withField(String field) {
        this.field = field;
        return this;
    }

    public Datapoint withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Datapoint addLongValue(long time, long value) {
        this.initialValues();
        this.checkType("Long");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new LongNode(value)}));
        return this;
    }

    public Datapoint addDoubleValue(long time, double value) {
        this.initialValues();
        this.checkType("Double");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new DoubleNode(value)}));
        return this;
    }

    public Datapoint addStringValue(long time, String value) {
        this.initialValues();
        this.checkType("String");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new TextNode(value)}));
        return this;
    }

    public Datapoint addBytesValue(long time, byte[] value) {
        this.initialValues();
        if (!(this.values == null || this.values.isEmpty() || this.type != null && this.type.equals("Bytes"))) {
            throw new IllegalStateException("There is already another type in datapoint, could not add byte array type again");
        }
        this.type = "Bytes";
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new BinaryNode(value)}));
        return this;
    }

    public Datapoint addTag(String tagKey, String tagValue) {
        this.initialTags();
        this.tags.put(tagKey, tagValue);
        return this;
    }

    private void initialValues() {
        if (this.values == null) {
            this.values = Lists.newArrayList();
            this.type = null;
        }
    }

    private void initialTags() {
        if (this.tags == null) {
            this.tags = Maps.newHashMap();
        }
    }

    private void checkType(String currentType) {
        if (this.type != null && !this.type.equals(currentType)) {
            throw new IllegalStateException("There is already " + this.type + " type in datapoint, could not add " + currentType + " type again");
        }
    }
}

