/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface IPage<T>
extends Serializable {
    public List<OrderItem> orders();

    default public boolean optimizeCountSql() {
        return true;
    }

    default public boolean optimizeJoinOfCountSql() {
        return true;
    }

    default public boolean searchCount() {
        return true;
    }

    default public long offset() {
        long current = this.getCurrent();
        if (current <= 1L) {
            return 0L;
        }
        return Math.max((current - 1L) * this.getSize(), 0L);
    }

    default public Long maxLimit() {
        return null;
    }

    default public long getPages() {
        if (this.getSize() == 0L) {
            return 0L;
        }
        long pages = this.getTotal() / this.getSize();
        if (this.getTotal() % this.getSize() != 0L) {
            ++pages;
        }
        return pages;
    }

    default public IPage<T> setPages(long pages) {
        return this;
    }

    public List<T> getRecords();

    public IPage<T> setRecords(List<T> var1);

    public long getTotal();

    public IPage<T> setTotal(long var1);

    public long getSize();

    public IPage<T> setSize(long var1);

    public long getCurrent();

    public IPage<T> setCurrent(long var1);

    default public <R> IPage<R> convert(Function<? super T, ? extends R> mapper) {
        List collect = this.getRecords().stream().map(mapper).collect(Collectors.toList());
        return this.setRecords(collect);
    }

    default public String countId() {
        return null;
    }
}

