/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class PreparedParameter {
    private Object value;
    private boolean nullValue;
    private int prec;
    private int scale;
    private int sqlType;
    private int outParamSqlType;
    private int length;
    private byte[] binaryValue;
    private int paramType = 4;
    private String outParamName = null;
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    public static final int NONE = 4;

    public PreparedParameter() {
    }

    public PreparedParameter(int n) {
        this.paramType = n;
    }

    public PreparedParameter(Object object, byte[] byArray, int n, boolean bl, int n2, int n3) {
        this.value = object;
        this.sqlType = n;
        this.nullValue = bl;
        this.prec = n2;
        this.scale = n3;
        this.binaryValue = byArray;
        this.length = byArray != null ? byArray.length : 0;
        this.setParamType(1);
    }

    public PreparedParameter(Object object, byte[] byArray, int n, boolean bl, int n2, int n3, int n4, String string, int n5) {
        this.value = object;
        this.sqlType = n;
        this.nullValue = bl;
        this.prec = n2;
        this.scale = n3;
        this.binaryValue = byArray;
        this.length = n5;
        this.paramType = n4;
        this.outParamName = string;
    }

    public void setNewValues(Object object, byte[] byArray, int n, boolean bl, int n2, int n3) {
        this.value = object;
        this.sqlType = n;
        this.nullValue = bl;
        this.prec = n2;
        this.scale = n3;
        this.binaryValue = byArray;
        this.length = byArray != null ? byArray.length : 0;
        this.setParamType(1);
    }

    public void resetDecimal(int n) {
        this.value = n < this.scale ? ComUtil.adjustScale((BigDecimal)this.value, this.scale, n) : ((BigDecimal)this.value).movePointRight(n - this.scale);
        this.scale = n;
        if (this.binaryValue.length == 16) {
            ByteConverter.bigIntToByteArray(((BigDecimal)this.value).toBigInteger(), this.binaryValue);
        } else {
            ByteConverter.putLong(this.binaryValue, 0, ((BigDecimal)this.value).longValue());
        }
    }

    public void resetTimeAndTimestamp(int n, String string) throws SQLException {
        if (!(this.value instanceof Time) && !(this.value instanceof Timestamp)) {
            return;
        }
        try {
            String string2 = this.getTimeAndTimestampTrailingZeros(n, string);
            String string3 = new String(this.binaryValue, string);
            if (string3.length() >= 6 && (string3.charAt(string3.length() - 6) == '+' || string3.charAt(string3.length() - 6) == '-')) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.insert(string3.length() - 6, string2);
                this.binaryValue = stringBuffer.toString().getBytes(string);
            } else {
                this.binaryValue = string3.concat(string2).getBytes(string);
            }
            this.length = this.binaryValue.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(251, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), string));
        }
    }

    public void resetToSpaces(int n, String string) throws SQLException {
        this.binaryValue = TeraPreparedStatement.spacesForNullValue(true, n, string);
        this.length = this.binaryValue.length;
    }

    private String getTimeAndTimestampTrailingZeros(int n, String string) throws UnsupportedEncodingException {
        char[] cArray;
        int n2 = n - this.scale;
        String string2 = new String(this.binaryValue, string);
        if (string2.indexOf(".") >= 0) {
            cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = 48;
            }
        } else {
            cArray = new char[n2 + 1];
            cArray[0] = 46;
            for (int i = 1; i <= n2; ++i) {
                cArray[i] = 48;
            }
        }
        return new String(cArray);
    }

    public PreparedParameter copy() {
        return new PreparedParameter(this.value, this.binaryValue, this.sqlType, this.nullValue, this.prec, this.scale, this.paramType, this.outParamName, this.length);
    }

    public Object getValue() {
        return this.value;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(byte[] byArray) {
        this.binaryValue = byArray;
        this.setParamType(1);
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getOutParamSqlType() {
        return this.outParamSqlType;
    }

    public void setOutParamSqlType(int n) {
        this.outParamSqlType = n;
    }

    public void setOutParamName(String string) {
        this.outParamName = string;
    }

    public String getOutParamName() {
        return this.outParamName;
    }

    public void setParamType(int n) {
        if (this.paramType == n) {
            return;
        }
        if (this.paramType == 4) {
            this.paramType = n;
        } else if (this.paramType == 1 && n == 2 || this.paramType == 2 && n == 1 || n == 3) {
            this.paramType = 3;
        }
    }

    public int getParamType() {
        return this.paramType;
    }

    public void setPrec(int n) {
        this.prec = n;
    }

    public int getPrec() {
        return this.prec;
    }

    public int getScale() {
        return this.scale;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }
}

