/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Blob;
import com.teradata.jdbc.Clob;
import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraStatement;
import com.teradata.jdbc.jdbc_4.ParameterSet;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXField;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class StatementParameters {
    private int numOfParams = 0;
    private int[] sqlParamsIndex = new int[1025];
    private int numOfOutParams = 0;
    private int numOfOutOnlyParams = 0;
    private int[] outParams;
    private String Sql;
    private String originalSql;
    protected ConnectionOptions conOptions;
    protected TDSession m_session;
    protected boolean m_bUseDataInfoX;
    private ArrayList lobList;
    private ParameterSet currentParamSet;
    private DataInfoField[] dataInfoFields;

    public StatementParameters(String string, ConnectionOptions connectionOptions, TDSession tDSession) {
        this.Sql = string;
        this.originalSql = string;
        this.conOptions = connectionOptions;
        this.m_session = tDSession;
        this.m_bUseDataInfoX = this.m_session.getConfigResponse().isMultiPartProtocolSupported();
        this.numOfParams = this.getParamIndex(string);
        this.dataInfoFields = new DataInfoField[this.numOfParams];
        for (int i = 0; i < this.numOfParams; ++i) {
            this.dataInfoFields[i] = this.m_bUseDataInfoX ? new DataInfoXField() : new DataInfoField();
        }
        this.lobList = null;
    }

    public void initOutputParameters() {
        this.outParams = new int[this.numOfParams];
        for (int i = 0; i < this.numOfParams; ++i) {
            this.outParams[i] = -1;
        }
    }

    private static void setNullIndicatorBitWithinArray(int n, byte[] byArray) {
        int n2 = 1 << 7 - (n - 1) % 8;
        int n3 = (n + 7) / 8 - 1;
        byArray[n3] = (byte)(byArray[n3] | (byte)n2);
    }

    public void clearAllParameters() throws SQLException {
        for (int i = 0; i < this.numOfParams; ++i) {
            this.outParams[i] = -1;
        }
        this.clearParameters();
        this.numOfOutParams = 0;
        this.lobList = null;
    }

    public void clearParameters() {
        for (int i = 0; i < this.numOfParams; ++i) {
            this.dataInfoFields[i].clear();
        }
        this.currentParamSet.clear();
    }

    private int getParamIndex(String string) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        block0: while ((n = string.indexOf("?", n2)) != -1) {
            int n6;
            if (n > n3 && ((n3 = string.indexOf("\"", n2)) != -1 || (n3 = string.indexOf("'", n2)) != -1)) {
                n6 = n3 + 1;
                while (((n4 = string.indexOf("\"", n6)) != -1 || (n4 = string.indexOf("'", n6)) != -1) && string.charAt(n4 - 1) == '\\') {
                    n6 = n4 + 1;
                }
            }
            if (n > n3 && n < n4) {
                n2 = n4 + 1;
                n4 = -1;
                continue;
            }
            if (n > n3 && n > n4 && n4 != -1) {
                n2 = n4 + 1;
                n4 = -1;
                while (n > n3 && n > n4) {
                    if (n > n3 && ((n3 = string.indexOf("\"", n2)) != -1 || (n3 = string.indexOf("'", n2)) != -1)) {
                        n6 = n3 + 1;
                        while (((n4 = string.indexOf("\"", n6)) != -1 || (n4 = string.indexOf("'", n6)) != -1) && string.charAt(n4 - 1) == '\\') {
                            n6 = n4 + 1;
                        }
                    }
                    if (n > n3 && n < n4) {
                        n2 = n4 + 1;
                        n4 = -1;
                        continue block0;
                    }
                    if (n > n3 && n > n4 && n4 != -1) {
                        n2 = n4 + 1;
                        n4 = -1;
                        continue;
                    }
                    ++this.numOfParams;
                    if (n5 < 1025) {
                        this.sqlParamsIndex[n5++] = n;
                    }
                    n2 = n + 1;
                    continue block0;
                }
                continue;
            }
            ++this.numOfParams;
            if (n5 < 1025) {
                this.sqlParamsIndex[n5++] = n;
            }
            n2 = n + 1;
        }
        return this.numOfParams;
    }

    protected byte[] createNullIndicatorBitArray(ParameterSet parameterSet) {
        int n = (this.numOfParams - this.numOfOutOnlyParams + 7) / 8;
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 1; i <= this.numOfParams; ++i) {
            if (parameterSet.getParamType(i) == 2) continue;
            ++n2;
            if (!parameterSet.isNull(i)) continue;
            StatementParameters.setNullIndicatorBitWithinArray(n2, byArray);
        }
        return byArray;
    }

    protected String getSql() {
        return this.Sql;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    protected void setColDataType(int n, int n2) {
        this.setColDataType(n, (short)n2);
    }

    protected void setColDataType(int n, short s) {
        this.dataInfoFields[n - 1].setType(s);
    }

    protected int getColPrecision(int n) {
        return this.dataInfoFields[n - 1].getPrecision();
    }

    protected int getColScale(int n) {
        return this.dataInfoFields[n - 1].getScale();
    }

    protected int getSignificantDigits(int n) {
        return this.dataInfoFields[n - 1].getSignificantDigits();
    }

    protected void setColPrecision(int n, int n2) {
        this.dataInfoFields[n - 1].setPrecision(n2);
    }

    protected void setColScale(int n, int n2) {
        this.dataInfoFields[n - 1].setScale(n2);
    }

    protected void setSignificantDigits(int n, int n2) {
        this.dataInfoFields[n - 1].setSignificantDigits(n2);
    }

    protected void setColDataLength(int n, long l) {
        this.dataInfoFields[n - 1].setLength(l);
    }

    protected void setColDataLength(int n, int n2) {
        this.setColDataLength(n, (long)n2);
    }

    protected long getColDataLength(int n) {
        return this.dataInfoFields[n - 1].getLength();
    }

    protected short getColDataType(int n) {
        return (short)this.dataInfoFields[n - 1].getType();
    }

    protected int getNumOfParams() {
        return this.numOfParams;
    }

    protected void setNumOfParams(int n) {
        this.numOfParams = n;
    }

    protected void setOutParam(int n, int n2) throws SQLException {
        if (n < 1 || n > this.outParams.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ181", n);
        }
        this.outParams[n - 1] = n2;
    }

    public int getNumOfOutOnlyParams() {
        return this.numOfOutOnlyParams;
    }

    public int getNumOfOutParams() {
        return this.numOfOutParams;
    }

    public void setNumOfOutParams(int n) {
        this.numOfOutParams = n;
    }

    protected int verifyOutParam(int n) throws SQLException {
        if (n < 1 || n > this.numOfParams) {
            throw ErrorFactory.makeDriverJDBCException("TJ181", n);
        }
        if (this.outParams[n - 1] == -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ181", n);
        }
        return this.outParams[n - 1];
    }

    protected void verify(int n) throws SQLException {
        if (n <= 0 || n > this.numOfParams) {
            throw ErrorFactory.makeDriverJDBCException("TJ169", n, this.numOfParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getOutParams(String string) throws SQLException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string.substring(0, 4).equalsIgnoreCase("CALL")) {
            return;
        }
        int n = "CALL".length() + 1;
        int n2 = TeraStatement.endOfWordIndex(string.substring(n));
        ResultSet resultSet = Statement.executeQuerySessionCommand(this.m_session, "HELP PROCEDURE " + string.substring(n, n2 + n), true);
        try {
            while (resultSet.next()) {
                if (!String.valueOf(resultSet.getObject(16)).trim().equals("O")) continue;
                object = String.valueOf(resultSet.getObject(1));
                object = ("x" + (String)object).trim().substring(1);
                object = "\"" + ((String)object).replaceAll("\"", "\"\"") + "\"";
                arrayList.add(object);
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        if (arrayList.size() != this.currentParamSet.getNumberOfOutParams()) {
            throw ErrorFactory.makeDriverJDBCException("TJ434", arrayList.size(), this.currentParamSet.getNumberOfOutParams());
        }
        object = arrayList.iterator();
        for (int i = 0; i < this.currentParamSet.getNumberOfParams(); ++i) {
            if (this.currentParamSet.getParamType(i + 1) != 2) continue;
            this.currentParamSet.setOutParamName(i + 1, (String)object.next());
        }
    }

    public void setOutOnlyParams() {
        if (this.numOfOutParams < 1) {
            return;
        }
        int n = 0;
        for (int i = this.numOfParams; i > 0; --i) {
            if (this.currentParamSet.getParamType(i) != 2) continue;
            ++n;
        }
        this.numOfOutOnlyParams = n;
        this.currentParamSet.setNumberOfOutParams(n);
    }

    public void replaceOutParams() throws SQLException {
        this.setOutOnlyParams();
        if (this.numOfOutParams < 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.originalSql.length() + this.numOfOutParams * 30);
        stringBuffer.append(this.originalSql);
        for (int i = this.numOfParams; i > 0; --i) {
            if (this.currentParamSet.getParamType(i) != 2) continue;
            if (this.currentParamSet.getOutParamName(i) == null) {
                this.getOutParams(this.originalSql);
            }
            int n = this.sqlParamsIndex[i - 1];
            stringBuffer.setCharAt(n, ' ');
            stringBuffer.insert(n + 1, this.currentParamSet.getOutParamName(i));
        }
        this.Sql = stringBuffer.toString();
    }

    public abstract int addLob(InputStream var1, long var2);

    public abstract int addLob(Reader var1, long var2);

    private void setLob(Object object) throws Exception {
        if (this.lobList == null) {
            this.lobList = new ArrayList();
        }
        this.lobList.add(object);
    }

    public byte[] getLobData(int n, int n2) throws SQLException {
        Object object = null;
        byte[] byArray = null;
        char[] cArray = null;
        try {
            object = this.findLob(n);
            if (object.getClass().getName().compareTo("com.teradata.jdbc.Blob") == 0) {
                InputStream inputStream = ((Blob)object).getBlob().getInBinaryStream();
                long l = ((Blob)object).getBlob().dataLeft();
                int n3 = (long)n2 > l ? (int)l : n2;
                byArray = new byte[n3];
                if ((n3 = inputStream.read(byArray, 0, n3)) == -1 && l > 0L) {
                    ComUtil.ThrowExcp(22, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ219"), "getLobData"));
                }
                ((Blob)object).getBlob().setDataLeft(l - (long)n3);
                return byArray;
            }
            if (object.getClass().getName().compareTo("com.teradata.jdbc.Clob") == 0) {
                Reader reader = ((Clob)object).getClob().getInCharacterStream();
                long l = ((Clob)object).getClob().dataLeft();
                int n4 = (long)n2 > l ? (int)l : n2;
                cArray = new char[n4];
                if ((n4 = reader.read(cArray, 0, n4)) == -1 && l > 0L) {
                    ComUtil.ThrowExcp(22, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ219"), "getLobData"));
                }
                String string = new String(cArray);
                byArray = string.getBytes(this.conOptions.getURLParams().getJavaEnCoding());
                ((Clob)object).getClob().setDataLeft(l - (long)n4);
                return byArray;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object == null) {
            return new byte[0];
        }
        return byArray;
    }

    public Object findLob(int n) {
        for (int i = 0; i < this.lobList.size(); ++i) {
            Object e = this.lobList.get(i);
            if (e.getClass().getName().compareTo("com.teradata.jdbc.Blob") == 0 && ((Blob)e).getToken() == n) {
                return e;
            }
            if (e.getClass().getName().compareTo("com.teradata.jdbc.Clob") != 0 || ((Clob)e).getToken() != n) continue;
            return e;
        }
        return null;
    }

    public String lobData(int n, int n2) throws SQLException {
        long l;
        long l2;
        Object object = this.findLob(n);
        String string = "N";
        if (object.getClass().getName().compareTo("com.teradata.jdbc.Blob") == 0) {
            l2 = ((Blob)object).getBlob().length();
            l = ((Blob)object).getBlob().dataLeft();
            string = l <= 0L ? "N" : ((long)n2 >= l ? "L" : (l == l2 ? "F" : "I"));
        }
        if (object.getClass().getName().compareTo("com.teradata.jdbc.Clob") == 0) {
            l2 = ((Clob)object).getClob().length();
            l = ((Clob)object).getClob().dataLeft();
            string = l <= 0L ? "N" : ((long)n2 > l ? "L" : (l == l2 ? "F" : "I"));
        }
        return string;
    }

    public ParameterSet getCurrentParamSet() {
        return this.currentParamSet;
    }

    public void setCurrentParamSet(ParameterSet parameterSet) {
        this.currentParamSet = parameterSet;
    }

    public void setParameter(int n, Object object, int n2, int n3) throws SQLException {
        this.setParameter(n, object, null, n2, false, 0, 0);
        this.currentParamSet.getPreparedParameter(n).setLength(n3);
    }

    public void setParameter(int n, Object object, byte[] byArray, int n2) throws SQLException {
        this.setParameter(n, object, byArray, n2, false, 0, 0);
    }

    public void setParameter(int n, Object object, byte[] byArray, int n2, int n3, int n4) throws SQLException {
        this.setParameter(n, object, byArray, n2, false, n3, n4);
    }

    public void setParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4) throws SQLException {
        this.setColPrecision(n, n3);
        this.setColScale(n, n4);
        this.setColDataType(n, n2);
        this.currentParamSet.setParameter(n, object, byArray, n2, bl, n3, n4);
    }

    public void setDecimalParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4, int n5) throws SQLException {
        this.setSignificantDigits(n, n5);
        this.setColDataLength(n, this.composeDataInfoDecimalLength(n3, n4));
        this.setParameter(n, object, byArray, n2, bl, n3, n4);
    }

    private long composeDataInfoDecimalLength(int n, int n2) {
        return this.m_bUseDataInfoX ? ComUtil.makeDataInfoXDecLength(n, n2) : (long)ComUtil.makeDataInfoDecLength((short)n, (byte)n2);
    }

    protected DataInfoField[] getDataInfoFields() {
        return this.dataInfoFields;
    }

    protected DataInfoField getDataInfoField(int n) {
        return this.dataInfoFields[n - 1];
    }
}

