/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ComSvcs;
import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraDatabaseMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public abstract class TeraConnection
implements Connection {
    public static final int AUTHMECH_USERNAME = 0;
    public static final int AUTHMECH_OIDNAME = 1;
    private ComSvcs ComObj;
    private String ErrMsg = "";
    private String SesId = new String("0");
    private boolean SessOpen = false;
    private String ServerName;
    private int PortNumber;
    private int ExtStmtId = 1;
    private int lobToken = 1;
    protected ConnectionOptions conOptions;
    int TRANSACTION_NONE = 0;
    int TRANSACTION_READ_UNCOMMITTED = 1;
    int TRANSACTION_READ_COMMITTED = 2;
    int TRANSACTION_REPEATABLE_READ = 4;
    int TRANSACTION_SERIALIZABLE = 8;

    public TeraConnection(URLParameters uRLParameters) throws SQLException {
        this.conOptions = new ConnectionOptions(uRLParameters);
    }

    protected final synchronized int getExtStmtId() {
        return this.ExtStmtId++;
    }

    protected final synchronized int getNewToken() {
        return this.lobToken++;
    }

    public String nativeSQL(String string) throws SQLException {
        string = EscapeUtil.nativeSQL(string, ((TeraLocalConnection)this).getTDSession().getLocalEscapeFunctions());
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (!bl) {
            this.ComObj.ExecCmd(ComUtil.MakePS("<SES_AUTOCOMMIT>", this.SesId, "0"));
        } else {
            this.ComObj.ExecCmd(ComUtil.MakePS("<SES_AUTOCOMMIT>", this.SesId, "1"));
        }
        if (this.ComObj.Code.compareTo("<OK>      ") != 0) {
            ComUtil.ThrowExcp(171, ErrorMessage.messages.getString("TJ005"));
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.ComObj.ExecCmd(ComUtil.MakePS("<SES_COMMITSTATE>", this.SesId));
        if (this.ComObj.Code.compareTo("<OK>      ") == 0) {
            return this.ComObj.VRes.elementAt(1).toString().compareTo("0") != 0;
        }
        ComUtil.ThrowExcp(172, ErrorMessage.messages.getString("TJ006"));
        return false;
    }

    public void commit() throws SQLException {
        this.ComObj.ExecCmd(ComUtil.MakePS("<SES_COMMIT>", this.SesId));
        if (this.ComObj.Code.compareTo("<OK>      ") != 0) {
            ComUtil.ThrowExcp(173, ErrorMessage.messages.getString("TJ007"));
        }
    }

    public void rollback() throws SQLException {
        this.ComObj.ExecCmd(ComUtil.MakePS("<SES_ROLLBACK>", this.SesId));
        if (this.ComObj.Code.compareTo("<OK>      ") != 0) {
            ComUtil.ThrowExcp(174, ErrorMessage.messages.getString("TJ008"));
        }
    }

    public void close() throws SQLException {
        if (this.SessOpen) {
            this.SessOpen = false;
            if (this.ComObj != null) {
                this.ComObj.ExecCmd(ComUtil.MakePS("<SES_CLOSE>", this.SesId));
                this.ComObj.close();
                this.ComObj = null;
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.SessOpen;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new TeraDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return "";
    }

    public void setTransactionIsolation(int n) throws SQLException {
    }

    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
    }

    public void reset() throws SQLException {
        this.ComObj.ExecCmd(ComUtil.MakePS("<SES_RESET>", this.SesId));
        if (this.ComObj.Code.compareTo("<OK>      ") != 0) {
            ComUtil.ThrowExcp(175, ErrorMessage.messages.getString("TJ193"));
        }
    }

    protected ComSvcs getComObj() {
        return this.ComObj;
    }

    protected void setServerName(String string) {
        this.ServerName = string;
    }

    protected String getServerName() {
        return this.ServerName;
    }

    protected void setPortNumber(int n) {
        this.PortNumber = n;
    }

    protected int getPortNumber() {
        return this.PortNumber;
    }

    protected void setSessOpen(boolean bl) {
        this.SessOpen = bl;
    }

    protected boolean getSessOpen() {
        return this.SessOpen;
    }

    protected void setErrMsg(String string) {
        this.ErrMsg = string;
    }

    protected String getErrMsg() {
        return this.ErrMsg;
    }

    protected ConnectionOptions getConnectionOptions() {
        return this.conOptions;
    }

    public void setHoldability(int n) throws SQLException {
        ComUtil.ThrowExcp(178, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "setHoldability"));
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public Savepoint setSavepoint() throws SQLException {
        ComUtil.ThrowExcp(180, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "setSavepoint"));
        return null;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        ComUtil.ThrowExcp(181, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "setSavepoint"));
        return null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        ComUtil.ThrowExcp(182, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "rollback"));
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        ComUtil.ThrowExcp(183, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "releaseSavepoint"));
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        ComUtil.ThrowExcp(184, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "createStatement"));
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        ComUtil.ThrowExcp(185, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "prepareStatement"));
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        ComUtil.ThrowExcp(186, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "prepareCall"));
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        ComUtil.ThrowExcp(187, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "prepareStatement"));
        return null;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        ComUtil.ThrowExcp(188, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "prepareStatement"));
        return null;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        ComUtil.ThrowExcp(189, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraConnection", "prepareStatement"));
        return null;
    }
}

