/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class TeraDataSourceBase
implements Referenceable,
Serializable {
    protected transient Log log;
    private String databaseName = "NO_DEF_DATABASE";
    private String accountId = "NO_ACCOUNT_ID";
    private String description = "Teradata Data Source";
    protected String password = null;
    private String serverName = null;
    protected String user = null;
    private String CharSet = "ASCII";
    private String DSName = null;
    private String Partition = "DBC/SQL";
    private String type = "DEFAULT";
    private String sessions = String.valueOf(8);
    private String govern = "ON";
    private String spl = String.valueOf(3);
    private String lobSupport = "ON";
    private String compatDBS = null;
    private String compatIsAutoInc = null;
    private String compatIsCurrency = null;
    private String compatIsSigned = null;
    private String compatIsSearch = null;
    private String compatGetSchema = null;
    private String compatGetTable = null;
    private String compatIsReadOnly = null;
    private String compatIsWritable = null;
    private String compatIsDefWrit = null;
    private String dbsPort = null;
    private String TransactMode = "D";
    private PrintWriter logWriter = null;
    private String LogMech = null;
    private String LogData = null;
    private String encryptData = "OFF";
    private int DSLoginTimeout = 0;
    private String JavaEnCoding = null;
    private String logLevel = null;
    private String tnano = null;
    private String tsnano = null;
    private String datasourceName = null;
    private String deprecated_serverName;
    private String newPassword = null;
    private String useXviews = "OFF";
    private String lobTempTable = null;
    private String m_prepSupport;
    private String m_copDiscovery = "ON";
    private String m_sRunStartup = null;
    private String m_sConnectFailureTTL = null;
    private String m_sTCP = null;
    private String type3Problem = "The %1 property was used for the deprecated Type 3 JDBC driver. It cannot be used with the type 4 driver. Please use the %2 property instead.";

    public TeraDataSourceBase() {
        this.log = new Log(this.toString());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String string) {
        this.accountId = string;
    }

    public String getdescription() {
        return this.description;
    }

    public void setdescription(String string) {
        this.description = string;
    }

    public String getpassword() {
        return this.password;
    }

    public void setpassword(String string) {
        this.password = string;
    }

    public String getServerName() {
        this.log.error(ErrorMessage.Format2(this.type3Problem, "serverName", "DSName"));
        return this.deprecated_serverName;
    }

    public void setServerName(String string) {
        this.log.error(ErrorMessage.Format2(this.type3Problem, "serverName", "DSName"));
        this.deprecated_serverName = string;
    }

    public String getuser() {
        return this.user;
    }

    public void setuser(String string) {
        this.user = string;
    }

    public String getCharSet() {
        return this.CharSet;
    }

    public void setCharSet(String string) {
        this.CharSet = string.equalsIgnoreCase("ascii") ? "ASCII" : (string.equalsIgnoreCase("latin1_0a") ? "LATIN1_0A" : (string.equalsIgnoreCase("latin9_0a") ? "LATIN9_0A" : (string.equalsIgnoreCase("kanjisjis_0s") ? "KANJISJIS_0S" : (string.equalsIgnoreCase("kanjieuc_0u") ? "KANJIEUC_0U" : (string.equalsIgnoreCase("kuserdefined_0s") ? "KUSERDEFINED_0S" : (string.equalsIgnoreCase("kuserdefined_0u") ? "KUSERDEFINED_0U" : (string.equalsIgnoreCase("ebcdic037_0e") ? "EBCDIC037_0E" : (string.equalsIgnoreCase("kanjiebcdic5026_0i") ? "KANJIEBCDIC5026_0I" : (string.equalsIgnoreCase("kanjiebcdic5035_0i") ? "KANJIEBCDIC5035_0I" : (string.equalsIgnoreCase("utf8") ? "UTF8" : (string.equalsIgnoreCase("utf16") ? "UTF16" : (string.equalsIgnoreCase("latin1252_0a") ? "LATIN1252_0A" : (string.equalsIgnoreCase("ebcdic273_0e") ? "EBCDIC273_0E" : (string.equalsIgnoreCase("ebcdic277_0e") ? "EBCDIC277_0E" : (string.equalsIgnoreCase("hangulebcdic933_1ii") ? "HANGULEBCDIC933_1II" : (string.equalsIgnoreCase("hangulksc5601_2r4") ? "HANGULKSC5601_2R4" : (string.equalsIgnoreCase("schebcdic935_2ij") ? "SCHEBCDIC935_2IJ" : (string.equalsIgnoreCase("schgb2312_1t0") ? "SCHGB2312_1T0" : (string.equalsIgnoreCase("tchbig5_1r0") ? "TCHBIG5_1R0" : (string.equalsIgnoreCase("tchebcdic937_3ib") ? "TCHEBCDIC937_3IB" : string))))))))))))))))))));
    }

    public String getDSName() {
        return this.DSName;
    }

    public void setDSName(String string) {
        this.DSName = string;
    }

    public String getLobSupport() {
        return this.lobSupport;
    }

    public void setLobSupport(String string) {
        this.lobSupport = string;
    }

    public String getPARTITION() {
        return this.Partition;
    }

    public void setPARTITION(String string) {
        this.Partition = string;
    }

    public String getTYPE() {
        return this.type;
    }

    public void setTYPE(String string) {
        this.type = string;
    }

    public String getSESSIONS() {
        return this.sessions;
    }

    public void setSESSIONS(String string) {
        this.sessions = string;
    }

    public String getGOVERN() {
        return this.govern;
    }

    public void setGOVERN(String string) {
        this.govern = string;
    }

    public String getspl() {
        if (String.valueOf(this.spl).equals(String.valueOf(4))) {
            return "NOSPL";
        }
        return "SPL";
    }

    public void setspl(String string) {
        if (string.equalsIgnoreCase("NOSPL")) {
            this.spl = String.valueOf(4);
        }
        if (string.equalsIgnoreCase("SPL")) {
            this.spl = String.valueOf(3);
        }
    }

    public String getTransactMode() {
        return this.TransactMode;
    }

    public void setTransactMode(String string) {
        this.TransactMode = string;
    }

    public void setCOMPAT_DBS(String string) {
        this.compatDBS = string;
    }

    public String getCOMPAT_DBS() {
        return this.compatDBS;
    }

    public void setCOMPAT_ISAUTOINC(String string) {
        this.compatIsAutoInc = string;
    }

    public String getCOMPAT_ISAUTOINC() {
        return this.compatIsAutoInc;
    }

    public void setCOMPAT_ISCURRENCY(String string) {
        this.compatIsCurrency = string;
    }

    public String getCOMPAT_ISCURRENCY() {
        return this.compatIsCurrency;
    }

    public void setCOMPAT_ISSIGNED(String string) {
        this.compatIsSigned = string;
    }

    public String getCOMPAT_ISSIGNED() {
        return this.compatIsSigned;
    }

    public void setCOMPAT_ISSEARCH(String string) {
        this.compatIsSearch = string;
    }

    public String getCOMPAT_ISSEARCH() {
        return this.compatIsSearch;
    }

    public void setCOMPAT_GETSCHEMA(String string) {
        this.compatGetSchema = string;
    }

    public String getCOMPAT_GETSCHEMA() {
        return this.compatGetSchema;
    }

    public void setCOMPAT_GETTABLE(String string) {
        this.compatGetTable = string;
    }

    public String getCOMPAT_GETTABLE() {
        return this.compatGetTable;
    }

    public void setCOMPAT_ISREADONLY(String string) {
        this.compatIsReadOnly = string;
    }

    public String getCOMPAT_ISREADONLY() {
        return this.compatIsReadOnly;
    }

    public void setCOMPAT_ISWRITABLE(String string) {
        this.compatIsWritable = string;
    }

    public String getCOMPAT_ISWRITABLE() {
        return this.compatIsWritable;
    }

    public void setCOMPAT_ISDEFWRIT(String string) {
        this.compatIsDefWrit = string;
    }

    public String getCOMPAT_ISDEFWRIT() {
        return this.compatIsDefWrit;
    }

    public void setDbsPort(String string) {
        this.dbsPort = string;
    }

    public String getDbsPort() {
        return this.dbsPort;
    }

    public void setLOB_TEMP_TABLE(String string) {
        this.lobTempTable = string;
    }

    public String getLOB_TEMP_TABLE() {
        return this.lobTempTable;
    }

    public void setLOGMECH(String string) {
        this.LogMech = string;
    }

    public String getLOGMECH() {
        return this.LogMech;
    }

    public String getLOGDATA() {
        return this.LogData;
    }

    public void setLOGDATA(String string) {
        this.LogData = string;
    }

    public String getENCRYPTDATA() {
        return this.encryptData;
    }

    public void setENCRYPTDATA(String string) {
        if (string == null) {
            return;
        }
        this.encryptData = string;
    }

    public Connection createNewConnection(String string, String string2) throws SQLException {
        if (this.DSName == null || this.DSName.equals("")) {
            ComUtil.ThrowExcp(6, ErrorMessage.messages.getString("TJ225"));
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        URLParameters uRLParameters = new URLParameters(this.TransactMode, this.CharSet, this.Partition, this.type, this.sessions, this.govern, Integer.parseInt(this.spl), this.databaseName, this.accountId, this.getLoginTimeout(), this.JavaEnCoding, this.lobSupport, this.dbsPort, this.LogMech, this.LogData, this.encryptData, this.compatDBS, this.compatIsAutoInc, this.compatIsCurrency, this.compatIsSigned, this.compatIsSearch, this.compatGetSchema, this.compatGetTable, this.compatIsReadOnly, this.compatIsWritable, this.compatIsDefWrit, this.tnano, this.tsnano, this.logLevel, this.newPassword, this.useXviews, this.lobTempTable, this.m_prepSupport, this.m_copDiscovery, this.m_sRunStartup, this.m_sConnectFailureTTL, this.m_sTCP);
        return ConnectionFactory.createConnection(this.DSName, string, string2, uRLParameters);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public int getLoginTimeout() {
        return this.DSLoginTimeout;
    }

    public void setLoginTimeout(int n) {
        this.DSLoginTimeout = n;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.teradata.jdbc.TeraObjectFactory", null);
        if (this.logLevel != null) {
            reference.add(new StringRefAddr("logLevel", this.getLOG()));
            this.log.setLogLevel(this.getLOG());
        }
        reference.add(new StringRefAddr("accountId", this.getAccountId()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("description", this.getdescription()));
        reference.add(new StringRefAddr("password", this.getpassword()));
        reference.add(new StringRefAddr("user", this.getuser()));
        reference.add(new StringRefAddr("CharSet", this.getCharSet()));
        reference.add(new StringRefAddr("DSName", this.getDSName()));
        reference.add(new StringRefAddr("Partition", this.getPARTITION()));
        reference.add(new StringRefAddr("type", this.getTYPE()));
        reference.add(new StringRefAddr("sessions", this.getSESSIONS()));
        reference.add(new StringRefAddr("govern", this.getGOVERN()));
        reference.add(new StringRefAddr("spl", this.getspl()));
        reference.add(new StringRefAddr("TransactMode", this.getTransactMode()));
        reference.add(new StringRefAddr("lobSupport", this.getLobSupport()));
        if (this.compatDBS != null) {
            reference.add(new StringRefAddr("compatDBS", this.getCOMPAT_DBS()));
        }
        if (this.compatIsAutoInc != null) {
            reference.add(new StringRefAddr("compatIsAutoInc", this.getCOMPAT_ISAUTOINC()));
        }
        if (this.compatIsCurrency != null) {
            reference.add(new StringRefAddr("compatIsCurrency", this.getCOMPAT_ISCURRENCY()));
        }
        if (this.compatIsSigned != null) {
            reference.add(new StringRefAddr("compatIsSigned", this.getCOMPAT_ISSIGNED()));
        }
        if (this.compatIsSearch != null) {
            reference.add(new StringRefAddr("compatIsSearch", this.getCOMPAT_ISSEARCH()));
        }
        if (this.compatGetSchema != null) {
            reference.add(new StringRefAddr("compatGetSchema", this.getCOMPAT_GETSCHEMA()));
        }
        if (this.compatGetTable != null) {
            reference.add(new StringRefAddr("compatGetTable", this.getCOMPAT_GETTABLE()));
        }
        if (this.compatIsReadOnly != null) {
            reference.add(new StringRefAddr("compatIsReadOnly", this.getCOMPAT_ISREADONLY()));
        }
        if (this.compatIsWritable != null) {
            reference.add(new StringRefAddr("compatIsWritable", this.getCOMPAT_ISWRITABLE()));
        }
        if (this.compatIsDefWrit != null) {
            reference.add(new StringRefAddr("compatIsDefWrit", this.getCOMPAT_ISDEFWRIT()));
        }
        if (this.dbsPort != null) {
            reference.add(new StringRefAddr("dbsPort", this.getDbsPort()));
        }
        if (this.JavaEnCoding != null) {
            reference.add(new StringRefAddr("JavaEnCoding", this.getCLIENT_CHARSET()));
        }
        if (this.LogMech != null) {
            reference.add(new StringRefAddr("LogMech", this.getLOGMECH()));
        }
        if (this.LogData != null) {
            reference.add(new StringRefAddr("LogData", this.getLOGDATA()));
        }
        if (this.encryptData != null) {
            reference.add(new StringRefAddr("encryptData", this.getENCRYPTDATA()));
        }
        if (this.tnano != null) {
            reference.add(new StringRefAddr("tnano", this.getTNANO()));
        }
        if (this.tsnano != null) {
            reference.add(new StringRefAddr("tsnano", this.getTSNANO()));
        }
        if (this.datasourceName != null) {
            reference.add(new StringRefAddr("datasourceName", this.getdatasourceName()));
        }
        if (this.useXviews != null) {
            reference.add(new StringRefAddr("useXviews", this.getUSEXVIEWS()));
        }
        if (this.newPassword != null) {
            reference.add(new StringRefAddr("newPassword", this.getNEW_PASSWORD()));
        }
        if (this.lobTempTable != null) {
            reference.add(new StringRefAddr("lobTempTable", this.getLOB_TEMP_TABLE()));
        }
        if (this.m_prepSupport != null) {
            reference.add(new StringRefAddr("prepSupport", this.getPREP_SUPPORT()));
        }
        if (this.m_copDiscovery != null) {
            reference.add(new StringRefAddr("copDiscovery", this.getCOP()));
        }
        if (this.m_sRunStartup != null) {
            reference.add(new StringRefAddr("runStartup", this.getRUNSTARTUP()));
        }
        if (this.m_sConnectFailureTTL != null) {
            reference.add(new StringRefAddr("connectFailureTTL", this.getCONNECT_FAILURE_TTL()));
        }
        if (this.m_sTCP != null) {
            reference.add(new StringRefAddr("tcp", this.getTCP()));
        }
        reference.add(new StringRefAddr("loginTimeout", String.valueOf(this.getLoginTimeout())));
        return reference;
    }

    private void addRefProperties(Reference reference, Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            reference.add(new StringRefAddr(string, properties.getProperty(string)));
        }
    }

    public void logit(String string) {
        PrintWriter printWriter = this.getLogWriter();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
        Date date = new Date();
        printWriter.print(dateFormat.format(date) + ";  ");
        printWriter.println(string);
        printWriter.flush();
    }

    public boolean logging() {
        return this.getLogWriter() != null;
    }

    public String getCLIENT_CHARSET() {
        return this.JavaEnCoding;
    }

    public void setCLIENT_CHARSET(String string) {
        this.JavaEnCoding = string;
    }

    public String getAccount() {
        return this.getAccountId();
    }

    public void setAccount(String string) {
        this.setAccountId(string);
    }

    public String getACCOUNT() {
        return this.getAccountId();
    }

    public void setACCOUNT(String string) {
        this.setAccountId(string);
    }

    public String getACCOUNTID() {
        return this.getAccountId();
    }

    public void setACCOUNTID(String string) {
        this.setAccountId(string);
    }

    public String getdatabaseName() {
        return this.getDatabaseName();
    }

    public void setdatabaseName(String string) {
        this.setDatabaseName(string);
    }

    public String getDATABASE() {
        return this.getDatabaseName();
    }

    public void setDATABASE(String string) {
        this.setDatabaseName(string);
    }

    public String getDBS_PORT() {
        return this.getDbsPort();
    }

    public void setDBS_PORT(String string) {
        this.setDbsPort(string);
    }

    public String getTMODE() {
        return this.getTransactMode();
    }

    public void setTMODE(String string) {
        this.setTransactMode(string);
    }

    public String getCHARSET() {
        return this.getCharSet();
    }

    public void setCHARSET(String string) {
        this.setCharSet(string);
    }

    public String getSP_SPL() {
        return this.getspl();
    }

    public void setSP_SPL(String string) {
        this.setspl(string);
    }

    public String getTNANO() {
        return this.tnano;
    }

    public void setTNANO(String string) {
        this.tnano = string;
    }

    public String getTSNANO() {
        return this.tsnano;
    }

    public void setTSNANO(String string) {
        this.tsnano = string;
    }

    public String getLOB_SUPPORT() {
        return this.getLobSupport();
    }

    public void setLOB_SUPPORT(String string) {
        this.setLobSupport(string);
    }

    public void setLOG(String string) {
        this.logLevel = string;
        this.log.setLogLevel(string);
    }

    public String getLOG() {
        return this.logLevel;
    }

    public void setNEW_PASSWORD(String string) {
        this.newPassword = string;
    }

    public String getNEW_PASSWORD() {
        return this.newPassword;
    }

    public String getdatasourceName() {
        return this.datasourceName;
    }

    public void setdatasourceName(String string) {
        this.datasourceName = string;
    }

    public void setUSEXVIEWS(String string) {
        this.useXviews = string;
    }

    public String getUSEXVIEWS() {
        return this.useXviews;
    }

    public String getDataSourceName() {
        return this.getdatasourceName();
    }

    public void setDataSourceName(String string) {
        this.setdatasourceName(string);
    }

    public String getDescription() {
        return this.getdescription();
    }

    public void setDescription(String string) {
        this.setdescription(string);
    }

    public String getPassword() {
        return this.getpassword();
    }

    public void setPassword(String string) {
        this.setpassword(string);
    }

    public String getUser() {
        return this.getuser();
    }

    public void setUser(String string) {
        this.setuser(string);
    }

    public void setPREP_SUPPORT(String string) {
        this.m_prepSupport = string;
    }

    public String getPREP_SUPPORT() {
        return this.m_prepSupport;
    }

    public void setCOP(String string) {
        this.m_copDiscovery = string;
    }

    public String getCOP() {
        return this.m_copDiscovery;
    }

    public void setRUNSTARTUP(String string) {
        this.m_sRunStartup = string;
    }

    public String getRUNSTARTUP() {
        return this.m_sRunStartup;
    }

    public void setCONNECT_FAILURE_TTL(String string) {
        this.m_sConnectFailureTTL = string;
    }

    public String getCONNECT_FAILURE_TTL() {
        return this.m_sConnectFailureTTL;
    }

    public void setTCP(String string) {
        this.m_sTCP = string;
    }

    public String getTCP() {
        return this.m_sTCP;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.log = new Log(this.toString());
        this.log.setLogLevel(this.logLevel);
    }
}

