/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.Const;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraConnection;
import com.teradata.jdbc.TeraResultSet;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_3.dbmetadata.ColumnInfo;
import com.teradata.jdbc.jdbc_3.dbmetadata.IndexInfoRow;
import com.teradata.jdbc.jdbc_3.dbmetadata.IndexInfoRows;
import com.teradata.jdbc.jdbc_3.dbmetadata.TypeInfoRow;
import com.teradata.jdbc.jdbc_3.dbmetadata.TypeInfoRows;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TeraDatabaseMetaData
implements DatabaseMetaData {
    private TeraResultSet RS = new TeraResultSet();
    private TeraConnection connection = null;
    private int nDatabaseMajorVersion = 0;
    private int nDatabaseMinorVersion = 0;
    private int DBCRelease = 0;
    public static final int R0 = 0;
    public static final int R1 = 10;
    public static final int R2 = 20;
    public static final int R3 = 30;
    public static final int R4 = 40;
    public static final int R5 = 50;
    public static final int R51 = 51;
    public static final int R6 = 60;
    public static final int R61 = 61;
    public static final int R62 = 62;
    public static final int R120 = 120;
    public static final int R130 = 130;
    public static final int R131 = 131;
    public static final int R132 = 132;
    public static final int R140 = 140;
    public static final int R141 = 141;
    public static final int R142 = 142;
    public static final int V2DataTypesNo = 10;
    public static final int V2R3DataTypesNo = 31;
    public static final int V2R51DataTypesNo = 33;
    public static final int V2R61DataTypesNo = 35;
    public static final int V2R62DataTypesAndBigIntNo = 36;
    boolean usingXviews = false;
    private String dbc_databases = "DBC.DATABASES";
    private String dbc_tables = "DBC.TABLES";
    private String dbc_columns = "DBC.COLUMNS";
    private String dbc_allRights = "DBC.AllRights";
    private String dbc_indices = "DBC.INDICES";
    private String dbc_allRiParents = "DBC.All_RI_Parents";
    static final int TDAT_NOACCESS = 3869;
    static final int TDAT_VIEWHASNOINDEXCOLUMN = 3720;
    static final int TDAT_VIEWMADEUPOFSEVERALTABLES = 3823;
    static final int TDAT_NOSTATSFORVOLATILETABLE = 5341;
    static final int TDAT_NOSTATSCOLLECTED = 3624;

    public TeraDatabaseMetaData(TeraConnection teraConnection) throws SQLException {
        this.connection = teraConnection;
        String[] stringArray = this.getDatabaseProductVersion().replaceAll("\\D+", " ").trim().split(" ");
        this.nDatabaseMajorVersion = Integer.parseInt(stringArray[0]);
        this.nDatabaseMinorVersion = Integer.parseInt(stringArray[1]);
        int n = Integer.parseInt(stringArray[2]);
        this.DBCRelease = this.nDatabaseMajorVersion < 12 ? this.nDatabaseMinorVersion * 10 + n : this.nDatabaseMajorVersion * 10 + this.nDatabaseMinorVersion;
        if (((TeraLocalConnection)this.connection).getTDSession().getURLParameters().getuseXviews()) {
            this.usingXviews = true;
            this.dbc_databases = this.dbc_databases + "X";
            this.dbc_tables = this.dbc_tables + "X";
            this.dbc_columns = this.dbc_columns + "X";
            this.dbc_allRights = this.dbc_allRights + "X";
            this.dbc_allRiParents = this.dbc_allRiParents + "X";
            this.dbc_indices = this.dbc_indices + "X";
        }
    }

    protected final int getDBCRelease() {
        return this.DBCRelease;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return this.usingXviews;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.usingXviews;
    }

    public String getURL() throws SQLException {
        return "jdbc:teradata";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUserName() throws SQLException {
        Statement statement = null;
        String string = null;
        try {
            statement = this.connection.createStatement();
            java.sql.ResultSet resultSet = statement.executeQuery("select user");
            resultSet.next();
            string = resultSet.getString(1);
            Object var5_4 = null;
            if (statement == null) return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            statement.close();
            return string;
        }
        catch (SQLException sQLException) {}
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getNullCollation() == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getNullCollation() == 1;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getDBMS();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return ((TeraLocalConnection)this.connection).getTDSession().getTeradataDatabaseVersion();
    }

    public String getDriverName() throws SQLException {
        return "com.teradata.jdbc.TeraDriver";
    }

    public String getDriverVersion() throws SQLException {
        return Const.DRIVER_VERSION;
    }

    public int getDriverMajorVersion() {
        return 13;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 0;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 1;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 2;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 0;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 1;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 2;
    }

    public String getIdentifierQuoteString() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getIdentifierQuote();
    }

    public String getSQLKeywords() throws SQLException {
        if (this.DBCRelease <= 50) {
            return "ABORT, ABORTSESSION, ABS, ACCESS, ACCESS_LOCK, ACCOUNT, ACOS, ACOSH, ADA, ADD_MONTHS, ADMIN, AFTER, AGGREGATE, ALIAS, ALLOCATION, ALWAYS, AMP, ANALYSIS, ANSIDATE, ARRAY, ASCII, ASENSITIVE, ASIN, ASINH, ASSIGNMENT, ASYMMETRIC, ATAN, ATAN2, ATANH, ATOMIC, ATTR, ATTRIBUTES, ATTRS, AVE, AVERAGE, BEFORE, BINARY, BITVAR, BLOB, BOOLEAN, BREADTH, BT, BUT, BYTE, BYTEINT, BYTES, C, CALL, CALLED, CARDINALITY, CASESPECIFIC, CASE_N, CATALOG_NAME, CD, CHAIN, CHANGERATE, CHAR2HEXINT, CHARACTERS, CHARACTER_SET_CATALOG, CHARACTER_SET_NAME, CHARACTER_SET_SCHEMA, CHARS, CHARSET_COLL, CHECKED, CHECKPOINT, CHECKSUM, CLASS, CLASS_ORIGIN, CLOB, CLUSTER, CM, COBOL, COLLATION_CATALOG, COLLATION_NAME, COLLATION_SCHEMA, COLLECT, COLUMNSPERINDEX, COLUMN_NAME, COMMAND_FUNCTION, COMMAND_FUNCTION_CODE, COMMENT, COMMITTED, COMPLETION, COMPRESS, CONDITION_NUMBER, CONNECTION_NAME, CONSTRAINT_CATALOG, CONSTRAINT_NAME, CONSTRAINT_SCHEMA, CONSTRUCTOR, CONTAINS, CONVERT_TABLE_HEADER, CORR, COS, COSH, COSTS, COVAR_POP, COVAR_SAMP, CS, CSUM, CT, CUBE, CURRENT_PATH, CURRENT_ROLE, CURSOR_NAME, CV, CYCLE, DATA, DATABASE, DATABLOCKSIZE, DATEFORM, DATETIME_INTERVAL_CODE, DATETIME_INTERVAL_PRECISION, DBC, DEFINED, DEFINER, DEGREES, DEL, DEMOGRAPHICS, DENIALS, DEPTH, DEREF, DESTROY, DESTRUCTOR, DETERMINISTIC, DIAGNOSTIC, DICTIONARY, DIGITS, DISABLED, DISPATCH, DO, DUAL, DUMP, DYNAMIC, DYNAMIC_FUNCTION, DYNAMIC_FUNCTION_CODE, EACH, EBCDIC, ECHO, ELSEIF, ENABLED, EQ, EQUALS, ERROR, ERRORFILES, ERRORTABLES, ET, EVERY, EXCL, EXCLUSIVE, EXISTING, EXIT, EXP, EXPIRE, EXPLAIN, FALLBACK, FASTEXPORT, FINAL, FOLLOWING, FORMAT, FORTRAN, FREE, FREESPACE, FUNCTION, G, GE, GENERAL, GENERATED, GIVE, GRANTED, GRAPHIC, GROUPING, GT, HANDLER, HASH, HASHAMP, HASHBAKAMP, HASHBUCKET, HASHROW, HELP, HIERARCHY, HOLD, HOST, IF, IFP, IGNORE, IMPLEMENTATION, INCONSISTENT, INCREMENT, INDEX, INDEXESPERTABLE, INFIX, INITIALIZE, INITIATE, INOUT, INS, INSTANCE, INSTANTIABLE, INSTEAD, INTEGERDATE, INVOKER, ITERATE, JIS_COLL, JOURNAL, K, KANJI1, KANJISJIS, KBYTE, KBYTES, KEEP, KEY_MEMBER, KEY_TYPE, KILOBYTES, KURTOSIS, LARGE, LATERAL, LATIN, LE, LEAVE, LENGTH, LESS, LIMIT, LN, LOADING, LOCALTIME, LOCALTIMESTAMP, LOCATOR, LOCK, LOCKEDUSEREXPIRE, LOCKING, LOG, LOGGING, LOGON, LONG, LOOP, LT, M, MACRO, MAP, MATCHED, MAVG, MAXCHAR, MAXIMUM, MAXLOGONATTEMPTS, MAXVALUE, MCHARACTERS, MDIFF, MERGE, MESSAGE_LENGTH, MESSAGE_OCTET_LENGTH, MESSAGE_TEXT, METHOD, MINCHAR, MINDEX, MINIMUM, MINUS, MINVALUE, MLINREG, MLOAD, MOD, MODE, MODIFIED, MODIFIES, MODIFY, MONITOR, MONRESOURCE, MONSESSION, MORE, MSUBSTR, MSUM, MULTINATIONAL, MULTISET, MUMPS, NAME, NAMED, NCLOB, NE, NEW, NEW_TABLE, NONE, NOWAIT, NULLABLE, NULLIFZERO, NUMBER, OBJECT, OBJECTS, OFF, OLD, OLD_TABLE, OPERATION, OPTIONS, ORDINALITY, OUT, OVER, OVERLAY, OVERRIDE, OVERRIDING, PARAMETER, PARAMETERS, PARAMETER_MODE, PARAMETER_NAME, PARAMETER_ORDINAL_POSITION, PARAMETER_SPECIFIC_CATALOG, PARAMETER_SPECIFIC_NAME, PARAMETER_SPECIFIC_SCHEMA, PARTITION, PARTITIONED, PASCAL, PASSWORD, PATH, PERCENT, PERCENT_RANK, PERM, PERMANENT, PLI, POSTFIX, PRECEDING, PREFIX, PREORDER, PRIVATE, PROFILE, PROPORTIONAL, PROTECTION, QUALIFIED, QUALIFY, QUANTILE, QUERY, RADIANS, RANDOM, RANDOMIZED, RANGE, RANGE_N, RANK, READS, RECALC, RECURSIVE, REF, REFERENCING, REGR_AVGX, REGR_AVGY, REGR_COUNT, REGR_INTERCEPT, REGR_R2, REGR_SLOPE, REGR_SXX, REGR_SXY, REGR_SYY, RELEASE, RENAME, REPEAT, REPEATABLE, REPLACE, REPLACEMENT, REPLICATION, REPOVERRIDE, REQUEST, RESTART, RESTORE, RESULT, RESUME, RET, RETRIEVE, RETURN, RETURNED_LENGTH, RETURNED_OCTET_LENGTH, RETURNED_SQLSTATE, RETURNS, REUSE, REVALIDATE, RIGHTS, ROLE, ROLLFORWARD, ROLLUP, ROUTINE, ROUTINE_CATALOG, ROUTINE_NAME, ROUTINE_SCHEMA, ROW, ROWID, ROW_COUNT, ROW_NUMBER, SAMPLE, SAMPLEID, SAMPLES, SAVEPOINT, SCALE, SCHEMA_NAME, SCOPE, SEARCH, SEARCHSPACE, SECURITY, SEL, SELF, SENSITIVE, SEQUENCE, SERIALIZABLE, SERVER_NAME, SETRESRATE, SETS, SETSESSRATE, SHARE, SHOW, SIMILAR, SIMPLE, SIN, SINH, SKEW, SOUNDEX, SOURCE, SPECCHAR, SPECIFIC, SPECIFICTYPE, SPECIFIC_NAME, SPOOL, SQLEXCEPTION, SQLTEXT, SQLWARNING, SQRT, SS, START, STARTUP, STAT, STATE, STATEMENT, STATIC, STATISTICS, STATS, STDDEV_POP, STDDEV_SAMP, STEPINFO, STRING_CS, STRUCTURE, STYLE, SUBCLASS_ORIGIN, SUBLIST, SUBSCRIBER, SUBSTR, SUMMARY, SUSPEND, SYMMETRIC, SYSTEM, SYSTEMTEST, TABLE_NAME, TAN, TANH, TBL_CS, TERMINATE, TEXT, THAN, THRESHOLD, TITLE, TPA, TRACE, TRANSACTIONS_COMMITTED, TRANSACTIONS_ROLLED_BACK, TRANSACTION_ACTIVE, TRANSFORM, TRANSFORMS, TRANSLATE_CHK, TREAT, TRIGGER, TRIGGER_CATALOG, TRIGGER_NAME, TRIGGER_SCHEMA, TYPE, UC, UNBOUNDED, UNCOMMITTED, UNDEFINED, UNDER, UNDO, UNICODE, UNNAMED, UNNEST, UNTIL, UPD, UPPERCASE, USE, USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_NAME, USER_DEFINED_TYPE_SCHEMA, VARBYTE, VARGRAPHIC, VARIABLE, VAR_POP, VAR_SAMP, VOLATILE, WAIT, WHILE, WIDTH_BUCKET, WITHOUT, ZEROIFNULL";
        }
        if (this.DBCRelease <= 51) {
            return "ABORT, ABORTSESSION, ABS, ACCESS, ACCESS_LOCK, ACCOUNT, ACOS, ACOSH, ADA, ADD_MONTHS, ADMIN, AFTER, AGGREGATE, ALIAS, ALLOCATION, ALWAYS, AMP, ANALYSIS, ANSIDATE, ARRAY, ASCII, ASENSITIVE, ASIN, ASINH, ASSIGNMENT, ASYMMETRIC, ATAN, ATAN2, ATANH, ATOMIC, ATTR, ATTRIBUTES, ATTRS, AVE, AVERAGE, BEFORE, BINARY, BITVAR, BLOB, BOOLEAN, BREADTH, BT, BUT, BYTE, BYTEINT, BYTES, C, CALL, CALLED, CARDINALITY, CASESPECIFIC, CASE_N, CATALOG_NAME, CD, CHAIN, CHANGERATE, CHAR2HEXINT, CHARACTERS, CHARACTER_SET_CATALOG, CHARACTER_SET_NAME, CHARACTER_SET_SCHEMA, CHARS, CHARSET_COLL, CHECKED, CHECKPOINT, CHECKSUM, CLASS, CLASS_ORIGIN, CLOB, CLUSTER, CM, COBOL, COLLATION_CATALOG, COLLATION_NAME, COLLATION_SCHEMA, COLLECT, COLUMNSPERINDEX, COLUMN_NAME, COMMAND_FUNCTION, COMMAND_FUNCTION_CODE, COMMENT, COMMITTED, COMPLETION, COMPRESS, CONDITION_NUMBER, CONNECTION_NAME, CONSTRAINT_CATALOG, CONSTRAINT_NAME, CONSTRAINT_SCHEMA, CONSTRUCTOR, CONTAINS, CONVERT_TABLE_HEADER, CORR, COS, COSH, COSTS, COVAR_POP, COVAR_SAMP, CS, CSUM, CT, CUBE, CURRENT_PATH, CURRENT_ROLE, CURSOR_NAME, CV, CYCLE, DATA, DATABASE, DATABLOCKSIZE, DATEFORM, DATETIME_INTERVAL_CODE, DATETIME_INTERVAL_PRECISION, DBC, DEFINED, DEFINER, DEGREES, DEL, DEMOGRAPHICS, DENIALS, DEPTH, DEREF, DESTROY, DESTRUCTOR, DETERMINISTIC, DIAGNOSTIC, DICTIONARY, DIGITS, DISABLED, DISPATCH, DO, DUAL, DUMP, DYNAMIC, DYNAMIC_FUNCTION, DYNAMIC_FUNCTION_CODE, EACH, EBCDIC, ECHO, ELSEIF, ENABLED, EQ, EQUALS, ERROR, ERRORFILES, ERRORTABLES, ET, EVERY, EXCL, EXCLUSIVE, EXISTING, EXIT, EXP, EXPIRE, EXPLAIN, FALLBACK, FASTEXPORT, FINAL, FOLLOWING, FORMAT, FORTRAN, FREE, FREESPACE, FUNCTION, G, GE, GENERAL, GENERATED, GIVE, GRANTED, GRAPHIC, GROUPING, GT, HANDLER, HASH, HASHAMP, HASHBAKAMP, HASHBUCKET, HASHROW, HELP, HIERARCHY, HIGH, HOLD, HOST, IF, IFP, IGNORE, IMPLEMENTATION, INCONSISTENT, INCREMENT, INDEX, INDEXESPERTABLE, INFIX, INITIALIZE, INITIATE, INOUT, INS, INSTANCE, INSTANTIABLE, INSTEAD, INTEGERDATE, INVOKER, ITERATE, JIS_COLL, JOURNAL, K, KANJI1, KANJISJIS, KBYTE, KBYTES, KEEP, KEY_MEMBER, KEY_TYPE, KILOBYTES, KURTOSIS, LARGE, LATERAL, LATIN, LE, LEAVE, LENGTH, LESS, LIMIT, LN, LOADING, LOCALTIME, LOCALTIMESTAMP, LOCATOR, LOCK, LOCKEDUSEREXPIRE, LOCKING, LOG, LOGGING, LOGON, LONG, LOOP, LOW, LT, M, MACRO, MAP, MATCHED, MAVG, MAXCHAR, MAXIMUM, MAXLOGONATTEMPTS, MAXVALUE, MCHARACTERS, MDIFF, MEDIUM, MERGE, MESSAGE_LENGTH, MESSAGE_OCTET_LENGTH, MESSAGE_TEXT, METHOD, MINCHAR, MINDEX, MINIMUM, MINUS, MINVALUE, MLINREG, MLOAD, MOD, MODE, MODIFIED, MODIFIES, MODIFY, MONITOR, MONRESOURCE, MONSESSION, MORE, MSUBSTR, MSUM, MULTINATIONAL, MULTISET, MUMPS, NAME, NAMED, NCLOB, NE, NEW, NEW_TABLE, NONE, NOWAIT, NULLABLE, NULLIFZERO, NUMBER, OBJECT, OBJECTS, OFF, OLD, OLD_TABLE, OPERATION, OPTIONS, ORDERED_ANALYTIC, ORDINALITY, OUT, OVER, OVERLAY, OVERRIDE, OVERRIDING, PARAMETER, PARAMETERS, PARAMETER_MODE, PARAMETER_NAME, PARAMETER_ORDINAL_POSITION, PARAMETER_SPECIFIC_CATALOG, PARAMETER_SPECIFIC_NAME, PARAMETER_SPECIFIC_SCHEMA, PARTITION, PARTITIONED, PASCAL, PASSWORD, PATH, PERCENT, PERCENT_RANK, PERM, PERMANENT, PLI, POSTFIX, PRECEDING, PREFIX, PREORDER, PRIVATE, PROFILE, PROPORTIONAL, PROTECTED, PROTECTION, QUALIFIED, QUALIFY, QUANTILE, QUERY, RADIANS, RANDOM, RANDOMIZED, RANGE, RANGE_N, RANK, READS, RECALC, RECURSIVE, REF, REFERENCING, REGR_AVGX, REGR_AVGY, REGR_COUNT, REGR_INTERCEPT, REGR_R2, REGR_SLOPE, REGR_SXX, REGR_SXY, REGR_SYY, RELEASE, RENAME, REPEAT, REPEATABLE, REPLACE, REPLACEMENT, REPLICATION, REPOVERRIDE, REQUEST, RESTART, RESTORE, RESULT, RESUME, RET, RETRIEVE, RETURN, RETURNED_LENGTH, RETURNED_OCTET_LENGTH, RETURNED_SQLSTATE, RETURNS, REUSE, REVALIDATE, RIGHTS, ROLE, ROLLFORWARD, ROLLUP, ROUTINE, ROUTINE_CATALOG, ROUTINE_NAME, ROUTINE_SCHEMA, ROW, ROWID, ROW_COUNT, ROW_NUMBER, SAMPLE, SAMPLEID, SAMPLES, SAVEPOINT, SCALE, SCHEMA_NAME, SCOPE, SEARCH, SEARCHSPACE, SECURITY, SEL, SELF, SENSITIVE, SEQUENCE, SERIALIZABLE, SERVER_NAME, SETRESRATE, SETS, SETSESSRATE, SHARE, SHOW, SIMILAR, SIMPLE, SIN, SINH, SKEW, SOUNDEX, SOURCE, SPECCHAR, SPECIFIC, SPECIFICTYPE, SPECIFIC_NAME, SPOOL, SQLEXCEPTION, SQLTEXT, SQLWARNING, SQRT, SS, START, STARTUP, STAT, STATE, STATEMENT, STATIC, STATISTICS, STATS, STDDEV_POP, STDDEV_SAMP, STEPINFO, STRING_CS, STRUCTURE, STYLE, SUBCLASS_ORIGIN, SUBLIST, SUBSCRIBER, SUBSTR, SUMMARY, SUSPEND, SYMMETRIC, SYSTEM, SYSTEMTEST, TABLE_NAME, TAN, TANH, TBL_CS, TD_GENERAL, TERMINATE, TEXT, THAN, THRESHOLD, TITLE, TPA, TRACE, TRANSACTIONS_COMMITTED, TRANSACTIONS_ROLLED_BACK, TRANSACTION_ACTIVE, TRANSFORM, TRANSFORMS, TRANSLATE_CHK, TREAT, TRIGGER, TRIGGER_CATALOG, TRIGGER_NAME, TRIGGER_SCHEMA, TYPE, UC, UNBOUNDED, UNCOMMITTED, UNDEFINED, UNDER, UNDO, UNICODE, UNNAMED, UNNEST, UNTIL, UPD, UPPERCASE, USE, USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_NAME, USER_DEFINED_TYPE_SCHEMA, VARBYTE, VARGRAPHIC, VARIABLE, VAR_POP, VAR_SAMP, VOLATILE, WAIT, WHILE, WIDTH_BUCKET, WITHOUT, ZEROIFNULL";
        }
        if (this.DBCRelease <= 62) {
            return "A, ABORT, ABORTSESSION, ABS, ACCESS, ACCESS_LOCK, ACCOUNT, ACOS, ACOSH, ADA, ADD_MONTHS, ADMIN, AFTER, AG, AGGREGATE, ALIAS, ALLOCATION, ALWAYS, AMP, ANALYSIS, ANSIDATE, ARGLPAREN, ARRAY, ASCII, ASENSITIVE, ASIN, ASINH, ASSIGNMENT, ASYMMETRIC, ATAN, ATAN2, ATANH, ATOMIC, ATTR, ATTRIBUTE, ATTRIBUTES, ATTRS, AVE, AVERAGE, BEFORE, BERNOULLI, BIGINT, BINARY, BLOB, BOOLEAN, BREADTH, BT, BUT, BYTE, BYTEINT, BYTES, C, CALL, CALLED, CARDINALITY, CASESPECIFIC, CASE_N, CATALOG_NAME, CD, CEIL, CEILING, CHAIN, CHANGERATE, CHAR2HEXINT, CHARACTERISTICS, CHARACTERS, CHARACTER_SET_CATALOG, CHARACTER_SET_NAME, CHARACTER_SET_SCHEMA, CHARS, CHARSET_COLL, CHECKPOINT, CHECKSUM, CLASS, CLASS_ORIGIN, CLOB, CLUSTER, CM, COBOL, COLLATION_CATALOG, COLLATION_NAME, COLLATION_SCHEMA, COLLECT, COLUMNSPERINDEX, COLUMN_NAME, COMMAND_FUNCTION, COMMAND_FUNCTION_CODE, COMMENT, COMMITTED, COMPILE, COMPRESS, CONDITION, CONDITION_NUMBER, CONNECTION_NAME, CONSTRAINT_CATALOG, CONSTRAINT_NAME, CONSTRAINT_SCHEMA, CONSTRUCTOR, CONSUME, CONTAINS, CONVERT_TABLE_HEADER, CORR, COS, COSH, COSTS, COVAR_POP, COVAR_SAMP, CPP, CPUTIME, CS, CSUM, CT, CUBE, CUME_DIST, CURRENT_DEFAULT_TRANSFORM_GROUP, CURRENT_PATH, CURRENT_ROLE, CURRENT_TRANSFORM_GROUP_FOR_TYPE, CURSOR_NAME, CV, CYCLE, DATA, DATABASE, DATABLOCKSIZE, DATEFORM, DATETIME_INTERVAL_CODE, DATETIME_INTERVAL_PRECISION, DBC, DEBUG, DEFAULTS, DEFINED, DEFINER, DEGREES, DEL, DEMOGRAPHICS, DENIALS, DENSE_RANK, DEPTH, DEREF, DERIVED, DETERMINISTIC, DIAGNOSTIC, DIGITS, DISABLED, DISPATCH, DO, DUAL, DUMP, DYNAMIC, DYNAMIC_FUNCTION, DYNAMIC_FUNCTION_CODE, EACH, EBCDIC, ECHO, ELEMENT, ELSEIF, ENABLED, ENCRYPT, EQ, EQUALS, ERROR, ERRORFILES, ERRORTABLES, ET, EVERY, EXCL, EXCLUDE, EXCLUDING, EXCLUSIVE, EXIT, EXP, EXPIRE, EXPLAIN, FALLBACK, FASTEXPORT, FILTER, FINAL, FLOOR, FOLLOWING, FORMAT, FORTRAN, FREE, FREESPACE, FUNCTION, FUSION, G, GE, GENERAL, GENERATED, GIVE, GRANTED, GRAPHIC, GROUPING, GT, HANDLER, HASH, HASHAMP, HASHBAKAMP, HASHBUCKET, HASHROW, HELP, HIERARCHY, HIGH, HOLD, HOST, IF, IFP, IMPLEMENTATION, INCLUDING, INCONSISTENT, INCREMENT, INDEX, INDEXESPERTABLE, INITIATE, INOUT, INS, INSTANCE, INSTANTIABLE, INSTEAD, INTEGERDATE, INTERSECTION, INVOKER, IOCOUNT, ITERATE, JAVA, JIS_COLL, JOURNAL, K, KANJI1, KANJISJIS, KBYTE, KBYTES, KEEP, KEY_MEMBER, KEY_TYPE, KILOBYTES, KURTOSIS, LARGE, LATERAL, LATIN, LE, LEAVE, LENGTH, LIMIT, LN, LOADING, LOCALTIME, LOCALTIMESTAMP, LOCATOR, LOCK, LOCKEDUSEREXPIRE, LOCKING, LOG, LOGGING, LOGON, LONG, LOOP, LOW, LT, M, MACRO, MAP, MATCHED, MAVG, MAXCHAR, MAXIMUM, MAXLOGONATTEMPTS, MAXVALUE, MCHARACTERS, MDIFF, MEDIUM, MEMBER, MERGE, MESSAGE_LENGTH, MESSAGE_OCTET_LENGTH, MESSAGE_TEXT, METHOD, MINCHAR, MINDEX, MINIMUM, MINUS, MINVALUE, MLINREG, MLOAD, MOD, MODE, MODIFIED, MODIFIES, MODIFY, MONITOR, MONRESOURCE, MONSESSION, MORE, MSUBSTR, MSUM, MULTINATIONAL, MULTISET, MUMPS, NAME, NAMED, NCLOB, NE, NESTING, NEW, NEW_TABLE, NONE, NORMALIZE, NORMALIZED, NOWAIT, NULLABLE, NULLIFZERO, NULLS, NUMBER, OA, OBJECT, OBJECTS, OCTETS, OFF, OLD, OLD_TABLE, OPTIONS, ORDERED_ANALYTIC, ORDERING, ORDINALITY, OTHERS, OUT, OVER, OVERLAY, OVERRIDE, OVERRIDING, PARAMETER, PARAMETER_MODE, PARAMETER_NAME, PARAMETER_ORDINAL_POSITION, PARAMETER_SPECIFIC_CATALOG, PARAMETER_SPECIFIC_NAME, PARAMETER_SPECIFIC_SCHEMA, PARTITION, PARTITIONED, PASCAL, PASSWORD, PATH, PERCENT, PERCENTILE_CONT, PERCENTILE_DISC, PERCENT_RANK, PERM, PERMANENT, PLACING, PLI, POWER, PRECEDING, PRINT, PRIVATE, PROFILE, PROTECTED, PROTECTION, QUALIFIED, QUALIFY, QUANTILE, QUERY, QUEUE, RADIANS, RANDOM, RANDOMIZED, RANGE, RANGE_N, RANK, READS, RECALC, RECURSIVE, REF, REFERENCING, REGR_AVGX, REGR_AVGY, REGR_COUNT, REGR_INTERCEPT, REGR_R2, REGR_SLOPE, REGR_SXX, REGR_SXY, REGR_SYY, RELEASE, RENAME, REPEAT, REPEATABLE, REPLACE, REPLACEMENT, REPLCONTROL, REPLICATION, REQUEST, RESTART, RESTORE, RESULT, RESUME, RET, RETRIEVE, RETURN, RETURNED_CARDINALITY, RETURNED_LENGTH, RETURNED_OCTET_LENGTH, RETURNED_SQLSTATE, RETURNS, REUSE, REVALIDATE, RIGHTS, ROLE, ROLLFORWARD, ROLLUP, ROUTINE, ROUTINE_CATALOG, ROUTINE_NAME, ROUTINE_SCHEMA, ROW, ROWID, ROW_COUNT, ROW_NUMBER, SAMPLE, SAMPLEID, SAMPLES, SAVEPOINT, SCALE, SCHEMA_NAME, SCOPE, SCOPE_CATALOG, SCOPE_NAME, SCOPE_SCHEMA, SEARCH, SEARCHSPACE, SECURITY, SEL, SELF, SENSITIVE, SEQUENCE, SERIALIZABLE, SERVER_NAME, SETRESRATE, SETS, SETSESSRATE, SHARE, SHOW, SIMILAR, SIMPLE, SIN, SINH, SKEW, SOUNDEX, SOURCE, SPECCHAR, SPECIFIC, SPECIFICTYPE, SPECIFIC_NAME, SPL, SPOOL, SQLEXCEPTION, SQLTEXT, SQLWARNING, SQRT, SS, START, STARTUP, STAT, STATE, STATEMENT, STATIC, STATISTICS, STATS, STDDEV_POP, STDDEV_SAMP, STEPINFO, STRING_CS, STRUCTURE, STYLE, SUBCLASS_ORIGIN, SUBMULTISET, SUBSCRIBER, SUBSTR, SUMMARY, SUMMARYONLY, SUSPEND, SYMMETRIC, SYSTEM, SYSTEMTEST, TABLESAMPLE, TABLE_NAME, TAN, TANH, TARGET, TBL_CS, TD_GENERAL, TD_INTERNAL, TERMINATE, TEXT, THRESHOLD, TIES, TITLE, TOP, TOP_LEVEL_COUNT, TPA, TRACE, TRANSACTIONS_COMMITTED, TRANSACTIONS_ROLLED_BACK, TRANSACTION_ACTIVE, TRANSFORM, TRANSFORMS, TRANSLATE_CHK, TREAT, TRIGGER, TRIGGER_CATALOG, TRIGGER_NAME, TRIGGER_SCHEMA, TYPE, UC, UDTCASTAS, UDTCASTLPAREN, UDTMETHOD, UDTTYPE, UDTUSAGE, UESCAPE, UNBOUNDED, UNCOMMITTED, UNDEFINED, UNDER, UNDO, UNICODE, UNNAMED, UNNEST, UNTIL, UPD, UPPERCASE, USE, USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_CODE, USER_DEFINED_TYPE_NAME, USER_DEFINED_TYPE_SCHEMA, VARBYTE, VARGRAPHIC, VAR_POP, VAR_SAMP, VOLATILE, WAIT, WARNING, WHILE, WIDTH_BUCKET, WINDOW, WITHIN, WITHOUT, ZEROIFNULL";
        }
        if (this.DBCRelease < 130) {
            return "A, ABORT, ABORTSESSION, ABS, ACCESS, ACCESS_LOCK, ACCOUNT, ACOS, ACOSH, ADA, ADD_MONTHS, ADMIN, AFTER, AG, AGGREGATE, ALIAS, ALLOCATION, ALWAYS, AMP, ANALYSIS, ANSIDATE, ARGLPAREN, ARRAY, ASCII, ASENSITIVE, ASIN, ASINH, ASSIGNMENT, ASYMMETRIC, ATAN, ATAN2, ATANH, ATOMIC, ATTR, ATTRIBUTE, ATTRIBUTES, ATTRS, AVE, AVERAGE, BEFORE, BERNOULLI, BIGINT, BINARY, BLOB, BOOLEAN, BREADTH, BT, BUT, BYTE, BYTEINT, BYTES, C, CALL, CALLED, CARDINALITY, CASESPECIFIC, CASE_N, CATALOG_NAME, CD, CEIL, CEILING, CHAIN, CHANGERATE, CHAR2HEXINT, CHARACTERISTICS, CHARACTERS, CHARACTER_SET_CATALOG, CHARACTER_SET_NAME, CHARACTER_SET_SCHEMA, CHARS, CHARSET_COLL, CHECKPOINT, CHECKSUM, CLASS, CLASS_ORIGIN, CLOB, CLUSTER, CM, COBOL, COLLATION_CATALOG, COLLATION_NAME, COLLATION_SCHEMA, COLLECT, COLUMNSPERINDEX, COLUMN_NAME, COMMAND_FUNCTION, COMMAND_FUNCTION_CODE, COMMENT, COMMITTED, COMPILE, COMPRESS, CONDITION, CONDITION_NUMBER, CONNECTION_NAME, CONSTRAINT_CATALOG, CONSTRAINT_NAME, CONSTRAINT_SCHEMA, CONSTRUCTOR, CONSUME, CONTAINS, CONVERT_TABLE_HEADER, CORR, COS, COSH, COSTS, COVAR_POP, COVAR_SAMP, CPP, CPUTIME, CS, CSUM, CT, CUBE, CUME_DIST, CURRENT_DEFAULT_TRANSFORM_GROUP, CURRENT_PATH, CURRENT_ROLE, CURRENT_TRANSFORM_GROUP_FOR_TYPE, CURSOR_NAME, CV, CYCLE, DATA, DATABASE, DATABLOCKSIZE, DATEFORM, DATETIME_INTERVAL_CODE, DATETIME_INTERVAL_PRECISION, DBC, DEBUG, DEFAULTS, DEFINED, DEFINER, DEGREES, DEL, DEMOGRAPHICS, DENIALS, DENSE_RANK, DEPTH, DEREF, DERIVED, DETERMINISTIC, DIAGNOSTIC, DIGITS, DISABLED, DISPATCH, DO, DUAL, DUMP, DYNAMIC, DYNAMIC_FUNCTION, DYNAMIC_FUNCTION_CODE, EACH, EBCDIC, ECHO, ELEMENT, ELSEIF, ENABLED, ENCRYPT, EQ, EQUALS, ERROR, ERRORFILES, ERRORTABLES, ET, EVERY, EXCL, EXCLUDE, EXCLUDING, EXCLUSIVE, EXIT, EXP, EXPIRE, EXPLAIN, FALLBACK, FASTEXPORT, FILTER, FINAL, FLOOR, FOLLOWING, FORMAT, FORTRAN, FREE, FREESPACE, FUNCTION, FUSION, G, GE, GENERAL, GENERATED, GIVE, GRANTED, GRAPHIC, GROUPING, GT, HANDLER, HASH, HASHAMP, HASHBAKAMP, HASHBUCKET, HASHROW, HELP, HIERARCHY, HIGH, HOLD, HOST, IF, IFP, IMPLEMENTATION, INCLUDING, INCONSISTENT, INCREMENT, INDEX, INDEXESPERTABLE, INITIATE, INOUT, INS, INSTANCE, INSTANTIABLE, INSTEAD, INTEGERDATE, INTERSECTION, INVOKER, IOCOUNT, ITERATE, JAR, JAVA, JIS_COLL, JOURNAL, K, KANJI1, KANJISJIS, KBYTE, KBYTES, KEEP, KEY_MEMBER, KEY_TYPE, KILOBYTES, KURTOSIS, LARGE, LATERAL, LATIN, LE, LEAVE, LENGTH, LIMIT, LN, LOADING, LOCALTIME, LOCALTIMESTAMP, LOCATOR, LOCK, LOCKEDUSEREXPIRE, LOCKING, LOG, LOGGING, LOGON, LONG, LOOP, LOW, LT, M, MACRO, MAP, MATCHED, MAVG, MAXCHAR, MAXIMUM, MAXLOGONATTEMPTS, MAXVALUE, MCHARACTERS, MDIFF, MEDIUM, MEMBER, MERGE, MESSAGE_LENGTH, MESSAGE_OCTET_LENGTH, MESSAGE_TEXT, METHOD, MINCHAR, MINDEX, MINIMUM, MINUS, MINVALUE, MLINREG, MLOAD, MOD, MODE, MODIFIED, MODIFIES, MODIFY, MONITOR, MONRESOURCE, MONSESSION, MORE, MSUBSTR, MSUM, MULTINATIONAL, MULTISET, MUMPS, NAME, NAMED, NCLOB, NE, NESTING, NEW, NEW_TABLE, NONE, NORMALIZE, NORMALIZED, NOWAIT, NULLABLE, NULLIFZERO, NULLS, NUMBER, OA, OBJECT, OBJECTS, OCTETS, OFF, OLD, OLD_TABLE, OPTIONS, ORDERED_ANALYTIC, ORDERING, ORDINALITY, OTHERS, OUT, OVER, OVERLAY, OVERRIDE, OVERRIDING, PARAMETER, PARAMETER_MODE, PARAMETER_NAME, PARAMETER_ORDINAL_POSITION, PARAMETER_SPECIFIC_CATALOG, PARAMETER_SPECIFIC_NAME, PARAMETER_SPECIFIC_SCHEMA, PARTITION, PARTITIONED, PASCAL, PASSWORD, PATH, PERCENT, PERCENTILE_CONT, PERCENTILE_DISC, PERCENT_RANK, PERM, PERMANENT, PLACING, PLI, POWER, PRECEDING, PRINT, PRIVATE, PROFILE, PROTECTED, PROTECTION, QUALIFIED, QUALIFY, QUANTILE, QUERY, QUERY_BAND, QUEUE, RADIANS, RANDOM, RANDOMIZED, RANGE, RANGE_N, RANK, READS, RECALC, RECURSIVE, REF, REFERENCING, REGR_AVGX, REGR_AVGY, REGR_COUNT, REGR_INTERCEPT, REGR_R2, REGR_SLOPE, REGR_SXX, REGR_SXY, REGR_SYY, RELEASE, RENAME, REPEAT, REPEATABLE, REPLACE, REPLACEMENT, REPLCONTROL, REPLICATION, REQUEST, RESTART, RESTORE, RESULT, RESUME, RET, RETRIEVE, RETURN, RETURNED_CARDINALITY, RETURNED_LENGTH, RETURNED_OCTET_LENGTH, RETURNED_SQLSTATE, RETURNS, REUSE, REVALIDATE, RIGHTS, ROLE, ROLLFORWARD, ROLLUP, ROUTINE, ROUTINE_CATALOG, ROUTINE_NAME, ROUTINE_SCHEMA, ROW, ROWID, ROW_COUNT, ROW_NUMBER, SAMPLE, SAMPLEID, SAMPLES, SAVEPOINT, SCALE, SCHEMA_NAME, SCOPE, SCOPE_CATALOG, SCOPE_NAME, SCOPE_SCHEMA, SEARCH, SEARCHSPACE, SECURITY, SEL, SELF, SENSITIVE, SEQUENCE, SERIALIZABLE, SERVER_NAME, SETRESRATE, SETS, SETSESSRATE, SHARE, SHOW, SIMILAR, SIMPLE, SIN, SINH, SKEW, SOUNDEX, SOURCE, SPECCHAR, SPECIFIC, SPECIFICTYPE, SPECIFIC_NAME, SPL, SPOOL, SQLEXCEPTION, SQLTEXT, SQLWARNING, SQRT, SS, START, STARTUP, STAT, STATE, STATEMENT, STATIC, STATISTICS, STATS, STDDEV_POP, STDDEV_SAMP, STEPINFO, STRING_CS, STRUCTURE, STYLE, SUBCLASS_ORIGIN, SUBMULTISET, SUBSCRIBER, SUBSTR, SUMMARY, SUMMARYONLY, SUSPEND, SYMMETRIC, SYSTEM, SYSTEMTEST, TABLESAMPLE, TABLE_NAME, TAN, TANH, TARGET, TBL_CS, TD_GENERAL, TD_INTERNAL, TERMINATE, TEXT, THRESHOLD, TIES, TITLE, TOP, TOP_LEVEL_COUNT, TPA, TRACE, TRANSACTIONS_COMMITTED, TRANSACTIONS_ROLLED_BACK, TRANSACTION_ACTIVE, TRANSFORM, TRANSFORMS, TRANSLATE_CHK, TREAT, TRIGGER, TRIGGER_CATALOG, TRIGGER_NAME, TRIGGER_SCHEMA, TYPE, UC, UDTCASTAS, UDTCASTLPAREN, UDTMETHOD, UDTTYPE, UDTUSAGE, UESCAPE, UNBOUNDED, UNCOMMITTED, UNDEFINED, UNDER, UNDO, UNICODE, UNNAMED, UNNEST, UNTIL, UPD, UPPERCASE, USE, USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_CODE, USER_DEFINED_TYPE_NAME, USER_DEFINED_TYPE_SCHEMA, VARBYTE, VARGRAPHIC, VAR_POP, VAR_SAMP, VOLATILE, WAIT, WARNING, WHILE, WIDTH_BUCKET, WINDOW, WITHIN, WITHOUT, ZEROIFNULL";
        }
        return "A, ABORT, ABORTSESSION, ABS, ACCESS, ACCESS_LOCK, ACCOUNT, ACOS, ACOSH, ADA, ADD_MONTHS, ADMIN, AFTER, AG, AGGREGATE, ALIAS, ALLOCATION, ALWAYS, AMP, ANALYSIS, ANSIDATE, ARGLPAREN, ARRAY, ASCII, ASENSITIVE, ASIN, ASINH, ASSIGNMENT, ASYMMETRIC, ATAN, ATAN2, ATANH, ATOMIC, ATTR, ATTRIBUTE, ATTRIBUTES, ATTRS, AVE, AVERAGE, BEFORE, BERNOULLI, BIGINT, BINARY, BLOB, BOOLEAN, BREADTH, BT, BUT, BYTE, BYTEINT, BYTES, C, CALL, CALLED, CARDINALITY, CASESPECIFIC, CASE_N, CATALOG_NAME, CD, CEIL, CEILING, CHAIN, CHANGERATE, CHAR2HEXINT, CHARACTERISTICS, CHARACTERS, CHARACTER_SET_CATALOG, CHARACTER_SET_NAME, CHARACTER_SET_SCHEMA, CHARS, CHARSET_COLL, CHECKPOINT, CHECKSUM, CLASS, CLASS_ORIGIN, CLOB, CLUSTER, CM, COBOL, COLLATION_CATALOG, COLLATION_NAME, COLLATION_SCHEMA, COLLECT, COLUMNSPERINDEX, COLUMN_NAME, COMMAND_FUNCTION, COMMAND_FUNCTION_CODE, COMMENT, COMMITTED, COMPILE, COMPRESS, CONDITION, CONDITION_NUMBER, CONNECTION_NAME, CONSTRAINT_CATALOG, CONSTRAINT_NAME, CONSTRAINT_SCHEMA, CONSTRUCTOR, CONSUME, CONTAINS, CONVERT_TABLE_HEADER, CORR, COS, COSH, COSTS, COVAR_POP, COVAR_SAMP, CPP, CPUTIME, CS, CSUM, CT, CTCONTROL, CUBE, CUME_DIST, CURRENT_DEFAULT_TRANSFORM_GROUP, CURRENT_PATH, CURRENT_ROLE, CURRENT_TRANSFORM_GROUP_FOR_TYPE, CURSOR_NAME, CV, CYCLE, DATA, DATABASE, DATABLOCKSIZE, DATEFORM, DATETIME_INTERVAL_CODE, DATETIME_INTERVAL_PRECISION, DBC, DEBUG, DEFAULTS, DEFINED, DEFINER, DEGREES, DEL, DEMOGRAPHICS, DENIALS, DENSE_RANK, DEPTH, DEREF, DERIVED, DETERMINISTIC, DIAGNOSTIC, DIGITS, DISABLED, DISPATCH, DO, DOWN, DUAL, DUMP, DYNAMIC, DYNAMIC_FUNCTION, DYNAMIC_FUNCTION_CODE, EACH, EBCDIC, ECHO, ELEMENT, ELSEIF, ENABLED, ENCRYPT, EQ, EQUALS, ERROR, ERRORFILES, ERRORTABLES, ET, EVERY, EXCL, EXCLUDE, EXCLUDING, EXCLUSIVE, EXIT, EXP, EXPAND, EXPIRE, EXPLAIN, FALLBACK, FASTEXPORT, FILTER, FINAL, FLOOR, FOLLOWING, FORMAT, FORTRAN, FREE, FREESPACE, FUNCTION, FUSION, G, GE, GENERAL, GENERATED, GIVE, GRANTED, GRAPHIC, GROUPING, GT, HANDLER, HASH, HASHAMP, HASHBAKAMP, HASHBUCKET, HASHROW, HELP, HIERARCHY, HIGH, HOLD, HOST, IF, IFP, IMPLEMENTATION, INCLUDING, INCONSISTENT, INCREMENT, INDEX, INDEXESPERTABLE, INITIATE, INOUT, INS, INSTANCE, INSTANTIABLE, INSTEAD, INTEGERDATE, INTERSECTION, INVOKER, IOCOUNT, ITERATE, JAR, JAVA, JIS_COLL, JOURNAL, K, KANJI1, KANJISJIS, KBYTE, KBYTES, KEEP, KEY_MEMBER, KEY_TYPE, KILOBYTES, KURTOSIS, LARGE, LATERAL, LATIN, LDIFF, LE, LEAVE, LENGTH, LIMIT, LN, LOADING, LOCALTIME, LOCALTIMESTAMP, LOCATOR, LOCK, LOCKEDUSEREXPIRE, LOCKING, LOG, LOGGING, LOGON, LONG, LOOP, LOW, LT, M, MACRO, MAP, MATCHED, MAVG, MAXCHAR, MAXIMUM, MAXLOGONATTEMPTS, MAXVALUE, MCHARACTERS, MDIFF, MEDIUM, MEETS, MEMBER, MERGE, MESSAGE_LENGTH, MESSAGE_OCTET_LENGTH, MESSAGE_TEXT, METHOD, MINCHAR, MINDEX, MINIMUM, MINUS, MINVALUE, MLINREG, MLOAD, MOD, MODE, MODIFIED, MODIFIES, MODIFY, MONITOR, MONRESOURCE, MONSESSION, MORE, MSUBSTR, MSUM, MULTINATIONAL, MULTISET, MUMPS, NAME, NAMED, NCLOB, NE, NESTING, NEW, NEW_TABLE, NONE, NORMALIZE, NORMALIZED, NOWAIT, NULLABLE, NULLIFZERO, NULLS, NUMBER, OA, OBJECT, OBJECTS, OCTETS, OFF, OLD, OLD_NEW_TABLE, OLD_TABLE, OPTIONS, ORDERED_ANALYTIC, ORDERING, ORDINALITY, OTHERS, OUT, OVER, OVERLAY, OVERRIDE, OVERRIDING, P_INTERSECT, P_NORMALIZE, PARAMETER, PARAMETER_MODE, PARAMETER_NAME, PARAMETER_ORDINAL_POSITION, PARAMETER_SPECIFIC_CATALOG, PARAMETER_SPECIFIC_NAME, PARAMETER_SPECIFIC_SCHEMA, PARTITION, PARTITIONED, PASCAL, PASSWORD, PATH, PERCENT, PERCENTILE_CONT, PERCENTILE_DISC, PERCENT_RANK, PERIOD, PERM, PERMANENT, PLACING, PLI, POWER, PRECEDES, PRECEDING, PRINT, PRIVATE, PROFILE, PROTECTED, PROTECTION, QUALIFIED, QUALIFY, QUANTILE, QUERY, QUERY_BAND, QUEUE, RADIANS, RANDOM, RANDOMIZED, RANGE, RANGE_N, RANK, RDIFF, READS, RECALC, RECURSIVE, REF, REFERENCING, REGR_AVGX, REGR_AVGY, REGR_COUNT, REGR_INTERCEPT, REGR_R2, REGR_SLOPE, REGR_SXX, REGR_SXY, REGR_SYY, RELEASE, RENAME, REPEAT, REPEATABLE, REPLACE, REPLACEMENT, REPLCONTROL, REPLICATION, REQUEST, RESIGNAL, RESTART, RESTORE, RESULT, RESUME, RET, RETRIEVE, RETURN, RETURNED_CARDINALITY, RETURNED_LENGTH, RETURNED_OCTET_LENGTH, RETURNED_SQLSTATE, RETURNS, REUSE, REVALIDATE, RIGHTS, ROLE, ROLLFORWARD, ROLLUP, ROUTINE, ROUTINE_CATALOG, ROUTINE_NAME, ROUTINE_SCHEMA, ROW, ROWID, ROW_COUNT, ROW_NUMBER, RULESET, SAMPLE, SAMPLEID, SAMPLES, SAVEPOINT, SCALE, SCHEMA_NAME, SCOPE, SCOPE_CATALOG, SCOPE_NAME, SCOPE_SCHEMA, SEARCH, SEARCHSPACE, SECURITY, SEL, SELF, SENSITIVE, SEQUENCE, SERIALIZABLE, SERVER_NAME, SETRESRATE, SETS, SETSESSRATE, SHARE, SHOW, SIGNAL, SIMILAR, SIMPLE, SIN, SINH, SKEW, SOUNDEX, SOURCE, SPECCHAR, SPECIFIC, SPECIFICTYPE, SPECIFIC_NAME, SPL, SPOOL, SQLEXCEPTION, SQLTEXT, SQLWARNING, SQRT, SS, START, STARTUP, STAT, STATE, STATEMENT, STATIC, STATISTICS, STATS, STDDEV_POP, STDDEV_SAMP, STEPINFO, STRING_CS, STRUCTURE, STYLE, SUBCLASS_ORIGIN, SUBMULTISET, SUBSCRIBER, SUBSTR, SUCCEEDS, SUMMARY, SUMMARYONLY, SUSPEND, SYMMETRIC, SYSTEM, SYSTEMTEST, TABLESAMPLE, TABLE_NAME, TAN, TANH, TARGET, TBL_CS, TD_GENERAL, TD_INTERNAL, TERMINATE, TEXT, THRESHOLD, THROUGH, TIES, TITLE, TOP, TOP_LEVEL_COUNT, TPA, TRACE, TRANSACTIONS_COMMITTED, TRANSACTIONS_ROLLED_BACK, TRANSACTION_ACTIVE, TRANSFORM, TRANSFORMS, TRANSLATE_CHK, TREAT, TRIGGER, TRIGGER_CATALOG, TRIGGER_NAME, TRIGGER_SCHEMA, TYPE, UC, UDTCASTAS, UDTCASTLPAREN, UDTMETHOD, UDTTYPE, UDTUSAGE, UESCAPE, UNBOUNDED, UNCOMMITTED, UNDEFINED, UNDER, UNDO, UNICODE, UNNAMED, UNNEST, UNTIL, UNTIL_CHANGED, UPD, UPPERCASE, USE, USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_CODE, USER_DEFINED_TYPE_NAME, USER_DEFINED_TYPE_SCHEMA, VARBYTE, VARGRAPHIC, VARIANT_TYPE, VAR_POP, VAR_SAMP, VOLATILE, WAIT, WARNING, WHILE, WIDTH_BUCKET, WINDOW, WITHIN, WITHOUT, XMLPLAN, ZEROIFNULL";
    }

    public String getNumericFunctions() throws SQLException {
        if (this.DBCRelease >= 50) {
            return "ABS(arg),ACOS(arg),ACOSH(arg),ASIN(arg),ASINH(arg)ATAN(arg),ATAN2(x,y),ATANH(arg),COS(arg),COSH(arg)EXP(arg),LN(arg),LOG(arg),NULLIFZERO(arg)SIN(arg),SINH(arg),SQRT(arg),TAN(arg),TANH(arg),ZEROIFNULL(arg)";
        }
        return "ABS(arg),EXP(arg),LOG(arg),LN(arg),SQRT(arg),NULLIFZERO(arg),ZEROIFNULL(arg)";
    }

    public String getStringFunctions() throws SQLException {
        return "TRIM, SUBSTRING, SUBSTR, MSUBSTR, INDEX,MINDEX, VARGRAPHIC, CHAR2HEXINT, UPPER";
    }

    public String getSystemFunctions() throws SQLException {
        return "CHARACTERS, BYTES, SUM, CSUM, MSUM, AVERAGE, MAVG, COUNT, MINIMUM, MAXIMUM, MLINREG, QUALIFY, QUANTILE, RANK";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "EXTRACT(<year/month/day> FROM <date_value>),EXTRACT(<hour/minute/second> FROM <real_value>),ADD-MONTHS(<date_expr>, <integer_expr>)";
    }

    public String getSearchStringEscape() throws SQLException {
        return ErrorMessage.messages.getString("TJ183");
    }

    public String getExtraNameCharacters() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getSpecialChars();
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.DBCRelease >= 40;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.DBCRelease >= 60;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.DBCRelease >= 40;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getSupportsExtendedSQLGrammar();
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getSupportsANSI92IntermSQLGrammar();
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getSupportsANSI92FullSQLGrammar();
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getSupportsIntegrityEnhancementFacility();
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    public String getProcedureTerm() throws SQLException {
        if (this.DBCRelease >= 40) {
            return "procedure";
        }
        return "macro";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.DBCRelease >= 40;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.DBCRelease >= 40;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getCursorCommitBehavior() == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getCursorCommitBehavior() == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxBinLiteralChars();
    }

    public int getMaxCharLiteralLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxCharLiteralChars();
    }

    public int getMaxColumnNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxColNameChars();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxColGrpBy();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxColperIdx();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxColOrdrBy();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxColInSel();
    }

    public int getMaxColumnsInTable() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxColinTbl();
    }

    public int getMaxConnections() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaximumDriverConnections();
    }

    public int getMaxCursorNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxCursorNameChars();
    }

    public int getMaxIndexLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxIdxBytes();
    }

    public int getMaxSchemaNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxSchemaNameChars();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxProcedureNameChars();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxRowBytes();
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxRowBytesIncludesLOBs();
    }

    public int getMaxStatementLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxStatementChars();
    }

    public int getMaxStatements() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxRequests();
    }

    public int getMaxTableNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxTblNameChars();
    }

    public int getMaxTablesInSelect() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxTblinSel();
    }

    public int getMaxUserNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getMaxUsrNameChars();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getTransactionIsolationDefault();
    }

    public boolean supportsTransactions() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getTransactionCapability() != 0;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return (configRspParcel.getSupportedTransactionIsolationLevels() & n) != 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getTransactionCapability() == 2;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getTransactionCapability() == 1;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getTransactionCapability() == 3;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getTransactionCapability() == 4;
    }

    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT CAST (null AS VARCHAR(30)) AS PROCEDURE_CAT, TRIM (DATABASENAME) AS PROCEDURE_SCHEM, TRIM (TABLENAME) AS PROCEDURE_NAME, CAST (null AS VARCHAR(30)) AS FUTURE_USE1, CAST (null AS VARCHAR(30)) AS FUTURE_USE2, CAST (null AS VARCHAR(30)) AS FUTURE_USE3, TRIM (COMMENTSTRING) AS REMARKS, CAST (1  AS SMALLINT) AS PROCEDURE_TYPE FROM " + this.dbc_tables + " WHERE TABLEKIND = 'P'" + (string2 != null && !string2.equals("") ? " AND UPPER(TRIM(DATABASENAME)) LIKE UPPER(TRIM('" + string2 + "'))" : "") + (string2 != null && string2.equals("") ? " AND UPPER(TRIM(DATABASENAME)) = UPPER(TRIM(USER))" : "") + (string3 != null && !string3.equals("") ? " AND UPPER(TRIM(TABLENAME)) LIKE UPPER(TRIM('" + string3 + "'))" : "") + " ORDER BY DATABASENAME, TABLENAME";
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        String string5 = "";
        string5 = this.getDBCRelease() < 61 ? "SELECT CAST (NULL AS VARCHAR(30)) AS PROCEDURE_CAT, TRIM (c.DATABASENAME) AS PROCEDURE_SCHEM, TRIM (c.TABLENAME) AS PROCEDURE_NAME, TRIM (COLUMNNAME) AS COLUMN_NAME, CAST ((CASE c.SPPARAMETERTYPE WHEN 'I' THEN 1 WHEN 'O' THEN 4 WHEN 'B' THEN 2 ELSE 0 END) AS SMALLINT) AS COLUMN_TYPE," + TeraDatabaseMetaData.caseJDBCTypes("COLUMNTYPE", null) + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("COLUMNTYPE", null) + " AS TYPE_NAME," + " CAST (DECIMALTOTALDIGITS AS INTEGER) AS \"PRECISION\"," + " CAST (COLUMNLENGTH AS INTEGER) AS LENGTH," + " CAST (DECIMALFRACTIONALDIGITS AS SMALLINT) AS SCALE," + " CAST (10 AS SMALLINT) AS RADIX," + " CAST ((CASE NULLABLE" + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END) AS SMALLINT) AS NULLABLE," + " TRIM (c.COMMENTSTRING) AS REMARKS" + " FROM " + this.dbc_columns + " c," + this.dbc_tables + " t" + " WHERE c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND = 'P'" + (string2 != null && !string2.equals("") ? " AND UPPER(TRIM(c.DATABASENAME)) LIKE UPPER(TRIM('" + string2 + "'))" : "") + (string2 != null && string2.equals("") ? " AND UPPER(TRIM(c.DATABASENAME)) = UPPER(TRIM(USER))" : "") + (string3 != null && !string3.equals("") ? " AND UPPER(TRIM(c.TABLENAME)) LIKE UPPER(TRIM('" + string3 + "'))" : "") + (string4 != null && !string4.equals("") ? " AND UPPER(TRIM(COLUMNNAME)) LIKE UPPER(TRIM('" + string4 + "'))" : "") + " ORDER BY c.DATABASENAME, c.TABLENAME, c.COLUMNID" : "SELECT DISTINCT CAST (NULL AS VARCHAR(30)) AS PROCEDURE_CAT, TRIM (c.DATABASENAME) AS PROCEDURE_SCHEM, TRIM (c.TABLENAME) AS PROCEDURE_NAME, TRIM (COLUMNNAME) AS COLUMN_NAME, CAST ((CASE c.SPPARAMETERTYPE WHEN 'I' THEN 1 WHEN 'O' THEN 4 WHEN 'B' THEN 2 ELSE 0 END) AS SMALLINT) AS COLUMN_TYPE," + TeraDatabaseMetaData.caseJDBCTypes("c.COLUMNTYPE", "u.TYPEKIND") + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.COLUMNTYPE", "c.COLUMNUDTNAME") + " AS TYPE_NAME," + " CAST (DECIMALTOTALDIGITS AS INTEGER) AS \"PRECISION\"," + " CAST (COLUMNLENGTH AS INTEGER) AS LENGTH," + " CAST (DECIMALFRACTIONALDIGITS AS SMALLINT) AS SCALE," + " CAST (10 AS SMALLINT) AS RADIX," + " CAST ((CASE NULLABLE" + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END) AS SMALLINT) AS NULLABLE," + " TRIM (c.COMMENTSTRING) AS REMARKS" + " FROM " + this.dbc_tables + " t, " + this.dbc_columns + " c LEFT OUTER JOIN DBC.UDTINFO u" + " ON c.COLUMNUDTNAME = u.TYPENAME" + " WHERE c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND = 'P'" + (string2 != null && !string2.equals("") ? " AND UPPER(TRIM(c.DATABASENAME)) LIKE UPPER(TRIM('" + string2 + "'))" : "") + (string2 != null && string2.equals("") ? " AND UPPER(TRIM(c.DATABASENAME)) = UPPER(TRIM(USER))" : "") + (string3 != null && !string3.equals("") ? " AND UPPER(TRIM(c.TABLENAME)) LIKE UPPER(TRIM('" + string3 + "'))" : "") + (string4 != null && !string4.equals("") ? " AND UPPER(TRIM(COLUMNNAME)) LIKE UPPER(TRIM('" + string4 + "'))" : "") + " ORDER BY c.DATABASENAME, c.TABLENAME, c.COLUMNID";
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(string5);
        TeraResultSet teraResultSet = (TeraResultSet)resultSet;
        teraResultSet.setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        String string4 = this.buildGetTables(string2, string3, stringArray);
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    protected String buildGetTables(String string, String string2, String[] stringArray) throws SQLException {
        String string3 = " SELECT CAST(NULL AS VARCHAR(100)) AS \"TABLE_CAT\", CAST(DATABASENAME AS VARCHAR(100)) AS \"TABLE_SCHEM\", CAST(TABLENAME AS VARCHAR(100)) AS \"TABLE_NAME\", CASE TABLEKIND WHEN 'V' THEN 'VIEW' ELSE 'TABLE' END \"TABLE_TYPE\", CAST(COMMENTSTRING AS VARCHAR(256)) AS \"REMARKS\", CAST(NULL AS VARCHAR(100)) AS \"TYPE_CAT\", CAST(NULL AS VARCHAR(100)) AS \"TYPE_SCHEM\", CAST(NULL AS VARCHAR(100)) AS \"TYPE_NAME\", CAST(NULL AS VARCHAR(100)) AS \"SELF_REFERENCING_COL_NAME\", CAST(NULL AS VARCHAR(100)) AS \"REF_GENERATION\" FROM " + this.dbc_tables + " WHERE" + (string != null && !string.equals("") ? " UPPER(TRIM(DATABASENAME)) LIKE UPPER(TRIM('" + string + "'))" : "") + (string != null && string.equals("") ? " UPPER(TRIM(DATABASENAME)) = UPPER(TRIM(USER)) " : "") + (string != null && string2 != null && !string2.equals("") ? " AND " : "") + (string2 != null && !string2.equals("") ? " UPPER(TRIM(TABLENAME)) LIKE UPPER(TRIM('" + string2 + "'))" : "") + (string != null || string2 != null && !string2.equals("") ? " AND " : "") + this.buildTableType(stringArray, string) + " ORDER BY TABLEKIND, DATABASENAME, TABLENAME;";
        return string3;
    }

    private String buildTableType(String[] stringArray, String string) throws SQLException {
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (stringArray == null) {
            bl2 = true;
            bl = true;
            bl3 = true;
            bl4 = true;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("TABLE")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("SYSTEM TABLE")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("VIEW")) {
                    bl3 = true;
                    continue;
                }
                bl4 = true;
            }
        }
        if (string != null && string.trim().equalsIgnoreCase("DBC") && bl) {
            return " TABLEKIND IN ('O','T','V') ";
        }
        if (string != null && string.trim().equalsIgnoreCase("DBC") && !bl) {
            return " 1 = 2 ";
        }
        if (string != null && !string.trim().equalsIgnoreCase("DBC") && bl && !bl2 && !bl3) {
            return " 1 = 2 ";
        }
        if (bl) {
            string2 = " ((DATABASENAME = 'DBC' AND TABLEKIND IN ('O','T','V')) ";
            bl5 = true;
        }
        if (!bl) {
            string2 = string2 + " DATABASENAME <> 'DBC' ";
            if (bl2 || bl3) {
                string2 = string2 + " AND ";
            }
        }
        if (bl2) {
            if (!bl5) {
                string2 = string2 + " ( ";
                bl5 = true;
            } else {
                string2 = string2 + " OR ";
            }
            string2 = string2 + " TABLEKIND IN ('O','T') ";
        }
        if (bl3) {
            if (!bl5) {
                string2 = string2 + " ( ";
                bl5 = true;
            } else {
                string2 = string2 + " OR ";
            }
            string2 = string2 + " TABLEKIND = 'V' ";
        }
        if (bl4 && !bl && !bl2 && !bl3) {
            return " 1 = 2 ";
        }
        if (bl5) {
            string2 = string2 + ") ";
        }
        return string2;
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = " SELECT  TRIM(DATABASENAME) AS TABLE_SCHEM,  CAST(null AS varchar(30))  AS TABLE_CATALOG   FROM " + this.dbc_databases + " ORDER BY DATABASENAME";
        java.sql.ResultSet resultSet = statement.executeQuery(string);
        TeraResultSet teraResultSet = (TeraResultSet)resultSet;
        teraResultSet.setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery("select cast(null as VARCHAR(30)) as TABLE_CAT where 1 = 0");
        TeraResultSet teraResultSet = (TeraResultSet)resultSet;
        teraResultSet.setMetadataRS(true);
        return resultSet;
    }

    private void addColumnInfo(TeraResultSetMetaData teraResultSetMetaData, ColumnInfo columnInfo) {
        ColumnProperties columnProperties = new ColumnProperties();
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties.setPrecision(columnInfo.getPrecision());
        columnProperties.setScale(columnInfo.getScale());
        columnProperties.setColumnName(columnInfo.getColumnName());
        columnProperties.setColumnLabel(columnInfo.getColumnName());
        columnProperties.setNullable(columnInfo.getNullable());
        columnProperties.setColumnType(columnInfo.getColumnType());
        columnProperties.setTdType(columnInfo.getTdType());
        columnProperties.setColumnDisplaySize(columnInfo.getColumnDisplaySize());
    }

    private void addTableTypeRow(ResultSet resultSet, Object object) throws SQLException {
        ResultSetRow resultSetRow = new ResultSetRow();
        resultSetRow.addValue(object);
        resultSet.addResultSetRow(resultSetRow);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setColumnName("TABLE_TYPE");
        columnProperties.setColumnLabel("TABLE_TYPE");
        columnProperties.setColumnType(12);
        columnProperties.setTdType(448);
        columnProperties.setColumnDisplaySize(16);
        TeraResultSetMetaData teraResultSetMetaData = new TeraResultSetMetaData(((TeraLocalConnection)this.connection).getTDSession());
        teraResultSetMetaData.addColumnProperties(columnProperties);
        Log log = ((TeraLocalConnection)this.connection).getTDSession().getLog();
        ResultSet resultSet = ResultSet.createResultSet(null, null, log);
        resultSet.setMetaData(teraResultSetMetaData);
        resultSet.setNumberOfRows(4);
        this.addTableTypeRow(resultSet, "GLOBAL TEMPORARY");
        this.addTableTypeRow(resultSet, "SYSTEM TABLE");
        this.addTableTypeRow(resultSet, "TABLE");
        this.addTableTypeRow(resultSet, "VIEW");
        TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
        teraLocalResultSet.setResultSet(resultSet);
        return teraLocalResultSet;
    }

    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        Log log = ((TeraLocalConnection)this.connection).getTDSession().getLog();
        boolean bl = this.getDBCRelease() >= 61;
        String string5 = "select cast (null as varchar(30)) as TABLE_CAT, trim (trailing from t.DatabaseName) as TABLE_SCHEM, trim (trailing from t.TableName) as TABLE_NAME, trim (trailing from c.ColumnName) as COLUMN_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.ColumnType", bl ? "u.TypeKind" : null) + " as DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.ColumnType", bl ? "c.ColumnUDTName" : null) + " as TYPE_NAME," + TeraDatabaseMetaData.caseDisplaySize("c.ColumnType", "c.DecimalTotalDigits", "c.CharType", "c.ColumnLength") + " as COLUMN_SIZE," + " cast (null as integer) as BUFFER_LENGTH," + " cast (c.DecimalFractionalDigits as integer) as DECIMAL_DIGITS," + " cast (10 as integer) as NUM_PREC_RADIX," + TeraDatabaseMetaData.caseColumnNullable("c.Nullable") + " as NULLABLE," + " c.CommentString as REMARKS," + " c.DefaultValue as COLUMN_DEF," + " cast (null as integer) as SQL_DATA_TYPE," + " cast (null as integer) as SQL_DATETIME_SUB," + " cast (c.ColumnLength as integer) as CHAR_OCTET_LENGTH," + " cast ((row_number () over (partition by TABLE_SCHEM, TABLE_NAME order by c.ColumnID)) as integer) as ORDINAL_POSITION," + TeraDatabaseMetaData.caseIsNullable("c.Nullable") + " as IS_NULLABLE," + " cast (null as varchar(30)) as SCOPE_CATLOG," + " cast (null as varchar(30)) as SCOPE_SCHEMA," + " cast (null as varchar(30)) as SCOPE_TABLE," + TeraDatabaseMetaData.caseUDTSrcType1("c.ColumnType", bl ? "u.TypeKind" : null, bl ? "BaseTypes.ColumnType" : null) + " as SOURCE_DATA_TYPE" + " from " + this.dbc_tables + " t" + " join " + this.dbc_columns + " c" + " on t.DatabaseName = c.DatabaseName" + " and t.TableName = c.TableName";
        if (bl) {
            string5 = string5 + " left outer join DBC.UDTInfo u on c.ColumnUDTName = u.TypeName left outer join " + this.dbc_columns + " BaseTypes" + " on u.TypeKind = 'D'" + " and 'SYSUDTLIB' = upper(BaseTypes.DatabaseName)" + " and upper(u.TypeName) = upper(BaseTypes.TableName)";
        }
        string5 = string5 + " where t.TableKind IN ('O','T','V')";
        if ("".equals(string2)) {
            string5 = string5 + " and upper(trim(trailing from t.DatabaseName)) = upper(trim(trailing from user))";
        } else if (string2 != null) {
            string5 = string5 + " and upper(trim(trailing from t.DatabaseName)) like upper(trim(trailing from '" + string2 + "'))";
        }
        if (string3 != null) {
            string5 = string5 + " and upper(trim(trailing from t.TableName)) like upper(trim(trailing from '" + string3 + "'))";
        }
        if (string4 != null) {
            string5 = string5 + " and upper(trim(trailing from c.ColumnName)) like upper(trim(trailing from '" + string4 + "'))";
        }
        string5 = string5 + " order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION";
        if (log.canLog(1)) {
            log.info("TeraDatabaseMetaData.getColumns: " + string5);
        }
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(string5);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        ((TeraLocalResultSet)resultSet).getResultSet().setFetchedRowsPostProcessor(new ObtainViewColumnMetaData());
        return resultSet;
    }

    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = this.connection.createStatement();
        String string5 = this.getColumnPrivilegesSQL(string2, string3, string4);
        java.sql.ResultSet resultSet = statement.executeQuery(string5);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    private String getColumnPrivilegesSQL(String string, String string2, String string3) {
        string = string != null ? string.replaceAll("'", "''") : null;
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        return "SELECT DISTINCT CAST (NULL AS VARCHAR(30)) AS TABLE_CAT, TRIM (c.DATABASENAME) AS TABLE_SCHEM, TRIM (c.TABLENAME) AS TABLE_NAME, TRIM (c.COLUMNNAME) AS COLUMN_NAME, TRIM (a.GrantorName) AS GRANTOR, TRIM (a.UserName) AS GRANTEE, CAST (" + TeraDatabaseMetaData.casePrivilegeName("a.AccessRight") + " AS VARCHAR(100)) AS PRIVILEGE," + " CAST (" + TeraDatabaseMetaData.caseYesNo("a.GrantAuthority") + " AS VARCHAR(3)) AS IS_GRANTABLE" + " FROM " + this.dbc_columns + " c, " + this.dbc_tables + " t, " + this.dbc_allRights + " a" + " WHERE " + "  (c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME AND t.TABLEKIND IN ('O','T')) " + (string != null || string2 != null ? " and " : "") + (string != null ? " upper(trim(c.DATABASENAME)) like upper(trim('" + string + "'))" : "") + (string != null && string2 != null ? " and" : "") + (string2 != null ? " upper(trim(c.TABLENAME)) like upper(trim('" + string2 + "'))" : "") + " and upper(trim(a.DATABASENAME)) = upper(trim(c.DATABASENAME)) " + " and upper(trim(a.TABLENAME)) = upper(trim(c.TABLENAME)) " + (string3 != null ? " AND (( upper(trim(a.COLUMNNAME)) = 'ALL'  " : "") + (string3 != null ? " AND upper(trim(c.COLUMNNAME)) like upper(trim('" + string3 + "'))) OR " : "") + (string3 != null ? " (( upper(trim(a.COLUMNNAME)) like upper(trim('" + string3 + "'))) " : "") + (string3 != null ? " AND ( (c.COLUMNNAME = a.COLUMNNAME ))))" : "") + " ORDER BY " + " c.DATABASENAME, c.TABLENAME, c.COLUMNNAME, PRIVILEGE";
    }

    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT DISTINCT CAST (NULL AS VARCHAR(30)) AS TABLE_CAT, TRIM (a.DATABASENAME) AS TABLE_SCHEM, TRIM (a.TABLENAME) AS TABLE_NAME, TRIM (a.GrantorName) AS GRANTOR, TRIM (a.UserName) AS GRANTEE, CAST (" + TeraDatabaseMetaData.casePrivilegeName("a.AccessRight") + " AS VARCHAR(100)) AS PRIVILEGE," + " CAST (" + TeraDatabaseMetaData.caseYesNo("a.GrantAuthority") + " AS VARCHAR(3)) AS IS_GRANTABLE" + " FROM " + this.dbc_allRights + " a, " + this.dbc_tables + " t" + " WHERE a.DATABASENAME = t.DATABASENAME" + " AND a.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND IN ('O','T')" + (string2 != null ? " AND UPPER(TRIM(a.DATABASENAME)) LIKE UPPER(TRIM('" + string2 + "'))" : "") + (string3 != null ? " AND UPPER(TRIM(a.TABLENAME)) LIKE UPPER(TRIM('" + string3 + "'))" : "") + " ORDER BY a.DATABASENAME, a.TABLENAME, PRIVILEGE";
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        boolean bl2;
        Object object;
        String string4;
        Object object2;
        if (string3 == null || string3.equals("")) {
            throw ErrorFactory.makeDriverJDBCException("TJ398");
        }
        if (string2 == null || string2.equals("")) {
            object2 = new HashMap();
            java.sql.ResultSet resultSet = this.getTables(string, string2, string3, null);
            try {
                while (resultSet.next()) {
                    string4 = resultSet.getString(2);
                    object = resultSet.getString(3);
                    String string5 = (String)object2.get(object);
                    if (string5 == null) {
                        object2.put(object, string4);
                        continue;
                    }
                    if (string5.equals(string4)) continue;
                    throw ErrorFactory.makeDriverJDBCException("TJ397", string3, string5, string4);
                }
            }
            finally {
                resultSet.close();
            }
        }
        if (!(object = (object2 = this.connection.createStatement()).executeQuery(string4 = this.getBestRowIdentifierSQL(string2, string3, bl, bl2 = true))).isBeforeFirst()) {
            bl2 = false;
            string4 = this.getBestRowIdentifierSQL(string2, string3, bl, bl2);
            object = object2.executeQuery(string4);
        }
        ((TeraResultSet)object).setMetadataRS(true);
        return object;
    }

    private String getBestRowIdentifierSQL(String string, String string2, boolean bl, boolean bl2) {
        string = string != null ? string.replaceAll("'", "''") : null;
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        String string3 = "";
        string3 = this.getDBCRelease() < 61 ? "SELECT CAST (2 AS SMALLINT) AS SCOPE, TRIM (c.COLUMNNAME) AS COLUMN_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.COLUMNTYPE", null) + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.COLUMNTYPE", null) + " AS TYPE_NAME," + TeraDatabaseMetaData.caseDisplaySize("c.COLUMNTYPE", "c.DECIMALTOTALDIGITS", "c.CHARTYPE", "c.COLUMNLENGTH") + " AS COLUMN_SIZE," + " CAST (NULL AS INTEGER) AS BUFFER_LENGTH," + " CAST (c.DECIMALFRACTIONALDIGITS AS SMALLINT) AS DECIMAL_DIGITS," + " CAST (" + 1 + " AS SMALLINT) AS PSEUDO_COLUMN" + " FROM " + this.dbc_columns + " c, " + this.dbc_tables + " t" + (bl2 ? ", " + this.dbc_indices + " i" : "") + " WHERE c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND = 'T'" + " AND c.COLUMNTYPE <> 'BO'" + " AND c.COLUMNTYPE <> 'CO'" + (bl2 ? " AND c.DATABASENAME = i.DATABASENAME AND c.TABLENAME = i.TABLENAME AND c.COLUMNNAME = i.COLUMNNAME AND i.UniqueFlag = 'Y'" : "") + (!bl ? " AND c.NULLABLE = 'N'" : "") + (string != null ? " AND UPPER(TRIM(c.DATABASENAME)) = UPPER(TRIM('" + string + "'))" : "") + (string2 != null ? " AND UPPER(TRIM(c.TABLENAME)) = UPPER(TRIM('" + string2 + "'))" : "") + " ORDER BY" + (bl2 ? " i.IndexType," : "") + " c.DATABASENAME, c.TABLENAME, c.COLUMNID" : "SELECT DISTINCT CAST (2 AS SMALLINT) AS SCOPE, TRIM (c.COLUMNNAME) AS COLUMN_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.COLUMNTYPE", "u.TYPEKIND") + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.COLUMNTYPE", "c.COLUMNUDTNAME") + " AS TYPE_NAME," + TeraDatabaseMetaData.caseDisplaySize("c.COLUMNTYPE", "c.DECIMALTOTALDIGITS", "c.CHARTYPE", "c.COLUMNLENGTH") + " AS COLUMN_SIZE," + " CAST (NULL AS INTEGER) AS BUFFER_LENGTH," + " CAST (c.DECIMALFRACTIONALDIGITS AS SMALLINT) AS DECIMAL_DIGITS," + " CAST (" + 1 + " AS SMALLINT) AS PSEUDO_COLUMN" + " FROM " + this.dbc_tables + " t" + (bl2 ? ", " + this.dbc_indices + " i" : "") + ", " + this.dbc_columns + " c" + " LEFT OUTER JOIN DBC.UDTINFO u" + " ON c.COLUMNUDTNAME = u.TYPENAME" + " WHERE c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND IN ('O','T')" + " AND c.COLUMNTYPE <> 'BO'" + " AND c.COLUMNTYPE <> 'CO'" + (bl2 ? " AND c.DATABASENAME = i.DATABASENAME AND c.TABLENAME = i.TABLENAME AND c.COLUMNNAME = i.COLUMNNAME AND i.UniqueFlag = 'Y'" : "") + (!bl ? " AND c.NULLABLE = 'N'" : "") + (string != null ? " AND UPPER(TRIM(c.DATABASENAME)) = UPPER(TRIM('" + string + "'))" : "") + (string2 != null ? " AND UPPER(TRIM(c.TABLENAME)) = UPPER(TRIM('" + string2 + "'))" : "") + " ORDER BY" + (bl2 ? "  i.IndexType," : "") + " c.DATABASENAME, c.TABLENAME, c.COLUMNID";
        return string3;
    }

    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        String string4 = " SELECT  CAST(NULL AS SMALLINT) AS SCOPE,  CAST(NULL AS VARCHAR(30))  AS COLUMN_NAME, CAST(NULL  AS INT) AS DATA_TYPE, CAST (NULL AS VARCHAR(30))  AS TYPE_NAME, CAST(NULL AS INT) AS COLUMN_SIZE, CAST ( NULL AS INT )  AS BUFFER_LENGTH, CAST ( NULL AS SMALLINT)  AS DECIMAL_DIGITS, CAST (NULL AS SMALLINT) AS PSEUDO_COLUMN  WHERE 1 = 2 ";
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT cast (null as varchar(30)) AS TABLE_CAT, TRIM (DATABASENAME) AS TABLE_SCHEM, TRIM (TABLENAME) AS TABLE_NAME, TRIM (COLUMNNAME) AS COLUMN_NAME, CAST (COLUMNPOSITION as SMALLINT) as KEY_SEQ, TRIM (INDEXNAME) AS PK_NAME FROM " + this.dbc_indices + " WHERE INDEXTYPE = 'K'" + (string2 != null && !string2.equals("") ? " AND UPPER(TRIM(DATABASENAME)) = UPPER(TRIM('" + string2 + "'))" : "") + (string2 != null && string2.equals("") ? " AND UPPER(TRIM(DATABASENAME)) = UPPER(TRIM(USER))" : "") + (string3 != null && !string3.equals("") ? " AND UPPER(TRIM(TABLENAME)) = UPPER(TRIM('" + string3 + "'))" : "") + " ORDER BY DATABASENAME, TABLENAME, COLUMNPOSITION";
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        TeraResultSet teraResultSet = (TeraResultSet)resultSet;
        teraResultSet.setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        String string4 = "select cast (null as varchar(30)) as PKTABLE_CAT, trim (ParentDB) as PKTABLE_SCHEM, trim (ParentTable) as PKTABLE_NAME, trim (ParentKeyColumn) as PKCOLUMN_NAME, cast (null as varchar(30)) as FKTABLE_CAT, trim (ChildDB) as FKTABLE_SCHEM, trim (ChildTable) as FKTABLE_NAME, trim (ChildKeyColumn) as FKCOLUMN_NAME, cast (null as smallint) as KEY_SEQ, cast (3 as smallint) as UPDATE_RULE, cast (3 as smallint) as DELETE_RULE, trim (IndexName) as FK_NAME, cast (null as varchar(30)) as PK_NAME, cast (null as smallint) as DEFERRABILITY from " + this.dbc_allRiParents + (string2 != null || string3 != null ? " where" : "") + (string2 != null ? " upper(trim(ChildDB)) = upper(trim('" + string2 + "'))" : "") + (string2 != null && string3 != null ? " and" : "") + (string3 != null ? " upper(trim(ChildTable)) = upper(trim('" + string3 + "'))" : "") + " order by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ";
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        String string4 = "select cast (null as varchar(30)) as PKTABLE_CAT, trim (ParentDB) as PKTABLE_SCHEM, trim (ParentTable) as PKTABLE_NAME, trim (ParentKeyColumn) as PKCOLUMN_NAME, cast (null as varchar(30)) as FKTABLE_CAT, trim (ChildDB) as FKTABLE_SCHEM, trim (ChildTable) as FKTABLE_NAME, trim (ChildKeyColumn) as FKCOLUMN_NAME, cast (null as smallint) as KEY_SEQ, cast (3 as smallint) as UPDATE_RULE, cast (3 as smallint) as DELETE_RULE, trim (IndexName) as FK_NAME, cast (null as varchar(30)) as PK_NAME, cast (null as smallint) as DEFERRABILITY from " + this.dbc_allRiParents + (string2 != null || string3 != null ? " where" : "") + (string2 != null ? " upper(trim(ParentDB)) = upper(trim('" + string2 + "'))" : "") + (string2 != null && string3 != null ? " and" : "") + (string3 != null ? " upper(trim(ParentTable)) = upper(trim('" + string3 + "'))" : "") + " order by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        java.sql.ResultSet resultSet = statement.executeQuery(string4);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string5 = string5 != null ? string5.replaceAll("'", "''") : null;
        string6 = string6 != null ? string6.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        String string7 = "select cast (null as varchar(30)) as PKTABLE_CAT, trim (ParentDB) as PKTABLE_SCHEM, trim (ParentTable) as PKTABLE_NAME, trim (ParentKeyColumn) as PKCOLUMN_NAME, cast (null as varchar(30)) as FKTABLE_CAT, trim (ChildDB) as FKTABLE_SCHEM, trim (ChildTable) as FKTABLE_NAME, trim (ChildKeyColumn) as FKCOLUMN_NAME, cast (null as smallint) as KEY_SEQ, cast (3 as smallint) as UPDATE_RULE, cast (3 as smallint) as DELETE_RULE, trim (IndexName) as FK_NAME,  cast (null as varchar(30)) as PK_NAME,  cast (null as smallint) as DEFERRABILITY from " + this.dbc_allRiParents + (string2 != null || string3 != null ? " where" : "") + (string2 != null ? " upper(trim(ParentDB)) = upper(trim('" + string2 + "'))" : "") + (string2 != null && string3 != null ? " and" : "") + (string3 != null ? " upper(trim(ParentTable)) = upper(trim('" + string3 + "'))" : "") + (string2 == null && string3 == null && (string5 != null || string6 != null) ? " where " : "") + (!(string2 == null && string3 == null || string5 == null && string6 == null) ? " and " : "") + (string5 != null ? " upper(trim(ChildDB)) = upper(trim('" + string5 + "'))" : "") + (string5 != null && string6 != null ? " and " : "") + (string6 != null ? " upper(trim(ChildTable)) = upper(trim('" + string6 + "'))" : "") + " order by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME," + " FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        java.sql.ResultSet resultSet = statement.executeQuery(string7);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        TypeInfoRows typeInfoRows = new TypeInfoRows(this.getDBCRelease(), ((TeraLocalConnection)this.connection).getTDSession().isLargeDecimalAndBigIntSupported());
        TeraResultSetMetaData teraResultSetMetaData = new TeraResultSetMetaData(((TeraLocalConnection)this.connection).getTDSession());
        for (int i = 0; i < typeInfoRows.getColCount(); ++i) {
            this.addColumnInfo(teraResultSetMetaData, typeInfoRows.getTypeInfoCol(i));
        }
        Log log = ((TeraLocalConnection)this.connection).getTDSession().getLog();
        ResultSet resultSet = ResultSet.createResultSet(null, null, log);
        resultSet.setMetaData(teraResultSetMetaData);
        int n = this.getDBCRelease() < 30 ? 10 : (this.getDBCRelease() < 51 ? 31 : (((TeraLocalConnection)this.connection).getTDSession().isLargeDecimalAndBigIntSupported() ? 36 : (this.getDBCRelease() < 61 ? 33 : 35)));
        resultSet.setNumberOfRows(n);
        for (int i = 0; i < typeInfoRows.getRowCount(); ++i) {
            TypeInfoRow typeInfoRow = typeInfoRows.getTypeInfoRow(i);
            ResultSetRow resultSetRow = new ResultSetRow();
            resultSetRow.addValue(typeInfoRow.getTypeName());
            resultSetRow.addValue(typeInfoRow.getDataType());
            resultSetRow.addValue(typeInfoRow.getPrecision());
            resultSetRow.addValue(typeInfoRow.getLiteralPrefix());
            resultSetRow.addValue(typeInfoRow.getLiteralSuffix());
            resultSetRow.addValue(typeInfoRow.getCreateParams());
            resultSetRow.addValue(typeInfoRow.getNullable());
            resultSetRow.addValue(typeInfoRow.getCaseSensitive());
            resultSetRow.addValue(typeInfoRow.getSearchable());
            resultSetRow.addValue(typeInfoRow.getUnsignedAttribute());
            resultSetRow.addValue(typeInfoRow.getFixedPrecScale());
            resultSetRow.addValue(typeInfoRow.getAutoIncrement());
            resultSetRow.addValue(typeInfoRow.getLocalTypeName());
            resultSetRow.addValue(typeInfoRow.getMinimumScale());
            resultSetRow.addValue(typeInfoRow.getMaximumScale());
            resultSetRow.addValue(typeInfoRow.getSqlDataType());
            resultSetRow.addValue(typeInfoRow.getSqlDatetimeSub());
            resultSetRow.addValue(typeInfoRow.getNumPrecRadix());
            resultSet.addResultSetRow(resultSetRow);
        }
        TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
        teraLocalResultSet.setResultSet(resultSet);
        return teraLocalResultSet;
    }

    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string2 != null && string2.indexOf(59) >= 0 || string3 != null && string3.indexOf(59) >= 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ376");
        }
        return this.buildIndexInfo(string2, string3, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private java.sql.ResultSet buildIndexInfo(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        Object object2;
        IndexInfoRow indexInfoRow;
        int n;
        ResultSet resultSet;
        IndexInfoRows indexInfoRows;
        block10: {
            indexInfoRows = new IndexInfoRows();
            TeraResultSetMetaData teraResultSetMetaData = new TeraResultSetMetaData(((TeraLocalConnection)this.connection).getTDSession());
            for (int i = 0; i < indexInfoRows.getColCount(); ++i) {
                this.addColumnInfo(teraResultSetMetaData, indexInfoRows.getIndexInfoCol(i));
            }
            Log log = ((TeraLocalConnection)this.connection).getTDSession().getLog();
            resultSet = ResultSet.createResultSet(null, null, log);
            resultSet.setMetaData(teraResultSetMetaData);
            java.sql.ResultSet resultSet2 = null;
            try {
                resultSet2 = this.submitIndexInfo("HELP STATISTICS ", string, string2);
                if (resultSet2 != null) {
                    n = this.retrieveStatsInfo(resultSet2, string, string2, indexInfoRows);
                } else {
                    resultSet2 = this.submitIndexInfo("HELP INDEX ", string, string2);
                    n = this.retrieveIndexInfo(resultSet2, string, string2, bl, bl2, indexInfoRows);
                }
                indexInfoRow = null;
                if (resultSet2 == null) break block10;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (resultSet2 == null) throw throwable;
                try {
                    resultSet2.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException object2) {}
            resultSet2.close();
        }
        resultSet.setNumberOfRows(n);
        int n2 = 0;
        while (true) {
            if (n2 >= indexInfoRows.getRowCount()) {
                TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
                teraLocalResultSet.setResultSet(resultSet);
                return teraLocalResultSet;
            }
            indexInfoRow = indexInfoRows.getIndexInfoRow(n2);
            object2 = new ResultSetRow();
            ((ResultSetRow)object2).addValue(indexInfoRow.getTableCat());
            ((ResultSetRow)object2).addValue(indexInfoRow.getTableSchem());
            ((ResultSetRow)object2).addValue(indexInfoRow.getTableName());
            ((ResultSetRow)object2).addValue(indexInfoRow.getNonUnique());
            ((ResultSetRow)object2).addValue(indexInfoRow.getIndexQualifier());
            ((ResultSetRow)object2).addValue(indexInfoRow.getIndexName());
            ((ResultSetRow)object2).addValue(indexInfoRow.getType());
            ((ResultSetRow)object2).addValue(indexInfoRow.getOrdinalPosition());
            ((ResultSetRow)object2).addValue(indexInfoRow.getColumnName());
            ((ResultSetRow)object2).addValue(indexInfoRow.getAscOrDesc());
            ((ResultSetRow)object2).addValue(indexInfoRow.getCardinality());
            ((ResultSetRow)object2).addValue(indexInfoRow.getPages());
            ((ResultSetRow)object2).addValue(indexInfoRow.getFilterCondition());
            resultSet.addResultSetRow((ResultSetRow)object2);
            ++n2;
        }
    }

    private java.sql.ResultSet submitIndexInfo(String string, String string2, String string3) throws SQLException {
        java.sql.ResultSet resultSet;
        block2: {
            resultSet = null;
            string = string2 != null && !string2.equals("") ? string + string2.trim() + "." + string3.trim() : string + string3.trim();
            try {
                Statement statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 3869 || sQLException.getErrorCode() == 3720 || sQLException.getErrorCode() == 3823 || sQLException.getErrorCode() == 5341 || sQLException.getErrorCode() == 3624) break block2;
                throw sQLException;
            }
        }
        return resultSet;
    }

    private int retrieveIndexInfo(java.sql.ResultSet resultSet, String string, String string2, boolean bl, boolean bl2, IndexInfoRows indexInfoRows) throws SQLException {
        int n = 0;
        short s = 1;
        boolean bl3 = false;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            while (resultSet.next()) {
                block15: {
                    IndexInfoRow indexInfoRow;
                    block16: {
                        block17: {
                            s = 1;
                            if (!bl3) {
                                if (bl && resultSet.getString(1).trim().compareToIgnoreCase("Y") == 0) {
                                    indexInfoRow = new IndexInfoRow(string, string2, null);
                                    indexInfoRows.addIndexInfoRow(indexInfoRow);
                                    this.setIndexInfoRow(resultSet, indexInfoRow, string, string2, bl2, null, (short)0, true);
                                    ++n;
                                    bl3 = true;
                                } else if (!bl) {
                                    indexInfoRow = new IndexInfoRow(string, string2, null);
                                    indexInfoRows.addIndexInfoRow(indexInfoRow);
                                    this.setIndexInfoRow(resultSet, indexInfoRow, string, string2, bl2, null, (short)0, true);
                                    ++n;
                                    bl3 = true;
                                }
                            }
                            if (resultSet.getString(3) != null) {
                                string3 = resultSet.getString(3).trim();
                            }
                            if (string3 == null) break block15;
                            n3 = string3.indexOf(",");
                            if (n3 != -1) break block16;
                            if (!bl || resultSet.getString(1).trim().compareToIgnoreCase("Y") != 0) break block17;
                            indexInfoRow = new IndexInfoRow(string, string2, "A");
                            indexInfoRows.addIndexInfoRow(indexInfoRow);
                            short s2 = s;
                            s = (short)(s + 1);
                            this.setIndexInfoRow(resultSet, indexInfoRow, string, string2, bl2, string3, s2, false);
                            break block15;
                        }
                        if (bl) break block15;
                        indexInfoRow = new IndexInfoRow(string, string2, "A");
                        indexInfoRows.addIndexInfoRow(indexInfoRow);
                        short s3 = s;
                        s = (short)(s + 1);
                        this.setIndexInfoRow(resultSet, indexInfoRow, string, string2, bl2, string3, s3, false);
                        break block15;
                    }
                    if (n3 != -1) {
                        bl4 = true;
                        bl5 = false;
                        n2 = 0;
                        while (bl4) {
                            if (!bl5) {
                                string4 = string3.substring(n2, n3);
                                n2 = n3 + 1;
                                if ((n3 = string3.indexOf(",", n2)) == -1) {
                                    bl4 = true;
                                    bl5 = true;
                                }
                            } else if (bl5) {
                                if (string3.length() <= n2) break;
                                string4 = string3.substring(n2);
                                bl4 = false;
                            }
                            if (bl && resultSet.getString(1).trim().compareToIgnoreCase("Y") == 0) {
                                indexInfoRow = new IndexInfoRow(string, string2, "A");
                                indexInfoRows.addIndexInfoRow(indexInfoRow);
                                short s4 = s;
                                s = (short)(s + 1);
                                this.setIndexInfoRow(resultSet, indexInfoRow, string, string2, bl2, string4, s4, false);
                                continue;
                            }
                            if (bl) continue;
                            indexInfoRow = new IndexInfoRow(string, string2, "A");
                            indexInfoRows.addIndexInfoRow(indexInfoRow);
                            short s5 = s;
                            s = (short)(s + 1);
                            this.setIndexInfoRow(resultSet, indexInfoRow, string, string2, bl2, string4, s5, false);
                        }
                    }
                }
                n = n + s - 1;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            ComUtil.ThrowExcp(222, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ214"), String.valueOf(s), String.valueOf(0)) + exception.getMessage());
        }
        return n;
    }

    private int setIndexInfoRow(java.sql.ResultSet resultSet, IndexInfoRow indexInfoRow, String string, String string2, boolean bl, String string3, short s, boolean bl2) throws SQLException {
        int n = 0;
        if (bl2) {
            indexInfoRow.setNonUnique(new Boolean(false));
        } else if (resultSet.getString(1).trim().equalsIgnoreCase("N")) {
            indexInfoRow.setNonUnique(new Boolean(true));
        } else {
            indexInfoRow.setNonUnique(new Boolean(false));
        }
        String string4 = resultSet.getString(6);
        if (resultSet.wasNull() || bl2) {
            indexInfoRow.setIndexName(null);
        } else {
            indexInfoRow.setIndexName(string4.trim());
        }
        if (bl2) {
            indexInfoRow.setType(new Short(0));
        } else if (resultSet.getString(2).trim().compareToIgnoreCase("P") == 0) {
            indexInfoRow.setType(new Short(1));
        } else {
            indexInfoRow.setType(new Short(2));
        }
        if (bl2) {
            indexInfoRow.setOrdinalPosition(new Short(0));
        } else {
            indexInfoRow.setOrdinalPosition(new Short(s));
        }
        if (bl2) {
            indexInfoRow.setColumnName(null);
        } else {
            indexInfoRow.setColumnName(string3);
        }
        n = bl ? resultSet.getInt(5) : this.getRowCount(string, string2);
        indexInfoRow.setCardinality(new Integer(n));
        int n2 = n * 14 / 4096;
        if (n2 < 1) {
            n2 = 1;
        }
        indexInfoRow.setPages(new Integer(n2));
        return s;
    }

    private int retrieveStatsInfo(java.sql.ResultSet resultSet, String string, String string2, IndexInfoRows indexInfoRows) throws SQLException {
        short s = 1;
        int n = 0;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            block2: while (resultSet.next()) {
                IndexInfoRow indexInfoRow;
                IndexInfoRow indexInfoRow2 = new IndexInfoRow(string, string2);
                indexInfoRows.addIndexInfoRow(indexInfoRow2);
                indexInfoRow2.setColumnName(null);
                n = this.getRowCount(string, string2);
                indexInfoRow2.setCardinality(new Integer(n));
                n4 = n * 14 / 4096;
                if (n4 < 1) {
                    n4 = 1;
                }
                indexInfoRow2.setPages(new Integer(n4));
                if (resultSet.getString(4) != null) {
                    string3 = resultSet.getString(4).trim();
                }
                if (string3 == null) continue;
                n3 = string3.indexOf(",");
                if (n3 == -1) {
                    indexInfoRow = new IndexInfoRow(string, string2);
                    indexInfoRows.addIndexInfoRow(indexInfoRow);
                    indexInfoRow.setColumnName(string4);
                    indexInfoRow.setOrdinalPosition(new Short(s));
                    n = this.getRowCount(string, string2);
                    indexInfoRow.setCardinality(new Integer(n));
                    n4 = n * 14 / 4096;
                    if (n4 < 1) {
                        n4 = 1;
                    }
                    indexInfoRow.setPages(new Integer(n4));
                    s = (short)(s + 1);
                    continue;
                }
                if (n3 == -1) continue;
                bl = true;
                while (bl) {
                    if (!bl2) {
                        string4 = string3.substring(n2, n3);
                        n2 = n3 + 1;
                        if ((n3 = string3.indexOf(",", n2)) == -1) {
                            bl = true;
                            bl2 = true;
                        }
                    } else if (bl2) {
                        if (string3.length() <= n2) continue block2;
                        string4 = string3.substring(n2);
                        bl = false;
                    }
                    indexInfoRow = new IndexInfoRow(string, string2);
                    indexInfoRows.addIndexInfoRow(indexInfoRow);
                    indexInfoRow.setColumnName(string4);
                    indexInfoRow.setOrdinalPosition(new Short(s));
                    n = this.getRowCount(string, string2);
                    indexInfoRow.setCardinality(new Integer(n));
                    n4 = n * 14 / 4096;
                    if (n4 < 1) {
                        n4 = 1;
                    }
                    indexInfoRow.setPages(new Integer(n4));
                    s = (short)(s + 1);
                }
            }
            resultSet.close();
        }
        catch (Exception exception) {
            ComUtil.ThrowExcp(222, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ214"), String.valueOf(s), String.valueOf(0)) + exception.getMessage());
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getRowCount(String string, String string2) throws SQLException {
        int n = 0;
        String string3 = "";
        Statement statement = null;
        if (string != null && !string.equals("")) {
            string3 = string3 + " LOCKING " + string.trim() + "." + string2.trim();
            string3 = string3 + " FOR ACCESS SELECT COUNT(*) FROM ";
            string3 = string3 + string.trim() + "." + string2.trim();
        } else {
            string3 = string3 + " LOCKING " + string2.trim();
            string3 = string3 + " FOR ACCESS SELECT COUNT(*) FROM ";
            string3 = string3 + string2.trim();
        }
        statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(string3);
        resultSet.next();
        n = resultSet.getInt(1);
        statement.close();
        resultSet.close();
        Object var8_8 = null;
        if (statement == null) return n;
        try {
            statement.close();
            return n;
        }
        catch (SQLException sQLException) {}
        return n;
        {
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 5341) {
                    throw sQLException;
                }
                Object var8_9 = null;
                if (statement == null) return n;
                try {
                    statement.close();
                    return n;
                }
                catch (SQLException sQLException2) {}
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        switch (n) {
            case 1003: {
                return true;
            }
            case 1004: {
                return ((TeraLocalConnection)this.connection).getTDSession().isPositioningSupported();
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        switch (n) {
            case 1003: {
                if (n2 == 1007) {
                    return true;
                }
                if (n2 == 1008) {
                    return ((TeraLocalConnection)this.connection).getTDSession().isStatementInfoSupported();
                }
            }
            case 1004: {
                if (n2 == 1007) {
                    return ((TeraLocalConnection)this.connection).getTDSession().isPositioningSupported();
                }
                if (n2 != 1008) break;
                return ((TeraLocalConnection)this.connection).getTDSession().isPositioningSupported() && ((TeraLocalConnection)this.connection).getTDSession().isStatementInfoSupported();
            }
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public java.sql.ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        if (string3 != null) {
            boolean bl;
            int n = string3.indexOf(".");
            boolean bl2 = bl = n != -1;
            if (bl) {
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                string2 = string4;
                string3 = string5;
            }
        }
        String string6 = "";
        string6 = this.getDBCRelease() < 61 ? "select  CAST(NULL AS VARCHAR(30)) AS TYPE_CAT,  CAST(NULL AS VARCHAR(30)) AS TYPE_SCHEM,  CAST(NULL AS VARCHAR(30)) AS TYPE_NAME, CAST(NULL AS VARCHAR(30)) AS CLASS_NAME,  CAST(NULL AS INT) AS DATA_TYPE,  CAST(NULL AS VARCHAR(30)) AS REMARKS,  CAST (NULL AS SMALLINT) AS BASE_TYPE   where 1 = 0" : "select distinct cast (null as varchar(30)) as TYPE_CAT, trim (t.DatabaseName) as TYPE_SCHEM, trim (t.TableName) as TYPE_NAME, cast ((CASE (CASE WHEN u.TypeKind = 'D' AND c1.ColumnType IS NULL THEN c.ColumnType WHEN u.TypeKind = 'D' OR u.TypeKind = 'S' THEN c1.ColumnType ELSE NULL END) WHEN 'AT' THEN 'java.sql.Time' WHEN 'BF' THEN '[B' WHEN 'BO' THEN 'java.sql.Blob' WHEN 'BV' THEN '[B' WHEN 'CF' THEN 'java.lang.String' WHEN 'CO' THEN 'java.sql.Clob' WHEN 'CV' THEN 'java.lang.String' WHEN 'D'  THEN 'java.math.BigDecimal' WHEN 'DA' THEN 'java.sql.Date' WHEN 'DH' THEN 'java.lang.String' WHEN 'DM' THEN 'java.lang.String' WHEN 'DS' THEN 'java.lang.String' WHEN 'DY' THEN 'java.lang.String' WHEN 'F'  THEN 'java.lang.Double' WHEN 'GF' THEN 'java.lang.String' WHEN 'GV' THEN 'java.lang.String' WHEN 'HM' THEN 'java.lang.String' WHEN 'HR' THEN 'java.lang.String' WHEN 'HS' THEN 'java.lang.String' WHEN 'I1' THEN 'java.lang.Integer' WHEN 'I2' THEN 'java.lang.Integer' WHEN 'I'  THEN 'java.lang.Integer' WHEN 'I8' THEN 'java.lang.Long' WHEN 'MI' THEN 'java.lang.String' WHEN 'MO' THEN 'java.lang.String' WHEN 'MS' THEN 'java.lang.String' WHEN 'SC' THEN 'java.lang.String' WHEN 'SZ' THEN 'java.sql.Timestamp' WHEN 'TS' THEN 'java.sql.Timestamp' WHEN 'TZ' THEN 'java.sql.Time' WHEN 'YM' THEN 'java.lang.String' WHEN 'YR' THEN 'java.lang.String' ELSE NULL END) as varchar(30)) as CLASS_NAME, cast (" + TeraDatabaseMetaData.caseUDTSQLTypes("u.TypeKind") + " as int) as DATA_TYPE," + " cast (t.CommentString as varchar(256)) as REMARKS," + " cast (" + TeraDatabaseMetaData.caseUDTSrcType2("u.TypeKind", "c.ColumnType") + " as smallint) as BASE_TYPE" + " from " + this.dbc_tables + " t, DBC.UDTInfo u, " + this.dbc_columns + " c" + " left outer join ((" + this.dbc_columns + " c1 join " + this.dbc_columns + " c2 on c1.TableName=c2.TableName" + " and c1.ColumnName in ('RETURN','RETURN0') and c1.ColumnType <> 'UT')" + " join (DBC.UDTTransform r join DBC.UDFInfo f on r.FromSQLRoutineId=f.FunctionId) on c1.TableName=f.FunctionName)" + " on c.TableName=c2.ColumnUDTName" + " where (t.DatabaseName = c.DatabaseName and t.TableName = c.TableName" + " and t.TableName = u.TypeName and t.TableKind = 'U')" + (string2 != null ? " and upper(trim(t.DatabaseName)) like upper(trim('" + string2 + "'))" : "") + (string3 != null ? " and upper(trim(t.TableName)) like upper(trim('" + string3 + "'))" + " and " + TeraDatabaseMetaData.buildTypeString(nArray) : "") + " order by DATA_TYPE, TYPE_SCHEM, TYPE_NAME";
        java.sql.ResultSet resultSet = statement.executeQuery(string6);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        ConfigRspParcel configRspParcel = ((TeraLocalConnection)this.connection).getTDSession().getConfigResponse();
        return configRspParcel.getStatementPositioningSupport();
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return ((TeraLocalConnection)this.connection).getTDSession().generatedKeysSupported();
    }

    public java.sql.ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery("select cast(null as VARCHAR(30)) as TYPE_CAT, cast(null as VARCHAR(30)) as TYPE_SCHEM, cast(null as VARCHAR(30)) as TYPE_NAME, cast(null as VARCHAR(30)) as SUPERTYPE_CAT, cast(null as VARCHAR(30)) as SUPERTYPE_SCHEM, cast(null as VARCHAR(30)) as SUPERTYPE_NAME where 1 = 0");
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery("select cast(null as VARCHAR(30)) as TABLE_CAT, cast(null as VARCHAR(30)) as TABLE_SCHEM, cast(null as VARCHAR(30)) as TABLE_NAME, cast(null as VARCHAR(30)) as SUPERTABLE_NAME where 1 = 0");
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public java.sql.ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        Statement statement = this.connection.createStatement();
        String string5 = "";
        string5 = this.getDBCRelease() < 61 ? "SELECT CAST(NULL AS VARCHAR(30)) AS TYPE_CAT, CAST(NULL AS VARCHAR(30)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(30)) AS TYPE_NAME, CAST(NULL AS VARCHAR(30)) AS ATTR_NAME, CAST(NULL AS INTEGER) AS DATA_TYPE, CAST(NULL AS VARCHAR(30)) AS ATTR_TYPE_NAME, CAST(NULL AS INTEGER) AS ATTR_SIZE, CAST(NULL AS INTEGER) AS DECIMAL_DIGITS, CAST(NULL AS INTEGER) AS NUM_PREC_RADIX, CAST(NULL AS INTEGER) AS NULLABLE, CAST(NULL AS VARCHAR(300)) AS REMARKS, CAST(NULL AS VARCHAR(30)) AS ATTR_DEF, CAST(NULL AS INTEGER) AS SQL_DATA_TYPE, CAST(NULL AS INTEGER) AS SQL_DATETIME_SUB, CAST(NULL AS INTEGER) AS CHAR_OCTET_LENGTH, CAST(NULL AS INTEGER) AS ORDINAL_POSITION, CAST(NULL AS VARCHAR(3)) AS IS_NULLABLE, CAST(NULL AS VARCHAR(30)) AS SCOPE_CATALOG, CAST(NULL AS VARCHAR(30)) AS SCOPE_SCHEMA, CAST(NULL AS VARCHAR(30)) AS SCOPE_TABLE, CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE WHERE 1 = 0" : "select distinct cast (null as varchar(30)) as TYPE_CAT, trim (c.DatabaseName) as TYPE_SCHEM, trim (c.TableName) as TYPE_NAME, trim (c.ColumnName) as ATTR_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.ColumnType", "u.TypeKind") + " as DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.ColumnType", "c.ColumnUDTName") + " as ATTR_TYPE_NAME," + TeraDatabaseMetaData.caseDisplaySize("c.COLUMNTYPE", "c.DecimalTotalDigits", "c.CHARTYPE", "c.ColumnLength") + " as ATTR_SIZE," + " cast (c.DecimalFractionalDigits as int) as DECIMAL_DIGITS," + " cast (10 as int) as NUM_PREC_RADIX," + TeraDatabaseMetaData.caseAttributeNullable("c.Nullable") + " as NULLABLE," + " cast (c.CommentString as varchar(256)) as REMARKS," + " trim (c.DefaultValue) as ATTR_DEF," + " cast (null as int) as SQL_DATA_TYPE," + " cast (null as int) as SQL_DATETIME_SUB," + " cast (c.ColumnLength as integer) as CHAR_OCTET_LENGTH," + " cast ((row_number () over (partition by TYPE_SCHEM, TYPE_NAME order by c.ColumnID)) as integer) as ORDINAL_POSITION," + TeraDatabaseMetaData.caseIsNullable("c.Nullable") + " as IS_NULLABLE," + " cast (null as varchar(30)) as SCOPE_CATALOG," + " cast (null as varchar(30)) as SCOPE_SCHEMA," + " cast (null as varchar(30)) as SCOPE_TABLE," + TeraDatabaseMetaData.caseUDTSrcType1("c.ColumnType", "u.TypeKind", "c2.ColumnType") + " as SOURCE_DATA_TYPE" + " from " + this.dbc_tables + " t, DBC.UDTInfo u, " + this.dbc_columns + " c" + " left outer join" + " (" + this.dbc_columns + " c2 join DBC.UDTInfo u2 on c2.TableName = u2.TypeName and u2.TypeKind = 'D')" + " on c.columnUDTname = c2.tablename" + " where (c.DatabaseName = t.DatabaseName" + " and c.TableName = t.TableName" + " and ((c.TableName = u.TypeName and c.columntype <> 'UT')" + " or (c.columnUDTname = u.typename and c.columntype='UT'))" + " and t.TableKind = 'U')" + (string2 != null ? " and upper(trim(c.DatabaseName)) like upper(trim('" + string2 + "'))" : "") + (string3 != null ? " and upper(trim(c.TableName)) like upper(trim('" + string3 + "'))" : "") + (string4 != null ? " and upper(trim(c.ColumnName)) like upper(trim('" + string4 + "'))" : "") + " order by TYPE_SCHEM, TYPE_NAME, ORDINAL_POSITION";
        java.sql.ResultSet resultSet = statement.executeQuery(string5);
        ((TeraResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.nDatabaseMajorVersion;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.nDatabaseMinorVersion;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 2;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    private static String caseJDBCTypes(String string, String string2) {
        return " CAST ((CASE " + string + " WHEN 'AT' THEN " + 92 + " WHEN 'BF' THEN " + -2 + " WHEN 'BO' THEN " + 2004 + " WHEN 'BV' THEN " + -3 + " WHEN 'CF' THEN " + 1 + " WHEN 'CO' THEN " + 2005 + " WHEN 'CV' THEN " + 12 + " WHEN 'D' THEN " + 3 + " WHEN 'DA' THEN " + 91 + " WHEN 'F' THEN " + 6 + " WHEN 'GF' THEN " + 1 + " WHEN 'GV' THEN " + 12 + " WHEN 'I1' THEN " + -6 + " WHEN 'I2' THEN " + 5 + " WHEN 'I' THEN " + 4 + " WHEN 'I8' THEN " + -5 + " WHEN 'SZ' THEN " + 93 + " WHEN 'TS' THEN " + 93 + " WHEN 'TZ' THEN " + 92 + " WHEN 'UT' THEN (CASE " + string2 + " WHEN 'D' THEN " + 2001 + " WHEN 'S' THEN " + 2002 + " ELSE " + 1111 + " END)" + " ELSE " + 1111 + " END)" + " AS INTEGER)";
    }

    private static Integer helpColumnToJDBCType(String string) {
        return new Integer(TeraDatabaseMetaData.convertTeradataTypeCodeToJDBCType(string));
    }

    private static Short helpTypeToJDBCType(String string) {
        return new Short((short)TeraDatabaseMetaData.convertTeradataTypeCodeToJDBCType(string));
    }

    private static int convertTeradataTypeCodeToJDBCType(String string) {
        if ("AT".equals(string)) {
            return 92;
        }
        if ("BF".equals(string)) {
            return -2;
        }
        if ("BO".equals(string)) {
            return 2004;
        }
        if ("BV".equals(string)) {
            return -3;
        }
        if ("CF".equals(string)) {
            return 1;
        }
        if ("CO".equals(string)) {
            return 2005;
        }
        if ("CV".equals(string)) {
            return 12;
        }
        if ("D".equals(string)) {
            return 3;
        }
        if ("DA".equals(string)) {
            return 91;
        }
        if ("F".equals(string)) {
            return 6;
        }
        if ("GF".equals(string)) {
            return 1;
        }
        if ("GV".equals(string)) {
            return 12;
        }
        if ("I1".equals(string)) {
            return -6;
        }
        if ("I2".equals(string)) {
            return 5;
        }
        if ("I".equals(string)) {
            return 4;
        }
        if ("I8".equals(string)) {
            return -5;
        }
        if ("SZ".equals(string)) {
            return 93;
        }
        if ("TS".equals(string)) {
            return 93;
        }
        if ("TZ".equals(string)) {
            return 92;
        }
        if ("UD".equals(string)) {
            return 2001;
        }
        if ("US".equals(string)) {
            return 2002;
        }
        return 1111;
    }

    private static String caseUDTSQLTypes(String string) {
        return " (CASE " + string + " WHEN 'D' THEN " + 2001 + " WHEN 'S' THEN " + 2002 + " END) ";
    }

    private static String caseUDTSrcType1(String string, String string2, String string3) {
        return " CAST(" + (string2 == null || string3 == null ? "NULL" : "(CASE " + string + " WHEN 'UT' THEN" + " (CASE " + string2 + " WHEN 'D' THEN " + TeraDatabaseMetaData.caseJDBCTypes(string3, null) + " ELSE NULL" + " END)" + " ELSE NULL" + " END)") + " AS SMALLINT)";
    }

    private static String caseUDTSrcType2(String string, String string2) {
        return " (CASE " + string + "  WHEN 'D' THEN " + TeraDatabaseMetaData.caseJDBCTypes(string2, null) + "  ELSE NULL" + " END) ";
    }

    private static String caseAttributeNullable(String string) {
        return " CAST((CASE " + string + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END)" + " AS INTEGER)";
    }

    private static String caseColumnNullable(String string) {
        return " CAST((CASE " + string + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END)" + " AS INTEGER)";
    }

    private static Integer helpColumnToNullable(String string) {
        return "Y".equals(string) ? new Integer(1) : ("N".equals(string) ? new Integer(0) : new Integer(2));
    }

    private static String caseIsNullable(String string) {
        return " TRIM((CASE " + string + " WHEN 'Y' THEN 'YES'" + " WHEN 'N' THEN 'NO'" + " ELSE ''" + " END)" + ")";
    }

    private static String helpColumnToIsNullable(String string) {
        return "Y".equals(string) ? "YES" : ("N".equals(string) ? "NO" : "");
    }

    private static String buildTypeString(int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        if (nArray == null) {
            bl = true;
            bl2 = true;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 2001) {
                    bl = true;
                    continue;
                }
                if (nArray[i] == 2002) {
                    bl2 = true;
                    continue;
                }
                bl3 = true;
            }
        }
        if (bl && !bl2) {
            string = string + "u.TypeKind = 'D'";
        }
        if (!bl && bl2) {
            string = string + "u.TypeKind = 'S'";
        }
        if (bl && bl2) {
            string = string + "(u.TypeKind = 'D' or u.TypeKind = 'S')";
        }
        if (!bl && !bl2) {
            string = string + "u.TypeKind = ''";
        }
        return string;
    }

    private static String caseTeradataTypeNames(String string, String string2) {
        return " CAST ((CASE " + string + " WHEN 'AT' THEN 'TIME'" + " WHEN 'BF' THEN 'BYTE'" + " WHEN 'BO' THEN 'BLOB'" + " WHEN 'BV' THEN 'VARBYTE'" + " WHEN 'CF' THEN 'CHAR'" + " WHEN 'CO' THEN 'CLOB'" + " WHEN 'CV' THEN 'VARCHAR'" + " WHEN 'D' THEN 'DECIMAL'" + " WHEN 'DA' THEN 'DATE'" + " WHEN 'DH' THEN 'INTERVAL DAY TO HOUR'" + " WHEN 'DM' THEN 'INTERVAL DAY TO MINUTE'" + " WHEN 'DS' THEN 'INTERVAL DAY TO SECOND'" + " WHEN 'DY' THEN 'INTERVAL DAY'" + " WHEN 'F' THEN 'FLOAT'" + " WHEN 'GF' THEN 'GRAPHIC'" + " WHEN 'GV' THEN 'VARGRAPHIC'" + " WHEN 'HM' THEN 'INTERVAL HOUR TO MINUTE'" + " WHEN 'HR' THEN 'INTERVAL HOUR'" + " WHEN 'HS' THEN 'INTERVAL HOUR TO SECOND'" + " WHEN 'I1' THEN 'BYTEINT'" + " WHEN 'I2' THEN 'SMALLINT'" + " WHEN 'I' THEN 'INTEGER'" + " WHEN 'I8' THEN 'BIGINT'" + " WHEN 'MI' THEN 'INTERVAL MINUTE'" + " WHEN 'MO' THEN 'INTERVAL MONTH'" + " WHEN 'MS' THEN 'INTERVAL MINUTE TO SECOND'" + " WHEN 'PD' THEN 'PERIOD(DATE)'" + " WHEN 'PM' THEN 'PERIOD(TIMESTAMP WITH TIME ZONE)'" + " WHEN 'PS' THEN 'PERIOD(TIMESTAMP)'" + " WHEN 'PT' THEN 'PERIOD(TIME)'" + " WHEN 'PZ' THEN 'PERIOD(TIME WITH TIME ZONE)'" + " WHEN 'SC' THEN 'INTERVAL SECOND'" + " WHEN 'SZ' THEN 'TIMESTAMP WITH TIME ZONE'" + " WHEN 'TS' THEN 'TIMESTAMP'" + " WHEN 'TZ' THEN 'TIME WITH TIME ZONE'" + " WHEN 'YM' THEN 'INTERVAL YEAR TO MONTH'" + " WHEN 'YR' THEN 'INTERVAL YEAR'" + (string2 != null ? " WHEN 'UT' THEN 'SYSUDTLIB.' || TRIM(TRAILING FROM " + string2 + ")" : "") + " ELSE TRIM (" + string + ")" + " END)" + " AS VARCHAR(500))";
    }

    private static String helpColumnToTeradataTypeName(String string, String string2) throws SQLException {
        if ("AT".equals(string)) {
            return "TIME";
        }
        if ("BF".equals(string)) {
            return "BYTE";
        }
        if ("BO".equals(string)) {
            return "BLOB";
        }
        if ("BV".equals(string)) {
            return "VARBYTE";
        }
        if ("CF".equals(string)) {
            return "CHAR";
        }
        if ("CO".equals(string)) {
            return "CLOB";
        }
        if ("CV".equals(string)) {
            return "VARCHAR";
        }
        if ("D".equals(string)) {
            return "DECIMAL";
        }
        if ("DA".equals(string)) {
            return "DATE";
        }
        if ("DH".equals(string)) {
            return "INTERVAL DAY TO HOUR";
        }
        if ("DM".equals(string)) {
            return "INTERVAL DAY TO MINUTE";
        }
        if ("DS".equals(string)) {
            return "INTERVAL DAY TO SECOND";
        }
        if ("DY".equals(string)) {
            return "INTERVAL DAY";
        }
        if ("F".equals(string)) {
            return "FLOAT";
        }
        if ("GF".equals(string)) {
            return "GRAPHIC";
        }
        if ("GV".equals(string)) {
            return "VARGRAPHIC";
        }
        if ("HM".equals(string)) {
            return "INTERVAL HOUR TO MINUTE";
        }
        if ("HR".equals(string)) {
            return "INTERVAL HOUR";
        }
        if ("HS".equals(string)) {
            return "INTERVAL HOUR TO SECOND";
        }
        if ("I1".equals(string)) {
            return "BYTEINT";
        }
        if ("I2".equals(string)) {
            return "SMALLINT";
        }
        if ("I".equals(string)) {
            return "INTEGER";
        }
        if ("I8".equals(string)) {
            return "BIGINT";
        }
        if ("MI".equals(string)) {
            return "INTERVAL MINUTE";
        }
        if ("MO".equals(string)) {
            return "INTERVAL MONTH";
        }
        if ("MS".equals(string)) {
            return "INTERVAL MINUTE TO SECOND";
        }
        if ("PD".equals(string)) {
            return "PERIOD(DATE)";
        }
        if ("PM".equals(string)) {
            return "PERIOD(TIMESTAMP WITH TIME ZONE)";
        }
        if ("PS".equals(string)) {
            return "PERIOD(TIMESTAMP)";
        }
        if ("PT".equals(string)) {
            return "PERIOD(TIME)";
        }
        if ("PZ".equals(string)) {
            return "PERIOD(TIME WITH TIME ZONE)";
        }
        if ("SC".equals(string)) {
            return "INTERVAL SECOND";
        }
        if ("SZ".equals(string)) {
            return "TIMESTAMP WITH TIME ZONE";
        }
        if ("TS".equals(string)) {
            return "TIMESTAMP";
        }
        if ("TZ".equals(string)) {
            return "TIME WITH TIME ZONE";
        }
        if ("YM".equals(string)) {
            return "INTERVAL YEAR TO MONTH";
        }
        if ("YR".equals(string)) {
            return "INTERVAL YEAR";
        }
        if (("UD".equals(string) || "US".equals(string) || "UT".equals(string)) && string2 != null) {
            return string2;
        }
        return string;
    }

    private static String caseDisplaySize(String string, String string2, String string3, String string4) {
        return " CAST ((CASE WHEN " + string + " = 'AT' THEN 15" + " WHEN (" + string + " = 'CF'" + " OR " + string + " = 'CO'" + " OR " + string + " = 'CV'" + " OR " + string + " = 'GF'" + " OR " + string + " = 'GV')" + " AND (" + string3 + " = 2" + " OR " + string3 + " = 4)" + " THEN " + string4 + " / 2" + " WHEN " + string + " = 'D' THEN " + string2 + " WHEN " + string + " = 'DA' THEN 10" + " WHEN " + string + " = 'DH' THEN 4 + " + string2 + " WHEN " + string + " = 'DM' THEN 7 + " + string2 + " WHEN " + string + " = 'DS' THEN 17 + " + string2 + " WHEN " + string + " = 'DY' THEN 1 + " + string2 + " WHEN " + string + " = 'F'  THEN 15" + " WHEN " + string + " = 'HM' THEN 4 + " + string2 + " WHEN " + string + " = 'HR' THEN 1 + " + string2 + " WHEN " + string + " = 'HS' THEN 14 + " + string2 + " WHEN " + string + " = 'I1' THEN 3" + " WHEN " + string + " = 'I2' THEN 5" + " WHEN " + string + " = 'I'  THEN 10" + " WHEN " + string + " = 'I8' THEN 19" + " WHEN " + string + " = 'MI' THEN 1 + " + string2 + " WHEN " + string + " = 'MO' THEN 1 + " + string2 + " WHEN " + string + " = 'MS' THEN 11 + " + string2 + " WHEN " + string + " = 'PD' THEN 28" + " WHEN " + string + " = 'PM' THEN 72" + " WHEN " + string + " = 'PS' THEN 60" + " WHEN " + string + " = 'PT' THEN 38" + " WHEN " + string + " = 'PZ' THEN 50" + " WHEN " + string + " = 'SC' THEN 8 + " + string2 + " WHEN " + string + " = 'SZ' THEN 32" + " WHEN " + string + " = 'TS' THEN 26" + " WHEN " + string + " = 'TZ' THEN 21" + " WHEN " + string + " = 'YM' THEN 4 + " + string2 + " WHEN " + string + " = 'YR' THEN 1 + " + string2 + " ELSE " + string4 + " END)" + " AS INTEGER)";
    }

    private static Integer helpColumnToDisplaySize(String string, Integer n, int n2, Integer n3) throws SQLException {
        if ("AT".equals(string)) {
            return new Integer(15);
        }
        if (("CF".equals(string) || "CO".equals(string) || "CV".equals(string) || "GF".equals(string) || "GV".equals(string)) && (n2 == 2 || n2 == 4)) {
            return TeraDatabaseMetaData.nullArith(n3, '/', 2);
        }
        if ("D".equals(string)) {
            return n;
        }
        if ("DA".equals(string)) {
            return new Integer(10);
        }
        if ("DH".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 4);
        }
        if ("DM".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 7);
        }
        if ("DS".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 17);
        }
        if ("DY".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("F".equals(string)) {
            return new Integer(15);
        }
        if ("HM".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 4);
        }
        if ("HR".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("HS".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 14);
        }
        if ("I1".equals(string)) {
            return new Integer(3);
        }
        if ("I2".equals(string)) {
            return new Integer(5);
        }
        if ("I".equals(string)) {
            return new Integer(10);
        }
        if ("I8".equals(string)) {
            return new Integer(19);
        }
        if ("MI".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("MO".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("MS".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 11);
        }
        if ("PD".equals(string)) {
            return new Integer(28);
        }
        if ("PM".equals(string)) {
            return new Integer(72);
        }
        if ("PS".equals(string)) {
            return new Integer(60);
        }
        if ("PT".equals(string)) {
            return new Integer(38);
        }
        if ("PZ".equals(string)) {
            return new Integer(50);
        }
        if ("SC".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 8);
        }
        if ("SZ".equals(string)) {
            return new Integer(32);
        }
        if ("TS".equals(string)) {
            return new Integer(26);
        }
        if ("TZ".equals(string)) {
            return new Integer(21);
        }
        if ("YM".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 4);
        }
        if ("YR".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        return n3;
    }

    private static Integer nullArith(Integer n, char c, int n2) {
        if (n == null) {
            return null;
        }
        switch (c) {
            case '+': {
                return new Integer(n + n2);
            }
            case '/': {
                return new Integer(n / n2);
            }
        }
        throw new IllegalArgumentException("Invalid value for cOperator: " + c);
    }

    private static String casePrivilegeName(String string) {
        return "(CASE " + string + " WHEN 'AE' THEN 'ALTER EXTERNAL PROCEDURE'" + " WHEN 'AF' THEN 'ALTER FUNCTION'" + " WHEN 'AN' THEN 'ANY PRIVILEGE'" + " WHEN 'AP' THEN 'ALTER PROCEDURE'" + " WHEN 'AS' THEN 'ABORT SESSION'" + " WHEN 'CA' THEN 'CREATE AUTHORIZATION'" + " WHEN 'CD' THEN 'CREATE DATABASE'" + " WHEN 'CE' THEN 'CREATE EXTERNAL PROCEDURE'" + " WHEN 'CF' THEN 'CREATE FUNCTION'" + " WHEN 'CG' THEN 'CREATE TRIGGER'" + " WHEN 'CM' THEN 'CREATE MACRO'" + " WHEN 'CO' THEN 'CREATE PROFILE'" + " WHEN 'CP' THEN 'CHECKPOINT'" + " WHEN 'CR' THEN 'CREATE ROLE'" + " WHEN 'CT' THEN 'CREATE TABLE'" + " WHEN 'CU' THEN 'CREATE USER'" + " WHEN 'CV' THEN 'CREATE VIEW'" + " WHEN 'D'  THEN 'DELETE'" + " WHEN 'DA' THEN 'DROP AUTHORIZATION'" + " WHEN 'DD' THEN 'DROP DATABASE'" + " WHEN 'DF' THEN 'DROP FUNCTION'" + " WHEN 'DG' THEN 'DROP TRIGGER'" + " WHEN 'DM' THEN 'DROP MACRO'" + " WHEN 'DO' THEN 'DROP PROFILE'" + " WHEN 'DP' THEN 'DUMP'" + " WHEN 'DR' THEN 'DROP ROLE'" + " WHEN 'DT' THEN 'DROP TABLE'" + " WHEN 'DU' THEN 'DROP USER'" + " WHEN 'DV' THEN 'DROP VIEW'" + " WHEN 'GC' THEN 'CREATE GLOP'" + " WHEN 'GD' THEN 'DROP GLOP'" + " WHEN 'GM' THEN 'GLOP MEMBER'" + " WHEN 'E'  THEN 'EXECUTE MACRO'" + " WHEN 'EF' THEN 'EXECUTE FUNCTION'" + " WHEN 'I'  THEN 'INSERT'" + " WHEN 'IX' THEN 'INDEX'" + " WHEN 'HR' THEN 'HUT RELEASE LOCK'" + " WHEN 'MR' THEN 'MONITOR RESOURCE'" + " WHEN 'MS' THEN 'MONITOR SESSION'" + " WHEN 'NT' THEN 'NONTEMPORAL'" + " WHEN 'OP' THEN 'CREATE OWNER PROCEDURE'" + " WHEN 'PC' THEN 'CREATE PROCEDURE'" + " WHEN 'PD' THEN 'DROP PROCEDURE'" + " WHEN 'PE' THEN 'EXECUTE PROCEDURE'" + " WHEN 'R'  THEN 'SELECT'" + " WHEN 'RF' THEN 'REFERENCE'" + " WHEN 'RS' THEN 'RESTORE'" + " WHEN 'S'  THEN 'SELECT'" + " WHEN 'SH' THEN 'SHOW'" + " WHEN 'SS' THEN 'SET SESSION RATE'" + " WHEN 'SR' THEN 'SET RESOURCE RATE'" + " WHEN 'ST' THEN 'STATISTICS'" + " WHEN 'TH' THEN 'CONNECT THROUGH'" + " WHEN 'U'  THEN 'UPDATE'" + " WHEN 'UU' THEN 'UDT USAGE'" + " WHEN 'UT' THEN 'UDT TYPE'" + " WHEN 'UM' THEN 'UDT METHOD'" + " WHEN 'WL' THEN 'WRITE LOCK'" + " ELSE TRIM (" + string + ") END)";
    }

    private static String caseYesNo(String string) {
        return "(CASE " + string + " WHEN 'Y' THEN 'YES'" + " WHEN 'N' THEN 'NO'" + " ELSE NULL END)";
    }

    private class ObtainViewColumnMetaData
    implements ResultSet.FetchedRowsPostProcessor {
        private ObtainViewColumnMetaData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processRows(int n, List list) throws SQLException {
            String string;
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            Object object4;
            Log log = ((TeraLocalConnection)TeraDatabaseMetaData.this.connection).getTDSession().getLog();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StringBuffer stringBuffer = new StringBuffer("help column ");
            Object object5 = list.iterator();
            while (object5.hasNext()) {
                object4 = (ResultSetRow)object5.next();
                boolean bl2 = ((ResultSetRow)object4).getValue(1) != null && ((ResultSetRow)object4).getValue(2) != null && ((ResultSetRow)object4).getValue(3) != null;
                boolean bl3 = bl = ((ResultSetRow)object4).getValue(5) == null;
                if (!bl2 || !bl) continue;
                stringBuffer.append((arrayList.isEmpty() ? "" : ",") + "\"" + ((ResultSetRow)object4).getValue(1).toString().replaceAll("\"", "\"\"") + "\".\"" + ((ResultSetRow)object4).getValue(2).toString().replaceAll("\"", "\"\"") + "\".\"" + ((ResultSetRow)object4).getValue(3).toString().replaceAll("\"", "\"\"") + "\"");
                arrayList.add(object4);
            }
            object5 = new ArrayList();
            object4 = new StringBuffer();
            if (!arrayList.isEmpty()) {
                if (log.canLog(1)) {
                    log.info("TeraDatabaseMetaData.ObtainViewColumnMetaData.processRows: " + stringBuffer);
                }
                Statement statement = TeraDatabaseMetaData.this.connection.createStatement();
                try {
                    java.sql.ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                    try {
                        object3 = resultSet.getMetaData();
                        object2 = arrayList.iterator();
                        while (resultSet.next() && object2.hasNext()) {
                            String string2;
                            object = (ResultSetRow)object2.next();
                            string = resultSet.getString(2);
                            if (string != null) {
                                string = string.trim();
                            }
                            if ((string2 = resultSet.getString(3)) != null) {
                                string2 = string2.trim();
                            }
                            Integer n2 = resultSet.getObject(5) != null ? new Integer(resultSet.getInt(5)) : null;
                            Integer n3 = resultSet.getObject(6) != null ? new Integer(resultSet.getInt(6)) : null;
                            Integer n4 = resultSet.getObject(7) != null ? new Integer(resultSet.getInt(7)) : null;
                            int n5 = resultSet.getInt(17);
                            String string3 = object3.getColumnCount() >= 19 ? resultSet.getString(19) : null;
                            ((ResultSetRow)object).setValue(4, TeraDatabaseMetaData.helpColumnToJDBCType(string));
                            ((ResultSetRow)object).setValue(5, TeraDatabaseMetaData.helpColumnToTeradataTypeName(string, string3));
                            ((ResultSetRow)object).setValue(6, TeraDatabaseMetaData.helpColumnToDisplaySize(string, n3, n5, n2));
                            ((ResultSetRow)object).setValue(8, n4);
                            ((ResultSetRow)object).setValue(10, TeraDatabaseMetaData.helpColumnToNullable(string2));
                            ((ResultSetRow)object).setValue(15, n2);
                            ((ResultSetRow)object).setValue(17, TeraDatabaseMetaData.helpColumnToIsNullable(string2));
                            if (!"UD".equals(string) || string3 == null) continue;
                            ((StringBuffer)object4).append((object5.isEmpty() ? "" : ";") + "help type " + string3);
                            object5.add(object);
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            if (!object5.isEmpty()) {
                if (log.canLog(1)) {
                    log.info("TeraDatabaseMetaData.ObtainViewColumnMetaData.processRows: " + object4);
                }
                Statement statement = TeraDatabaseMetaData.this.connection.createStatement();
                try {
                    bl = statement.execute(((StringBuffer)object4).toString());
                    object3 = object5.iterator();
                    while (bl && object3.hasNext()) {
                        object2 = (ResultSetRow)object3.next();
                        object = statement.getResultSet();
                        try {
                            object.next();
                            string = object.getString(3);
                            if (string != null) {
                                string = string.trim();
                            }
                            ((ResultSetRow)object2).setValue(21, TeraDatabaseMetaData.helpTypeToJDBCType(string));
                        }
                        finally {
                            object.close();
                        }
                        bl = statement.getMoreResults();
                    }
                }
                finally {
                    statement.close();
                }
            }
        }
    }
}

