/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Clob;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.Blob;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class TeraDriver
implements Driver {
    protected static Log log = new Log("TeraDriver/" + (class$com$teradata$jdbc$TeraDriver == null ? (class$com$teradata$jdbc$TeraDriver = TeraDriver.class$("com.teradata.jdbc.TeraDriver")) : class$com$teradata$jdbc$TeraDriver).getClassLoader());
    private static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    private static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    static /* synthetic */ Class class$com$teradata$jdbc$TeraDriver;

    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string3 = null;
        String string4 = null;
        String string5 = "";
        String string6 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string7 = string.substring(string6.length());
        int n = string7.indexOf("/");
        if (n >= 0) {
            string2 = string7.substring(0, n);
            string5 = string7.substring(n + 1);
        } else {
            string2 = string7.trim();
            string5 = "";
        }
        if (string2.startsWith("[") && string2.endsWith("]")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (properties.containsKey("user")) {
            string3 = properties.getProperty("user");
        } else if (properties.containsKey("username")) {
            string3 = properties.getProperty("username");
        }
        if (properties.containsKey("password")) {
            string4 = properties.getProperty("password");
        }
        URLParameters uRLParameters = new URLParameters(string5);
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string2, string3, string4, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() == null) {
            currentThreadIO.setConnection(connection);
            TDSession tDSession = ((TeraLocalConnection)connection).getTDSession();
            Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
            if (n2 != null) {
                tDSession.setSPReturnResult(n2.byteValue());
            }
            if (tDSession.getLog().isDebugEnabled()) {
                tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
            }
        }
        if (uRLParameters.isJavaSPDefaultConnection()) {
            ((TeraLocalConnection)connection).changeURLParams(uRLParameters);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return null;
    }

    public int getMajorVersion() {
        return 13;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        Hashtable hashtable = ioTable;
        synchronized (hashtable) {
            ioTable.put(Thread.currentThread(), currentThreadIO);
        }
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static java.sql.Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TeraLocalConnection teraLocalConnection = (TeraLocalConnection)currentThreadIO.getConnection();
        com.teradata.jdbc.jdbc_4.Clob clob = new com.teradata.jdbc.jdbc_4.Clob(teraLocalConnection.getTDSession().getLog());
        clob.setLength(l);
        clob.setLocator(byArray2);
        clob.setTDSession(teraLocalConnection.getTDSession());
        Clob clob2 = new Clob(clob);
        return clob2;
    }

    public static byte[] getClobLocator(java.sql.Clob clob) throws SQLException {
        Clob clob2 = (Clob)clob;
        byte[] byArray = clob2.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static java.sql.Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TeraLocalConnection teraLocalConnection = (TeraLocalConnection)currentThreadIO.getConnection();
        Blob blob = new Blob();
        blob.setLength(l);
        blob.setLocator(byArray2);
        blob.setTDSession(teraLocalConnection.getTDSession());
        com.teradata.jdbc.Blob blob2 = new com.teradata.jdbc.Blob(blob);
        return blob2;
    }

    public static byte[] getBlobLocator(java.sql.Blob blob) throws SQLException {
        com.teradata.jdbc.Blob blob2 = (com.teradata.jdbc.Blob)blob;
        byte[] byArray = blob2.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(java.sql.ResultSet[] resultSetArray, Integer n) throws SQLException {
        Object object;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TeraLocalConnection)currentThreadIO.getConnection()).getTDSession().getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; i < resultSetArray.length; ++i) {
            int n2;
            if (resultSetArray[i] == null || (object = ((TeraLocalResultSet)resultSetArray[i]).getResultSet()) == null || ((ResultSet)object).isClosed()) continue;
            int n3 = n2 = ((ResultSet)object).isAfterLast() ? ((ResultSet)object).getNumberOfRows() : ((ResultSet)object).getRow();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((ResultSet)object).getRequestNumber() + " stmtnum=" + ((ResultSet)object).getStatementNumber() + " row=" + n2);
            }
            arrayList.add(new ResultSetSelectionItem(((ResultSet)object).getStatementNumber(), ((ResultSet)object).getRequestNumber(), n2));
            ((ResultSet)object).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = ((TeraLocalConnection)currentThreadIO.getConnection()).getTDSession();
        object = tDSession.createStatement(1003, 1007);
        StatementController statementController = new StatementController((Statement)object, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
    }
}

