/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.TeraPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class TeraParameterMetaData
implements ParameterMetaData {
    int numberOfParameters = 0;
    TeraPreparedStatement pStmt;

    public TeraParameterMetaData(TeraPreparedStatement teraPreparedStatement) throws SQLException {
        if (!teraPreparedStatement.hasParameterMetaData()) {
            throw ErrorFactory.makeDriverJDBCException("TJ442");
        }
        this.pStmt = teraPreparedStatement;
        this.numberOfParameters = teraPreparedStatement.getNumberOfParameters();
    }

    public int getParameterCount() throws SQLException {
        return this.numberOfParameters;
    }

    public int isNullable(int n) throws SQLException {
        this.validateIndex(n);
        switch (this.pStmt.getParameterMarkerMetaData(n).isNullable()) {
            case 89: {
                return 1;
            }
            case 78: {
                return 0;
            }
        }
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        this.validateIndex(n);
        return this.pStmt.getParameterMarkerMetaData(n).isSigned() == 89;
    }

    public int getPrecision(int n) throws SQLException {
        this.validateIndex(n);
        short s = this.pStmt.getParameterMarkerMetaData(n).getDataType();
        if (s == 0) {
            return 0;
        }
        return this.pStmt.getParameterMarkerMetaData(n).getTotalNumberOfDigits();
    }

    public int getScale(int n) throws SQLException {
        this.validateIndex(n);
        short s = this.pStmt.getParameterMarkerMetaData(n).getDataType();
        if (s == 0) {
            return 0;
        }
        return this.pStmt.getParameterMarkerMetaData(n).getNumberOfFractionalDigits();
    }

    public int getParameterType(int n) throws SQLException {
        this.validateIndex(n);
        short s = this.pStmt.getParameterMarkerMetaData(n).getDataType();
        if (s == 0) {
            return 0;
        }
        return JDBC4Constants.getJavaSQLType(s);
    }

    public String getParameterTypeName(int n) throws SQLException {
        this.validateIndex(n);
        if (this.pStmt.getParameterMarkerMetaData(n).getUdtIndicator() != 0) {
            return this.pStmt.getParameterMarkerMetaData(n).getUdtTypeName();
        }
        short s = this.pStmt.getParameterMarkerMetaData(n).getDataType();
        return JDBC4Constants.getTDTypeName(s);
    }

    public String getParameterClassName(int n) throws SQLException {
        this.validateIndex(n);
        short s = this.pStmt.getParameterMarkerMetaData(n).getDataType();
        if (s == 0) {
            return null;
        }
        return JDBC4Constants.getJavaClassName(JDBC4Constants.getJavaSQLType(s));
    }

    public int getParameterMode(int n) throws SQLException {
        this.validateIndex(n);
        int n2 = JDBC4Constants.getTDTypeParameterMode(this.pStmt.getParameterMarkerMetaData(n).getDataType());
        if (n2 != 0) {
            return n2;
        }
        switch (this.pStmt.getParameterMarkerMetaData(n).getSPParameterDirection()) {
            case 73: {
                n2 = 1;
                break;
            }
            case 79: {
                n2 = 4;
                break;
            }
            case 66: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private void validateIndex(int n) throws SQLException {
        if (n < 1 || n > this.numberOfParameters) {
            throw ErrorFactory.makeDriverJDBCException("TJ169", n, this.numberOfParameters);
        }
    }
}

