/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Blob;
import com.teradata.jdbc.Clob;
import com.teradata.jdbc.ComSvcs;
import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraConnection;
import com.teradata.jdbc.TeraParameterMetaData;
import com.teradata.jdbc.TeraStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;

public abstract class TeraPreparedStatement
extends TeraStatement
implements PreparedStatement {
    private FullContentMetadataItem[] parmArray;
    public static final int TIME_STRING_LENGTH = 8;
    public static final int TIME_ZONE_STRING_LENGTH = 6;

    public TeraPreparedStatement(TeraConnection teraConnection, String string, ConnectionOptions connectionOptions) {
        super(teraConnection, null, "0", connectionOptions);
    }

    public TeraPreparedStatement(TeraConnection teraConnection, String string, ComSvcs comSvcs, String string2, ConnectionOptions connectionOptions) {
        super(teraConnection, comSvcs, string2, connectionOptions);
    }

    public void clearParameters() throws SQLException {
        this.stmtParams.clearParameters();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public int executeUpdate(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public void setNull(int n, int n2) throws SQLException {
        int n3;
        this.stmtParams.verify(n);
        boolean bl = ((TeraLocalConnection)this.con).getTDSession().shouldSendAnsiDate();
        boolean bl2 = ((TeraLocalConnection)this.con).getTDSession().isStatementInfoRequestSupported();
        boolean bl3 = this.conOptions.isLargeDecimalAndBigIntSupported();
        switch (n2) {
            case 91: {
                n3 = bl ? 749 : (bl2 ? 753 : 497);
                break;
            }
            case 93: {
                n3 = bl2 ? 765 : 453;
                break;
            }
            case 92: {
                n3 = bl2 ? 761 : 453;
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 1111: {
                n3 = 449;
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                n3 = 757;
                break;
            }
            case 5: {
                n3 = 501;
                break;
            }
            case 4: {
                n3 = 497;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                n3 = 689;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n3 = 481;
                break;
            }
            case -5: {
                n3 = bl3 ? 601 : 485;
                break;
            }
            case 2: 
            case 3: {
                n3 = 485;
                break;
            }
            case 2004: {
                n3 = 405;
                break;
            }
            case 2005: {
                n3 = 421;
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ231", n2);
            }
        }
        this.internalSetNull(n, n2, n3, false);
    }

    private void internalSetNull(int n, int n2, int n3, boolean bl) throws SQLException {
        byte[] byArray;
        int n4;
        int n5;
        int n6 = 0;
        if (n2 == 92 || n2 == 93) {
            n5 = n2 == 92 ? 8 : 19;
            int n7 = n4 = n2 == 92 ? this.conOptions.getURLParams().getTimeNano() : this.conOptions.getURLParams().getTimestampNano();
            if (n4 != -1 && n4 > 0) {
                n6 = n4;
                n5 += 1 + n4;
            }
            if (bl) {
                n5 += 6;
            }
            byArray = TeraPreparedStatement.spacesForNullValue(false, n5, this.conOptions.getURLParams().getJavaEnCoding());
        } else if (n3 == 749) {
            byArray = TeraPreparedStatement.spacesForNullValue(false, 10, this.conOptions.getURLParams().getJavaEnCoding());
        } else {
            switch (n3) {
                case 453: 
                case 693: {
                    n5 = 0;
                    break;
                }
                case 449: 
                case 457: 
                case 689: 
                case 697: {
                    n5 = 2;
                    break;
                }
                case 757: {
                    n5 = 1;
                    break;
                }
                case 501: {
                    n5 = 2;
                    break;
                }
                case 497: 
                case 753: {
                    n5 = 4;
                    break;
                }
                case 601: {
                    n5 = 8;
                    break;
                }
                case 481: {
                    n5 = 8;
                    break;
                }
                case 485: {
                    n5 = this.conOptions.isLargeDecimalAndBigIntSupported() ? 16 : 8;
                    break;
                }
                case 405: 
                case 421: {
                    n5 = 4;
                    break;
                }
                default: {
                    throw ErrorFactory.makeDriverJDBCException("TJ426", n, n3);
                }
            }
            byArray = new byte[n5];
        }
        n5 = !this.conOptions.isLargeDecimalAndBigIntSupported() ? 1 : 0;
        int n8 = n4 = n2 == 3 || n2 == 2 || n2 == -5 && n5 != 0 ? 1 : 0;
        if (n4 != 0) {
            this.stmtParams.setDecimalParameter(n, null, byArray, n3, true, this.conOptions.isLargeDecimalAndBigIntSupported() ? 38 : 18, n6, 0);
        } else {
            this.stmtParams.setColDataLength(n, byArray.length);
            this.stmtParams.setParameter(n, null, byArray, n3, true, 0, n6);
        }
    }

    public static byte[] spacesForNullValue(boolean bl, int n, String string) throws SQLException {
        try {
            int n2;
            if (bl) {
                int n3 = " ".getBytes(string).length;
                n2 = n / n3;
            } else {
                n2 = n;
            }
            char[] cArray = new char[n2];
            Arrays.fill(cArray, ' ');
            return new String(cArray).getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", string);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.stmtParams.verify(n);
        this.stmtParams.setColDataLength(n, 1);
        this.stmtParams.setParameter(n, (Object)new Boolean(bl), ByteConverter.putBoolean(bl), 757);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.stmtParams.verify(n);
        this.stmtParams.setColDataLength(n, 1);
        this.stmtParams.setParameter(n, (Object)new Byte(by), ByteConverter.putByte(by), 757);
    }

    public void setShort(int n, short s) throws SQLException {
        this.stmtParams.verify(n);
        this.stmtParams.setColDataLength(n, 2);
        this.stmtParams.setParameter(n, (Object)new Short(s), ByteConverter.putShort(s), 501);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.stmtParams.verify(n);
        this.stmtParams.setColDataLength(n, 4);
        this.stmtParams.setParameter(n, (Object)new Integer(n2), ByteConverter.putInt(n2), 497);
    }

    public void setLong(int n, long l) throws SQLException {
        this.stmtParams.verify(n);
        if (this.conOptions.isLargeDecimalAndBigIntSupported()) {
            this.stmtParams.setColDataLength(n, 8);
            this.stmtParams.setParameter(n, (Object)new Long(l), ByteConverter.putLong(l), 600);
        } else {
            BigInteger bigInteger = new BigInteger(Long.toString(l));
            int n2 = bigInteger.abs().toString().length();
            if (n2 > 18) {
                throw ErrorFactory.makeTDDataTruncation("TJ433", n, true, false, bigInteger.toString().length(), 0, n2);
            }
            this.stmtParams.setDecimalParameter(n, new Long(l), ByteConverter.putLong(l), 485, false, 18, 0, 0);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, Double.valueOf(Float.toString(f)));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.stmtParams.verify(n);
        this.stmtParams.setColDataLength(n, 8);
        this.stmtParams.setParameter(n, (Object)new Double(d), ByteConverter.putDouble(d), 481);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2;
        int n3 = 0;
        this.stmtParams.verify(n);
        if (bigDecimal == null) {
            this.setNull(n, 3);
            return;
        }
        if (bigDecimal.compareTo(new BigDecimal(0.0)) == 0) {
            n2 = 0;
        } else {
            int n4;
            int n5;
            int n6 = 18;
            if (this.conOptions.isLargeDecimalAndBigIntSupported()) {
                n6 = 38;
            }
            if ((n2 = bigDecimal.scale()) < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n2 = bigDecimal.scale();
            }
            int n7 = bigDecimal.compareTo(new BigDecimal(1.0)) == -1 && bigDecimal.compareTo(new BigDecimal(-1.0)) == 1 ? n2 : bigDecimal.abs().unscaledValue().toString().length();
            n3 = ComUtil.getSignificantDigits(bigDecimal);
            if (n3 > n6) {
                throw ErrorFactory.makeTDDataTruncation("TJ433", n, true, false, bigDecimal.abs().unscaledValue().toByteArray().length, 0, n7);
            }
            if (n7 > n6) {
                if ((n2 = n6 - (n7 - n2)) < 0) {
                    n2 = 0;
                }
                bigDecimal = bigDecimal.setScale(n2, 4);
            }
            bigDecimal = bigDecimal.movePointRight(n2);
            String string = bigDecimal.toString();
            for (n5 = n4 = string.length(); n5 > n4 - n2 && string.charAt(n5 - 1) == '0'; --n5) {
            }
            if (n5 < n4) {
                bigDecimal = new BigDecimal(string.substring(0, n5));
                n2 -= n4 - n5;
            }
        }
        this.stmtParams.setDecimalParameter(n, bigDecimal, this.conOptions.isLargeDecimalAndBigIntSupported() ? ByteConverter.bigIntToByteArray(bigDecimal.toBigInteger(), 16) : ByteConverter.putLong(bigDecimal.longValue()), 485, false, this.conOptions.isLargeDecimalAndBigIntSupported() ? 38 : 18, n2, n3);
    }

    public void setString(int n, String string) throws SQLException {
        this.stmtParams.verify(n);
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        try {
            byte[] byArray = string.getBytes(this.conOptions.getURLParams().getJavaEnCoding());
            int n2 = byArray.length;
            if (n2 > 64000) {
                throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(n2));
            }
            byte[] byArray2 = new byte[n2 + 2];
            ByteConverter.putShort(byArray2, 0, (short)n2);
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            this.stmtParams.setColDataLength(n, n2);
            this.stmtParams.setParameter(n, (Object)string, byArray2, 449);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(251, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), this.conOptions.getURLParams().getJavaEnCoding()));
        }
    }

    protected final byte[] setChar(int n, String string) throws SQLException {
        byte[] byArray = null;
        if (string == null) {
            this.setNull(n, 12);
            return new byte[0];
        }
        try {
            byArray = string.getBytes(this.conOptions.getURLParams().getJavaEnCoding());
            this.stmtParams.setColDataLength(n, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(251, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), this.conOptions.getURLParams().getJavaEnCoding()));
        }
        return byArray;
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.stmtParams.verify(n);
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        if (byArray.length > 64000) {
            throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(byArray.length));
        }
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 2];
        ByteConverter.putShort(byArray2, 0, (short)n2);
        System.arraycopy(byArray, 0, byArray2, 2, n2);
        this.stmtParams.setColDataLength(n, n2);
        this.stmtParams.setParameter(n, (Object)byArray, byArray2, 689);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.stmtParams.verify(n);
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (((TeraLocalConnection)this.con).getTDSession().shouldSendAnsiDate()) {
            byte[] byArray;
            try {
                byArray = date.toString().getBytes(this.conOptions.getURLParams().getJavaEnCoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ErrorFactory.makeDriverJDBCException("TJ212", this.conOptions.getURLParams().getJavaEnCoding());
            }
            this.stmtParams.setColDataLength(n, byArray.length);
            this.stmtParams.setParameter(n, (Object)date, byArray, 749);
        } else {
            int n2 = (Integer.valueOf(String.valueOf(date).substring(0, 4)) - 1900) * 10000 + Integer.valueOf(String.valueOf(date).substring(5, 7)) * 100 + Integer.valueOf(String.valueOf(date).substring(8, 10));
            this.stmtParams.setColDataLength(n, 4);
            this.stmtParams.setParameter(n, (Object)date, ByteConverter.putInt(n2), ((TeraLocalConnection)this.con).getTDSession().isStatementInfoRequestSupported() ? 753 : 497);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setCharacterStream(n, inputStream == null ? null : this.getReader(inputStream, "ASCII"), n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 2005);
            return;
        }
        this.setCharacterStream(n, this.getReader(inputStream, "UTF8"), n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        this.stmtParams.verify(n);
        if (n2 < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ166", n2);
        }
        this.stmtParams.setParameter(n, (Object)inputStream, 405, n2);
    }

    public Reader getReader(InputStream inputStream, String string) throws SQLException {
        try {
            return new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(251, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), string));
            return null;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    private static Date toDate(String string, int n, int n2) throws SQLException {
        try {
            return Date.valueOf(string);
        }
        catch (Exception exception) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
            jDBCException.initCause(exception);
            throw jDBCException;
        }
    }

    private static Time toTime(String string, int n, int n2) throws SQLException {
        try {
            return Time.valueOf(string);
        }
        catch (Exception exception) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
            jDBCException.initCause(exception);
            throw jDBCException;
        }
    }

    private static Timestamp toTimestamp(String string, int n, int n2) throws SQLException {
        try {
            return Timestamp.valueOf(string);
        }
        catch (Exception exception) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
            jDBCException.initCause(exception);
            throw jDBCException;
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -7: {
                String string = object.toString();
                if (string.length() < 1) {
                    this.setByte(n, (byte)0);
                } else {
                    byte by = (byte)string.charAt(0);
                    this.setByte(n, by);
                }
                return;
            }
            case -6: {
                this.setByte(n, Byte.parseByte(object.toString()));
                return;
            }
            case 5: {
                this.setShort(n, Short.parseShort(object.toString()));
                return;
            }
            case 4: {
                this.setInt(n, Integer.parseInt(object.toString()));
                return;
            }
            case -5: {
                this.setLong(n, Long.parseLong(object.toString()));
                return;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = Double.valueOf(object.toString());
                this.setDouble(n, d);
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(n, new BigDecimal(object.toString()));
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                return;
            }
            case 91: {
                Date date = object instanceof Date ? (Date)object : (object instanceof java.util.Date ? new Date(((java.util.Date)object).getTime()) : TeraPreparedStatement.toDate(object.toString(), n, n2));
                this.setDate(n, date);
                return;
            }
            case 92: {
                Time time = object instanceof Time ? (Time)object : (object instanceof java.util.Date ? new Time(((java.util.Date)object).getTime()) : TeraPreparedStatement.toTime(object.toString(), n, n2));
                this.setTime(n, time);
                return;
            }
            case 93: {
                Timestamp timestamp = object instanceof Timestamp ? (Timestamp)object : (object instanceof java.util.Date ? new Timestamp(((java.util.Date)object).getTime()) : TeraPreparedStatement.toTimestamp(object.toString(), n, n2));
                this.setTimestamp(n, timestamp);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof java.sql.Blob) {
                    if (((Blob)object).length() < 64000L) {
                        try {
                            InputStream inputStream = ((Blob)object).getBinaryStream();
                            byte[] byArray = new byte[(int)((Blob)object).length()];
                            inputStream.read(byArray);
                            this.setBytes(n, byArray);
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    } else {
                        this.setBlob(n, (java.sql.Blob)object);
                    }
                } else if (object instanceof byte[]) {
                    this.setBytes(n, (byte[])object);
                } else if (object instanceof Serializable) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        this.setBytes(n, byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                } else {
                    throw ErrorFactory.makeDriverJDBCException("TJ167");
                }
                return;
            }
            case 2004: {
                if (object instanceof java.sql.Blob) {
                    this.setBlob(n, (java.sql.Blob)object);
                } else if (object instanceof byte[]) {
                    this.setBytes(n, (byte[])object);
                } else if (object instanceof Serializable) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        this.setBytes(n, byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                } else {
                    ComUtil.ThrowExcp(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ219"), "setObject", object.getClass().getName()));
                }
                return;
            }
            case 2005: {
                if (object instanceof java.sql.Clob) {
                    this.setClob(n, (java.sql.Clob)object);
                } else if (object instanceof byte[]) {
                    this.setString(n, object.toString());
                } else if (object instanceof Serializable) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        this.setString(n, new String(byteArrayOutputStream.toByteArray()));
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                } else {
                    ComUtil.ThrowExcp(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ220"), "setObject", object.getClass().getName()));
                }
                return;
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ168");
            }
        }
        ComUtil.ThrowExcp(256, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ306"), n2));
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ374");
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof String) {
            this.setString(n, object.toString());
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof java.sql.Blob) {
            this.setBlob(n, (java.sql.Blob)object);
        } else if (object instanceof java.sql.Clob) {
            this.setClob(n, (java.sql.Clob)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else {
            ComUtil.ThrowExcp(257, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ230"), object.getClass().getName()));
        }
    }

    public boolean execute(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public boolean execute(String string, int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public void addBatch() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ170");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            this.setNull(n, 2005);
            return;
        }
        this.stmtParams.verify(n);
        if (n2 < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ171", n2);
        }
        this.stmtParams.setParameter(n, (Object)reader, 421, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ172");
    }

    public void setBlob(int n, java.sql.Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(n, 2004);
            return;
        }
        TDSession tDSession = ((TeraLocalConnection)this.con).getTDSession();
        if (((Blob)blob).isLocatorStale()) {
            ((Blob)blob).refreshLocator(tDSession, 408);
        }
        byte[] byArray = this.getLocatorWithLength(((Blob)blob).getLocator());
        this.stmtParams.setColDataLength(n, 2097088000L);
        this.stmtParams.setParameter(n, (Object)blob, byArray, 409);
    }

    public void setClob(int n, java.sql.Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(n, 2005);
            return;
        }
        TDSession tDSession = ((TeraLocalConnection)this.con).getTDSession();
        if (((Clob)clob).locatorIsStale()) {
            ((Clob)clob).refreshLocator(tDSession, 424);
        }
        byte[] byArray = this.getLocatorWithLength(((Clob)clob).getLocator());
        this.stmtParams.setColDataLength(n, 2097088000L);
        this.stmtParams.setParameter(n, (Object)clob, byArray, 425);
    }

    private byte[] getLocatorWithLength(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 2];
        byArray2[1] = (byte)(n & 0xFF);
        byArray2[0] = (byte)(n >> 8);
        System.arraycopy(byArray, 0, byArray2, 2, n);
        return byArray2;
    }

    public void setArray(int n, Array array) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ174");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ175");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        int n2;
        this.stmtParams.verify(n);
        int n3 = ((TeraLocalConnection)this.con).getTDSession().isStatementInfoRequestSupported() ? (calendar != null ? 769 : 761) : (n2 = 453);
        if (time == null) {
            this.internalSetNull(n, 92, n2, calendar != null);
            return;
        }
        int n4 = 0;
        if (calendar != null) {
            n4 = 6;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(time.getTime());
        int n5 = gregorianCalendar.get(14);
        String string = String.valueOf(n5);
        if (n5 < 10) {
            string = "00" + n5;
        } else if (n5 < 100) {
            string = "0" + n5;
        }
        int n6 = this.conOptions.getURLParams().getTimeNano();
        int n7 = this.getNanoString(n5 * 1000 * 1000, n6).length();
        int n8 = n6 == -1 ? (n7 == 0 ? 0 : n7 + 1) : (n6 == 0 ? 0 : n6 + 1);
        StringBuffer stringBuffer = new StringBuffer(8 + n8 + n4);
        String string2 = time.toString() + "." + string;
        int n9 = string2.length() > stringBuffer.capacity() - n4 ? stringBuffer.capacity() - n4 : string2.length();
        stringBuffer = stringBuffer.append(string2.toCharArray(), 0, n9);
        for (int i = n9; i < stringBuffer.capacity() - n4; ++i) {
            stringBuffer = stringBuffer.append('0');
        }
        if (calendar != null) {
            stringBuffer = stringBuffer.append(TeraPreparedStatement.getTimeZone(calendar));
        }
        byte[] byArray = this.setChar(n, stringBuffer.toString());
        this.stmtParams.setParameter(n, time, byArray, n2, 0, n6 == -1 ? n7 : n6);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n2;
        this.stmtParams.verify(n);
        int n3 = ((TeraLocalConnection)this.con).getTDSession().isStatementInfoRequestSupported() ? (calendar != null ? 773 : 765) : (n2 = 453);
        if (timestamp == null) {
            this.internalSetNull(n, 93, n2, calendar != null);
            return;
        }
        int n4 = timestamp.getNanos();
        String string = timestamp.toString();
        String string2 = string.substring(0, string.lastIndexOf(46) + 1);
        int n5 = this.conOptions.getURLParams().getTimestampNano();
        String string3 = this.getNanoString(n4, n5);
        int n6 = string2.length();
        if (string3.length() > 0) {
            string2 = string2.concat(string3);
        } else if (string2.charAt(n6 - 1) == '.') {
            string2 = string2.substring(0, n6 - 1);
        }
        if (calendar != null) {
            string2 = string2.concat(TeraPreparedStatement.getTimeZone(calendar));
        }
        byte[] byArray = this.setChar(n, string2);
        this.stmtParams.setParameter(n, timestamp, byArray, n2, 0, n5 == -1 ? string3.length() : n5);
    }

    private final String getNanoString(int n, int n2) {
        int n3;
        int n4;
        if (n != 0) {
            n4 = 9 - String.valueOf(n).length();
            if (n4 > 5) {
                n = 0;
                n4 = 0;
            }
        } else {
            n4 = 0;
        }
        String string = String.valueOf(n);
        int n5 = string.length();
        if (n2 != -1) {
            if (n5 + n4 < n2) {
                int n6 = n2 - n5;
                for (n3 = 0; n3 < n6; ++n3) {
                    string = string.concat("0");
                }
            }
            if (n2 < n4) {
                n4 = n2;
            }
            n5 = n2 - n4 - 1;
        } else {
            for (n5 = string.length() - 1; n5 >= 0 && string.charAt(n5) == '0'; --n5) {
            }
        }
        if (n5 + n4 > 5) {
            n5 = 5 - n4;
        }
        string = string.substring(0, n5 + 1);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.insert(0, '0');
        }
        string = stringBuffer.toString();
        return string;
    }

    public static final String getTimeZone(Calendar calendar) {
        int n;
        char c = '+';
        StringBuffer stringBuffer = new StringBuffer(6);
        int n2 = n % 60 * ((n = calendar.getTimeZone().getRawOffset() / 60000) < 0 ? -1 : 1);
        int n3 = n / 60 * (n < 0 ? -1 : 1);
        if (n < 0) {
            c = '-';
        }
        stringBuffer.append(c);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(String.valueOf(n3)).append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(String.valueOf(n2));
        return stringBuffer.toString();
    }

    public String getOriginalSql() {
        return this.stmtParams.getOriginalSql();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        ComUtil.ThrowExcp(254, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraPrepareStatement", "setURL"));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new TeraParameterMetaData(this);
    }

    protected FullContentMetadataItem getParameterMarkerMetaData(int n) throws SQLException {
        if (this.parmArray == null) {
            return null;
        }
        if (n < 1 || n > this.parmArray.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ169", n, this.parmArray.length);
        }
        return this.parmArray[n - 1];
    }

    protected void setParameterMarkerMetaData(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        this.parmArray = new FullContentMetadataItem[n];
        for (int i = 0; i < n; ++i) {
            this.parmArray[i] = (FullContentMetadataItem)arrayList.get(i);
        }
    }

    protected int getNumberOfParameters() {
        return this.parmArray == null ? 0 : this.parmArray.length;
    }

    protected boolean hasParameterMetaData() {
        return this.parmArray != null;
    }
}

