/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Clob;
import com.teradata.jdbc.ComSvcs;
import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.Const;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraStatement;
import com.teradata.jdbc.jdbc_3.Blob;
import com.teradata.jdbc.jdbc_3.LobReader;
import com.teradata.jdbc.jdbc_3.LobStream;
import com.teradata.jdbc.jdbc_3.util.jdbcIntArray;
import com.teradata.jdbc.jdbc_3.util.jdbcVector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;

public class TeraResultSet
implements ResultSet {
    ComSvcs ComObj = null;
    private String SesId = "0";
    private String StmtId = "0";
    private SQLWarning sqlWarning = null;
    public int maxRows = 0;
    public int retRows = 0;
    protected TeraResultSetMetaData RSMD;
    protected Statement tStatement = null;
    protected String sessionJavaCharSet = null;
    protected int ColumnCount = 0;
    protected Vector ColNames;
    protected Vector ColLabel;
    protected Vector ColTypes;
    protected Vector ColFormat;
    protected Vector ColPrec;
    protected Vector ColScale;
    protected Vector ColDispSize;
    protected Vector ColNullable;
    protected jdbcIntArray ColJavaTypes;
    private ArrayList lobList;
    protected jdbcVector CacheData;
    private jdbcVector BinCacheData;
    private jdbcVector RowCache;
    private jdbcIntArray ColumnSize;
    private jdbcIntArray ColumnOffset;
    protected int FetchRows = 1;
    protected int CurRow = 0;
    private int RowsIn = 0;
    private int ColsIn = 0;
    protected int EOFTable = 0;
    private boolean lastColumnNull = false;
    private boolean metadataRS = false;
    protected byte[] rowInfo;
    protected byte[] rowData;
    protected byte[] lobData;
    int FETCH_FORWARD = 1000;
    int FETCH_REVERSE = 1001;
    int FETCH_UNKNOWN = 1002;
    int TYPE_FORWARD_ONLY = 1003;
    int TYPE_SCROLL_INSENSITIVE = 1004;
    int TYPE_SCROLL_SENSITIVE = 1005;
    int CONCUR_READ_ONLY = 1007;
    int CONCUR_UPDATABLE = 1008;

    protected void setCacheData(Vector vector) throws SQLException {
        int n;
        this.CurRow = 0;
        this.RowsIn = new Integer(vector.elementAt(1).toString());
        this.ColsIn = new Integer(vector.elementAt(2).toString());
        if (this.RowsIn > 0) {
            this.EOFTable = 1;
            this.retRows = -1;
        }
        try {
            this.CacheData = new jdbcVector(vector.size());
            for (n = 0; n < vector.size(); ++n) {
                this.CacheData.setElementAt(vector.elementAt(n), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ColumnCount = this.ColsIn;
        this.ColNames.removeAllElements();
        this.ColLabel.removeAllElements();
        for (int i = n = 3; i <= (this.ColumnCount - 1) * 6 + n; i += 6) {
            this.ColNames.addElement(this.CacheData.elementAt(i));
            this.ColLabel.addElement(this.CacheData.elementAt(i + 1));
        }
    }

    protected void setParams(ComSvcs comSvcs, TeraStatement teraStatement, String string, String string2, int n) throws SQLException {
        this.ComObj = comSvcs;
        this.tStatement = teraStatement;
        this.SesId = string;
        this.StmtId = string2;
        this.FetchRows = n;
        this.retRows = this.maxRows > 0 ? this.maxRows : -1;
        if (this.FetchRows > this.maxRows && this.maxRows > 0) {
            this.FetchRows = this.maxRows;
        }
        if (this.FetchRows <= 1) {
            this.FetchRows = 2;
        }
        this.ColsIn = 0;
        this.RowsIn = 0;
        this.EOFTable = 0;
    }

    public void initEmpty() {
        this.ColsIn = 0;
        this.RowsIn = 0;
        this.retRows = 0;
        this.EOFTable = 1;
        this.ColNames = new Vector(0);
        this.ColLabel = new Vector(0);
        this.ColTypes = new Vector(0);
        this.ColFormat = new Vector(0);
        this.ColPrec = new Vector(0);
        this.ColScale = new Vector(0);
        this.ColDispSize = new Vector(0);
        this.ColNullable = new Vector(0);
    }

    public boolean next() throws SQLException {
        if (this.retRows != 0) {
            if (this.retRows > 0) {
                --this.retRows;
            }
            this.sqlWarning = null;
            if (this.RowsIn == 0 && this.EOFTable == 0) {
                long l = System.currentTimeMillis();
                this.CacheData = new jdbcVector();
                if (this.RowCache != null) {
                    this.RowCache.removeAllElements();
                    this.ColumnSize.removeAllElements();
                }
                if (this.CacheData.elementAt(0).toString().compareTo("<OK>      ") == 0) {
                    return this.setRows(1);
                }
                if (this.CacheData.elementAt(0).toString().compareTo("<ERR>     ") != 0) {
                    if (this.sqlWarning == null) {
                        this.sqlWarning = ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString());
                    } else {
                        this.sqlWarning.setNextWarning(ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString()));
                    }
                    return this.setRows(2);
                }
                ComUtil.ThrowExcp(this.CacheData.elementAt(1).toString());
                return false;
            }
            ++this.CurRow;
            if (this.CurRow > this.RowsIn && this.EOFTable == 0) {
                long l = System.currentTimeMillis();
                this.CurRow = 0;
                this.RowsIn = 0;
                if (this.CacheData == null) {
                    ComUtil.ThrowExcp(21, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ189"), "HY000", 621));
                }
                if (this.RowCache != null) {
                    this.RowCache.removeAllElements();
                    this.ColumnSize.removeAllElements();
                }
                if (this.CacheData.elementAt(0).toString().compareTo("<OK>      ") == 0) {
                    return this.setRows(1);
                }
                if (this.CacheData.elementAt(0).toString().compareTo("<ERR>     ") != 0) {
                    if (this.sqlWarning == null) {
                        this.sqlWarning = ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString());
                    } else {
                        this.sqlWarning.setNextWarning(ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString()));
                    }
                    return this.setRows(2);
                }
                ComUtil.ThrowExcp(this.CacheData.elementAt(1).toString());
                return false;
            }
            return this.CurRow <= this.RowsIn || this.EOFTable != 1;
        }
        return false;
    }

    public void setRowCache(byte[] byArray, byte[] byArray2, int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.ColumnCount;
        this.RowsIn = n;
        try {
            n5 = new BigInteger(this.getNum(byArray, 4, n2)).intValue();
        }
        catch (Exception exception) {
            ComUtil.ThrowExcp(43, ErrorMessage.messages.getString("TJ207"));
        }
        n2 += 4;
        int n7 = n6 * this.RowsIn + 5;
        if (this.RowCache == null || this.RowCache.size() == 0) {
            this.ColumnCount = n6;
            this.RowCache = new jdbcVector();
            this.ColumnSize = new jdbcIntArray(n7);
            this.ColumnOffset = new jdbcIntArray(n7);
        }
        try {
            int n8 = 0;
            int n9 = 0;
            while (n8 < n7 - 5) {
                if (n9 >= n6) {
                    n9 = 0;
                }
                int n10 = new BigInteger(this.getNum(byArray, 4, n2)).intValue();
                if (n3 < 0) {
                    n3 = n3 * -1 - 1;
                }
                if (n9 == 0) {
                    n3 += n5;
                }
                if (ComUtil.LobLocType(new Integer(this.ColTypes.elementAt(n9).toString()))) {
                    n10 = new BigInteger(this.getNum(byArray2, 2, n4 + n3)).intValue();
                }
                if (ComUtil.VarType(new Integer(this.ColTypes.elementAt(n9).toString()))) {
                    n3 += 2;
                }
                this.ColumnSize.addElement(n10);
                int n11 = n4 + n3;
                this.ColumnOffset.addElement(n11);
                n4 = n11;
                n3 = n10;
                n2 += 4;
                ++n8;
                ++n9;
            }
            this.RowCache.setElementAt(byArray2, 0);
        }
        catch (Exception exception) {
            ComUtil.ThrowExcp(44, ErrorMessage.messages.getString("TJ208"));
        }
    }

    protected byte[] getNum(byte[] byArray, int n, int n2) throws Exception {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, n);
        return byArray2;
    }

    private void createLob(int n, long l) {
        Blob blob = new Blob();
        blob.setLength(l);
        blob.setColumnNumber(n);
        if (this.lobList == null) {
            this.lobList = new ArrayList();
        }
        this.lobList.add(blob);
    }

    public void setMetadataRS(boolean bl) {
        this.metadataRS = bl;
    }

    protected boolean getMetadataRS() {
        return this.metadataRS;
    }

    public void close() throws SQLException {
        if (this.metadataRS) {
            this.metadataRS = false;
            this.tStatement.close();
        } else {
            this.RowsIn = 0;
            this.ColsIn = 0;
            this.EOFTable = 0;
            if (this.ComObj != null) {
                this.ComObj.setMetaType(0);
            }
            this.ComObj = null;
            this.sqlWarning = null;
            this.RSMD = null;
            if (this.ColNames != null) {
                this.ColNames.removeAllElements();
            }
            if (this.ColTypes != null) {
                this.ColTypes.removeAllElements();
                this.ColTypes = null;
            }
            if (this.ColLabel != null) {
                this.ColLabel.removeAllElements();
                this.ColLabel = null;
            }
            if (this.ColFormat != null) {
                this.ColFormat.removeAllElements();
                this.ColFormat = null;
            }
            if (this.ColPrec != null) {
                this.ColPrec.removeAllElements();
                this.ColPrec = null;
            }
            if (this.ColScale != null) {
                this.ColScale.removeAllElements();
                this.ColScale = null;
            }
            if (this.ColDispSize != null) {
                this.ColDispSize.removeAllElements();
                this.ColDispSize = null;
            }
            if (this.ColNullable != null) {
                this.ColNullable.removeAllElements();
                this.ColNullable = null;
            }
            if (this.CacheData != null) {
                this.CacheData.removeAllElements();
                this.CacheData = null;
            }
            if (this.BinCacheData != null) {
                this.BinCacheData.removeAllElements();
                this.BinCacheData = null;
            }
            if (this.ColJavaTypes != null) {
                this.ColJavaTypes.removeAllElements();
                this.ColJavaTypes = null;
            }
            if (this.RowCache != null) {
                this.RowCache.removeAllElements();
                this.RowCache = null;
            }
            if (this.ColumnSize != null) {
                this.ColumnSize.removeAllElements();
                this.ColumnSize = null;
            }
            if (this.ColumnOffset != null) {
                this.ColumnOffset.removeAllElements();
                this.ColumnOffset = null;
            }
            if (this.lobList != null) {
                this.lobList = null;
            }
        }
    }

    public void close(String string) throws SQLException {
        if (string.compareTo("0") != 0) {
            this.ComObj.ExecCmd(ComUtil.MakePS("<STMT_CLOSE>", this.SesId, string));
        }
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }

    public String getString(int n) throws SQLException {
        return this.getString(this.getObject(n));
    }

    public String getString(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.lang.String") == 0) {
            return object.toString();
        }
        if (string.compareTo("java.lang.Integer") == 0) {
            return ((Integer)object).toString();
        }
        if (string.compareTo("java.lang.Short") == 0) {
            return ((Short)object).toString();
        }
        if (string.compareTo("java.math.BigDecimal") == 0) {
            return ((BigDecimal)object).toString();
        }
        if (string.compareTo("java.lang.Boolean") == 0) {
            return ((Boolean)object).toString();
        }
        if (string.compareTo("java.lang.Float") == 0) {
            return ((Float)object).toString();
        }
        if (string.compareTo("java.lang.Double") == 0) {
            return ((Double)object).toString();
        }
        if (string.compareTo("[B") == 0) {
            String string2 = new String((byte[])object);
            return string2;
        }
        if (string.compareTo("java.sql.Date") == 0) {
            return ((Date)object).toString();
        }
        if (string.compareTo("java.sql.Time") == 0) {
            return ((Time)object).toString();
        }
        if (string.compareTo("java.sql.Timestamp") == 0) {
            return ((Timestamp)object).toString();
        }
        ComUtil.println(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ138"), object.getClass().getName()));
        ComUtil.ThrowExcp(1, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ138"), object.getClass().getName()));
        return "";
    }

    public boolean getBoolean(int n) throws SQLException {
        int n2 = this.getInt(n);
        return n2 != 0;
    }

    public byte getByte(int n) throws SQLException {
        int n2 = this.getInt(n);
        return (byte)n2;
    }

    public short getShort(int n) throws SQLException {
        int n2 = this.getInt(n);
        return (short)n2;
    }

    public int getInt(int n) throws SQLException {
        return this.getInt(this.getObject(n));
    }

    protected int getInt(Object object) throws SQLException {
        if (object == null) {
            return 0;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.lang.Long") == 0) {
            return ((Long)object).intValue();
        }
        if (string.compareTo("java.lang.Integer") == 0) {
            return (Integer)object;
        }
        if (string.compareTo("java.lang.Short") == 0) {
            return ((Short)object).intValue();
        }
        if (string.compareTo("java.lang.String") == 0) {
            try {
                Double d = new Double(((String)object).trim());
                int n = d.intValue();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ100"));
                ComUtil.ThrowExcp(2, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ140"), ((String)object).trim()));
                return 0;
            }
        }
        if (string.compareTo("java.math.BigDecimal") == 0) {
            int n = ((BigDecimal)object).intValue();
            return n;
        }
        if (string.compareTo("java.lang.Boolean") == 0) {
            try {
                Boolean bl = (Boolean)object;
                int n = bl == true ? 1 : 0;
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ023"));
                ComUtil.ThrowExcp(3, ErrorMessage.messages.getString("TJ023"));
                return 0;
            }
        }
        if (string.compareTo("java.lang.Float") == 0) {
            return ((Float)object).intValue();
        }
        if (string.compareTo("java.lang.Double") == 0) {
            return ((Double)object).intValue();
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ101"));
        if (object.getClass().getName().compareTo("[B") == 0) {
            ComUtil.ThrowExcp(4, ErrorMessage.messages.getString("TJ141"));
        } else {
            ComUtil.ThrowExcp(4, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ142"), object.getClass().getName()));
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        return this.getLong(this.getObject(n));
    }

    public long getLong(Object object) throws SQLException {
        if (object == null) {
            return 0L;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.lang.Integer") == 0) {
            return ((Integer)object).longValue();
        }
        if (string.compareTo("java.lang.Long") == 0) {
            return (Long)object;
        }
        if (string.compareTo("java.lang.String") == 0) {
            try {
                Double d = new Double(((String)object).trim());
                long l = d.longValue();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ024"));
                ComUtil.ThrowExcp(5, ErrorMessage.messages.getString("TJ024"));
                return 0L;
            }
        }
        if (string.compareTo("java.math.BigDecimal") == 0) {
            return ((BigDecimal)object).longValue();
        }
        if (string.compareTo("java.lang.Boolean") == 0) {
            try {
                Boolean bl = new Boolean((String)object);
                long l = bl == true ? 1L : 0L;
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ024"));
                ComUtil.ThrowExcp(6, ErrorMessage.messages.getString("TJ024"));
                return 0L;
            }
        }
        if (string.compareTo("java.lang.Float") == 0) {
            return ((Float)object).longValue();
        }
        if (string.compareTo("java.lang.Double") == 0) {
            return ((Double)object).longValue();
        }
        if (string.compareTo("java.lang.Short") == 0) {
            return ((Short)object).longValue();
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ025"));
        ComUtil.ThrowExcp(7, ErrorMessage.messages.getString("TJ025"));
        return 0L;
    }

    public float getFloat(int n) throws SQLException {
        return this.getFloat(this.getObject(n));
    }

    public float getFloat(Object object) throws SQLException {
        if (object == null) {
            return 0.0f;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.lang.Float") == 0) {
            return ((Float)object).floatValue();
        }
        if (string.compareTo("java.lang.Double") == 0) {
            return ((Double)object).floatValue();
        }
        if (string.compareTo("java.lang.String") == 0) {
            try {
                Float f = new Float(((String)object).trim());
                float f2 = f.floatValue();
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ026"));
                ComUtil.ThrowExcp(8, ErrorMessage.messages.getString("TJ026"));
                return 0.0f;
            }
        }
        if (string.compareTo("java.math.BigDecimal") == 0) {
            return ((BigDecimal)object).floatValue();
        }
        if (string.compareTo("java.lang.Boolean") == 0) {
            try {
                Boolean bl = new Boolean((String)object);
                float f = bl == true ? 1.0f : 0.0f;
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ026"));
                ComUtil.ThrowExcp(9, ErrorMessage.messages.getString("TJ026"));
                return 0.0f;
            }
        }
        if (string.compareTo("java.lang.Integer") == 0) {
            return ((Integer)object).floatValue();
        }
        if (string.compareTo("java.lang.Long") == 0) {
            return ((Long)object).floatValue();
        }
        if (string.compareTo("java.lang.Short") == 0) {
            return ((Short)object).floatValue();
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ027"));
        ComUtil.ThrowExcp(10, ErrorMessage.messages.getString("TJ027"));
        return 0.0f;
    }

    public double getDouble(int n) throws SQLException {
        return this.getDouble(this.getObject(n));
    }

    public double getDouble(Object object) throws SQLException {
        if (object == null) {
            return 0.0;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.math.BigDecimal") == 0) {
            return ((BigDecimal)object).doubleValue();
        }
        if (string.compareTo("java.lang.Double") == 0) {
            return (Double)object;
        }
        if (string.compareTo("java.lang.Float") == 0) {
            return ((Float)object).doubleValue();
        }
        if (string.compareTo("java.lang.String") == 0) {
            try {
                Double d = new Double(((String)object).trim());
                double d2 = d;
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ028"));
                ComUtil.ThrowExcp(11, ErrorMessage.messages.getString("TJ028"));
                return 0.0;
            }
        }
        if (string.compareTo("java.lang.Boolean") == 0) {
            try {
                Boolean bl = new Boolean((String)object);
                double d = bl == true ? 1.0 : 0.0;
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ028"));
                ComUtil.ThrowExcp(12, ErrorMessage.messages.getString("TJ028"));
                return 0.0;
            }
        }
        if (string.compareTo("java.lang.Long") == 0) {
            return ((Long)object).doubleValue();
        }
        if (string.compareTo("java.lang.Integer") == 0) {
            return ((Integer)object).doubleValue();
        }
        if (string.compareTo("java.lang.Short") == 0) {
            return ((Short)object).doubleValue();
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ029"));
        ComUtil.ThrowExcp(13, ErrorMessage.messages.getString("TJ029"));
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(this.getObject(n), n2);
    }

    public BigDecimal getBigDecimal(Object object, int n) throws SQLException {
        BigDecimal bigDecimal = null;
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        try {
            if (string.compareTo("java.math.BigDecimal") == 0) {
                bigDecimal = (BigDecimal)object;
            } else if (string.compareTo("java.lang.Float") == 0) {
                bigDecimal = new BigDecimal(((Float)object).doubleValue());
            } else if (string.compareTo("java.lang.Double") == 0) {
                bigDecimal = new BigDecimal((Double)object);
            } else if (string.compareTo("java.lang.String") == 0) {
                bigDecimal = new BigDecimal(((String)object).trim());
            } else if (string.compareTo("java.lang.Integer") == 0) {
                bigDecimal = new BigDecimal((double)((Integer)object).intValue());
            } else if (string.compareTo("java.lang.Long") == 0) {
                bigDecimal = new BigDecimal(((Long)object).toString());
            } else if (string.compareTo("java.lang.Short") == 0) {
                bigDecimal = new BigDecimal((double)((Short)object).intValue());
            } else if (string.compareTo("java.lang.Boolean") == 0) {
                try {
                    Boolean bl = new Boolean((String)object);
                    bigDecimal = bl.booleanValue() ? new BigDecimal("1") : new BigDecimal("0");
                }
                catch (NumberFormatException numberFormatException) {
                    ComUtil.println(ErrorMessage.messages.getString("TJ030"));
                    ComUtil.ThrowExcp(14, ErrorMessage.messages.getString("TJ030"));
                    return null;
                }
            }
            if (bigDecimal != null) {
                if (n > 0) {
                    return bigDecimal.setScale(n);
                }
                return bigDecimal;
            }
            ComUtil.println(ErrorMessage.messages.getString("TJ031"));
            ComUtil.ThrowExcp(15, ErrorMessage.messages.getString("TJ031"));
        }
        catch (Exception exception) {
            ComUtil.println(ErrorMessage.messages.getString("TJ031"));
            ComUtil.ThrowExcp(15, ErrorMessage.messages.getString("TJ031"));
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getBytes(this.getObject(n));
    }

    public byte[] getBytes(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object.getClass().getName().compareTo("[B") == 0) {
            return (byte[])object;
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ032"));
        ComUtil.ThrowExcp(16, ErrorMessage.messages.getString("TJ032"));
        return null;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(this.getObject(n));
    }

    public Date getDate(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.sql.Date") == 0) {
            return (Date)object;
        }
        if (string.compareTo("java.lang.Integer") == 0 || string.compareTo("java.sql.Timestamp") == 0) {
            object = object.toString();
            string = object.getClass().getName();
        }
        if (string.compareTo("java.lang.String") == 0) {
            String string2 = ((String)object).toString().trim();
            if (string2.length() == 0) {
                return null;
            }
            if (string2.length() < 6) {
                ComUtil.println(ErrorMessage.messages.getString("TJ033"));
                ComUtil.ThrowExcp(16, ErrorMessage.messages.getString("TJ033"));
                return null;
            }
            try {
                int n;
                if (string2.length() == 6 || string2.length() == 7) {
                    Vector vector = ComUtil.ConvDate(string2);
                    if (vector == null) {
                        ComUtil.println(ErrorMessage.messages.getString("TJ034"));
                        ComUtil.ThrowExcp(27, ErrorMessage.messages.getString("TJ034"));
                        return null;
                    }
                    string2 = vector.elementAt(1) + "/" + vector.elementAt(2) + "/" + vector.elementAt(0);
                    Date date = new Date((Integer)vector.elementAt(0) - 1900, (Integer)vector.elementAt(1) - 1, (Integer)vector.elementAt(2));
                    return date;
                }
                for (n = 0; n < string2.length() && string2.charAt(n) <= '9' && string2.charAt(n) >= '0'; ++n) {
                }
                if (n != 2 && n != 4 || string2.charAt(n) == ':') {
                    ComUtil.println(ErrorMessage.messages.getString("TJ035"));
                    ComUtil.ThrowExcp(17, ErrorMessage.messages.getString("TJ035"));
                    return null;
                }
                Date date = new Date(Integer.parseInt(string2.substring(0, n)) - (n == 4 ? 1900 : 0), Integer.parseInt(string2.substring(n + 1, n + 3)) - 1, Integer.parseInt(string2.substring(n + 4, n + 6)));
                return date;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ035"));
                ComUtil.ThrowExcp(18, ErrorMessage.messages.getString("TJ035"));
                return null;
            }
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ035"));
        ComUtil.ThrowExcp(19, ErrorMessage.messages.getString("TJ035"));
        return null;
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, (Calendar)null);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(this.getString(n));
        return stringBufferInputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = null;
        String string = this.getString(n);
        try {
            byte[] byArray = string.getBytes(this.sessionJavaCharSet);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(46, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), this.sessionJavaCharSet));
            return null;
        }
        return byteArrayInputStream;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getBinaryStream(this.getObject(n));
    }

    public InputStream getBinaryStream(Object object) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            if (object == null) {
                byte[] byArray = "".getBytes(this.sessionJavaCharSet);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            } else if (object.getClass().getName().compareTo("[B") == 0) {
                byte[] byArray = (byte[])object;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            } else {
                String string = this.getString(object);
                byte[] byArray = string.getBytes(this.sessionJavaCharSet);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(46, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), this.sessionJavaCharSet));
            return null;
        }
        return byteArrayInputStream;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), (Calendar)null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), (Calendar)null);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    private void addWarning(String string) throws SQLException {
        String string2;
        int n;
        String string3;
        if (string.length() >= 5) {
            string3 = string.substring(0, 5);
            String string4 = string.substring(5);
            string4.trim();
            int n2 = string4.indexOf(" ");
            if (n2 == -1) {
                n = 600;
                string2 = string;
            } else {
                string4 = string4.substring(0, n2);
                string4.trim();
                try {
                    n = Integer.parseInt(string4);
                    string2 = string4.substring(0, n2);
                    string2.trim();
                }
                catch (Exception exception) {
                    string2 = string4;
                    string2.trim();
                    n = 600;
                }
            }
        } else {
            string2 = string;
            string3 = "HY000";
            n = 600;
        }
        if (this.sqlWarning == null) {
            this.sqlWarning = new SQLWarning(string2, string3, n);
        } else {
            this.sqlWarning.setNextWarning(new SQLWarning(string2, string3, n));
        }
    }

    private void addWarning(int n, String string) throws SQLException {
        if (this.sqlWarning == null) {
            this.sqlWarning = ComUtil.ParseWarnings("HY000 600" + n + " : " + string);
        } else {
            this.sqlWarning.setNextWarning(ComUtil.ParseWarnings("HY000 600" + n + " : " + string));
        }
    }

    public String getCursorName() throws SQLException {
        ComUtil.println(ErrorMessage.messages.getString("TJ038"));
        ComUtil.ThrowExcp(21, ErrorMessage.messages.getString("TJ038"));
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.RSMD;
    }

    public void setColDispSize(int n, Object object) {
        if (this.ColDispSize == null) {
            this.ColDispSize = new Vector(20);
        }
        this.ColDispSize.addElement(object);
    }

    public void setColNullable(int n, Object object) {
        if (this.ColNullable == null) {
            this.ColNullable = new Vector(20);
        }
        this.ColNullable.addElement(object);
    }

    protected final boolean setRows(int n) throws SQLException {
        int n2 = 0;
        if (n == 1) {
            this.EOFTable = 0;
            n2 = new Integer(this.CacheData.elementAt(this.CacheData.size() - 1).toString());
        } else if (n == 2) {
            this.EOFTable = 1;
            n2 = new Integer(this.CacheData.elementAt(this.CacheData.size() - 2).toString());
            if (this.sqlWarning == null) {
                this.sqlWarning = ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString());
            } else {
                this.sqlWarning.setNextWarning(ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString()));
            }
            this.ComObj.setMetaType(0);
        }
        if (n == 1 || n == 2) {
            if (n2 == 1) {
                this.EOFTable = 1;
            }
        } else {
            this.RowsIn = 0;
            this.ColsIn = 0;
            this.CurRow = 0;
            ComUtil.println(ErrorMessage.messages.getString("TJ106"));
            ComUtil.ThrowExcp(33, ErrorMessage.messages.getString("TJ048"));
            return false;
        }
        this.RowsIn = new Integer(this.CacheData.elementAt(1).toString());
        this.setRowCache(this.rowInfo, this.rowData, this.RowsIn);
        this.CurRow = 1;
        return this.RowsIn != 0;
    }

    public Object getObject(int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object var12_5 = null;
        if (this.ColumnCount == 0 || this.ColumnOffset == null || this.ColumnSize == null || this.RowCache == null) {
            ComUtil.ThrowExcp(45, ErrorMessage.messages.getString("TJ209"));
        }
        if (this.RSMD == null) {
            this.RSMD = (TeraResultSetMetaData)this.getMetaData();
        }
        int n5 = this.RSMD.getColumnType(n);
        n2 = this.ColumnCount * (this.CurRow - 1) + n - 1;
        n3 = this.ColumnOffset.elementAt(n2);
        n4 = this.ColumnSize.elementAt(n2);
        if (n4 < 0) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        switch (n5) {
            case -1: 
            case 1: 
            case 12: {
                if (n4 == 0) {
                    return "";
                }
                try {
                    return new String((byte[])this.RowCache.elementAt(0), n3, n4, this.sessionJavaCharSet);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ComUtil.ThrowExcp(46, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), this.sessionJavaCharSet));
                    return null;
                }
            }
            case -6: 
            case 4: 
            case 5: {
                try {
                    byte[] byArray = this.getNum((byte[])this.RowCache.elementAt(0), n4, n3);
                    Integer n6 = new Integer(new BigInteger(byArray).intValue());
                    return n6;
                }
                catch (Exception exception) {
                    ComUtil.println(ErrorMessage.messages.getString("TJ108"));
                    ComUtil.ThrowExcp(35, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
            }
            case -4: 
            case -3: 
            case -2: {
                if (n4 == 0) {
                    return new byte[0];
                }
                byte[] byArray = this.copyParam((byte[])this.RowCache.elementAt(0), n4, n3);
                return byArray;
            }
            case 6: {
                try {
                    byte[] byArray = this.getNum((byte[])this.RowCache.elementAt(0), n4, n3);
                    return new Double(Double.longBitsToDouble(new BigInteger(byArray).longValue()));
                }
                catch (Exception exception) {
                    ComUtil.println(ErrorMessage.messages.getString("TJ109"));
                    ComUtil.ThrowExcp(36, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
            }
            case 3: {
                int n7;
                try {
                    n7 = new Integer(this.ColScale.elementAt(n - 1).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    ComUtil.println(ErrorMessage.messages.getString("TJ110"));
                    ComUtil.ThrowExcp(37, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
                try {
                    int n8 = new Integer(this.ColPrec.elementAt(n - 1).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    ComUtil.println(ErrorMessage.messages.getString("TJ111"));
                    ComUtil.ThrowExcp(38, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
                try {
                    byte[] byArray = this.getNum((byte[])this.RowCache.elementAt(0), n4, n3);
                    BigInteger bigInteger = new BigInteger(byArray);
                    return new BigDecimal(bigInteger).movePointLeft(n7).setScale(n7);
                }
                catch (Exception exception) {
                    if (this.CacheData.elementAt(Const.RsGetCol_data).toString().length() == 0) {
                        return null;
                    }
                    ComUtil.println(ErrorMessage.messages.getString("TJ112"));
                    ComUtil.ThrowExcp(39, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
            }
            case 91: {
                try {
                    byte[] byArray = this.getNum((byte[])this.RowCache.elementAt(0), n4, n3);
                    Vector vector = ComUtil.ConvDate(new BigInteger(byArray).intValue());
                    if (vector == null) {
                        ComUtil.println(ErrorMessage.messages.getString("TJ045"));
                        ComUtil.ThrowExcp(27, ErrorMessage.messages.getString("TJ045"));
                        return null;
                    }
                    String string = vector.elementAt(1) + "/" + vector.elementAt(2) + "/" + vector.elementAt(0);
                    ComUtil.println("GetObject, Date field: here is the date field=" + string);
                    Date date = new Date((Integer)vector.elementAt(0) - 1900, (Integer)vector.elementAt(1) - 1, (Integer)vector.elementAt(2));
                    return date;
                }
                catch (Exception exception) {
                    ComUtil.println(ErrorMessage.messages.getString("TJ046"));
                    ComUtil.ThrowExcp(41, ErrorMessage.messages.getString("TJ046"));
                    return null;
                }
            }
            case 92: {
                String string = new String((byte[])this.RowCache.elementAt(0), n3, n4);
                return this.getTime((Object)string, null);
            }
            case 93: {
                String string = new String((byte[])this.RowCache.elementAt(0), n3, n4);
                return this.getTimestamp((Object)string, null);
            }
            case 2004: {
                if (n4 == 0) {
                    this.lastColumnNull = true;
                    return null;
                }
                Blob blob = new Blob();
                try {
                    byte[] byArray = this.copyParam((byte[])this.RowCache.elementAt(0), n4, n3);
                    blob.setLocator(byArray);
                    blob.setResultSet(this);
                    blob.setLength(new BigInteger(this.getNum(byArray, 8, 0)).longValue());
                    blob.setColumnNumber(n);
                    com.teradata.jdbc.Blob blob2 = new com.teradata.jdbc.Blob(blob);
                    return blob2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ComUtil.println(ErrorMessage.messages.getString("TJ108"));
                    ComUtil.ThrowExcp(35, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
            }
            case 2005: {
                if (n4 == 0) {
                    this.lastColumnNull = true;
                    return null;
                }
                com.teradata.jdbc.jdbc_3.Clob clob = new com.teradata.jdbc.jdbc_3.Clob();
                try {
                    byte[] byArray = this.copyParam((byte[])this.RowCache.elementAt(0), n4, n3);
                    clob.setLocator(byArray);
                    clob.setResultSet(this);
                    clob.setLength(new BigInteger(this.getNum(byArray, 8, 0)).longValue());
                    clob.setColumnNumber(n);
                    Clob clob2 = new Clob(clob);
                    return clob2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ComUtil.println(ErrorMessage.messages.getString("TJ108"));
                    ComUtil.ThrowExcp(35, ErrorMessage.messages.getString("TJ047"));
                    return null;
                }
            }
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ113"));
        ComUtil.ThrowExcp(42, ErrorMessage.messages.getString("TJ113"));
        return null;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public byte[] getBlobData(Object object, byte[] byArray, String string, String string2) throws SQLException {
        return this.getBlobData(object, byArray, string, string2, -1L, -1);
    }

    public byte[] getBlobData(Object object, byte[] byArray, String string, String string2, long l, int n) throws SQLException {
        if (this.CacheData.elementAt(0).toString().compareTo("<OK>      ") == 0) {
            if (string.compareTo("0") == 0 && object != null) {
                if (object.getClass().getName().compareTo("com.teradata.jdbc.jdbc_3.ClobStream") == 0 || object.getClass().getName().compareTo("com.teradata.jdbc.jdbc_3.LobStream") == 0) {
                    ((LobStream)object).setStmtId(this.CacheData.elementAt(1).toString());
                } else {
                    ((LobReader)object).setStmtId(this.CacheData.elementAt(1).toString());
                }
            } else if (object == null) {
                this.close(this.CacheData.elementAt(1).toString());
            }
        } else if (this.CacheData.elementAt(0).toString().compareTo("<ERR>     ") == 0) {
            ComUtil.ThrowExcp(this.CacheData.elementAt(1).toString());
        } else if (this.sqlWarning == null) {
            this.sqlWarning = ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString());
        } else {
            this.sqlWarning.setNextWarning(ComUtil.ParseWarnings(this.CacheData.elementAt(this.CacheData.size() - 1).toString()));
        }
        return this.lobData;
    }

    protected byte[] copyParam(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, n);
        return byArray2;
    }

    public int findColumn(String string) throws SQLException {
        String string2;
        int n;
        for (n = 0; n < this.ColNames.size(); ++n) {
            string2 = (String)this.ColNames.get(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            return n + 1;
        }
        for (n = 0; n < this.ColLabel.size(); ++n) {
            string2 = (String)this.ColLabel.get(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            return n + 1;
        }
        ComUtil.println(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ049"), string));
        ComUtil.ThrowExcp(40, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ049"), string));
        return 0;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        StringReader stringReader = new StringReader(this.getString(n));
        return stringReader;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public void beforeFirst() throws SQLException {
    }

    public void afterLast() throws SQLException {
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public int getRow() throws SQLException {
        return 0;
    }

    public boolean absolute(int n) throws SQLException {
        return false;
    }

    public boolean relative(int n) throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getType() throws SQLException {
        return 0;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int n) throws SQLException {
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        ComUtil.ThrowExcp(58, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ503"), "Boolean"));
    }

    public void updateByte(int n, byte by) throws SQLException {
    }

    public void updateShort(int n, short s) throws SQLException {
    }

    public void updateInt(int n, int n2) throws SQLException {
    }

    public void updateLong(int n, long l) throws SQLException {
    }

    public void updateFloat(int n, float f) throws SQLException {
    }

    public void updateDouble(int n, double d) throws SQLException {
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
    }

    public void updateString(int n, String string) throws SQLException {
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
    }

    public void updateDate(int n, Date date) throws SQLException {
    }

    public void updateTime(int n, Time time) throws SQLException {
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
    }

    public void updateObject(int n, Object object) throws SQLException {
    }

    public void updateNull(String string) throws SQLException {
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        ComUtil.ThrowExcp(59, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ503"), "Boolean"));
    }

    public void updateByte(String string, byte by) throws SQLException {
    }

    public void updateShort(String string, short s) throws SQLException {
    }

    public void updateInt(String string, int n) throws SQLException {
    }

    public void updateLong(String string, long l) throws SQLException {
    }

    public void updateFloat(String string, float f) throws SQLException {
    }

    public void updateDouble(String string, double d) throws SQLException {
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
    }

    public void updateString(String string, String string2) throws SQLException {
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
    }

    public void updateDate(String string, Date date) throws SQLException {
    }

    public void updateTime(String string, Time time) throws SQLException {
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
    }

    public void updateObject(String string, Object object) throws SQLException {
    }

    public void insertRow() throws SQLException {
    }

    public void updateRow() throws SQLException {
    }

    public void deleteRow() throws SQLException {
    }

    public void refreshRow() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return this.tStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        return null;
    }

    public java.sql.Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object.getClass().getName().compareTo("com.teradata.jdbc.Blob") == 0) {
            return (java.sql.Blob)this.getObject(n);
        }
        ComUtil.ThrowExcp(47, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ220"), "getBlob", object.getClass().getName()));
        return null;
    }

    public java.sql.Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object.getClass().getName().compareTo("com.teradata.jdbc.Clob") == 0) {
            return (java.sql.Clob)this.getObject(n);
        }
        ComUtil.ThrowExcp(47, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ221"), "getClob", object.getClass().getName()));
        return null;
    }

    public Array getArray(int n) throws SQLException {
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return null;
    }

    public java.sql.Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public java.sql.Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(this.getObject(n), calendar);
    }

    public Time getTime(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.sql.Time") == 0) {
            return (Time)object;
        }
        if (string.compareTo("java.sql.Timestamp") == 0) {
            object = object.toString();
            string = object.getClass().getName();
        }
        if (string.compareTo("java.lang.String") == 0) {
            int n;
            int n2;
            String string2 = ((String)object).toString().trim();
            int n3 = string2.length();
            if (n3 == 0) {
                return null;
            }
            if (n3 < 8) {
                ComUtil.println(ErrorMessage.messages.getString("TJ036"));
                ComUtil.ThrowExcp(17, ErrorMessage.messages.getString("TJ036"));
                return null;
            }
            char c = string2.charAt(n3 - 6);
            if (c == '+' || c == '-') {
                if (calendar != null) {
                    int n4 = n3 - 5;
                    n2 = Integer.parseInt(string2.substring(n4, n4 + 2));
                    n = Integer.parseInt(string2.substring(n4 + 3, n4 + 5));
                    int n5 = (n2 * 60 + n) * 60000;
                    n5 = c == '+' ? n5 : n5 * -1;
                    TimeZone timeZone = TimeZone.getDefault();
                    timeZone.setRawOffset(n5);
                    calendar.setTimeZone(timeZone);
                }
                string2 = string2.substring(0, n3 - 6);
                n3 = string2.length();
            }
            if (n3 >= 19) {
                string2 = string2.substring(11);
                n3 = string2.length();
            }
            try {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                n2 = 0;
                n = string2.indexOf(46);
                if (n < 0) {
                    gregorianCalendar.setTimeInMillis(Time.valueOf(string2).getTime());
                } else {
                    String string3;
                    string3 = string3.substring(0, (string3 = string2.substring(n + 1)).length() > 3 ? 3 : string3.length());
                    n2 = Integer.parseInt(string3);
                    switch (string3.length()) {
                        case 1: {
                            n2 *= 100;
                            break;
                        }
                        case 2: {
                            n2 *= 10;
                        }
                    }
                    gregorianCalendar.setTimeInMillis(Time.valueOf(string2.substring(0, n)).getTime());
                }
                gregorianCalendar.set(14, n2);
                Time time = new Time(gregorianCalendar.getTimeInMillis());
                if (calendar != null) {
                    calendar.setTime(time);
                }
                return time;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ036"));
                ComUtil.ThrowExcp(18, ErrorMessage.messages.getString("TJ036"));
                return null;
            }
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ036"));
        ComUtil.ThrowExcp(18, ErrorMessage.messages.getString("TJ036"));
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getObject(n), calendar);
    }

    public Timestamp getTimestamp(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (string.compareTo("java.sql.Timestamp") == 0) {
            return (Timestamp)object;
        }
        if (string.compareTo("java.lang.String") == 0) {
            int n;
            int n2;
            int n3;
            int n4;
            String string2 = ((String)object).toString().trim();
            int n5 = string2.length();
            if (n5 == 0) {
                return null;
            }
            if (n5 < 19 || n5 > 32) {
                ComUtil.println(ErrorMessage.messages.getString("TJ037"));
                ComUtil.ThrowExcp(17, ErrorMessage.messages.getString("TJ037"));
                return null;
            }
            char c = string2.charAt(n5 - 6);
            if (c == '+' || c == '-') {
                if (calendar != null) {
                    n4 = n5 - 5;
                    n3 = Integer.parseInt(string2.substring(n4, n4 + 2));
                    n2 = Integer.parseInt(string2.substring(n4 + 3, n4 + 5));
                    n = (n3 * 60 + n2) * 60000;
                    n = c == '+' ? n : n * -1;
                    TimeZone timeZone = TimeZone.getDefault();
                    timeZone.setRawOffset(n);
                    calendar.setTimeZone(timeZone);
                }
                string2 = string2.substring(0, n5 - 6);
                n5 = string2.length();
            }
            n4 = 0;
            if (n5 > 19) {
                int n6 = 29 - string2.length();
                int n7 = 10;
                for (n3 = 1; n3 < n6; ++n3) {
                    n7 *= 10;
                }
                n4 = Integer.parseInt(string2.substring(20)) * n7;
            }
            try {
                n3 = Integer.parseInt(string2.substring(0, 4)) - 1900;
                n2 = Integer.parseInt(string2.substring(5, 7)) - 1;
                n = Integer.parseInt(string2.substring(8, 10));
                int n8 = Integer.parseInt(string2.substring(11, 13));
                int n9 = Integer.parseInt(string2.substring(14, 16));
                int n10 = Integer.parseInt(string2.substring(17, 19));
                Timestamp timestamp = new Timestamp(n3, n2, n, n8, n9, n10, n4);
                if (calendar != null) {
                    calendar.setTime(new java.util.Date(n3, n2, n, n8, n9, n10));
                }
                return timestamp;
            }
            catch (NumberFormatException numberFormatException) {
                ComUtil.println(ErrorMessage.messages.getString("TJ037"));
                ComUtil.ThrowExcp(20, ErrorMessage.messages.getString("TJ037"));
                return null;
            }
        }
        ComUtil.println(ErrorMessage.messages.getString("TJ037"));
        ComUtil.ThrowExcp(18, ErrorMessage.messages.getString("TJ037"));
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        ComUtil.ThrowExcp(48, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraResultSet", "getURL"));
        return null;
    }

    public URL getURL(String string) throws SQLException {
        ComUtil.ThrowExcp(49, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraResultSet", "getURL"));
        return null;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        ComUtil.ThrowExcp(50, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ503"), "Ref"));
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        ComUtil.ThrowExcp(51, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ503"), "Ref"));
    }

    public void updateBlob(int n, java.sql.Blob blob) throws SQLException {
        ComUtil.ThrowExcp(52, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraResultSet", "updateBlob"));
    }

    public void updateBlob(String string, java.sql.Blob blob) throws SQLException {
        ComUtil.ThrowExcp(53, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraResultSet", "updateBlob"));
    }

    public void updateClob(int n, java.sql.Clob clob) throws SQLException {
        ComUtil.ThrowExcp(54, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraResultSet", "updateClob"));
    }

    public void updateClob(String string, java.sql.Clob clob) throws SQLException {
        ComUtil.ThrowExcp(55, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ215"), "TeraResultSet", "updateClob"));
    }

    public void updateArray(int n, Array array) throws SQLException {
        ComUtil.ThrowExcp(56, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ503"), "Array"));
    }

    public void updateArray(String string, Array array) throws SQLException {
        ComUtil.ThrowExcp(57, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ503"), "Array"));
    }
}

