/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;

public class TeraResultSetMetaData
implements ResultSetMetaData {
    private TDSession session;
    private PrepInfoParcel prepInfoParcel;
    private int activityType;
    private ArrayList columnProperties = new ArrayList();
    public static final String TERA_DATA_TYPE = "TeraDataType";
    public static final String MAX_DATA_LENGTH_IN_BYTES = "MaxDataLengthInBytes";
    public static final String PRECISION = "Precision";
    public static final String SCALE = "Scale";

    public TeraResultSetMetaData(TDSession tDSession) {
        this.session = tDSession;
    }

    public void addColumnProperties(ColumnProperties columnProperties) {
        this.columnProperties.add(columnProperties);
    }

    public ColumnProperties getColumnProperties(int n) throws JDBCException {
        if (n < 1 || n > this.columnProperties.size()) {
            throw ErrorFactory.makeDriverJDBCException("TJ127", Integer.toString(n));
        }
        return (ColumnProperties)this.columnProperties.get(n - 1);
    }

    public PrepInfoParcel getPrepInfoParcel() {
        return this.prepInfoParcel;
    }

    public int getActivityType() {
        return this.activityType;
    }

    public void setPrepInfoParcel(PrepInfoParcel prepInfoParcel) {
        this.prepInfoParcel = prepInfoParcel;
    }

    public void setActivityType(int n) {
        this.activityType = n;
    }

    public int getColumnCount() {
        return this.columnProperties.size();
    }

    private boolean shouldUseColumnProperties() {
        return this.session == null || this.session.isStatementInfoSupported() && (this.session.getCompatDBS() == 0 || this.session.getCompatDBS() == 1);
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isAutoIncrement();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsAutoInc() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISAUTOINC");
        }
        return this.session.getCompatIsAutoInc() == 1;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        byte by = this.getColumnProperties(n).getColumnExtInfo();
        byte by2 = (byte)(by & 1);
        return by2 == 1;
    }

    public boolean isSearchable(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isSearchable();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsSearch() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISSEARCH");
        }
        return this.session.getCompatIsSearch() == 1;
    }

    public boolean isCurrency(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isCurrency();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsCurrency() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISCURRENCY");
        }
        return this.session.getCompatIsCurrency() == 1;
    }

    public int isNullable(int n) throws SQLException {
        return this.getColumnProperties(n).getNullable();
    }

    public boolean isSigned(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isSigned();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsSigned() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISSIGNED");
        }
        return this.session.getCompatIsSigned() == 1;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnDisplaySize();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnLabel();
    }

    public String getColumnName(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnName();
    }

    public String getSchemaName(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.getSchemaName();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatGetSchema() == null || this.session.getCompatGetSchema().equalsIgnoreCase("NO_DEF_SCHEMA")) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_GETSCHEMA");
        }
        return this.session.getCompatGetSchema();
    }

    public int getPrecision(int n) throws SQLException {
        return this.getColumnProperties(n).getPrecision();
    }

    public int getScale(int n) throws SQLException {
        return this.getColumnProperties(n).getScale();
    }

    public String getTableName(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.getTableName();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatGetTable() == null || this.session.getCompatGetTable().equalsIgnoreCase("NO_DEF_TABLE")) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_GETTABLE");
        }
        return this.session.getCompatGetTable();
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws JDBCException {
        return this.getColumnProperties(n).getColumnType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (this.session != null && this.session.getURLParameters().isTypeNameMetadata()) {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            treeMap.put(TERA_DATA_TYPE, new Integer(this.getColumnProperties(n).getTdType()));
            treeMap.put(MAX_DATA_LENGTH_IN_BYTES, new Integer(this.getColumnProperties(n).getMaxDataLengthInBytes()));
            treeMap.put(PRECISION, new Integer(this.getPrecision(n)));
            treeMap.put(SCALE, new Integer(this.getScale(n)));
            return treeMap.toString();
        }
        return this.getColumnProperties(n).getColumnTypeName();
    }

    public boolean isReadOnly(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isReadOnly();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsReadOnly() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISREADONLY");
        }
        return this.session.getCompatIsReadOnly() == 1;
    }

    public boolean isWritable(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isWritable();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsWritable() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISWRITABLE");
        }
        return this.session.getCompatIsWritable() == 1;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isDefinitelyWritable();
        }
        if (this.session.getCompatDBS() == 0 || this.session.getCompatIsDefWrit() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISDEFWRIT");
        }
        return this.session.getCompatIsDefWrit() == 1;
    }

    public String getColumnClassName(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnClassName();
    }
}

