/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ComSvcs;
import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraConnection;
import com.teradata.jdbc.TeraResultSet;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.LocalStatementParameters;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_3.util.jdbcVector;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class TeraStatement
implements java.sql.Statement {
    protected TeraResultSet RS = null;
    protected TeraConnection con;
    public static final int SPL = 3;
    public static final int NOSPL = 4;
    private jdbcVector batchVect = new jdbcVector(50);
    private int batchLength;
    private static final int batchVectSize = 50;
    protected boolean createProcedure = false;
    private long maxBatchSize;
    protected ConnectionOptions conOptions;
    protected LocalStatementParameters stmtParams;

    public TeraStatement(TeraConnection teraConnection, ComSvcs comSvcs, String string, ConnectionOptions connectionOptions) {
        this.con = teraConnection;
        this.conOptions = connectionOptions;
        if (this.RS == null) {
            this.RS = new TeraResultSet();
        }
        this.RS.maxRows = 0;
        this.batchLength = 0;
        this.maxBatchSize = 1048076L;
    }

    protected final void cleanUp() throws SQLException {
        if (this.RS != null) {
            this.RS.close();
        }
        this.batchLength = 0;
        this.clearBatch();
        this.createProcedure = false;
    }

    public void setCursorName(String string) throws SQLException {
    }

    protected String parseCreateProcedure(String string) throws SQLException {
        int n = "REPLACE".length();
        if ((string.trim().regionMatches(true, 0, "CREATE", 0, "CREATE".length()) || string.trim().regionMatches(true, 0, "REPLACE", 0, "REPLACE".length())) && string.substring(n).trim().regionMatches(true, 0, "PROCEDURE", 0, "PROCEDURE".length())) {
            this.createProcedure = true;
            n = string.indexOf("PROCEDURE");
            if (n < 0) {
                n = string.indexOf("procedure");
            }
            n += "PROCEDURE".length() + 1;
            if (string.substring(n += TeraStatement.endOfWordIndex(string.substring(n))).trim().regionMatches(true, 0, "FROM", 0, "FROM".length())) {
                n += string.substring(n).indexOf(61) + 1;
                string = this.readSPL(string.substring(n).trim());
                string = string.trim();
            }
        } else {
            this.createProcedure = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readSPL(String string) throws SQLException {
        String string2;
        Reader reader = null;
        int n = string.indexOf("WITH");
        char[] cArray = new char[]{};
        if (n < 0) {
            n = string.indexOf("with");
        }
        if ((string2 = string.substring(0, n > 0 ? n : string.length())).charAt(string2.length() - 1) == ';') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        FileInputStream fileInputStream = new FileInputStream(string2.trim());
        reader = new BufferedReader(new InputStreamReader(fileInputStream));
        int n2 = fileInputStream.available();
        cArray = new char[n2 + 1];
        reader.read(cArray, 0, n2);
        cArray[n2] = '\u0000';
        Object var9_10 = null;
        if (reader == null) return new String(cArray);
        try {
            reader.close();
            return new String(cArray);
        }
        catch (IOException iOException) {}
        return new String(cArray);
        {
            catch (FileNotFoundException fileNotFoundException) {
                ComUtil.ThrowExcp(155, ErrorMessage.messages.getString("TJ179") + fileNotFoundException);
                Object var9_11 = null;
                if (reader == null) return new String(cArray);
                try {
                    reader.close();
                    return new String(cArray);
                }
                catch (IOException iOException) {}
                return new String(cArray);
            }
            catch (IOException iOException) {
                ComUtil.ThrowExcp(155, ErrorMessage.messages.getString("TJ179") + iOException);
                Object var9_12 = null;
                if (reader == null) return new String(cArray);
                try {
                    reader.close();
                    return new String(cArray);
                }
                catch (IOException iOException2) {}
                return new String(cArray);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static int endOfWordIndex(String string) {
        return ComUtil.indexOf(string, "(", 0);
    }

    public void addBatch(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        if (stringBuffer.charAt(stringBuffer.length() - 1) != ';') {
            stringBuffer = stringBuffer.append(";");
        }
        this.batchLength += stringBuffer.length();
        if ((long)this.batchLength > this.maxBatchSize) {
            this.batchLength -= stringBuffer.length();
            ComUtil.ThrowExcp(161, ErrorMessage.messages.getString("TJ202"));
        }
        try {
            this.batchVect.addElement(stringBuffer.toString());
        }
        catch (Exception exception) {
            ComUtil.ThrowExcp(160, ErrorMessage.messages.getString("TJ201"));
        }
    }

    public void clearBatch() throws SQLException {
        this.batchVect.removeAllElements();
        this.batchLength = 0;
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    protected jdbcVector getBatchVector() {
        return this.batchVect;
    }

    protected int getBatchLength() {
        return this.batchLength;
    }

    protected boolean isCreateProcedure() {
        return this.createProcedure;
    }

    protected void setRS(TeraResultSet teraResultSet) {
        this.RS = teraResultSet;
    }

    public ConnectionOptions getConnectionOptions() {
        return this.conOptions;
    }

    protected abstract Statement getStatementDelegate();

    protected java.sql.ResultSet internalGetResultSet(boolean bl, boolean bl2) throws SQLException {
        Statement statement = this.getStatementDelegate();
        TDSession tDSession = statement.getConnection();
        ResultSet resultSet = statement.getResultSet();
        if (resultSet == null || bl2) {
            if (bl) {
                return null;
            }
            resultSet = ResultSet.createResultSet(statement, null, tDSession.getLog());
            resultSet.setMetaData(new TeraResultSetMetaData(tDSession));
        }
        TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
        teraLocalResultSet.setTeraStatement(this);
        teraLocalResultSet.setResultSet(resultSet);
        return teraLocalResultSet;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        Statement statement = this.getStatementDelegate();
        if (!statement.getConnection().generatedKeysSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ441");
        }
        if (statement.returnGeneratedKeys() && statement.getResults() != null && statement.getResults().getResultType() == 3) {
            return this.internalGetResultSet(false, false);
        }
        return this.internalGetResultSet(false, true);
    }

    public void setEscapeProcessing(boolean bl) {
        Statement statement = this.getStatementDelegate();
        statement.setEscapeProcessing(bl);
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }
}

