/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class URLParameters {
    private String transactMode = "D";
    private String charSet = "ASCII";
    private String partition = "DBC/SQL";
    private int logonSequenceNumber = 0;
    private short connectFunction = 0;
    private String lssType = "";
    private boolean isGoverned = true;
    private boolean isTypeNameMetadata = false;
    private String type = "DEFAULT";
    private int sessions = 8;
    private String databaseName = "NO_DEF_DATABASE";
    private String accountId = "NO_ACCOUNT_ID";
    private int spl = 3;
    private int timestampNano = -1;
    private int timeNano = -1;
    private boolean charset_Xlate_Flag = false;
    private boolean lobSupport = true;
    private int compatDBS = 0;
    private int compatIsAutoInc = 0;
    private int compatIsCurrency = 0;
    private int compatIsSigned = 0;
    private int compatIsSearch = 0;
    private String compatGetSchema = "NO_DEF_SCHEMA";
    private String compatGetTable = "NO_DEF_TABLE";
    private int compatIsReadOnly = 0;
    private int compatIsWritable = 0;
    private int compatIsDefWrit = 0;
    private int dbsPort = 1025;
    private String javaEnCoding = "ASCII";
    private String log = "0";
    private int loginTimeout;
    private String logLevel = "ERROR";
    private String LogMech;
    private String LogData;
    private boolean encryptData;
    private boolean sipSupport = true;
    private boolean javaSPDefaultConnection = false;
    private String newPassword;
    private boolean useXviews = false;
    private String lobTempTable;
    private boolean m_prepSupport = true;
    private boolean m_copDiscovery = true;
    private boolean m_bRunStartup = false;
    private long m_nConnectFailureTTL = 0L;
    private String m_sTCP = null;

    protected URLParameters(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, String string8, int n2, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22, String string23, String string24, String string25, String string26, String string27, String string28, String string29, String string30, String string31, String string32, String string33, String string34, String string35) throws SQLException {
        this.transactMode = string;
        this.setCharSet(string2);
        this.partition = string3;
        this.type = string4;
        this.setSessions(string5);
        this.setGovern(string6);
        this.spl = n;
        this.databaseName = string7;
        this.accountId = string8;
        this.loginTimeout = n2;
        this.newPassword = string28;
        if (string9 != null) {
            this.setCharset_Xlate_Flag(string9);
        }
        this.setLobSupport(string10);
        this.setCompatDBS(string15);
        this.setCompatIsAutoInc(string16);
        this.setCompatIsCurrency(string17);
        this.setCompatIsSigned(string18);
        this.setCompatIsSearch(string19);
        this.setCompatGetSchema(string20);
        this.setCompatGetTable(string21);
        this.setCompatIsReadOnly(string22);
        this.setCompatIsWritable(string23);
        this.setCompatIsDefWrit(string24);
        this.setDbsPort(string11);
        this.setLogMech(string12);
        this.setLogData(string13);
        this.setEncryptData(string14);
        this.setLogLevel(string27);
        this.setTimeNano(string25);
        this.setTimestampNano(string26);
        this.setuseXviews(string29);
        this.setLobTempTable(string30);
        this.setPrepSupport(string31);
        this.setCopDiscovery(string32);
        this.setRunStartup(string33);
        this.setConnectFailureTTL(string34);
        this.setTCP(string35);
    }

    public URLParameters(String string) throws SQLException {
        Vector vector = new Vector(5);
        this.ParseParams(vector, string);
        this.setParams(vector);
    }

    private void setParams(Vector vector) throws SQLException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        ComUtil.println(ErrorMessage.messages.getString("TJ115"));
        for (n = 0; n < vector.size(); n += 2) {
            ComUtil.println((String)vector.elementAt(n) + "=" + (String)vector.elementAt(n + 1));
        }
        for (n = 0; n < vector.size(); n += 2) {
            if (((String)vector.elementAt(n)).equalsIgnoreCase("database")) {
                this.setDatabaseName(vector.elementAt(n + 1).toString());
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("account") || ((String)vector.elementAt(n)).equalsIgnoreCase("accountid")) {
                this.setAccountId(vector.elementAt(n + 1).toString());
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("tmode")) {
                this.setTransactMode((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("charset")) {
                this.setCharSet((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("CLIENT_CHARSET")) {
                this.setCharset_Xlate_Flag(vector.elementAt(n + 1).toString().toUpperCase());
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("PARTITION")) {
                this.setPartition((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LOGON_SEQUENCE_NUMBER")) {
                this.setLogonSequenceNumber((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("CONNECT_FUNCTION")) {
                this.setConnectFunction((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("TYPE")) {
                this.setType((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("SESSIONS")) {
                this.setSessions((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LSS_TYPE")) {
                this.setLssType((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("GOVERN")) {
                this.setGovern((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("TYPE_NAME_METADATA")) {
                this.setTypeNameMetadata((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("sp_spl")) {
                this.setSpl((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("tsnano")) {
                this.setTimestampNano((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("tnano")) {
                this.setTimeNano((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LOB_SUPPORT")) {
                this.setLobSupport((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_DBS")) {
                this.setCompatDBS((String)vector.elementAt(n + 1));
                bl2 = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISAUTOINC")) {
                this.setCompatIsAutoInc((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISCURRENCY")) {
                this.setCompatIsCurrency((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISSIGNED")) {
                this.setCompatIsSigned((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISSEARCH")) {
                this.setCompatIsSearch((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_GETSCHEMA")) {
                this.setCompatGetSchema((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_GETTABLE")) {
                this.setCompatGetTable((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISREADONLY")) {
                this.setCompatIsReadOnly((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISWRITABLE")) {
                this.setCompatIsWritable((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COMPAT_ISDEFWRIT")) {
                this.setCompatIsDefWrit((String)vector.elementAt(n + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("DBS_PORT")) {
                this.setDbsPort((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LOG")) {
                this.setLogLevel((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LOGMECH")) {
                this.setLogMech((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LOGDATA")) {
                this.setLogData((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("ENCRYPTDATA")) {
                this.setEncryptData((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("SIP_SUPPORT")) {
                this.setSipSupport((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("NEW_PASSWORD")) {
                this.setNewPassword((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("USEXVIEWS")) {
                this.setuseXviews((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("LOB_TEMP_TABLE")) {
                this.setLobTempTable((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("PREP_SUPPORT")) {
                this.setPrepSupport((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("COP")) {
                this.setCopDiscovery((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("RUNSTARTUP")) {
                this.setRunStartup((String)vector.elementAt(n + 1));
                continue;
            }
            if (((String)vector.elementAt(n)).equalsIgnoreCase("CONNECT_FAILURE_TTL")) {
                this.setConnectFailureTTL((String)vector.elementAt(n + 1));
                continue;
            }
            if (!((String)vector.elementAt(n)).equalsIgnoreCase("TCP")) continue;
            this.setTCP((String)vector.elementAt(n + 1));
        }
        if (bl && !bl2) {
            ComUtil.ThrowExcp(456, ErrorMessage.messages.getString("TJ366"));
        }
        this.setLoginTimeout(DriverManager.getLoginTimeout());
    }

    public String getTransactMode() {
        return this.transactMode;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getPartition() {
        return this.partition;
    }

    public int getLogonSequenceNumber() {
        return this.logonSequenceNumber;
    }

    public short getConnectFunction() {
        return this.connectFunction;
    }

    public String getType() {
        return this.type;
    }

    public int getSessions() {
        return this.sessions;
    }

    public String getLssType() {
        return this.lssType;
    }

    public String getGovern() {
        if (this.isGoverned) {
            return "ON";
        }
        return "OFF";
    }

    public boolean isGoverned() {
        return this.isGoverned;
    }

    public String getTypeNameMetadata() {
        if (this.isTypeNameMetadata) {
            return "ON";
        }
        return "OFF";
    }

    public boolean isTypeNameMetadata() {
        return this.isTypeNameMetadata;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public int getSpl() {
        return this.spl;
    }

    public int getTimestampNano() {
        return this.timestampNano;
    }

    public int getTimeNano() {
        return this.timeNano;
    }

    public boolean getCharset_Xlate_Flag() {
        return this.charset_Xlate_Flag;
    }

    public String getLobSupport() {
        if (this.lobSupport) {
            return "1";
        }
        return "0";
    }

    public boolean isLobSupported() {
        return this.lobSupport;
    }

    public String getJavaEnCoding() {
        return this.javaEnCoding;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setTransactMode(String string) {
        if (string.equalsIgnoreCase("tera")) {
            this.transactMode = "T";
        } else if (string.equalsIgnoreCase("ansi")) {
            this.transactMode = "A";
        } else if (string.equalsIgnoreCase("default")) {
            this.transactMode = "D";
        }
    }

    public void setCharSet(String string) {
        if (string.equalsIgnoreCase("ascii")) {
            this.charSet = "ASCII";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("ASCII");
            }
        } else if (string.equalsIgnoreCase("latin1_0a")) {
            this.charSet = "LATIN1_0A";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("ISO8859_1");
            }
        } else if (string.equalsIgnoreCase("latin9_0a")) {
            this.charSet = "LATIN9_0A";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("ISO8859_15_FDIS");
            }
        } else if (string.equalsIgnoreCase("kanjisjis_0s")) {
            this.charSet = "KANJISJIS_0S";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("MS932");
            }
        } else if (string.equalsIgnoreCase("kanjieuc_0u")) {
            this.charSet = "KANJIEUC_0U";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("EUC_JP");
            }
        } else if (string.equalsIgnoreCase("kuserdefined_0s")) {
            this.charSet = "KUSERDEFINED_0S";
        } else if (string.equalsIgnoreCase("kuserdefined_0u")) {
            this.charSet = "KUSERDEFINED_0U";
        } else if (string.equalsIgnoreCase("ebcdic037_0e")) {
            this.charSet = "EBCDIC037_0E";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP037");
            }
        } else if (string.equalsIgnoreCase("kanjiebcdic5026_0i")) {
            this.charSet = "KANJIEBCDIC5026_0I";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP930");
            }
        } else if (string.equalsIgnoreCase("kanjiebcdic5035_0i")) {
            this.charSet = "KANJIEBCDIC5035_0I";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP939");
            }
        } else if (string.equalsIgnoreCase("utf8")) {
            this.charSet = "UTF8";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("UTF8");
            }
        } else if (string.equalsIgnoreCase("utf16")) {
            this.charSet = "UTF16";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("UnicodeBigUnmarked");
            }
        } else if (string.equalsIgnoreCase("latin1252_0a")) {
            this.charSet = "LATIN1252_0A";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("Cp1252");
            }
        } else if (string.equalsIgnoreCase("ebcdic273_0e")) {
            this.charSet = "EBCDIC273_0E";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP273");
            }
        } else if (string.equalsIgnoreCase("ebcdic277_0e")) {
            this.charSet = "EBCDIC277_0E";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP277");
            }
        } else if (string.equalsIgnoreCase("hangulebcdic933_1ii")) {
            this.charSet = "HANGULEBCDIC933_1II";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP933");
            }
        } else if (string.equalsIgnoreCase("hangulksc5601_2r4")) {
            this.charSet = "HANGULKSC5601_2R4";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("MS949");
            }
        } else if (string.equalsIgnoreCase("schebcdic935_2ij")) {
            this.charSet = "SCHEBCDIC935_2IJ";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP935");
            }
        } else if (string.equalsIgnoreCase("schgb2312_1t0")) {
            this.charSet = "SCHGB2312_1T0";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("EUC_CN");
            }
        } else if (string.equalsIgnoreCase("tchbig5_1r0")) {
            this.charSet = "TCHBIG5_1R0";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("BIG5");
            }
        } else if (string.equalsIgnoreCase("tchebcdic937_3ib")) {
            this.charSet = "TCHEBCDIC937_3IB";
            if (!this.charset_Xlate_Flag) {
                this.setJavaEnCoding("CP937");
            }
        } else {
            this.charSet = string;
        }
    }

    protected void setPartition(String string) {
        this.partition = string;
    }

    protected void setLogonSequenceNumber(String string) throws SQLException {
        try {
            this.logonSequenceNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw ErrorFactory.makeDriverJDBCException("TJ404", string);
        }
    }

    protected void setConnectFunction(String string) throws SQLException {
        try {
            this.connectFunction = Short.parseShort(string);
        }
        catch (Exception exception) {
            throw ErrorFactory.makeDriverJDBCException("TJ405", string);
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    protected void setSessions(String string) throws SQLException {
        try {
            this.sessions = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw ErrorFactory.makeDriverJDBCException("TJ454", string);
        }
        if (this.sessions <= 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ455", this.sessions);
        }
    }

    protected void setLssType(String string) throws SQLException {
        this.lssType = string;
    }

    protected void setGovern(String string) throws SQLException {
        this.isGoverned = string.equalsIgnoreCase("ON");
    }

    protected void setTypeNameMetadata(String string) throws SQLException {
        this.isTypeNameMetadata = string.equalsIgnoreCase("ON");
    }

    protected void setDatabaseName(String string) {
        try {
            this.databaseName = string;
        }
        catch (Exception exception) {
            this.databaseName = "NO_DEF_DATABASE";
        }
    }

    protected void setLobTempTable(String string) {
        if (string != null) {
            string = "\"" + string.replaceAll("\"", "\"\"").replaceAll("[.]", "\".\"") + "\"";
        }
        this.lobTempTable = string;
    }

    public String getLobTempTable() {
        return this.lobTempTable;
    }

    protected void setAccountId(String string) {
        try {
            this.accountId = string;
        }
        catch (Exception exception) {
            this.accountId = "NO_ACCOUNT_ID";
        }
    }

    protected void setSpl(String string) {
        if (string.equalsIgnoreCase("NOSPL")) {
            this.spl = 4;
        }
    }

    public void setSpl(int n) {
        this.spl = n;
    }

    protected void setTimestampNano(String string) {
        try {
            this.timestampNano = Integer.parseInt(string);
            if (this.timestampNano > 6) {
                this.timestampNano = 6;
            } else if (this.timestampNano < 0) {
                this.timestampNano = -1;
            }
        }
        catch (Exception exception) {
            this.timestampNano = -1;
        }
    }

    public void setTimestampNano(int n) {
        this.timestampNano = n;
    }

    protected void setTimeNano(String string) {
        try {
            this.timeNano = Integer.parseInt(string);
            if (this.timeNano > 6) {
                this.timeNano = 6;
            } else if (this.timeNano < 0) {
                this.timeNano = -1;
            }
        }
        catch (Exception exception) {
            this.timeNano = -1;
        }
    }

    public void setTimeNano(int n) {
        this.timeNano = n;
    }

    protected void setCharset_Xlate_Flag(String string) throws SQLException {
        this.setJavaEnCoding(string);
        this.charset_Xlate_Flag = true;
        try {
            if (string.length() == 0) {
                ComUtil.ThrowExcp(3, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ211"), string));
                return;
            }
            byte[] byArray = this.charSet.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(3, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ211"), string));
            return;
        }
    }

    public void setLobSupport(String string) {
        this.lobSupport = !string.equalsIgnoreCase("OFF");
    }

    protected void setCompatDBS(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatDBS = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatDBS = 2;
            }
        }
    }

    public int getCompatDBS() {
        return this.compatDBS;
    }

    protected void setCompatIsAutoInc(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsAutoInc = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsAutoInc = 2;
            }
        }
    }

    public int getCompatIsAutoInc() {
        return this.compatIsAutoInc;
    }

    protected void setCompatIsCurrency(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsCurrency = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsCurrency = 2;
            }
        }
    }

    public int getCompatIsCurrency() {
        return this.compatIsCurrency;
    }

    protected void setCompatIsSigned(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsSigned = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsSigned = 2;
            }
        }
    }

    public int getCompatIsSigned() {
        return this.compatIsSigned;
    }

    protected void setCompatIsSearch(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsSearch = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsSearch = 2;
            }
        }
    }

    public int getCompatIsSearch() {
        return this.compatIsSearch;
    }

    protected void setCompatGetSchema(String string) {
        this.compatGetSchema = string;
    }

    public String getCompatGetSchema() {
        return this.compatGetSchema;
    }

    protected void setCompatGetTable(String string) {
        this.compatGetTable = string;
    }

    public String getCompatGetTable() {
        return this.compatGetTable;
    }

    protected void setCompatIsReadOnly(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsReadOnly = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsReadOnly = 2;
            }
        }
    }

    public int getCompatIsReadOnly() {
        return this.compatIsReadOnly;
    }

    protected void setCompatIsWritable(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsWritable = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsWritable = 2;
            }
        }
    }

    public int getCompatIsWritable() {
        return this.compatIsWritable;
    }

    protected void setCompatIsDefWrit(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsDefWrit = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsDefWrit = 2;
            }
        }
    }

    public int getCompatIsDefWrit() {
        return this.compatIsDefWrit;
    }

    protected void setDbsPort(String string) {
        if (string != null) {
            try {
                int n = Integer.valueOf(string);
                if (n > 0) {
                    this.dbsPort = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int getDbsPort() {
        return this.dbsPort;
    }

    protected void setJavaEnCoding(String string) {
        this.javaEnCoding = string;
    }

    protected void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    protected void setLogMech(String string) {
        this.LogMech = string;
    }

    public String getLogMech() {
        return this.LogMech;
    }

    protected void setLogData(String string) {
        this.LogData = string;
    }

    public String getLogData() {
        return this.LogData;
    }

    protected void setEncryptData(String string) {
        if (string != null && string.equalsIgnoreCase("ON")) {
            this.encryptData = true;
        }
    }

    public boolean getEncryptData() {
        return this.encryptData;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setuseXviews(String string) {
        if (string != null && string.equalsIgnoreCase("ON")) {
            this.useXviews = true;
        }
    }

    public boolean getuseXviews() {
        return this.useXviews;
    }

    private void ParseParams(Vector vector, String string) throws SQLException {
        String string2 = string;
        while (string2.length() > 0) {
            int n = (string2 = string2.trim()).indexOf(61, 0);
            if (n >= 0) {
                String string3;
                int n2;
                String string4 = string2.substring(0, n).trim();
                if ((string2 = string2.substring(n + 1).trim()).length() == 0 || string2.charAt(0) == ',') {
                    throw ErrorFactory.makeDriverJDBCException("TJ631", string4);
                }
                int n3 = -1;
                int n4 = -1;
                int n5 = 0;
                n3 = string2.indexOf(39);
                if (n3 != -1) {
                    n2 = n3;
                    while ((n4 = string2.indexOf(39, n2 + 1)) != -1 && string2.length() > n4 + 1 && string2.charAt(n4 + 1) == '\'') {
                        if (n5 == 0) {
                            n5 = n4;
                        }
                        n2 = n4 + 2;
                    }
                }
                n = string2.indexOf(44, 0);
                n2 = string2.indexOf(32, 0);
                if (n != -1 && n > n3 && n < n4) {
                    n = string2.indexOf(44, n4 + 1);
                }
                if (n2 != -1 && n2 > n3 && n2 < n4) {
                    n2 = string2.indexOf(32, n4 + 1);
                }
                int n6 = n;
                if (n < 0) {
                    n6 = n2;
                } else {
                    n6 = n;
                    if (n2 >= 0 && n2 < n) {
                        n6 = n2;
                    }
                }
                if (n6 > 0) {
                    string3 = string2.substring(0, n6);
                    string2 = string2.substring(n6 + 1);
                } else if (n6 == 0) {
                    string3 = "";
                    string2 = string2.substring(n6 + 1);
                } else {
                    string3 = string2.substring(0);
                    string2 = "";
                }
                vector.addElement(string4);
                if (n5 != 0 && (n5 <= n6 || n6 == -1)) {
                    string3 = string3.replaceAll("''", "'");
                }
                if (string3.charAt(0) == '\'') {
                    string3 = string3.substring(1);
                }
                if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\'') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                vector.addElement(string3);
                continue;
            }
            string2 = "";
        }
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String string) {
        if (string != null) {
            this.logLevel = string;
        }
    }

    public boolean sipSupport() {
        return this.sipSupport;
    }

    protected void setSipSupport(String string) {
        if (string.equalsIgnoreCase("ON")) {
            this.sipSupport = true;
        } else if (string.equalsIgnoreCase("OFF")) {
            this.sipSupport = false;
        }
    }

    public void setSipSupport(boolean bl) {
        this.sipSupport = bl;
    }

    public void setJavaSPDefaultConnection(boolean bl) {
        this.javaSPDefaultConnection = bl;
    }

    public boolean isJavaSPDefaultConnection() {
        return this.javaSPDefaultConnection;
    }

    public boolean getPrepSupport() {
        return this.m_prepSupport;
    }

    private void setPrepSupport(String string) {
        this.m_prepSupport = !"OFF".equalsIgnoreCase(string);
    }

    public boolean getCopDiscovery() {
        return this.m_copDiscovery;
    }

    public void setCopDiscovery(String string) {
        this.m_copDiscovery = !"OFF".equalsIgnoreCase(string);
    }

    public boolean getRunStartup() {
        return this.m_bRunStartup;
    }

    public void setRunStartup(String string) {
        this.m_bRunStartup = "ON".equalsIgnoreCase(string);
    }

    public long getConnectFailureTTL() {
        return this.m_nConnectFailureTTL;
    }

    public void setConnectFailureTTL(String string) {
        if (string != null) {
            this.m_nConnectFailureTTL = Long.parseLong(string);
        }
    }

    public String getTCP() {
        return this.m_sTCP;
    }

    public void setTCP(String string) {
        this.m_sTCP = string;
    }
}

