/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.interfaces;

import com.teradata.jdbc.jdbc_4.Blob;
import com.teradata.jdbc.jdbc_4.Clob;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.sql.SQLException;

public abstract class Lob {
    private long length;
    protected byte[] locator;
    private int token;
    private int columnNumber;
    protected long amountRead;
    private int writableLobId = 0;
    private boolean staleLocator = false;
    private Statement stmt = null;
    private ResultSet rs;

    public long length() throws SQLException {
        return this.length;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public void setLocator(byte[] byArray) {
        this.locator = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.locator, 0, byArray.length);
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    public int getToken() {
        return this.token;
    }

    public void setToken(int n) {
        this.token = n;
    }

    public int write(TDPacketStream tDPacketStream, int n, String string) throws IOException, SQLException {
        return 0;
    }

    public boolean eof() throws IOException {
        return false;
    }

    public long amountRead() {
        return this.amountRead;
    }

    public int getWritableLobId() {
        return this.writableLobId;
    }

    public void setWritableLobId(int n) {
        this.writableLobId = n;
    }

    public boolean locatorIsStale() {
        return this.staleLocator;
    }

    public void setStaleLocator(boolean bl) {
        this.staleLocator = bl;
    }

    public void close() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
    }

    public void refreshStaleLocator(TDSession tDSession, int n) throws SQLException {
        String string = "select " + (n == 408 ? "bval" : "cval") + " from " + tDSession.getLobTempTable() + " where id = " + this.getWritableLobId();
        if (tDSession != null) {
            if (this.stmt != null) {
                this.stmt.close();
            }
            this.stmt = tDSession.createStatement(1003, 1007);
            this.rs = this.stmt.executeQuery(string);
            this.rs.next();
            if (n == 408) {
                this.setLocator(((Blob)this.rs.getObject(1)).getLocator());
                this.setLength(((Blob)this.rs.getObject(1)).length());
            } else {
                this.setLocator(((Clob)this.rs.getObject(1)).getLocator());
                this.setLength(((Clob)this.rs.getObject(1)).length());
            }
            this.setStaleLocator(false);
        }
    }

    public String initWritableLobs(TDSession tDSession, String string) throws SQLException {
        String string2 = tDSession.getLobTempTable();
        if (string2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ514", string);
        }
        if (this.getWritableLobId() == 0) {
            this.setWritableLobId(tDSession.getWritableLobId());
            Statement statement = tDSession.createStatement(1003, 1007);
            statement.executeUpdate("INSERT INTO " + string2 + "(id) VALUES(" + this.getWritableLobId() + ")");
            statement.close();
        }
        return string2;
    }
}

