/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.CharSetNames;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public abstract class ConnectionBase {
    private static final CharSetNames CHARSET_NAMES = new CharSetNames();
    protected String machineName;
    protected URLParameters urlParams;
    protected Log log;
    private long m_nLoginEndTime = 0L;
    private SQLWarning m_sqlWarningChain = null;

    protected ConnectionBase(String string, URLParameters uRLParameters) throws SQLException {
        this.machineName = string;
        this.log = new Log(this.toString());
        this.updateURLParameters(uRLParameters);
        if (this.urlParams.getLoginTimeout() != 0) {
            this.m_nLoginEndTime = System.currentTimeMillis() + (long)(this.urlParams.getLoginTimeout() * 1000);
        }
    }

    public String getMachineName() {
        return this.machineName;
    }

    public int getMachinePort() {
        return this.urlParams.getDbsPort();
    }

    public URLParameters getURLParameters() {
        return this.urlParams;
    }

    public String getSessionJavaCharSet() {
        return CHARSET_NAMES.getMappedName(this.urlParams.getCharSet());
    }

    public Log getLog() {
        return this.log;
    }

    public int checkRemainingLoginTime() throws JDBCException {
        if (this.m_nLoginEndTime == 0L) {
            return 0;
        }
        long l = this.m_nLoginEndTime - System.currentTimeMillis();
        if (l < 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ589", this.machineName);
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Login time remaining is " + l + " ms");
        }
        return (int)l;
    }

    public abstract boolean isClosed() throws SQLException;

    protected void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return this.m_sqlWarningChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            this.m_sqlWarningChain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(SQLWarning sQLWarning) {
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (this.m_sqlWarningChain != null) {
                this.m_sqlWarningChain.setNextWarning(sQLWarning);
            } else {
                this.m_sqlWarningChain = sQLWarning;
            }
        }
    }

    public boolean supportsPasswordChange() {
        return false;
    }

    public void setNeedNewPassword(boolean bl) {
    }

    public void updateURLParameters(URLParameters uRLParameters) throws SQLException {
        this.log.setLogLevel(uRLParameters.getLogLevel());
        if (this.urlParams == null) {
            this.urlParams = uRLParameters;
        } else {
            this.urlParams.setLogLevel(uRLParameters.getLogLevel());
            this.urlParams.setSpl(uRLParameters.getSpl());
            this.urlParams.setLobSupport(uRLParameters.getLobSupport());
            this.urlParams.setSipSupport(uRLParameters.sipSupport());
            this.urlParams.setTimestampNano(uRLParameters.getTimestampNano());
            this.urlParams.setTimeNano(uRLParameters.getTimeNano());
            this.urlParams.setCharSet(uRLParameters.getCharSet());
        }
        if (this.getSessionJavaCharSet() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ302", this.urlParams.getCharSet());
        }
    }
}

