/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.console.ConsoleConnection;
import com.teradata.jdbc.jdbc.fastexport.FastExportConnection;
import com.teradata.jdbc.jdbc.fastexport.FastExportManagerConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerConnection;
import com.teradata.jdbc.jdbc.monitor.MonitorConnection;
import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Connection;
import java.sql.SQLException;

public final class ConnectionFactory {
    public static final Connection createConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        if (uRLParameters.getType().equalsIgnoreCase("FASTLOAD")) {
            return new FastLoadManagerConnection(string, string2, string3, uRLParameters);
        }
        if (uRLParameters.getType().equalsIgnoreCase("FASTEXPORT")) {
            return new FastExportManagerConnection(string, string2, string3, uRLParameters);
        }
        if (uRLParameters.getType().equalsIgnoreCase("RAW")) {
            return new RawConnection(string, string2, string3, uRLParameters);
        }
        if (uRLParameters.getType().equalsIgnoreCase("DEFAULT")) {
            if (uRLParameters.getPartition().equalsIgnoreCase("DBC/SQL")) {
                return new TeraLocalConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("FASTLOAD")) {
                return new FastLoadConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("EXPORT")) {
                return new FastExportConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("MONITOR")) {
                return new MonitorConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("DBCCONS")) {
                return new ConsoleConnection(string, string2, string3, uRLParameters);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ403", uRLParameters.getPartition());
        }
        throw ErrorFactory.makeDriverJDBCException("TJ456", uRLParameters.getType());
    }
}

