/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.jdbc.GenericConnectState;
import com.teradata.jdbc.jdbc.GenericEncryptContextState;
import com.teradata.jdbc.jdbc.GenericEncryptMethodState;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class GenericAssignRspState
implements TDParcelState {
    private GenericLogonController controller;
    private TDPacket packet;
    private TDNetworkIOIF io;
    protected Log log;

    public GenericAssignRspState(GenericLogonController genericLogonController, Log log) {
        this.log = log;
        this.controller = genericLogonController;
        this.packet = genericLogonController.getPacket();
        this.io = genericLogonController.getNetworkIO();
    }

    public TDParcelState action(Parcel parcel) {
        return null;
    }

    public TDParcelState action() throws SQLException {
        Object object;
        Parcel parcel = null;
        GenericTeradataConnection genericTeradataConnection = this.controller.getGenericTeradataConnection();
        this.packet.clear();
        this.packet.getBuffer().readStream(this.io, genericTeradataConnection.getTeraEncrypt(), false, genericTeradataConnection.checkRemainingLoginTime(), false);
        this.packet.initParcelFactory(genericTeradataConnection.getCharSet(), this.log);
        genericTeradataConnection.setEncryptPassword(this.packet.getEncryption());
        this.log.debug(this.packet.getBuffer());
        genericTeradataConnection.setSessionNum(this.packet.getLANSessionNumber());
        block9: while ((parcel = this.packet.nextParcel()) != null) {
            switch (parcel.getFlavor()) {
                case 101: {
                    genericTeradataConnection.setAssignRspParcel((AssignRspParcel)parcel);
                    continue block9;
                }
                case 43: {
                    continue block9;
                }
                case 134: {
                    object = (SSOResponseParcel)parcel;
                    genericTeradataConnection.getTeraEncrypt().setIntoken(((SSOResponseParcel)object).getAuthData());
                    continue block9;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            this.log.error("AssignRspState receive an un-expected parcel with flavor: " + parcel.getFlavor());
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
        }
        if (genericTeradataConnection.serverHasAuthMechs()) {
            return new GenericEncryptContextState(this.controller, this.log);
        }
        object = genericTeradataConnection.getlogmech();
        if (!(genericTeradataConnection.getUsingClientDefaultMech() || object == null || genericTeradataConnection.getEncryptPassword() && ((String)object).equalsIgnoreCase("TD1"))) {
            throw ErrorFactory.makeDriverJDBCException("TJ344", "LOGMECH");
        }
        if (genericTeradataConnection.getEncryptData() && (!genericTeradataConnection.getEncryptPassword() || object == null)) {
            throw ErrorFactory.makeDriverJDBCException("TJ344", "ENCRYPTDATA");
        }
        if (genericTeradataConnection.getEncryptPassword()) {
            return new GenericEncryptMethodState(this.controller, this.log);
        }
        return new GenericConnectState(this.controller, this.log);
    }
}

