/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class GenericConnectRspState
implements TDParcelState {
    private GenericLogonController controller;
    private TDPacket packet;
    private TDNetworkIOIF io;
    protected Log log;

    public GenericConnectRspState(GenericLogonController genericLogonController, Log log) {
        this.log = log;
        this.controller = genericLogonController;
        this.packet = genericLogonController.getPacket();
        this.io = genericLogonController.getNetworkIO();
    }

    public TDParcelState action(Parcel parcel) {
        return null;
    }

    public TDParcelState action() throws SQLException {
        Parcel parcel = null;
        this.packet.clear();
        GenericTeradataConnection genericTeradataConnection = this.controller.getGenericTeradataConnection();
        this.packet.getBuffer().readStream(this.io, genericTeradataConnection.getTeraEncrypt(), false, genericTeradataConnection.checkRemainingLoginTime(), false);
        this.packet.initParcelFactory(this.controller.getGenericTeradataConnection().getCharSet(), this.log);
        this.log.debug(this.packet.getBuffer());
        block9: while ((parcel = this.packet.nextParcel()) != null) {
            switch (parcel.getFlavor()) {
                case 8: {
                    SuccessParcel successParcel = (SuccessParcel)parcel;
                    if (successParcel.getWarningCode() == 0) continue block9;
                    this.controller.getGenericTeradataConnection().setNeedNewPassword(successParcel.getWarningCode() == 3032);
                    if (this.controller.getGenericTeradataConnection().supportsPasswordChange()) continue block9;
                    Object object = ErrorFactory.makeDatabaseSQLWarning(successParcel.getWarningMessage(), successParcel.getWarningCode());
                    this.controller.getGenericTeradataConnection().addWarning((SQLWarning)object);
                    continue block9;
                }
                case 89: {
                    this.controller.getGenericTeradataConnection().setLogonSequenceNumberParcel((LogonSequenceNumberParcel)parcel);
                    continue block9;
                }
                case 9: {
                    Object object = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object).getMsg(), ((ErrorParcel)object).getCode());
                }
                case 12: {
                    EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                    continue block9;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
        }
        return null;
    }
}

