/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.jdbc.GenericConnectRspState;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ConnectParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionOptionsParcel;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class GenericConnectState
implements TDParcelState {
    private GenericLogonController controller;
    protected Log log;

    public GenericConnectState(GenericLogonController genericLogonController, Log log) {
        this.controller = genericLogonController;
        this.log = log;
    }

    public TDParcelState action(Parcel parcel) {
        return null;
    }

    public TDParcelState action() throws JDBCException {
        String string = null;
        LogonParcel logonParcel = null;
        TDPacket tDPacket = this.controller.getPacket();
        TDNetworkIOIF tDNetworkIOIF = this.controller.getNetworkIO();
        string = this.controller.getGenericTeradataConnection().getCharSet();
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind((byte)3);
        tDPacket.setHostCharSet(this.controller.getGenericTeradataConnection().getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.controller.getGenericTeradataConnection().getSessionNum());
        tDPacket.setAuthentication(this.controller.getGenericTeradataConnection().getAuthenticationNonce());
        logonParcel = new LogonParcel(string, this.log);
        if (this.controller.getGenericTeradataConnection().getTeraEncrypt() == null || !this.controller.getGenericTeradataConnection().getTeraEncrypt().isUsingGeneratedCredentials()) {
            logonParcel.setLogonInformation(this.controller.getLogon());
        }
        tDPacket.addParcel(logonParcel);
        SessionOptionsParcel sessionOptionsParcel = new SessionOptionsParcel(this.log);
        sessionOptionsParcel.setSemantics(this.controller.getGenericTeradataConnection().getTransactionSemantics());
        tDPacket.addParcel(sessionOptionsParcel);
        ConnectParcel connectParcel = new ConnectParcel("ASCII", this.log);
        connectParcel.setPartitionName(this.controller.getGenericTeradataConnection().getURLParameters().getPartition());
        connectParcel.setLogonSequenceNumber(this.controller.getGenericTeradataConnection().getURLParameters().getLogonSequenceNumber());
        connectParcel.setFunction(this.controller.getGenericTeradataConnection().getURLParameters().getConnectFunction());
        tDPacket.addParcel(connectParcel);
        if (this.controller.getGenericTeradataConnection().getEncryptPassword()) {
            tDPacket.setEncrypted();
        }
        LogonDataParcel logonDataParcel = new LogonDataParcel(this.controller.getGenericTeradataConnection().getIO(), this.controller.getGenericTeradataConnection().getURLParameters().getLssType(), this.log);
        tDPacket.addParcel(logonDataParcel);
        tDPacket.toStream();
        this.log.debug(tDPacket.getBuffer());
        tDPacket.getBuffer().writeStream(tDNetworkIOIF, this.controller.getGenericTeradataConnection().getTeraEncrypt());
        return new GenericConnectRspState(this.controller, this.log);
    }
}

