/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.jdbc.GenericConnectState;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SSORequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class GenericEncryptContextState
implements TDParcelState {
    private GenericLogonController controller;
    private GenericTeraEncrypt myEncrypt = null;
    protected Log log;

    public GenericEncryptContextState(GenericLogonController genericLogonController, Log log) {
        this.controller = genericLogonController;
        this.log = log;
    }

    public TDParcelState action() throws JDBCException {
        TDNetworkIOIF tDNetworkIOIF = this.controller.getNetworkIO();
        try {
            this.myEncrypt = this.controller.getGenericTeradataConnection().getTeraEncrypt();
            if (this.myEncrypt == null) {
                this.myEncrypt = new GenericTeraEncrypt(this.controller.getGenericTeradataConnection());
                this.controller.getGenericTeradataConnection().setTeraEncrypt(this.myEncrypt);
            }
            String string = "ASCII";
            byte[] byArray = this.myEncrypt.getIntoken();
            do {
                Parcel parcel = null;
                TDPacket tDPacket = this.controller.getPacket();
                tDPacket.clear();
                tDPacket.setInitParcelPosition();
                tDPacket.setLANKind((byte)12);
                tDPacket.setByteVar((byte)7);
                tDPacket.setHostCharSet((byte)-1);
                tDPacket.setSessionNumber(this.controller.getGenericTeradataConnection().getSessionNum());
                this.log.debugByteArray("EncryptContextState calling initSecContext with", byArray);
                byte[] byArray2 = this.myEncrypt.initSecContext(byArray, 0, byArray.length);
                this.log.debugByteArray("EncryptContextState called initSecContext and got", byArray2);
                if (byArray2 == null && !this.myEncrypt.isEstablished()) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 == null) continue;
                tDPacket.setAuthentication(this.controller.getGenericTeradataConnection().getAuthenticationNonce());
                SSORequestParcel sSORequestParcel = new SSORequestParcel(string, this.log);
                sSORequestParcel.setTrip(this.myEncrypt.getTrip());
                this.myEncrypt.incTrip();
                sSORequestParcel.setAuthData(byArray2);
                sSORequestParcel.setMethod(this.myEncrypt.getSSOAuthMethod());
                tDPacket.addParcel(sSORequestParcel);
                tDPacket.toStream();
                this.log.debug(tDPacket.getBuffer());
                tDPacket.getBuffer().writeStream(tDNetworkIOIF, this.controller.getGenericTeradataConnection().getTeraEncrypt());
                tDPacket.clear();
                GenericTeradataConnection genericTeradataConnection = this.controller.getGenericTeradataConnection();
                tDPacket.getBuffer().readStream(tDNetworkIOIF, genericTeradataConnection.getTeraEncrypt(), false, genericTeradataConnection.checkRemainingLoginTime(), false);
                tDPacket.initParcelFactory(this.controller.getGenericTeradataConnection().getCharSet(), this.log);
                block9: while ((parcel = tDPacket.nextParcel()) != null) {
                    switch (parcel.getFlavor()) {
                        case 134: {
                            SSOResponseParcel sSOResponseParcel = (SSOResponseParcel)parcel;
                            byArray = sSOResponseParcel.getAuthData();
                            this.log.debugByteArray("EncryptContextState called getAuthData and got", byArray);
                            continue block9;
                        }
                        case 9: {
                            FailureParcel failureParcel = (FailureParcel)parcel;
                            throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                        }
                        case 49: {
                            ErrorParcel errorParcel = (ErrorParcel)parcel;
                            throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                        }
                    }
                    throw ErrorFactory.makeIoJDBCException("TJ305", Integer.toString(parcel.getFlavor()), tDNetworkIOIF, null, this.log);
                }
            } while (!this.myEncrypt.isEstablished());
            if (this.log.isDebugEnabled()) {
                this.myEncrypt.showContext();
            }
        }
        catch (JDBCException jDBCException) {
            throw jDBCException;
        }
        catch (Throwable throwable) {
            throw ErrorFactory.makeIoJDBCException("TJ331", "GenericEncryptContextState action", tDNetworkIOIF, throwable, this.log);
        }
        return new GenericConnectState(this.controller, this.log);
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

