/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigFeatureTdgss;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class GenericInitDBConfigState
implements TDParcelState {
    private GenericLogonController controller;
    protected Log log;

    public GenericInitDBConfigState(GenericLogonController genericLogonController, Log log) {
        this.controller = genericLogonController;
        this.log = log;
    }

    public TDParcelState action() throws SQLException {
        Object object;
        Parcel parcel = null;
        TDPacket tDPacket = this.controller.getPacket();
        TDNetworkIOIF tDNetworkIOIF = this.controller.getNetworkIO();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind((byte)10);
        tDPacket.setByteVar((byte)7);
        tDPacket.setHostCharSet((byte)-1);
        ClientConfigParcel clientConfigParcel = new ClientConfigParcel(this.log);
        ConfigFeatureTdgss configFeatureTdgss = new ConfigFeatureTdgss(this.log);
        clientConfigParcel.addFeature(configFeatureTdgss);
        tDPacket.addParcel(clientConfigParcel);
        try {
            tDPacket.toStream().writeStream(tDNetworkIOIF, this.controller.getGenericTeradataConnection().getTeraEncrypt());
        }
        catch (JDBCException jDBCException) {
            this.log.error("Exception!!!", jDBCException);
            throw jDBCException;
        }
        tDPacket.clear();
        try {
            object = this.controller.getGenericTeradataConnection();
            tDPacket.getBuffer().readStream(tDNetworkIOIF, object.getTeraEncrypt(), false, object.checkRemainingLoginTime(), false);
        }
        catch (JDBCException jDBCException) {
            this.log.error("Exception!!!", jDBCException);
            throw jDBCException;
        }
        tDPacket.initParcelFactory(this.controller.getGenericTeradataConnection().getCharSet(), this.log);
        this.log.debug(tDPacket.getBuffer());
        block9: while ((parcel = tDPacket.nextParcel()) != null) {
            switch (parcel.getFlavor()) {
                case 43: {
                    object = (ConfigRspParcel)parcel;
                    this.controller.getGenericTeradataConnection().setConfigResponse((ConfigRspParcel)object);
                    continue block9;
                }
                case 165: {
                    GtwConfigParcel gtwConfigParcel = (GtwConfigParcel)parcel;
                    this.controller.getGenericTeradataConnection().setUTF_CredentialSupported(gtwConfigParcel.isUTF_CredentialSupported());
                    continue block9;
                }
                case 167: {
                    AuthMechParcel authMechParcel = (AuthMechParcel)parcel;
                    AuthMechanism authMechanism = new AuthMechanism(authMechParcel.getMechOid(), this.log);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("New Server Mechanism: " + authMechanism.getUserName() + "   " + authMechanism.getName());
                    }
                    this.controller.getGenericTeradataConnection().addServerAuthMech(authMechanism);
                    if (!authMechParcel.isDefaultMechanism()) continue block9;
                    this.controller.getGenericTeradataConnection().setServerDefaultAuthMethodOid(authMechParcel.getMechOid());
                    if (!this.log.isDebugEnabled()) continue block9;
                    this.log.debug(" Default Server Mechanism is: " + authMechParcel.getMechOidString());
                    continue block9;
                }
            }
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
        }
        return null;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

