/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc.GenericAssignState;
import com.teradata.jdbc.jdbc.GenericInitDBConfigState;
import com.teradata.jdbc.jdbc.GenericStateController;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.ietf.jgss.Oid;

public class GenericLogonController
extends GenericStateController {
    static final String LINE_SEP = System.getProperty("line.separator");
    private LogonInformation logon;

    public GenericLogonController(LogonInformation logonInformation, GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        super(genericTeradataConnection);
        this.logon = logonInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException {
        TDParcelState tDParcelState = null;
        TDNetworkIOIF tDNetworkIOIF = this.io;
        synchronized (tDNetworkIOIF) {
            for (tDParcelState = new GenericInitDBConfigState(this, this.log); tDParcelState != null; tDParcelState = tDParcelState.action()) {
            }
            String string = this.genericTdatCon.getlogmech();
            Oid oid = null;
            Oid oid2 = GenericTeraEncrypt.getClientDefaultMech(this.log);
            if (string != null || oid2 != null) {
                if (string != null) {
                    oid = GenericTeraEncrypt.getOidForName(string, this.log);
                    if (oid == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ335", string);
                    }
                } else {
                    if (!this.genericTdatCon.serverHasAuthMechs()) {
                        oid = null;
                        this.genericTdatCon.setAuthMethod(null);
                    } else {
                        oid = oid2;
                    }
                    if (oid2 != null) {
                        this.genericTdatCon.setUsingClientDefaultMech(true);
                    }
                }
                if (this.genericTdatCon.serverHasAuthMechs()) {
                    Object object;
                    ArrayList arrayList = this.genericTdatCon.getServerAuthMechs();
                    boolean bl = false;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object = (AuthMechanism)iterator.next();
                        if (!oid.equals(((AuthMechanism)object).getOid())) continue;
                        bl = true;
                        this.genericTdatCon.setAuthMethod(new AuthMechanism(oid, this.log));
                        break;
                    }
                    if (!bl) {
                        object = new StringBuffer(1000);
                        ((StringBuffer)object).append(LINE_SEP + ErrorMessage.Format1(ErrorMessage.messages.getString("TJ340"), string));
                        ((StringBuffer)object).append(LINE_SEP + ErrorMessage.messages.getString("TJ337"));
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            AuthMechanism authMechanism = (AuthMechanism)iterator2.next();
                            ((StringBuffer)object).append(LINE_SEP + authMechanism.getUserName() + "  " + authMechanism.getName());
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ341", new String((StringBuffer)object));
                    }
                }
            } else if (this.genericTdatCon.serverHasAuthMechs()) {
                if (this.genericTdatCon.getServerDefaultAuthMethodOid() == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ333", string);
                }
                this.genericTdatCon.setAuthMethod(new AuthMechanism(this.genericTdatCon.getServerDefaultAuthMethodOid(), this.log));
            }
            for (tDParcelState = new GenericAssignState(this, this.log); tDParcelState != null; tDParcelState = tDParcelState.action()) {
            }
            this.genericTdatCon.returnPacket(this.packet);
        }
    }

    public LogonInformation getLogon() {
        return this.logon;
    }

    public void setLogon(LogonInformation logonInformation) {
        this.logon = logonInformation;
    }
}

