/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public abstract class GenericStateController {
    protected GenericTeradataConnection genericTdatCon;
    protected TDPacket packet;
    protected TDNetworkIOIF io;
    protected Log log;

    public GenericStateController(GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        this.genericTdatCon = genericTeradataConnection;
        this.io = this.genericTdatCon.getIO();
        this.log = this.genericTdatCon.getLog();
    }

    protected abstract void run() throws SQLException;

    public TDPacket getPacket() {
        if (this.packet != null) {
            this.packet.clear();
        } else {
            this.packet = this.genericTdatCon.getPacket();
        }
        this.packet.newLanHeader();
        return this.packet;
    }

    public TDPacket getPacket(int n) {
        if (this.packet != null) {
            if (this.packet.getBuffer().capacity() >= n) {
                this.packet.clear();
            } else {
                this.genericTdatCon.returnPacket(this.packet);
                this.packet = this.genericTdatCon.getPacket(n);
            }
        } else {
            this.packet = this.genericTdatCon.getPacket(n);
        }
        this.packet.newLanHeader();
        return this.packet;
    }

    public GenericTeradataConnection getGenericTeradataConnection() {
        return this.genericTdatCon;
    }

    public TDNetworkIOIF getNetworkIO() {
        return this.io;
    }
}

