/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.TeraCallbackHandler;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketEncrypt;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssContext;
import com.teradata.tdgss.jtdgss.TdgssManager;
import com.teradata.tdgss.jtdgss.TdgssMechProp;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GenericTeraEncrypt
implements PrivilegedExceptionAction,
TDPacketEncrypt {
    static final String GSS_KERBEROS_PRINCIPALNAME = "1.2.840.113554.1.2.2.1";
    static final String TD1_OID = "1.3.6.1.4.1.191.1.1012.1.1.8";
    static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private boolean isKerberos = false;
    static final int MECH_SUPPORTS_UTF16 = 8;
    static final int MECH_SUPPORTS_UTF8 = 4;
    static final int MECH_SUPPORTS_MECHDATA = 2;
    static final int SIZE_USER_NAME_PASS_DATA_ACCT = 50;
    static final String LINE_SEP = System.getProperty("line.separator");
    private static TdgssManager myGSSManager;
    private static TdgssConfigApi myConfig;
    private TdgssContext context;
    private byte[] inToken;
    private byte trip;
    private boolean enabled;
    private boolean isPreV2R6;
    private GSSCredential myCred = null;
    private TdgssName myID = null;
    private int lifetimeCredential = 0;
    private Oid mechOid;
    private boolean usingGeneratedCredentials = false;
    protected Log log;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;

    private void transformException(Throwable throwable) throws JDBCException {
        if (throwable instanceof JDBCException) {
            throw (JDBCException)throwable;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        throw ErrorFactory.makeDriverJDBCException("TJ314", "tdgss-stack-trace-begin>>> " + stringWriter + " <<<end-tdgss-stack-trace");
    }

    public GenericTeraEncrypt(GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        this.log = genericTeradataConnection.getLog();
        try {
            Oid oid = new Oid(TD1_OID);
            genericTeradataConnection.setAuthMethod(new AuthMechanism(oid, this.log));
            this.initEncrypt(genericTeradataConnection, oid);
            this.isPreV2R6 = true;
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
    }

    public GenericTeraEncrypt(GenericTeradataConnection genericTeradataConnection, String string) throws JDBCException {
        this.log = genericTeradataConnection.getLog();
        try {
            Oid oid = new Oid(string);
            this.initEncrypt(genericTeradataConnection, oid);
            this.isPreV2R6 = false;
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
    }

    private void initEncrypt(GenericTeradataConnection genericTeradataConnection, Oid oid) throws JDBCException, GSSException, LoginException {
        Object object;
        Object object2;
        int n;
        Oid[] oidArray;
        Object object3;
        TdgssName tdgssName = null;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.mechOid = oid;
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(this.log);
        String string = null;
        if (this.log.canLog(1)) {
            object3 = TdgssManager.InquireLibraryVersion();
            this.log.info("tdgss version: " + object3.MajorRelease + "." + object3.MinorRelease + "." + object3.MaintenanceRelease + "." + object3.EmergencyRelease);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("java.security.auth.login.config: " + System.getProperty("java.security.auth.login.config"));
            this.log.debug("javax.security.auth.useSubjectCredsOnly: " + System.getProperty("javax.security.auth.useSubjectCredsOnly"));
            object3 = this.getLocalMechs();
            if (object3 != null) {
                this.log.debug(object3);
            }
        }
        object3 = tdgssConfigApi.InquirePropertiesForMech(oid.toString());
        genericTeradataConnection.setAuthMethod(new AuthMechanism(oid.toString(), this.log));
        block26: for (int i = 0; i < ((TdgssMechProp[])object3).length - 1; ++i) {
            if (object3[i] == null) continue;
            switch (object3[i].getIndex()) {
                case 1: {
                    if (object3[i].getValue().compareToIgnoreCase("yes") != 0) continue block26;
                    this.enabled = true;
                    continue block26;
                }
                case 24: {
                    n2 = this.getInt(object3[i].getValue());
                    continue block26;
                }
                case 25: {
                    this.lifetimeCredential = this.getInt(object3[i].getValue());
                    continue block26;
                }
                case 2: {
                    bl = this.getBool(object3[i].getValue());
                    continue block26;
                }
                case 3: {
                    bl2 = this.getBool(object3[i].getValue());
                    continue block26;
                }
                case 41: {
                    bl3 = this.getBool(object3[i].getValue());
                }
            }
        }
        if (!this.enabled) {
            throw ErrorFactory.makeDriverJDBCException("TJ339", oid.toString());
        }
        genericTeradataConnection.setSSOSupported(bl || bl2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("SSOSupported is: " + genericTeradataConnection.getSSOSupported());
        }
        if (!genericTeradataConnection.getSSOSupported() && genericTeradataConnection.getLogonInformation().getUserName().equals("") && genericTeradataConnection.getLogonInformation().getPassword().equals("")) {
            throw ErrorFactory.makeDriverJDBCException("TJ332", tdgssConfigApi.GetInforForMech(oid)[0]);
        }
        if (oid.toString().equals(KRB5_OID)) {
            this.isKerberos = true;
        }
        if ((oidArray = tdgssManager.getNamesForMech(oid)) != null) {
            n = 0;
            for (int i = 0; i < oidArray.length; ++i) {
                if (oidArray[i].equals(GSSName.NT_HOSTBASED_SERVICE)) {
                    object2 = genericTeradataConnection.getIO().getRemoteAddress();
                    object = ((InetAddress)object2).getHostAddress();
                    long l = System.currentTimeMillis();
                    String string2 = ((InetAddress)object2).getCanonicalHostName();
                    if (this.log.canLog(2)) {
                        this.log.timing("getCanonicalHostName for " + object2 + " took " + (System.currentTimeMillis() - l) + " ms and returned " + string2);
                    }
                    String string3 = ((String)object).equals(string2) ? genericTeradataConnection.getMachineName() : string2;
                    String string4 = "TERADATA@" + string3;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("initEncrypt: iaRemote=" + object2 + " sRemoteLiteralIPAddress=" + (String)object + " sRemoteFQDN=" + string2 + " serverNameString=" + string4);
                    }
                    tdgssName = (TdgssName)tdgssManager.createName(string4, GSSName.NT_HOSTBASED_SERVICE, oid);
                    continue;
                }
                if (oidArray[i].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA)) {
                    n = Math.max(n, 2);
                    continue;
                }
                if (oidArray[i].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                    if (!genericTeradataConnection.isUTF_CredentialSupported()) continue;
                    n = Math.max(n, 8);
                    continue;
                }
                if (oidArray[i].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                    if (!genericTeradataConnection.isUTF_CredentialSupported()) continue;
                    n = Math.max(n, 4);
                    continue;
                }
                this.log.debug("Unknown Oid Name Type for Mechanism: " + oidArray[i].toString());
            }
            string = genericTeradataConnection.getlogdata();
            if (bl && bl3) {
                String string5 = genericTeradataConnection.getLogonInformation().getUserName();
                object2 = genericTeradataConnection.getLogonInformation().getPassword();
                if (string5 != null && string5.length() != 0 && object2 != null && ((String)object2).length() != 0) {
                    object = string5 + "@@" + (String)object2;
                    if (string != null) {
                        object = (String)object + " " + string;
                    }
                    string = object;
                    this.usingGeneratedCredentials = true;
                }
            }
            if (string != null && string.length() != 0) {
                switch (n) {
                    case 8: {
                        this.myID = (TdgssName)tdgssManager.createName(string, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16, oid);
                        break;
                    }
                    case 4: {
                        this.myID = (TdgssName)tdgssManager.createName(string, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, oid);
                        break;
                    }
                    case 2: {
                        try {
                            byte[] byArray = null;
                            byArray = string.getBytes(genericTeradataConnection.getCharSet());
                            this.myID = (TdgssName)tdgssManager.createName(byArray, TdgssName.GSS_C_NT_TDAT_MECHDATA, oid);
                            break;
                        }
                        catch (Throwable throwable) {
                            this.transformException(throwable);
                        }
                    }
                }
            }
        }
        if (genericTeradataConnection.getSSOSupported()) {
            if (this.isKerberos) {
                if (string != null && string.length() != 0) {
                    String[] stringArray = string.split("@@", 3);
                    if (stringArray == null || stringArray.length != 2) {
                        throw ErrorFactory.makeDriverJDBCException("TJ345");
                    }
                    try {
                        TeraCallbackHandler teraCallbackHandler = new TeraCallbackHandler(stringArray[0], stringArray[1]);
                        object2 = new LoginContext(this.getClass().getName(), teraCallbackHandler);
                        ((LoginContext)object2).login();
                        this.log.debug("Subject is: " + ((LoginContext)object2).getSubject().toString());
                        Subject.doAs(((LoginContext)object2).getSubject(), this);
                        if (this.log.isDebugEnabled()) {
                            object = ((LoginContext)object2).getSubject().getPrincipals().iterator();
                            this.log.debug("Authenticated user has the following Principals:");
                            while (object.hasNext()) {
                                Principal principal = (Principal)object.next();
                                this.log.debug("\t" + ((Object)principal).toString());
                            }
                            this.log.debug("User has " + ((LoginContext)object2).getSubject().getPublicCredentials().size() + " Public Credential(s)");
                        }
                    }
                    catch (Throwable throwable) {
                        this.transformException(throwable);
                    }
                } else {
                    this.myCred = tdgssManager.createCredential(null, this.lifetimeCredential, oid, 1);
                }
            } else {
                if (string == null || string.length() == 0) {
                    throw ErrorFactory.makeDriverJDBCException("TJ346");
                }
                this.myCred = tdgssManager.createCredential((GSSName)this.myID, this.lifetimeCredential, oid, 1);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Credentials are: " + this.myCred);
        }
        this.context = (TdgssContext)tdgssManager.createContext(tdgssName, oid, this.myCred, n2);
        this.inToken = new byte[0];
        block29: for (n = 0; n < ((TdgssMechProp[])object3).length - 1; ++n) {
            if (object3[n] == null) continue;
            switch (object3[n].getIndex()) {
                case 18: {
                    this.context.requestCredDeleg(this.getBool(object3[n].getValue()));
                    continue block29;
                }
                case 19: {
                    this.context.requestMutualAuth(this.getBool(object3[n].getValue()));
                    continue block29;
                }
                case 20: {
                    this.context.requestReplayDet(this.getBool(object3[n].getValue()));
                    continue block29;
                }
                case 33: {
                    this.context.requestSequenceDet(this.getBool(object3[n].getValue()));
                    continue block29;
                }
                case 21: {
                    this.context.requestConf(this.getBool(object3[n].getValue()));
                    continue block29;
                }
                case 23: {
                    this.context.requestAnonymity(this.getBool(object3[n].getValue()));
                    continue block29;
                }
                case 22: {
                    this.context.requestInteg(this.getBool(object3[n].getValue()));
                }
            }
        }
    }

    public Object run() throws Exception {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        this.myCred = tdgssManager.createCredential((GSSName)this.myID, this.lifetimeCredential, this.mechOid, 1);
        return this.myCred;
    }

    public boolean isEstablished() {
        return this.context.isEstablished();
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws JDBCException {
        long l = System.currentTimeMillis();
        byte[] byArray2 = null;
        try {
            byArray2 = this.context.initSecContext(byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
        if (this.log.canLog(2)) {
            this.log.timing("TdgssContext.initSecContext took " + (System.currentTimeMillis() - l) + " ms");
        }
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) throws JDBCException {
        byte[] byArray2 = null;
        try {
            MessageProp messageProp = new MessageProp(true);
            byArray2 = this.context.wrap(byArray, n, n2, messageProp);
            if (this.log.canLog(1)) {
                this.log.info("TeraEncrypt.encrypt: inBuf.length=" + byArray.length + " offset=" + n + " len=" + n2 + " outToken.length=" + (byArray2 == null ? "null" : "" + byArray2.length) + " expansion=" + (byArray2 == null ? "n/a" : "" + (byArray2.length - n2)));
            }
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws JDBCException {
        byte[] byArray2 = null;
        try {
            MessageProp messageProp = new MessageProp(true);
            byArray2 = this.context.unwrap(byArray, n, n2, messageProp);
            if (this.log.canLog(1)) {
                this.log.info("TeraEncrypt.decrypt: inBuf.length=" + byArray.length + " offset=" + n + " len=" + n2 + " outToken.length=" + (byArray2 == null ? "null" : "" + byArray2.length) + " shrinkage=" + (byArray2 == null ? "n/a" : "" + (n2 - byArray2.length)));
            }
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
        return byArray2;
    }

    public byte[] getIntoken() {
        return this.inToken;
    }

    public void setIntoken(byte[] byArray) {
        this.inToken = byArray;
    }

    public byte getTrip() {
        return this.trip;
    }

    public void incTrip() {
        this.trip = (byte)(this.trip + 2);
    }

    public void showContext() throws SQLException {
        GSSName gSSName;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("Context Information:" + LINE_SEP);
        stringBuffer.append("getAnonymityState: " + this.context.getAnonymityState() + LINE_SEP);
        stringBuffer.append("getConfState: " + this.context.getConfState() + LINE_SEP);
        stringBuffer.append("getConfState: " + this.context.getConfState() + LINE_SEP);
        stringBuffer.append("getCredDelegState: " + this.context.getCredDelegState() + LINE_SEP);
        stringBuffer.append("getLifeTime: " + this.context.getLifetime() + LINE_SEP);
        try {
            stringBuffer.append("getMech: " + this.context.getMech().toString() + LINE_SEP);
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
        stringBuffer.append("getMutualAuthState: " + this.context.getMutualAuthState() + LINE_SEP);
        stringBuffer.append("getReplayDetState: " + this.context.getReplayDetState() + LINE_SEP);
        stringBuffer.append("getSequenceDetState: " + this.context.getSequenceDetState() + LINE_SEP);
        try {
            stringBuffer.append("SrcName is: ");
            gSSName = this.context.getSrcName();
            if (gSSName != null) {
                stringBuffer.append(((Object)gSSName).toString() + LINE_SEP);
            } else {
                stringBuffer.append("undefined" + LINE_SEP);
            }
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
        try {
            stringBuffer.append("TargName is: ");
            gSSName = this.context.getTargName();
            if (gSSName != null) {
                stringBuffer.append(((Object)gSSName).toString() + LINE_SEP);
            } else {
                stringBuffer.append("undefined" + LINE_SEP);
            }
        }
        catch (Throwable throwable) {
            this.transformException(throwable);
        }
        stringBuffer.append("isEstablished: " + this.context.isEstablished() + LINE_SEP);
        stringBuffer.append("isProtReady: " + this.context.isProtReady() + LINE_SEP);
        this.log.debug(stringBuffer);
    }

    public static byte[] getTDgssVersion() {
        TdgssVersion tdgssVersion = TdgssManager.InquireLibraryVersion();
        byte[] byArray = new byte[]{tdgssVersion.MajorRelease, tdgssVersion.MinorRelease, tdgssVersion.MaintenanceRelease, tdgssVersion.EmergencyRelease};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TdgssManager getGSSM(Log log) {
        if (myGSSManager == null) {
            Class clazz = class$com$teradata$jdbc$jdbc$GenericTeraEncrypt == null ? (class$com$teradata$jdbc$jdbc$GenericTeraEncrypt = GenericTeraEncrypt.class$("com.teradata.jdbc.jdbc.GenericTeraEncrypt")) : class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;
            synchronized (clazz) {
                if (myGSSManager == null) {
                    long l = System.currentTimeMillis();
                    myGSSManager = (TdgssManager)TdgssManager.getInstance();
                    long l2 = System.currentTimeMillis();
                    myConfig = new TdgssConfigApi();
                    if (log.canLog(2)) {
                        log.timing("TdgssManager initialization took " + (l2 - l) + " ms, TdgssConfigApi initialization took " + (System.currentTimeMillis() - l2) + " ms");
                    }
                }
            }
        }
        return myGSSManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TdgssConfigApi getConfig(Log log) {
        if (myConfig == null) {
            Class clazz = class$com$teradata$jdbc$jdbc$GenericTeraEncrypt == null ? (class$com$teradata$jdbc$jdbc$GenericTeraEncrypt = GenericTeraEncrypt.class$("com.teradata.jdbc.jdbc.GenericTeraEncrypt")) : class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;
            synchronized (clazz) {
                GenericTeraEncrypt.getGSSM(log);
            }
        }
        return myConfig;
    }

    String dispOidType(Oid oid) {
        if (oid.equals(GSSName.NT_USER_NAME)) {
            return new String("\tNT_USER_NAME");
        }
        if (oid.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            return new String("\tNT_HOSTBASED_SERVICE");
        }
        if (oid.equals(GSSName.NT_EXPORT_NAME)) {
            return new String("\tNT_EXPORT_NAME");
        }
        if (oid.equals(GSSName.NT_ANONYMOUS)) {
            return new String("\tNT_ANONYMOUS");
        }
        if (oid.equals(GSSName.NT_MACHINE_UID_NAME)) {
            return new String("\tNT_MACHINE_UID_NAME");
        }
        if (oid.equals(GSSName.NT_STRING_UID_NAME)) {
            return new String("\tNT_STRING_UID_NAME");
        }
        if (oid.toString().equals(GSS_KERBEROS_PRINCIPALNAME)) {
            return new String("\tNT__ Kerberos Principal Name");
        }
        return new String("\tNT__ Unknown");
    }

    public boolean getBool(String string) {
        return string.equalsIgnoreCase(new String("yes"));
    }

    public int getInt(String string) {
        return string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
    }

    public byte getSSOAuthMethod() {
        if (this.isPreV2R6) {
            return 8;
        }
        return 0;
    }

    public static Oid getOidForName(String string, Log log) {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        Oid[] oidArray = tdgssManager.getMechs();
        for (int i = 0; i < oidArray.length; ++i) {
            String[] stringArray = tdgssConfigApi.GetInforForMech(oidArray[i]);
            if (stringArray[0].compareToIgnoreCase(string) != 0) continue;
            return oidArray[i];
        }
        return null;
    }

    public static String getUserNameForOid(Oid oid, Log log) {
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        String[] stringArray = tdgssConfigApi.GetInforForMech(oid);
        return stringArray[0];
    }

    public String getLocalMechs() {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(this.log);
        Oid[] oidArray = tdgssManager.getMechs();
        if (oidArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Locally defined Mechanisms are:");
        String[][] stringArray = new String[oidArray.length][2];
        for (int i = 0; i < oidArray.length; ++i) {
            String[] stringArray2 = tdgssConfigApi.GetInforForMech(oidArray[i]);
            stringBuffer.append(LINE_SEP + stringArray2[0] + "\t" + oidArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static Oid getClientDefaultMech(Log log) {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        Oid[] oidArray = tdgssManager.getMechs();
        if (oidArray == null) {
            return null;
        }
        for (int i = 0; i < oidArray.length; ++i) {
            if (oidArray[i] == null) continue;
            TdgssMechProp[] tdgssMechPropArray = tdgssConfigApi.InquirePropertiesForMech(oidArray[i].toString());
            boolean bl = false;
            boolean bl2 = false;
            block5: for (int j = 0; j < tdgssMechPropArray.length - 1; ++j) {
                if (tdgssMechPropArray[j] == null) continue;
                switch (tdgssMechPropArray[j].getIndex()) {
                    case 16: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0) continue block5;
                        bl2 = true;
                        continue block5;
                    }
                    case 1: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0) continue block5;
                        bl = true;
                    }
                }
            }
            if (!bl || !bl2) continue;
            if (log.isDebugEnabled()) {
                log.debug("Client Default Mechanism is: " + oidArray[i].toString());
            }
            return oidArray[i];
        }
        return null;
    }

    public boolean isUsingGeneratedCredentials() {
        return this.usingGeneratedCredentials;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

