/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.console;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc.console.ConsoleConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.DataParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PromptParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.RequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class ConsoleStatement
implements Statement,
RowFetchController {
    private ConsoleConnection con = null;
    private Results results = null;
    private String sqlStmt = null;
    private int rowFetchSize;
    private int rowFetchDirection;
    private int maxFetchRows;
    private int maxFetchFieldSize;

    public ConsoleStatement(ConsoleConnection consoleConnection) throws SQLException {
        this.con = consoleConnection;
        this.results = new Results(consoleConnection.getLog());
    }

    private void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.results == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void initReqPacket(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind(by);
        tDPacket.setRequestNumber(n);
    }

    private void initReq(TDPacket tDPacket, String string) throws SQLException {
        RequestParcel requestParcel = new RequestParcel(this.con.getCharSet(), this.con.getLog());
        requestParcel.setRequestText(string);
        tDPacket.addParcel(requestParcel);
    }

    private void initData(TDPacket tDPacket, String string) throws SQLException {
        DataParcel dataParcel = new DataParcel(this.con.getCharSet(), this.con.getLog(), string, true);
        tDPacket.addParcel(dataParcel);
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        ResponseParcel responseParcel = new ResponseParcel(this.con.getCharSet(), this.con.getLog());
        responseParcel.setMaxMsgSize(65104);
        tDPacket.addParcel(responseParcel);
    }

    private void bufferMessage(TDPacket tDPacket, String string) throws SQLException {
        this.initReqPacket(tDPacket, (byte)5, this.con.getRequestNum());
        if (this.con.getPromptMode()) {
            this.initReq(tDPacket, " ");
            this.initData(tDPacket, string);
        } else {
            this.initReq(tDPacket, string);
        }
        this.initResp(tDPacket);
        if (this.con.getEncryptData() && this.con.getAuthMethod() != null) {
            tDPacket.setEncrypted();
        }
        tDPacket.toStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(TDPacket tDPacket) throws SQLException {
        this.con.getLog().debug(tDPacket.getBuffer());
        this.con.getLog().debug("LAN Header request number: " + tDPacket.getRequestNumber());
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireWriteLock();
        try {
            tDPacket.getBuffer().writeStream(tDNetworkIOIF, this.con.getTeraEncrypt());
        }
        finally {
            tDNetworkIOIF.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(TDPacket tDPacket) throws SQLException {
        tDPacket.clear();
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(tDNetworkIOIF, this.con.getTeraEncrypt());
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
        tDPacket.initParcelFactory(this.con.getCharSet(), this.con.getLog());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveResults(ResultSet resultSet) throws SQLException {
        TDPacket tDPacket;
        block15: {
            tDPacket = null;
            try {
                tDPacket = this.con.getPacket();
                this.receiveMessage(tDPacket);
                Parcel parcel = null;
                block11: while (true) {
                    if ((parcel = tDPacket.nextParcel()) == null) {
                        this.con.getLog().error("Did not receive an expected parcel from the database!");
                        throw ErrorFactory.makeIoJDBCException("TJ420", "ConsoleStatement.receiveResults", this.con.getIO(), null, this.con.getLog());
                    }
                    this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
                    switch (parcel.getFlavor()) {
                        case 8: {
                            SuccessParcel successParcel = (SuccessParcel)parcel;
                            continue block11;
                        }
                        case 10: {
                            RecordParcel recordParcel = (RecordParcel)parcel;
                            ResultSetRow resultSetRow = new ResultSetRow();
                            RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
                            while (recordParcelColumnValuesIterator.hasNext()) {
                                resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                            }
                            resultSet.addResultSetRow(resultSetRow);
                            continue block11;
                        }
                        case 11: {
                            EndStatementParcel endStatementParcel = (EndStatementParcel)parcel;
                            continue block11;
                        }
                        case 9: {
                            FailureParcel failureParcel = (FailureParcel)parcel;
                            if (failureParcel.getCode() == 3187) {
                                resultSet.lastRowFetched();
                                this.con.setPromptMode(false);
                                Object var14_11 = null;
                                if (tDPacket == null) return;
                                this.con.returnPacket(tDPacket);
                                return;
                            }
                            this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                            throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                        }
                        case 49: {
                            ErrorParcel errorParcel = (ErrorParcel)parcel;
                            this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                            throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                        }
                        case 12: {
                            EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                            break block15;
                        }
                        case 29: {
                            PromptParcel promptParcel = (PromptParcel)parcel;
                            resultSet.lastRowFetched();
                            this.con.setPromptMode(true);
                            continue block11;
                        }
                        default: {
                            this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                            throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
                        }
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                if (tDPacket == null) throw throwable;
                this.con.returnPacket(tDPacket);
                throw throwable;
            }
        }
        Object var14_12 = null;
        if (tDPacket == null) return;
        this.con.returnPacket(tDPacket);
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    public void close() throws SQLException {
        this.results = null;
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        Object object;
        this.abortIfClosed();
        SQLException sQLException = null;
        this.results.reinit();
        try {
            this.rowFetchSize = this.getFetchSize();
            this.rowFetchDirection = this.getFetchDirection();
            this.maxFetchRows = this.getMaxRows();
            this.maxFetchFieldSize = this.getMaxFieldSize();
            this.sqlStmt = string;
            object = ResultSet.createResultSet(null, this, this.con.getLog());
            ((ResultSet)object).setNumberOfRows(0x7FFFFFFE);
            TeraResultSetMetaData teraResultSetMetaData = new TeraResultSetMetaData(null);
            ColumnProperties columnProperties = new ColumnProperties();
            columnProperties = new ColumnProperties();
            columnProperties.setPrecision(0);
            columnProperties.setScale(0);
            columnProperties.setColumnName(null);
            columnProperties.setColumnLabel(columnProperties.getColumnName());
            columnProperties.setNullable(0);
            columnProperties.setColumnType(12);
            columnProperties.setTdType(448);
            columnProperties.setColumnDisplaySize(64000);
            teraResultSetMetaData.addColumnProperties(columnProperties);
            ((ResultSet)object).setMetaData(teraResultSetMetaData);
            this.results.addResult(null, new Result((ResultSet)object));
            this.fetchRows((ResultSet)object, -1, 1, 0, 0);
        }
        catch (SQLException sQLException2) {
            sQLException = ConsoleStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ531");
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
        return this.getResultSet();
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            ResultSet resultSet = this.results.getResult().getResultSet();
            TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
            teraLocalResultSet.setResultSet(resultSet);
            return teraLocalResultSet;
        }
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void suppressResponseCancel() {
    }

    public void closingResultSet(boolean bl) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchRows(ResultSet resultSet, int n, int n2, int n3, int n4) throws SQLException {
        SQLException sQLException = null;
        TDPacket tDPacket = null;
        try {
            try {
                tDPacket = this.con.getPacket();
                if (resultSet.isBeforeFirst()) {
                    this.bufferMessage(tDPacket, this.sqlStmt);
                } else {
                    this.bufferMessage(tDPacket, " ");
                }
                this.sendMessage(tDPacket);
                this.receiveResults(resultSet);
            }
            catch (SQLException sQLException2) {
                sQLException = ConsoleStatement.chainSQLExceptions(sQLException, sQLException2);
                Object var10_9 = null;
                if (tDPacket != null) {
                    this.con.returnPacket(tDPacket);
                }
                if (sQLException == null) return;
                JDBCException jDBCException2 = ErrorFactory.makeDriverJDBCException("TJ609");
                jDBCException2.setNextException(sQLException);
                throw jDBCException2;
            }
            Object var10_8 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
            if (sQLException == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
            if (sQLException == null) throw throwable;
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ609");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ609");
        jDBCException.setNextException(sQLException);
        throw jDBCException;
    }

    public Object getCloseMutex() {
        return this.con;
    }

    public int getCurrentRequestNumber() {
        return -1;
    }

    public int getCurrentStatementNumber() {
        return this.results.getResultsSize() + 1;
    }

    public int getRowFetchDirection() {
        return this.rowFetchDirection;
    }

    public int getRowFetchSize() {
        return this.rowFetchSize;
    }

    public TDSession getLobSession() {
        return null;
    }

    public int getMaxFetchRows() {
        return this.maxFetchRows;
    }

    public int getMaxFetchFieldSize() {
        return this.maxFetchFieldSize;
    }

    public boolean registerStatement() {
        return true;
    }

    public void unregisterStatement() {
    }
}

