/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastexport;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.fastexport.FastExportManagerPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalPreparedStatement;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FastExportManagerConnection
implements Connection,
LocalEscapeFunctions {
    private Connection appCon = null;
    private String machineName = null;
    private String userName = null;
    private String password = null;
    private URLParameters appUrlParams = null;
    private List fastexports = Collections.synchronizedList(new ArrayList());
    private boolean connected = false;
    private SQLWarning sqlWarnings = null;

    public FastExportManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.appUrlParams = uRLParameters;
        this.appUrlParams.setType("DEFAULT");
        this.appCon = ConnectionFactory.createConnection(string, string2, string3, this.appUrlParams);
        this.connected = true;
    }

    private void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    protected void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = sQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    private boolean isTeradataTypeSupported(TeraResultSetMetaData teraResultSetMetaData) throws SQLException {
        SQLWarning sQLWarning = null;
        block4: for (int i = 1; i <= teraResultSetMetaData.getColumnCount(); ++i) {
            switch (teraResultSetMetaData.getColumnType(i)) {
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    continue block4;
                }
                case 1111: {
                    if (teraResultSetMetaData.getColumnTypeName(i).startsWith("INTERVAL")) continue block4;
                }
                default: {
                    String string = this.isStatementInfoSupported() ? teraResultSetMetaData.getSchemaName(i) + "." + teraResultSetMetaData.getTableName(i) : "";
                    this.getLog().info("Cannot FastExport because a data type of " + teraResultSetMetaData.getColumnTypeName(i) + " in column " + i + " of " + "the selected table " + string + " is not supported!");
                    sQLWarning = ErrorFactory.makeSQLWarning("TJ588", teraResultSetMetaData.getColumnTypeName(i), String.valueOf(i), string);
                    this.chainSQLWarnings(sQLWarning);
                    return false;
                }
            }
        }
        return true;
    }

    private synchronized java.sql.PreparedStatement prepareStatement(java.sql.PreparedStatement preparedStatement, String string) throws SQLException {
        String string2 = this.getURLParameters().getCharSet();
        if (!(string2.equals("ASCII") || string2.equals("UTF8") || string2.equals("UTF16"))) {
            this.getLog().info("Cannot FastExport because the specified Java Character Encoding is not supported: " + string2);
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ570", string2);
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        PreparedStatement preparedStatement2 = ((TeraLocalPreparedStatement)preparedStatement).getPreparedStatement();
        MetaDataList metaDataList = preparedStatement2.getMetaDataList();
        if (metaDataList.size() == 0) {
            this.getLog().info("Cannot FastExport because no metadata is available.");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ629");
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        for (int i = 0; i < metaDataList.size(); ++i) {
            TeraResultSetMetaData teraResultSetMetaData = metaDataList.getMetaDataForStatement(i + 1);
            if (!ActivityAnalyzer.isFastExportCompatible(teraResultSetMetaData.getActivityType())) {
                this.getLog().info("Cannot FastExport because statement is not a SELECT!");
                SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ571");
                this.chainSQLWarnings(sQLWarning);
                return preparedStatement;
            }
            if (this.isTeradataTypeSupported(teraResultSetMetaData)) continue;
            return preparedStatement;
        }
        preparedStatement = new FastExportManagerPreparedStatement(this, this.machineName, this.userName, this.password, preparedStatement, string);
        this.fastexports.add(preparedStatement);
        return preparedStatement;
    }

    protected synchronized void removeStatement(Object object) {
        this.fastexports.remove(object);
    }

    protected URLParameters getURLParameters() {
        return this.appUrlParams;
    }

    protected Log getLog() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getLog();
    }

    protected boolean isStatementInfoSupported() {
        return ((TeraLocalConnection)this.appCon).getTDSession().isStatementInfoSupported();
    }

    private LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public synchronized String getLogonSequenceNumber() {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.fastexports.size(); ++i) {
            FastExportManagerPreparedStatement fastExportManagerPreparedStatement = (FastExportManagerPreparedStatement)this.fastexports.get(i);
            if (!fastExportManagerPreparedStatement.isConnected()) continue;
            if (!bl) {
                string = string + ",";
            } else {
                bl = false;
            }
            string = string + fastExportManagerPreparedStatement.hashCode() + ",";
            string = string + fastExportManagerPreparedStatement.getLogonSequenceNumber();
        }
        return string;
    }

    public String getAMPCount() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getAMPCount();
    }

    public String getLogLevel() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getLogLevel();
    }

    public String setLogLevel(String string) {
        return ((TeraLocalConnection)this.appCon).getTDSession().setLogLevel(string);
    }

    public String beginCapture() {
        return ((TeraLocalConnection)this.appCon).getTDSession().beginCapture();
    }

    public String endCapture() {
        return ((TeraLocalConnection)this.appCon).getTDSession().endCapture();
    }

    public String useAnsiDate() {
        return ((TeraLocalConnection)this.appCon).getTDSession().useAnsiDate();
    }

    public String useIntegerDate() {
        return ((TeraLocalConnection)this.appCon).getTDSession().useIntegerDate();
    }

    public String getSessionNumber() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getSessionNumber();
    }

    public String getSocketInfo() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getSocketInfo();
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.sqlWarnings = null;
        this.appCon.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            ArrayList arrayList = new ArrayList(this.fastexports);
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FastExportManagerPreparedStatement fastExportManagerPreparedStatement = (FastExportManagerPreparedStatement)arrayList.get(i);
                    try {
                        fastExportManagerPreparedStatement.close();
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ595", i, arrayList.size());
                        sQLException = FastExportManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                        sQLException = FastExportManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                        continue;
                    }
                    finally {
                        this.removeStatement(fastExportManagerPreparedStatement);
                    }
                }
                this.appCon.close();
            }
            catch (SQLException sQLException3) {
                sQLException = FastExportManagerConnection.chainSQLExceptions(sQLException, sQLException3);
            }
            finally {
                this.connected = false;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ596");
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    public void commit() throws SQLException {
        this.abortIfClosed();
        this.appCon.commit();
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        return this.appCon.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.appCon.createStatement(n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.appCon.createStatement(n, n2, n3);
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getCatalog();
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        this.chainSQLWarnings(this.appCon.getWarnings());
        this.appCon.clearWarnings();
        return this.sqlWarnings;
    }

    public boolean isClosed() throws SQLException {
        return !this.connected;
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return this.appCon.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        return this.appCon.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.appCon.prepareCall(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.appCon.prepareCall(string, n, n2, n3);
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string), string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, n), string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, nArray), string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, n, n2), string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, n, n2, n3), string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, stringArray), string);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        this.appCon.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.abortIfClosed();
        this.appCon.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        this.appCon.rollback(savepoint);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.appCon.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
        this.appCon.setCatalog(string);
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
        this.appCon.setHoldability(n);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.appCon.setReadOnly(bl);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        return this.appCon.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        return this.appCon.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
        this.appCon.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
        this.appCon.setTypeMap(map);
    }
}

