/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastexport;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc.fastexport.FastExportManagerConnection;
import com.teradata.jdbc.jdbc.fastexport.FastExportPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketPool;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;

public class FastExportManagerPreparedStatement
implements java.sql.PreparedStatement,
RowFetchController {
    private Connection managerCon = null;
    private java.sql.PreparedStatement appPstmt = null;
    private Connection controlCon = null;
    private Connection[] fastexportCons = null;
    private boolean fastexporting = false;
    private String machineName = null;
    private String userName = null;
    private String password = null;
    private String selectStmt = null;
    private Results results = null;
    private TDPacket[] resultsPacket = null;
    private Statement controlStmt = null;
    private java.sql.PreparedStatement controlPstmt = null;
    private Object[] boundParam = new Object[2000];
    private BitSet boundParamColumn = new BitSet(2000);
    private java.sql.PreparedStatement[] fastexportPrepStmts = null;
    private boolean closed = false;
    private boolean connected = false;
    private SQLWarning sqlWarnings = null;
    private int rowFetchSize;
    private int rowFetchDirection;
    private int maxFetchRows;
    private int maxFetchFieldSize;
    private int blkNumber;
    private int blkNumberLastReceived;
    private int blkNumberLastDeserialized;
    private int stmtNumber;
    private ArrayList rsmdList = new ArrayList();
    private ArrayList blockCountList = new ArrayList();
    public static final int MAX_COLUMN_COUNT = 2000;

    public FastExportManagerPreparedStatement(FastExportManagerConnection fastExportManagerConnection, String string, String string2, String string3, java.sql.PreparedStatement preparedStatement, String string4) throws SQLException {
        this.managerCon = fastExportManagerConnection;
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.selectStmt = string4;
        this.appPstmt = preparedStatement;
        this.results = new Results(fastExportManagerConnection.getLog());
    }

    private void abortIfClosed() throws SQLException {
        if (this.managerCon.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.closed) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > 2000) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private void saveBoundParam(int n, Object object) throws SQLException {
        this.abortIfIndexNotValid(n);
        this.boundParam[n - 1] = object;
        this.boundParamColumn.set(n - 1);
    }

    private void initializeFastExport() throws SQLException {
        try {
            boolean bl = this.fastexporting;
            if (bl) {
                this.closeFastExport();
            }
            this.connectFastExport();
            if (bl && this.boundParamColumn.length() != 0) {
                for (int i = 0; i < this.boundParamColumn.length(); ++i) {
                    int n;
                    Object object = this.boundParam[i];
                    if (object instanceof TypedNull) {
                        n = ((TypedNull)object).getType();
                        this.controlPstmt.setNull(i + 1, n);
                        continue;
                    }
                    if (object instanceof ObjectWithCalendar) {
                        n = ((ObjectWithCalendar)object).getType();
                        Calendar calendar = ((ObjectWithCalendar)object).getCalendar();
                        if ((object = ((ObjectWithCalendar)object).getObject()) instanceof Time || n == 92) {
                            this.controlPstmt.setTime(i + 1, (Time)object, calendar);
                            continue;
                        }
                        if (!(object instanceof Timestamp) && n != 93) continue;
                        this.controlPstmt.setTimestamp(i + 1, (Timestamp)object, calendar);
                        continue;
                    }
                    if (object instanceof ObjectWithScale) {
                        n = ((ObjectWithScale)object).getType();
                        int n2 = ((ObjectWithScale)object).getScale();
                        object = ((ObjectWithScale)object).getObject();
                        this.controlPstmt.setObject(i + 1, object, n, n2);
                        continue;
                    }
                    if (object instanceof ObjectWithoutScale) {
                        n = ((ObjectWithoutScale)object).getType();
                        object = ((ObjectWithoutScale)object).getObject();
                        this.controlPstmt.setObject(i + 1, object, n);
                        continue;
                    }
                    this.controlPstmt.setObject(i + 1, object);
                }
            }
        }
        catch (SQLException sQLException) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ574", this.selectStmt);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = sQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    private void connectFastExport() throws SQLException {
        if (!this.connected) {
            SQLException sQLException = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                int n5;
                URLParameters uRLParameters = ((FastExportManagerConnection)this.managerCon).getURLParameters();
                URLParameters uRLParameters2 = new URLParameters("LOG=" + uRLParameters.getLogLevel() + "," + "DBS_PORT" + "=" + uRLParameters.getDbsPort() + "," + "COP" + "=" + (uRLParameters.getCopDiscovery() ? "ON" : "OFF") + "," + "CONNECT_FAILURE_TTL" + "=" + uRLParameters.getConnectFailureTTL() + "," + "TCP" + "=" + uRLParameters.getTCP() + "," + "charset" + "=" + uRLParameters.getCharSet() + "," + "ENCRYPTDATA" + "=" + (uRLParameters.getEncryptData() ? "ON" : "OFF") + (uRLParameters.getLogMech() != null ? ",LOGMECH=" + uRLParameters.getLogMech() : "") + (uRLParameters.getLogData() != null ? ",LOGDATA='" + uRLParameters.getLogData() + "'" : "") + "," + "tmode" + "=TERA" + (uRLParameters.isGoverned() ? ",LSS_TYPE=E" : "") + "," + "TYPE_NAME_METADATA" + "=" + "ON" + "," + "CONNECT_FUNCTION" + "=" + 1);
                this.controlCon = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters2);
                this.controlStmt = this.controlCon.createStatement();
                this.controlPstmt = this.controlCon.prepareStatement(this.selectStmt);
                PreparedStatement preparedStatement = ((TeraLocalPreparedStatement)this.controlPstmt).getPreparedStatement();
                preparedStatement.setRequestMode((byte)73);
                MetaDataList metaDataList = preparedStatement.getMetaDataList();
                for (int i = 0; i < metaDataList.size(); ++i) {
                    TeraResultSetMetaData teraResultSetMetaData = metaDataList.getMetaDataForStatement(i + 1);
                    if (ActivityAnalyzer.isFastExportCompatible(teraResultSetMetaData.getActivityType())) continue;
                    throw ErrorFactory.makeDriverJDBCException("TJ571");
                }
                n2 = uRLParameters.getSessions();
                n = Integer.parseInt(this.controlCon.nativeSQL("{fn teradata_amp_count()}"));
                URLParameters uRLParameters3 = new URLParameters("LOG=" + uRLParameters.getLogLevel() + "," + "DBS_PORT" + "=" + uRLParameters.getDbsPort() + "," + "COP" + "=" + (uRLParameters.getCopDiscovery() ? "ON" : "OFF") + "," + "CONNECT_FAILURE_TTL" + "=" + uRLParameters.getConnectFailureTTL() + "," + "TCP" + "=" + uRLParameters.getTCP() + "," + "charset" + "=" + uRLParameters.getCharSet() + "," + "ENCRYPTDATA" + "=" + (uRLParameters.getEncryptData() ? "ON" : "OFF") + (uRLParameters.getLogMech() != null ? ",LOGMECH=" + uRLParameters.getLogMech() : "") + (uRLParameters.getLogData() != null ? ",LOGDATA='" + uRLParameters.getLogData() + "'" : "") + (uRLParameters.isGoverned() ? ",LSS_TYPE=E" : "") + "," + "PARTITION" + "=" + "EXPORT" + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.controlCon.nativeSQL("{fn teradata_logon_sequence_number()}"));
                this.fastexportCons = new Connection[n2 < n ? n2 : n];
                for (n5 = 0; n5 < this.fastexportCons.length; ++n5) {
                    this.fastexportCons[n5] = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters3);
                    ++n3;
                }
                this.resultsPacket = new TDPacket[this.fastexportCons.length];
                for (n5 = 0; n5 < this.resultsPacket.length; ++n5) {
                    this.resultsPacket[n5] = TDPacketPool.getInstance().getTDPacket(((FastExportManagerConnection)this.managerCon).getLog());
                }
                this.fastexportPrepStmts = new java.sql.PreparedStatement[this.fastexportCons.length];
                for (n5 = 0; n5 < this.fastexportPrepStmts.length; ++n5) {
                    this.fastexportPrepStmts[n5] = this.fastexportCons[n5].prepareStatement(null);
                    if (n5 > 0) {
                        ((FastExportPreparedStatement)this.fastexportPrepStmts[n5]).shareWorkingMetadata((FastExportPreparedStatement)this.fastexportPrepStmts[0]);
                    }
                    ++n4;
                }
                ((FastExportManagerConnection)this.managerCon).getLog().info("FastExport found " + n + " AMP(s) in " + this.machineName + " and created " + n3 + " FastExportConnection(s) and " + n4 + " FastExportPreparedStatement(s) with SESSIONS=" + n2 + ".");
                this.connected = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                try {
                    this.closeFastExport();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ575", this.selectStmt, String.valueOf(n), String.valueOf(n3), String.valueOf(n4), String.valueOf(n2));
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFastExport() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            try {
                JDBCException jDBCException;
                try {
                    this.endFastExport();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                if (this.resultsPacket != null) {
                    for (int i = 0; i < this.resultsPacket.length; ++i) {
                        if (this.resultsPacket[i] == null) continue;
                        TDPacketPool.getInstance().returnTDPacket(this.resultsPacket[i], ((FastExportManagerConnection)this.managerCon).getLog());
                    }
                }
                if (this.fastexportPrepStmts != null) {
                    for (int i = 0; i < this.fastexportPrepStmts.length; ++i) {
                        if (this.fastexportPrepStmts[i] == null) continue;
                        try {
                            this.fastexportPrepStmts[i].close();
                            continue;
                        }
                        catch (SQLException sQLException3) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ576", i, this.fastexportPrepStmts.length);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                        }
                    }
                }
                if (this.controlStmt != null) {
                    try {
                        this.controlStmt.close();
                    }
                    catch (SQLException sQLException4) {
                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                    }
                }
                if (this.controlPstmt != null) {
                    try {
                        this.controlPstmt.close();
                    }
                    catch (SQLException sQLException5) {
                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                    }
                }
                if (this.fastexportCons != null) {
                    for (int i = 0; i < this.fastexportCons.length; ++i) {
                        if (this.fastexportCons[i] == null) continue;
                        try {
                            this.fastexportCons[i].close();
                            continue;
                        }
                        catch (SQLException sQLException6) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ577", i, this.fastexportCons.length);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                        }
                    }
                }
                if (this.controlCon != null) {
                    try {
                        this.controlCon.close();
                    }
                    catch (SQLException sQLException7) {
                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
                    }
                }
                Object var6_15 = null;
                this.connected = false;
                this.resultsPacket = null;
                this.fastexportPrepStmts = null;
                this.controlStmt = null;
                this.controlPstmt = null;
                this.fastexportCons = null;
                this.controlCon = null;
            }
            catch (Throwable throwable) {
                Object var6_16 = null;
                this.connected = false;
                this.resultsPacket = null;
                this.fastexportPrepStmts = null;
                this.controlStmt = null;
                this.controlPstmt = null;
                this.fastexportCons = null;
                this.controlCon = null;
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ578", this.selectStmt);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    private void beginFastExport() throws SQLException {
        if (this.connected && !this.fastexporting) {
            SQLException sQLException = null;
            try {
                this.controlStmt.executeUpdate("BEGIN FASTEXPORT");
                this.controlPstmt.execute();
                this.fastexporting = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ580", this.selectStmt);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFastExport() throws SQLException {
        if (this.connected && this.fastexporting) {
            SQLException sQLException = null;
            try {
                this.receiveResultsPreviouslyRequested();
                this.controlStmt.executeUpdate("END FASTEXPORT");
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            finally {
                this.fastexporting = false;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ581", this.selectStmt);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    private void clearFastExportParameters() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            for (int i = 0; i < this.fastexportPrepStmts.length; ++i) {
                try {
                    this.fastexportPrepStmts[i].clearParameters();
                    continue;
                }
                catch (SQLException sQLException2) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ576", i, this.fastexportPrepStmts.length);
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ584", this.selectStmt);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    protected String getLogonSequenceNumber() {
        if (this.connected) {
            return ((TeraLocalConnection)this.controlCon).getTDSession().getLogonSequenceNumber();
        }
        return "";
    }

    protected boolean isConnected() {
        return this.connected;
    }

    private void receiveResultsPreviouslyRequested() throws SQLException {
        if (this.blkNumber != 0 && this.blkNumber - 1 != this.blkNumberLastReceived) {
            long l = (long)this.stmtNumber << 32;
            int n = (Integer)this.blockCountList.get(this.stmtNumber - 1);
            int n2 = n < this.fastexportPrepStmts.length ? n : this.fastexportPrepStmts.length;
            int n3 = 0;
            while (this.blkNumberLastReceived < n && n3 < n2) {
                try {
                    ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).receiveResults(this.resultsPacket[n3]);
                }
                catch (SQLException sQLException) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ586", Long.toHexString(l + (long)this.blkNumberLastReceived + 1L), String.valueOf(n), String.valueOf(n3), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n2));
                    jDBCException.setNextException(sQLException);
                    throw jDBCException;
                }
                ++n3;
                ++this.blkNumberLastReceived;
            }
        }
    }

    public void suppressResponseCancel() {
    }

    public void closingResultSet(boolean bl) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchRows(ResultSet resultSet, int n, int n2, int n3, int n4) throws SQLException {
        SQLException sQLException;
        block31: {
            block30: {
                block29: {
                    block28: {
                        sQLException = null;
                        try {
                            try {
                                JDBCException jDBCException;
                                int n5;
                                this.receiveResultsPreviouslyRequested();
                                if (this.stmtNumber != n2) {
                                    if (this.stmtNumber != 0) {
                                        this.clearFastExportParameters();
                                    }
                                    this.blkNumber = 1;
                                    this.blkNumberLastReceived = 0;
                                    this.blkNumberLastDeserialized = 0;
                                    this.stmtNumber = n2;
                                }
                                ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.rsmdList.get(this.stmtNumber - 1);
                                long l = (long)this.stmtNumber << 32;
                                int n6 = (Integer)this.blockCountList.get(this.stmtNumber - 1);
                                int n7 = n6 < this.fastexportPrepStmts.length ? n6 : this.fastexportPrepStmts.length;
                                boolean[] blArray = new boolean[this.fastexportPrepStmts.length];
                                if (this.blkNumber == 1) {
                                    for (n5 = 1; n5 <= resultSetMetaData.getColumnCount(); ++n5) {
                                        ((FastExportManagerConnection)this.managerCon).getLog().info("FastExport " + (((FastExportManagerConnection)this.managerCon).isStatementInfoSupported() ? resultSetMetaData.getSchemaName(n5) + "." + resultSetMetaData.getTableName(n5) : "") + " Col " + n5 + " " + resultSetMetaData.getColumnName(n5) + " as " + resultSetMetaData.getColumnTypeName(n5) + ".");
                                        this.fastexportPrepStmts[0].setString(n5, resultSetMetaData.getColumnTypeName(n5));
                                    }
                                    ((FastExportManagerConnection)this.managerCon).getLog().info("FastExport will use " + n7 + " FastExportPreparedStatement(s) to select data for statement " + this.stmtNumber + " with blkCnt=" + n6 + ".");
                                    for (n5 = 0; n5 < n7; ++n5) {
                                        ((FastExportPreparedStatement)this.fastexportPrepStmts[n5]).shareResults(this.results, this.stmtNumber - 1);
                                    }
                                }
                                for (n5 = 0; this.blkNumber <= n6 && n5 < n7 && sQLException == null; ++n5, ++this.blkNumber) {
                                    try {
                                        this.fastexportPrepStmts[n5].setLong(resultSetMetaData.getColumnCount() + 1, l + (long)this.blkNumber);
                                        ((FastExportPreparedStatement)this.fastexportPrepStmts[n5]).requestResults();
                                        continue;
                                    }
                                    catch (SQLException sQLException2) {
                                        jDBCException = ErrorFactory.makeDriverJDBCException("TJ585", Long.toHexString(l + (long)this.blkNumber), String.valueOf(n6), String.valueOf(n5), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n7));
                                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                                        blArray[n5] = true;
                                    }
                                }
                                if (this.blkNumberLastReceived == 0) {
                                    for (n5 = 0; this.blkNumberLastReceived < n6 && n5 < n7; ++n5, ++this.blkNumberLastReceived) {
                                        if (blArray[n5]) {
                                            Object var17_20 = null;
                                            if (sQLException == null) return;
                                            break block28;
                                        }
                                        try {
                                            ((FastExportPreparedStatement)this.fastexportPrepStmts[n5]).receiveResults(this.resultsPacket[n5]);
                                            continue;
                                        }
                                        catch (SQLException sQLException3) {
                                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ586", Long.toHexString(l + (long)this.blkNumberLastReceived + 1L), String.valueOf(n6), String.valueOf(n5), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n7));
                                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                                        }
                                    }
                                    for (n5 = 0; this.blkNumber <= n6 && n5 < n7; ++n5, ++this.blkNumber) {
                                        if (sQLException != null) {
                                            break block29;
                                        }
                                        try {
                                            this.fastexportPrepStmts[n5].setLong(resultSetMetaData.getColumnCount() + 1, l + (long)this.blkNumber);
                                            ((FastExportPreparedStatement)this.fastexportPrepStmts[n5]).requestResults();
                                            continue;
                                        }
                                        catch (SQLException sQLException4) {
                                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ585", Long.toHexString(l + (long)this.blkNumber), String.valueOf(n6), String.valueOf(n5), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n7));
                                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                                        }
                                    }
                                }
                                for (n5 = 0; this.blkNumberLastDeserialized < n6 && n5 < n7; ++n5, ++this.blkNumberLastDeserialized) {
                                    if (sQLException != null) {
                                        break block30;
                                    }
                                    try {
                                        ((FastExportPreparedStatement)this.fastexportPrepStmts[n5]).deserializeResults(this.resultsPacket[n5]);
                                        continue;
                                    }
                                    catch (SQLException sQLException5) {
                                        jDBCException = ErrorFactory.makeDriverJDBCException("TJ587", Long.toHexString(l + (long)this.blkNumberLastDeserialized + 1L), String.valueOf(n6), String.valueOf(n5), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n7));
                                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                                    }
                                }
                                if (this.blkNumber - 1 == this.blkNumberLastDeserialized) {
                                    this.results.getResult(this.stmtNumber - 1).getResultSet().lastRowFetched();
                                }
                                break block31;
                            }
                            catch (SQLException sQLException6) {
                                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                                Object var17_24 = null;
                                if (sQLException == null) return;
                                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
                                jDBCException.setNextException(sQLException);
                                throw jDBCException;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_25 = null;
                            if (sQLException != null) {
                                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
                                jDBCException.setNextException(sQLException);
                                throw jDBCException;
                            }
                            throw throwable;
                        }
                    }
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
                    jDBCException.setNextException(sQLException);
                    throw jDBCException;
                }
                Object var17_21 = null;
                if (sQLException == null) return;
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
            Object var17_22 = null;
            if (sQLException == null) return;
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
        Object var17_23 = null;
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public Object getCloseMutex() {
        return this.managerCon;
    }

    public int getCurrentRequestNumber() {
        return -1;
    }

    public int getCurrentStatementNumber() {
        return this.results.getResultsSize() + 1;
    }

    public int getRowFetchDirection() {
        return this.rowFetchDirection;
    }

    public int getRowFetchSize() {
        return this.rowFetchSize;
    }

    public TDSession getLobSession() {
        return null;
    }

    public int getMaxFetchRows() {
        return this.maxFetchRows;
    }

    public int getMaxFetchFieldSize() {
        return this.maxFetchFieldSize;
    }

    public boolean registerStatement() {
        return this.fastexporting;
    }

    public void unregisterStatement() {
    }

    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ573");
    }

    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        for (int i = 0; i < this.boundParamColumn.length(); ++i) {
            this.boundParam[i] = null;
        }
        this.boundParamColumn.clear();
        this.clearFastExportParameters();
    }

    public boolean execute() throws SQLException {
        Object object;
        this.abortIfClosed();
        this.initializeFastExport();
        SQLException sQLException = null;
        try {
            this.clearWarnings();
            this.results.reinit();
            this.beginFastExport();
            this.rsmdList.clear();
            this.blockCountList.clear();
            do {
                this.rsmdList.add(this.controlPstmt.getMetaData());
                this.blockCountList.add(new Integer(this.controlPstmt.getUpdateCount()));
            } while (this.controlPstmt.getMoreResults() || this.controlPstmt.getUpdateCount() >= 0);
            this.rowFetchSize = this.getFetchSize();
            this.rowFetchDirection = this.getFetchDirection();
            this.maxFetchRows = this.getMaxRows();
            this.maxFetchFieldSize = this.getMaxFieldSize();
            object = ((TeraLocalPreparedStatement)this.appPstmt).getPreparedStatement();
            MetaDataList metaDataList = ((com.teradata.jdbc.jdbc_4.Statement)object).getMetaDataList();
            for (int i = 0; i < metaDataList.size(); ++i) {
                ResultSet resultSet = ResultSet.createResultSet(null, this, ((FastExportManagerConnection)this.managerCon).getLog(), metaDataList.getMetaDataForStatement(i + 1));
                int n = (Integer)this.blockCountList.get(i);
                resultSet.setNumberOfRows(n == 0 ? 0 : 0x7FFFFFFE);
                this.results.addResult(null, new Result(resultSet));
            }
            this.stmtNumber = 0;
            this.blkNumber = 0;
            this.blkNumberLastReceived = 0;
            this.blkNumberLastDeserialized = 0;
            this.fetchRows(null, -1, 1, 0, 0);
        }
        catch (SQLException sQLException2) {
            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ579", this.selectStmt);
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
        return true;
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        PreparedStatement preparedStatement = ((TeraLocalPreparedStatement)this.appPstmt).getPreparedStatement();
        MetaDataList metaDataList = preparedStatement.getMetaDataList();
        if (metaDataList.size() > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ572", this.selectStmt);
        }
        this.execute();
        return this.getResultSet();
    }

    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getParameterMetaData();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.saveBoundParam(n, bigDecimal);
        }
        this.initializeFastExport();
        this.controlPstmt.setBigDecimal(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Byte(by));
        this.initializeFastExport();
        this.controlPstmt.setByte(n, by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        if (byArray == null) {
            this.setNull(n, -3);
        } else {
            this.saveBoundParam(n, byArray);
        }
        this.initializeFastExport();
        this.controlPstmt.setBytes(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        if (date == null) {
            this.setNull(n, 91);
        } else {
            this.saveBoundParam(n, date);
        }
        this.initializeFastExport();
        this.controlPstmt.setDate(n, date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Double(d));
        this.initializeFastExport();
        this.controlPstmt.setDouble(n, d);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Float(f));
        this.initializeFastExport();
        this.controlPstmt.setFloat(n, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Integer(n2));
        this.initializeFastExport();
        this.controlPstmt.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Long(l));
        this.initializeFastExport();
        this.controlPstmt.setLong(n, l);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new TypedNull(n2));
        this.initializeFastExport();
        this.controlPstmt.setNull(n, n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, object);
        this.initializeFastExport();
        this.controlPstmt.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new ObjectWithoutScale(object, n2));
        this.initializeFastExport();
        this.controlPstmt.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new ObjectWithScale(object, n2, n3));
        this.initializeFastExport();
        this.controlPstmt.setObject(n, object, n2, n3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Short(s));
        this.initializeFastExport();
        this.controlPstmt.setShort(n, s);
    }

    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        if (string == null) {
            this.setNull(n, 12);
        } else {
            this.saveBoundParam(n, string);
        }
        this.initializeFastExport();
        this.controlPstmt.setString(n, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        if (time == null && calendar == null) {
            this.setNull(n, 92);
        } else if (time == null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(null, calendar, 92));
        } else if (time != null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(time, calendar, 92));
        } else if (time != null && calendar == null) {
            this.saveBoundParam(n, time);
        }
        this.initializeFastExport();
        this.controlPstmt.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        if (timestamp == null && calendar == null) {
            this.setNull(n, 93);
        } else if (timestamp == null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(null, calendar, 93));
        } else if (timestamp != null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(timestamp, calendar, 93));
        } else if (timestamp != null && calendar == null) {
            this.saveBoundParam(n, timestamp);
        }
        this.initializeFastExport();
        this.controlPstmt.setTimestamp(n, timestamp, calendar);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ573");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.sqlWarnings = null;
        if (this.connected) {
            this.controlStmt.clearWarnings();
            this.controlPstmt.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        SQLException sQLException = null;
        try {
            try {
                try {
                    this.closeFastExport();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                this.appPstmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                Object var4_6 = null;
                this.closed = true;
                this.boundParam = null;
                this.boundParamColumn = null;
                ((FastExportManagerConnection)this.managerCon).removeStatement(this);
            }
            Object var4_5 = null;
            this.closed = true;
            this.boundParam = null;
            this.boundParamColumn = null;
            ((FastExportManagerConnection)this.managerCon).removeStatement(this);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.closed = true;
            this.boundParam = null;
            this.boundParamColumn = null;
            ((FastExportManagerConnection)this.managerCon).removeStatement(this);
            throw throwable;
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ582", this.selectStmt);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ573");
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.managerCon;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchSize();
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            ResultSet resultSet = this.results.getResult().getResultSet();
            TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet(this, ((FastExportManagerConnection)this.managerCon).getURLParameters().getJavaEnCoding());
            teraLocalResultSet.setResultSet(resultSet);
            return teraLocalResultSet;
        }
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        if (this.connected) {
            this.chainSQLWarnings(this.controlStmt.getWarnings());
            this.controlStmt.clearWarnings();
            this.chainSQLWarnings(this.controlPstmt.getWarnings());
            this.controlPstmt.clearWarnings();
        }
        return this.sqlWarnings;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchSize(n);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxFieldSize(n);
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxRows(n);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    private static class ObjectWithCalendar {
        private Object obj;
        private Calendar cal;
        private int type;

        public ObjectWithCalendar(Object object, Calendar calendar, int n) {
            this.obj = object;
            this.cal = calendar;
            this.type = n;
        }

        public Object getObject() {
            return this.obj;
        }

        public Calendar getCalendar() {
            return this.cal;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class ObjectWithoutScale {
        private Object obj;
        private int type;

        public ObjectWithoutScale(Object object, int n) {
            this.obj = object;
            this.type = n;
        }

        public Object getObject() {
            return this.obj;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class ObjectWithScale {
        private Object obj;
        private int type;
        private int scale;

        public ObjectWithScale(Object object, int n, int n2) {
            this.obj = object;
            this.type = n;
            this.scale = n2;
        }

        public Object getObject() {
            return this.obj;
        }

        public int getType() {
            return this.type;
        }

        public int getScale() {
            return this.scale;
        }
    }

    private static class TypedNull {
        private int type;

        public TypedNull(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }
    }
}

