/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastexport;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc.fastexport.FastExportConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.RequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.StringTokenizer;

public class FastExportPreparedStatement
implements PreparedStatement {
    private FastExportConnection con = null;
    private Results results = null;
    private int resultsIndex = -1;
    private Object[] workingMetadata = new Object[2000];
    private BitSet workingMetadataColumn = new BitSet(2000);
    private long statementBlockCount = 0L;
    private int statementBlockCountParameterIndex = 0;
    public static final int MAX_COLUMN_COUNT = 2000;

    public FastExportPreparedStatement(FastExportConnection fastExportConnection) throws SQLException {
        this.con = fastExportConnection;
        this.results = new Results(fastExportConnection.getLog());
    }

    private void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.workingMetadata == null || this.workingMetadataColumn == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > 2000) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void initReqPacket(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind(by);
        tDPacket.setRequestNumber(n);
    }

    private void initReq(TDPacket tDPacket) throws SQLException {
        RequestParcel requestParcel = new RequestParcel(this.con.getCharSet(), this.con.getLog());
        byte[] byArray = new byte[8];
        ByteConverter.putLong(byArray, 0, this.statementBlockCount);
        requestParcel.setRequestText(byArray);
        tDPacket.addParcel(requestParcel);
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        ResponseParcel responseParcel = new ResponseParcel(this.con.getCharSet(), this.con.getLog());
        responseParcel.setMaxMsgSize(65104);
        tDPacket.addParcel(responseParcel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestResults() throws SQLException {
        TDPacket tDPacket = null;
        try {
            tDPacket = this.con.getPacket();
            this.initReqPacket(tDPacket, (byte)5, this.con.getRequestNum());
            this.initReq(tDPacket);
            this.initResp(tDPacket);
            if (this.con.getEncryptData() && this.con.getAuthMethod() != null) {
                tDPacket.setEncrypted();
            }
            tDPacket.toStream();
            this.con.getLog().debug(tDPacket.getBuffer());
            this.con.getLog().debug("LAN Header request number: " + tDPacket.getRequestNumber());
            TDNetworkIOIF tDNetworkIOIF = null;
            try {
                tDNetworkIOIF = this.con.getIO();
                tDNetworkIOIF.acquireWriteLock();
                tDPacket.getBuffer().writeStream(tDNetworkIOIF, this.con.getTeraEncrypt());
            }
            finally {
                if (tDNetworkIOIF != null) {
                    tDNetworkIOIF.releaseWriteLock();
                }
            }
            Object var5_4 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveResults(TDPacket tDPacket) throws SQLException {
        tDPacket.clear();
        TDNetworkIOIF tDNetworkIOIF = null;
        try {
            tDNetworkIOIF = this.con.getIO();
            tDNetworkIOIF.acquireReadLock();
            tDPacket.getBuffer().readStream(tDNetworkIOIF, this.con.getTeraEncrypt());
        }
        finally {
            if (tDNetworkIOIF != null) {
                tDNetworkIOIF.releaseReadLock();
            }
        }
        tDPacket.initParcelFactory(this.con.getCharSet(), this.con.getLog());
    }

    protected void deserializeResults(TDPacket tDPacket) throws SQLException {
        ResultSet resultSet = null;
        ResultSetRow resultSetRow = null;
        Parcel parcel = null;
        block9: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                this.con.getLog().error("Did not receive an expected parcel from the database!");
                throw ErrorFactory.makeIoJDBCException("TJ420", "FastExportPreparedStatement.receiveResults", this.con.getIO(), null, this.con.getLog());
            }
            this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
            switch (parcel.getFlavor()) {
                case 8: {
                    Object object;
                    int n;
                    SuccessParcel successParcel = (SuccessParcel)parcel;
                    int n2 = n = successParcel.getActivityCount() < 0 ? Integer.MAX_VALUE : successParcel.getActivityCount();
                    if (this.resultsIndex < 0) {
                        resultSet = ResultSet.createResultSet(null, null, this.con.getLog());
                        resultSet.setNumberOfRows(n);
                    } else {
                        resultSet = this.results.getResult(this.resultsIndex).getResultSet();
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < this.workingMetadataColumn.length(); ++i) {
                        arrayList.add(this.workingMetadata[i]);
                    }
                    StatementInfoParcel statementInfoParcel = new StatementInfoParcel(this.con.getCharSet(), this.con.getLog(), arrayList);
                    tDPacket.setParcelFactoryPrepInfo(statementInfoParcel);
                    if (this.resultsIndex >= 0) continue block9;
                    Object object2 = new TeraResultSetMetaData(null);
                    Object object3 = statementInfoParcel.getPrepInfoItemIterator();
                    while (((PrepInfoParcel.PrepInfoItemIterator)object3).hasNext()) {
                        object = new ColumnProperties();
                        ((ColumnProperties)object).initWithPrepInfoItem(((PrepInfoParcel.PrepInfoItemIterator)object3).next(), this.con.getSessionJavaCharSet());
                        ((TeraResultSetMetaData)object2).addColumnProperties((ColumnProperties)object);
                    }
                    resultSet.setMetaData((TeraResultSetMetaData)object2);
                    continue block9;
                }
                case 10: {
                    Object object2 = (RecordParcel)parcel;
                    if (resultSetRow == null) {
                        resultSetRow = new ResultSetRow();
                    }
                    Object object3 = ((RecordParcel)object2).getRecordParcelColumnValuesIterator();
                    while (((RecordParcel.RecordParcelColumnValuesIterator)object3).hasNext()) {
                        resultSetRow.addValue(((RecordParcel.RecordParcelColumnValuesIterator)object3).next());
                    }
                    resultSet.addResultSetRow(resultSetRow);
                    resultSetRow = null;
                    continue block9;
                }
                case 144: {
                    Object object = (MultiPartRecordParcel)parcel;
                    if (resultSetRow == null) {
                        resultSetRow = new ResultSetRow();
                    }
                    RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = ((RecordParcel)object).getRecordParcelColumnValuesIterator();
                    while (true) {
                        if (!recordParcelColumnValuesIterator.hasNext()) continue block9;
                        resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                    }
                }
                case 145: {
                    EndMultiPartRecordParcel endMultiPartRecordParcel = (EndMultiPartRecordParcel)parcel;
                    resultSet.addResultSetRow(resultSetRow);
                    resultSetRow = null;
                    continue block9;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
                case 12: {
                    if (this.resultsIndex < 0) {
                        resultSet.lastRowFetched();
                        this.results.addResult(null, new Result(resultSet));
                    }
                    tDPacket.setParcelFactoryPrepInfo(null);
                    return;
                }
            }
            break;
        }
        this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
        throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
    }

    protected void shareWorkingMetadata(FastExportPreparedStatement fastExportPreparedStatement) {
        this.workingMetadata = fastExportPreparedStatement.workingMetadata;
        this.workingMetadataColumn = fastExportPreparedStatement.workingMetadataColumn;
    }

    protected void shareResults(Results results, int n) {
        this.results = results;
        this.resultsIndex = n;
    }

    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        for (int i = 0; i < this.workingMetadataColumn.length(); ++i) {
            this.workingMetadata[i] = null;
        }
        this.workingMetadataColumn.clear();
        this.statementBlockCountParameterIndex = 0;
        this.statementBlockCount = 0L;
    }

    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        if (this.workingMetadataColumn.isEmpty()) {
            throw ErrorFactory.makeDriverJDBCException("TJ568");
        }
        SQLException sQLException = null;
        TDPacket tDPacket = null;
        java.sql.ResultSet resultSet = null;
        try {
            try {
                this.clearWarnings();
                this.results.reinit();
                if (this.workingMetadataColumn.length() != this.workingMetadataColumn.nextClearBit(0)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ566", this.workingMetadataColumn.nextClearBit(0) + 1);
                }
                if (this.statementBlockCountParameterIndex != this.workingMetadataColumn.cardinality() + 1) {
                    throw ErrorFactory.makeDriverJDBCException("TJ569", this.workingMetadataColumn.cardinality() + 1, this.statementBlockCountParameterIndex);
                }
                tDPacket = this.con.getPacket();
                this.requestResults();
                this.receiveResults(tDPacket);
                this.deserializeResults(tDPacket);
                resultSet = this.getResultSet();
                if (resultSet == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ583");
                }
                Object var6_4 = null;
                if (tDPacket != null) {
                    this.con.returnPacket(tDPacket);
                }
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                Object var6_5 = null;
                if (tDPacket != null) {
                    this.con.returnPacket(tDPacket);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
            throw throwable;
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ567");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, Double.valueOf(Float.toString(f)));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        this.statementBlockCountParameterIndex = n;
        this.statementBlockCount = l;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{=, }");
        if (stringTokenizer.countTokens() % 2 == 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ564", String.valueOf(n), string);
        }
        FullContentMetadataItem fullContentMetadataItem = new FullContentMetadataItem(1, 1, 0);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            try {
                if (string2.equalsIgnoreCase("TeraDataType")) {
                    fullContentMetadataItem.setDataType(Short.parseShort(string3));
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxDataLengthInBytes")) {
                    fullContentMetadataItem.setMaxDataLengthInBytes(Integer.parseInt(string3));
                    continue;
                }
                if (string2.equalsIgnoreCase("Precision")) {
                    fullContentMetadataItem.setTotalNumberOfDigits(Short.parseShort(string3));
                    continue;
                }
                if (!string2.equalsIgnoreCase("Scale")) continue;
                fullContentMetadataItem.setNumberOfFractionalDigits(Short.parseShort(string3));
            }
            catch (Exception exception) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ565", String.valueOf(n), string2, string3);
                jDBCException.initCause(exception);
                throw jDBCException;
            }
        }
        this.workingMetadata[n - 1] = fullContentMetadataItem;
        this.workingMetadataColumn.set(n - 1);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    public void close() throws SQLException {
        this.workingMetadata = null;
        this.workingMetadataColumn = null;
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            ResultSet resultSet = this.results.getResult().getResultSet();
            TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
            teraLocalResultSet.setResultSet(resultSet);
            return teraLocalResultSet;
        }
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }
}

