/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalPreparedStatement;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastLoadManagerConnection
implements Connection,
LocalEscapeFunctions {
    private Connection appCon = null;
    private String machineName = null;
    private String userName = null;
    private String password = null;
    private URLParameters appUrlParams = null;
    private List fastloads = Collections.synchronizedList(new ArrayList());
    private boolean connected = false;
    private SQLWarning sqlWarnings = null;

    public FastLoadManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.appUrlParams = uRLParameters;
        this.appUrlParams.setType("DEFAULT");
        this.appCon = ConnectionFactory.createConnection(string, string2, string3, this.appUrlParams);
        this.connected = true;
    }

    private void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    protected void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = sQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    private String getTeradataTypeCast(int n, FullContentMetadataItem fullContentMetadataItem, String string) {
        String string2 = null;
        String string3 = JDBC4Constants.getTDTypeName(fullContentMetadataItem.getDataType());
        if (string3.equals("BIGINT") || string3.equals("BYTEINT") || string3.equals("DATE") || string3.equals("FLOAT") || string3.equals("INTEGER") || string3.equals("SMALLINT")) {
            string2 = string3;
        } else if (string3.endsWith("BYTE")) {
            string2 = "VARBYTE(" + fullContentMetadataItem.getMaxDataLengthInBytes() + ")";
        } else if (string3.endsWith("CHAR") || string3.startsWith("INTERVAL")) {
            string2 = "VARCHAR(" + fullContentMetadataItem.getMaxDataLengthInBytes() + ")";
        } else if (string3.equals("DECIMAL")) {
            string2 = string3 + "(" + ((TeraLocalConnection)this.appCon).getTDSession().getMaxDecimalPrecision() + "," + fullContentMetadataItem.getNumberOfFractionalDigits() + ")";
        } else if (string3.startsWith("TIME")) {
            int n2 = 1;
            if (string.equals("UTF16")) {
                n2 = 2;
            }
            if (string3.startsWith("TIMESTAMP")) {
                int n3;
                int n4 = n3 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = string3.endsWith("ZONE") ? "CHAR(" + n2 * (25 + n3) + ")" : "CHAR(" + n2 * (19 + n3) + ")";
            } else {
                int n5;
                int n6 = n5 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = string3.endsWith("ZONE") ? "CHAR(" + n2 * (14 + n5) + ")" : "CHAR(" + n2 * (8 + n5) + ")";
            }
        } else {
            this.getLog().info("Cannot FastLoad because a data type of " + string3 + " in column " + n + " of the destination database table is not supported!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ546", string3, String.valueOf(n));
            this.chainSQLWarnings(sQLWarning);
        }
        return string2;
    }

    public static String quoteName(String string) {
        return string == null ? string : "\"" + string.replaceAll("\"", "\"\"") + "\"";
    }

    public static String unquoteName(String string) {
        return string == null || string.length() < 2 || !string.startsWith("\"") ? string : string.substring(1, string.length() - 1).replaceAll("\"\"", "\"");
    }

    private static String caseTeradataTypeCodes(String string, String string2, String string3) {
        return "cast ((coalesce (case " + string + " when 'AT' then " + 760 + " when 'BF' then " + 692 + " when 'BO' then " + 400 + " when 'BV' then " + 688 + " when 'CF' then case " + string2 + " when 4 then " + 468 + " else " + 452 + " end" + " when 'CO' then " + 416 + " when 'CV' then case " + string2 + " when 4 then " + 464 + " else " + 448 + " end" + " when 'D'  then " + 484 + " when 'DA' then " + 752 + " when 'DH' then " + 792 + " when 'DM' then " + 796 + " when 'DS' then " + 800 + " when 'DY' then " + 788 + " when 'F'  then " + 480 + " when 'GF' then " + 468 + " when 'GV' then " + 464 + " when 'HM' then " + 808 + " when 'HR' then " + 804 + " when 'HS' then " + 812 + " when 'I1' then " + 756 + " when 'I2' then " + 500 + " when 'I'  then " + 496 + " when 'I8' then " + 600 + " when 'MI' then " + 816 + " when 'MO' then " + 784 + " when 'MS' then " + 820 + " when 'SC' then " + 824 + " when 'SZ' then " + 772 + " when 'TS' then " + 764 + " when 'TZ' then " + 768 + " when 'YM' then " + 780 + " when 'YR' then " + 776 + " else null end" + " +" + " case " + string3 + " when 'Y' then 1" + " else 0 end" + ", 0))" + " as smallint)";
    }

    private static String caseMaxLengthInBytes(String string, String string2, String string3, String string4) {
        String string5 = "cast ((" + string2 + " / case " + string3 + " when 2 then 2" + " when 4 then 2" + " else 1 end)" + " * ";
        string5 = string.equals("UTF8") ? string5 + "case " + string3 + " when 1 then 2" + " when 2 then 3" + " else 1 end" : (string.equals("UTF16") ? string5 + "case " + string3 + " when 0 then (case " + string4 + " when 'AT' then 2" + " when 'DH' then 2" + " when 'DM' then 2" + " when 'DS' then 2" + " when 'DY' then 2" + " when 'HM' then 2" + " when 'HR' then 2" + " when 'HS' then 2" + " when 'MI' then 2" + " when 'MO' then 2" + " when 'MS' then 2" + " when 'SC' then 2" + " when 'SZ' then 2" + " when 'TS' then 2" + " when 'TZ' then 2" + " when 'YM' then 2" + " when 'YR' then 2" + " else 1 end)" + " else 2 end" : string5 + "1");
        string5 = string5 + " as integer)";
        return string5;
    }

    private static String caseMaxLengthInChars(String string, String string2) {
        String string3 = "cast ((" + string + " / case " + string2 + " when 2 then 2" + " when 4 then 2" + " else 1 end)";
        string3 = string3 + " as integer)";
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList createMetadataItemsFromDataDictionary(Connection connection, String string, String string2, String string3) throws SQLException {
        ArrayList<FullContentMetadataItem> arrayList = new ArrayList<FullContentMetadataItem>();
        java.sql.PreparedStatement preparedStatement = connection.prepareStatement("locking row for access select trim(DatabaseName), trim(TableName), trim(ColumnName), " + FastLoadManagerConnection.caseTeradataTypeCodes("ColumnType", "CharType", "Nullable") + "," + " " + FastLoadManagerConnection.caseMaxLengthInBytes(string, "ColumnLength", "CharType", "ColumnType") + "," + " DecimalTotalDigits," + " DecimalFractionalDigits," + " Nullable," + " " + FastLoadManagerConnection.caseMaxLengthInChars("ColumnLength", "CharType") + " from dbc.columns" + " where upper(DatabaseName) = upper((coalesce(?, database)))" + " and upper(TableName) = upper(?)");
        try {
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                FullContentMetadataItem fullContentMetadataItem = new FullContentMetadataItem(1, 1, 0);
                fullContentMetadataItem.setDatabaseName(resultSet.getString(1));
                fullContentMetadataItem.setProcedureOrTableName(resultSet.getString(2));
                fullContentMetadataItem.setColumnOrParameterName(resultSet.getString(3));
                fullContentMetadataItem.setDataType(resultSet.getShort(4));
                fullContentMetadataItem.setMaxDataLengthInBytes(resultSet.getInt(5));
                fullContentMetadataItem.setTotalNumberOfDigits(resultSet.getShort(6));
                fullContentMetadataItem.setNumberOfFractionalDigits(resultSet.getShort(7));
                fullContentMetadataItem.setIsNullable((byte)resultSet.getString(8).charAt(0));
                fullContentMetadataItem.setMaxNumberOfCharacters(resultSet.getInt(9));
                arrayList.add(fullContentMetadataItem);
            }
        }
        finally {
            preparedStatement.close();
        }
        return arrayList;
    }

    private static SQLWarning createInsertStatementParameterMarkerMetadata(Log log, Connection connection, String string, String string2, ArrayList arrayList) throws SQLException {
        Object object;
        Matcher matcher;
        String string3 = "(?is)\\s*INSERT\\s+INTO\\s+(?:([^\"][^\\s.]*|\"(?:\"\"|[^\"])*\")\\s*\\.\\s*)?([^\"][^\\s]*|\"(?:\"\"|[^\"])*\")\\s*(?:\\((.*)\\))?\\s*(?:VALUES)?\\s*\\([\\s?,]+\\)\\s*(?:;\\s*)?";
        Matcher matcher2 = Pattern.compile(string3).matcher(string2);
        if (!matcher2.matches()) {
            log.info("SQL request did not match regular expression: " + string2);
            return ErrorFactory.makeSQLWarning("TJ544", string2);
        }
        String string4 = FastLoadManagerConnection.unquoteName(matcher2.group(1));
        String string5 = FastLoadManagerConnection.unquoteName(matcher2.group(2));
        String string6 = matcher2.group(3);
        ArrayList<String> arrayList2 = string6 != null ? new ArrayList<String>() : null;
        String string7 = "\\s*,\\s*([^\"][^\\s,]*|\"(?:\"\"|[^\"])*\")";
        Matcher matcher3 = matcher = string6 != null ? Pattern.compile(string7).matcher("," + string6) : null;
        while (arrayList2 != null && matcher != null && matcher.find()) {
            arrayList2.add(FastLoadManagerConnection.unquoteName(matcher.group(1)).toUpperCase());
        }
        ArrayList arrayList3 = FastLoadManagerConnection.createMetadataItemsFromDataDictionary(connection, string, string4, string5);
        LinkedHashMap<String, FullContentMetadataItem> linkedHashMap = new LinkedHashMap<String, FullContentMetadataItem>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            object = (FullContentMetadataItem)iterator.next();
            linkedHashMap.put(((FullContentMetadataItem)object).getColumnOrParameterName().toUpperCase(), (FullContentMetadataItem)object);
        }
        if (arrayList2 == null) {
            arrayList.addAll(arrayList3);
        } else {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)linkedHashMap.get(object);
                if (fullContentMetadataItem == null) {
                    log.info("Column name " + (String)object + " was not found in table's columns: " + linkedHashMap.keySet());
                    return ErrorFactory.makeSQLWarning("TJ545", (String)object, linkedHashMap.keySet().toString());
                }
                arrayList.add(fullContentMetadataItem);
            }
        }
        return null;
    }

    private synchronized java.sql.PreparedStatement prepareStatement(java.sql.PreparedStatement preparedStatement) throws SQLException {
        Object object;
        ArrayList arrayList;
        String string = this.getURLParameters().getCharSet();
        if (!(string.equals("ASCII") || string.equals("UTF8") || string.equals("UTF16"))) {
            this.getLog().info("Cannot FastLoad because the specified Java Character Encoding is not supported: " + string);
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ540", string);
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        PreparedStatement preparedStatement2 = ((TeraLocalPreparedStatement)preparedStatement).getPreparedStatement();
        MetaDataList metaDataList = preparedStatement2.getMetaDataList();
        if (metaDataList.size() == 0) {
            this.getLog().info("Cannot FastLoad because no metadata is available.");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ628");
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        if (metaDataList.size() > 1) {
            this.getLog().info("Cannot FastLoad a multi-statement request!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ541");
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        TeraResultSetMetaData teraResultSetMetaData = metaDataList.getFirstMetaData();
        if (!ActivityAnalyzer.isFastLoadCompatible(teraResultSetMetaData.getActivityType())) {
            this.getLog().info("Cannot FastLoad because statement is not an INSERT!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ542");
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        if (preparedStatement2.returnGeneratedKeys()) {
            this.getLog().info("Cannot FastLoad because auto-generated key retrieval was requested, but is not supported!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ543");
            this.chainSQLWarnings(sQLWarning);
            return preparedStatement;
        }
        if (((TeraLocalConnection)this.appCon).getTDSession().isStatementInfoSupported()) {
            arrayList = preparedStatement2.getParameterMarkerMetaData();
        } else {
            arrayList = new ArrayList();
            object = FastLoadManagerConnection.createInsertStatementParameterMarkerMetadata(this.getLog(), this.appCon, string, ((TeraLocalPreparedStatement)preparedStatement).getOriginalSql(), arrayList);
            if (object != null) {
                this.getLog().info("Cannot FastLoad because metadata could not be obtained for the destination table.");
                SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ559");
                this.chainSQLWarnings(sQLWarning);
                this.chainSQLWarnings((SQLWarning)object);
                return preparedStatement;
            }
        }
        object = null;
        String string2 = null;
        String string3 = "USING ";
        String string4 = " INSERT INTO ";
        String string5 = " VALUES ( ";
        for (int i = 0; i < arrayList.size(); ++i) {
            FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)arrayList.get(i);
            String string6 = this.getTeradataTypeCast(i + 1, fullContentMetadataItem, string);
            if (string6 == null) {
                return preparedStatement;
            }
            if (i == 0) {
                object = fullContentMetadataItem.getDatabaseName();
                string2 = fullContentMetadataItem.getProcedureOrTableName();
                string4 = string4 + FastLoadManagerConnection.quoteName((String)object) + "." + FastLoadManagerConnection.quoteName(string2) + " ( ";
            } else {
                string3 = string3 + ", ";
                string4 = string4 + ", ";
                string5 = string5 + ", ";
            }
            String string7 = fullContentMetadataItem.getColumnOrParameterName();
            string3 = string3 + FastLoadManagerConnection.quoteName("F_" + string7) + " (" + string6 + ")";
            string4 = string4 + FastLoadManagerConnection.quoteName(string7);
            string5 = string5 + ":" + FastLoadManagerConnection.quoteName("F_" + string7);
        }
        string4 = string4 + " )";
        string5 = string5 + " )";
        String string8 = string3 + string4 + string5;
        this.getLog().info("FastLoad " + string8);
        preparedStatement = new FastLoadManagerPreparedStatement(this, this.machineName, this.userName, this.password, (String)object, string2, string8, preparedStatement, arrayList);
        this.fastloads.add(preparedStatement);
        return preparedStatement;
    }

    protected synchronized void removeStatement(Object object) {
        this.fastloads.remove(object);
    }

    protected URLParameters getURLParameters() {
        return this.appUrlParams;
    }

    protected Log getLog() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getLog();
    }

    private LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public synchronized String getLogonSequenceNumber() {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.fastloads.size(); ++i) {
            FastLoadManagerPreparedStatement fastLoadManagerPreparedStatement = (FastLoadManagerPreparedStatement)this.fastloads.get(i);
            if (!fastLoadManagerPreparedStatement.isConnected()) continue;
            if (!bl) {
                string = string + ",";
            } else {
                bl = false;
            }
            string = string + fastLoadManagerPreparedStatement.hashCode() + ",";
            string = string + fastLoadManagerPreparedStatement.getLogonSequenceNumber();
        }
        return string;
    }

    public String getAMPCount() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getAMPCount();
    }

    public String getLogLevel() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getLogLevel();
    }

    public String setLogLevel(String string) {
        return ((TeraLocalConnection)this.appCon).getTDSession().setLogLevel(string);
    }

    public String beginCapture() {
        return ((TeraLocalConnection)this.appCon).getTDSession().beginCapture();
    }

    public String endCapture() {
        return ((TeraLocalConnection)this.appCon).getTDSession().endCapture();
    }

    public String useAnsiDate() {
        return ((TeraLocalConnection)this.appCon).getTDSession().useAnsiDate();
    }

    public String useIntegerDate() {
        return ((TeraLocalConnection)this.appCon).getTDSession().useIntegerDate();
    }

    public String getSessionNumber() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getSessionNumber();
    }

    public String getSocketInfo() {
        return ((TeraLocalConnection)this.appCon).getTDSession().getSocketInfo();
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.sqlWarnings = null;
        this.appCon.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            ArrayList arrayList = new ArrayList(this.fastloads);
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FastLoadManagerPreparedStatement fastLoadManagerPreparedStatement = (FastLoadManagerPreparedStatement)arrayList.get(i);
                    boolean bl = fastLoadManagerPreparedStatement.isFastLoading();
                    try {
                        fastLoadManagerPreparedStatement.close();
                        if (!bl) continue;
                        fastLoadManagerPreparedStatement.rollbackFastLoad();
                        fastLoadManagerPreparedStatement.closeFastLoad();
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                        sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                        sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                        continue;
                    }
                    finally {
                        if (bl) {
                            this.removeStatement(fastLoadManagerPreparedStatement);
                        }
                    }
                }
                this.appCon.close();
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
            }
            finally {
                this.connected = false;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ457");
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.fastloads);
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((FastLoadManagerPreparedStatement)arrayList.get(i)).endFastLoad();
                    continue;
                }
                catch (SQLException sQLException2) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            this.appCon.commit();
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ458");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        return this.appCon.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.appCon.createStatement(n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.appCon.createStatement(n, n2, n3);
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getCatalog();
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return this.appCon.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        this.chainSQLWarnings(this.appCon.getWarnings());
        this.appCon.clearWarnings();
        return this.sqlWarnings;
    }

    public boolean isClosed() throws SQLException {
        return !this.connected;
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return this.appCon.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        return this.appCon.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.appCon.prepareCall(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.appCon.prepareCall(string, n, n2, n3);
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string));
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, n));
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, nArray));
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, n, n2));
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, n, n2, n3));
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        return this.prepareStatement(this.appCon.prepareStatement(string, stringArray));
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        this.appCon.releaseSavepoint(savepoint);
    }

    public synchronized void rollback() throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.fastloads);
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((FastLoadManagerPreparedStatement)arrayList.get(i)).rollbackFastLoad();
                    continue;
                }
                catch (SQLException sQLException2) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            this.appCon.rollback();
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ474");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        this.appCon.rollback(savepoint);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.appCon.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
        this.appCon.setCatalog(string);
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
        this.appCon.setHoldability(n);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.appCon.setReadOnly(bl);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        return this.appCon.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        return this.appCon.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
        this.appCon.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
        this.appCon.setTypeMap(map);
    }
}

