/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketPool;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class FastLoadManagerPreparedStatement
implements PreparedStatement {
    private Connection managerCon = null;
    private PreparedStatement appPstmt = null;
    private ArrayList paramMetaData = null;
    private Connection controlCon = null;
    private Connection[] fastloadCons = null;
    private boolean fastloading = false;
    private boolean checkFastloadErrorTables = false;
    private String machineName = null;
    private String userName = null;
    private String password = null;
    private String tableName = null;
    private String tableNameErr1 = null;
    private String tableNameErr2 = null;
    private String beginLoading = null;
    private String usingInsertValues = null;
    private Statement controlStmt = null;
    private PreparedStatement[] fastloadPrepStmts = null;
    private int fastloadPrepStmtIndex = 0;
    private int numBatchedRows = 0;
    private int numBatchedRowsSent = 0;
    private int[] numBatchedRowsInPrepStmt = null;
    private boolean closed = false;
    private boolean connected = false;
    private boolean rollingback = false;
    private SQLWarning sqlWarnings = null;
    public static final int MAX_FASTLOAD_ERROR_TABLE_ROW_COUNT = Integer.MAX_VALUE;
    public static final int MAX_FASTLOAD_ERROR_TABLE_ARRAY_LENGTH = 64000;
    private static final int FROM_OBJECT = 1;
    private static final int FROM_STRING = 2;
    private static final int FROM_NUMBER = 3;
    private static final int FROM_DATE = 4;
    private static final int FROM_TIME = 5;
    private static final int FROM_TIMESTAMP = 6;
    public static final BigInteger MIN_BYTE_BIGINTEGER = BigInteger.valueOf(-128L);
    public static final BigInteger MAX_BYTE_BIGINTEGER = BigInteger.valueOf(127L);
    public static final BigInteger MIN_INTEGER_BIGINTEGER = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MAX_INTEGER_BIGINTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger MIN_LONG_BIGINTEGER = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger MAX_LONG_BIGINTEGER = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_SHORT_BIGINTEGER = BigInteger.valueOf(-32768L);
    public static final BigInteger MAX_SHORT_BIGINTEGER = BigInteger.valueOf(32767L);

    public FastLoadManagerPreparedStatement(FastLoadManagerConnection fastLoadManagerConnection, String string, String string2, String string3, String string4, String string5, String string6, PreparedStatement preparedStatement, ArrayList arrayList) throws SQLException {
        this.managerCon = fastLoadManagerConnection;
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.tableName = FastLoadManagerConnection.quoteName(string4) + "." + FastLoadManagerConnection.quoteName(string5);
        this.tableNameErr1 = FastLoadManagerConnection.quoteName(string4) + "." + FastLoadManagerConnection.quoteName(string5 + "_ERR_1");
        this.tableNameErr2 = FastLoadManagerConnection.quoteName(string4) + "." + FastLoadManagerConnection.quoteName(string5 + "_ERR_2");
        this.beginLoading = "BEGIN LOADING " + this.tableName + " ERRORFILES " + this.tableNameErr1 + ", " + this.tableNameErr2 + " WITH INTERVAL";
        this.usingInsertValues = string6;
        this.appPstmt = preparedStatement;
        this.paramMetaData = arrayList;
    }

    private void abortIfClosed() throws SQLException {
        if (this.managerCon.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.closed) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void initializeFastLoad() throws SQLException {
        try {
            this.connectFastLoad();
        }
        catch (SQLException sQLException) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ459", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = sQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    private void connectFastLoad() throws SQLException {
        if (!this.connected) {
            SQLException sQLException = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                int n5;
                URLParameters uRLParameters = ((FastLoadManagerConnection)this.managerCon).getURLParameters();
                URLParameters uRLParameters2 = new URLParameters("LOG=" + uRLParameters.getLogLevel() + "," + "DBS_PORT" + "=" + uRLParameters.getDbsPort() + "," + "COP" + "=" + (uRLParameters.getCopDiscovery() ? "ON" : "OFF") + "," + "CONNECT_FAILURE_TTL" + "=" + uRLParameters.getConnectFailureTTL() + "," + "TCP" + "=" + uRLParameters.getTCP() + "," + "charset" + "=" + uRLParameters.getCharSet() + "," + "ENCRYPTDATA" + "=" + (uRLParameters.getEncryptData() ? "ON" : "OFF") + (uRLParameters.getLogMech() != null ? ",LOGMECH=" + uRLParameters.getLogMech() : "") + (uRLParameters.getLogData() != null ? ",LOGDATA='" + uRLParameters.getLogData() + "'" : "") + "," + "tmode" + "=TERA" + (uRLParameters.isGoverned() ? ",LSS_TYPE=L" : "") + "," + "CONNECT_FUNCTION" + "=" + 1);
                this.controlCon = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters2);
                this.controlStmt = this.controlCon.createStatement();
                n2 = uRLParameters.getSessions();
                n = Integer.parseInt(this.controlCon.nativeSQL("{fn teradata_amp_count()}"));
                URLParameters uRLParameters3 = new URLParameters("LOG=" + uRLParameters.getLogLevel() + "," + "DBS_PORT" + "=" + uRLParameters.getDbsPort() + "," + "COP" + "=" + (uRLParameters.getCopDiscovery() ? "ON" : "OFF") + "," + "CONNECT_FAILURE_TTL" + "=" + uRLParameters.getConnectFailureTTL() + "," + "TCP" + "=" + uRLParameters.getTCP() + "," + "charset" + "=" + uRLParameters.getCharSet() + "," + "ENCRYPTDATA" + "=" + (uRLParameters.getEncryptData() ? "ON" : "OFF") + (uRLParameters.getLogMech() != null ? ",LOGMECH=" + uRLParameters.getLogMech() : "") + (uRLParameters.getLogData() != null ? ",LOGDATA='" + uRLParameters.getLogData() + "'" : "") + (uRLParameters.isGoverned() ? ",LSS_TYPE=L" : "") + "," + "PARTITION" + "=" + "FASTLOAD" + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.controlCon.nativeSQL("{fn teradata_logon_sequence_number()}"));
                this.fastloadCons = new Connection[n2 < n ? n2 : n];
                for (n5 = 0; n5 < this.fastloadCons.length; ++n5) {
                    this.fastloadCons[n5] = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters3);
                    ++n3;
                }
                this.fastloadPrepStmts = new PreparedStatement[this.fastloadCons.length];
                for (n5 = 0; n5 < this.fastloadPrepStmts.length; ++n5) {
                    this.fastloadPrepStmts[n5] = this.fastloadCons[n5].prepareStatement(null);
                    if (n5 > 0) {
                        ((FastLoadPreparedStatement)this.fastloadPrepStmts[n5]).shareWorkingRow((FastLoadPreparedStatement)this.fastloadPrepStmts[0]);
                    }
                    ((FastLoadPreparedStatement)this.fastloadPrepStmts[n5]).setParameterMetaData(this.paramMetaData);
                    ++n4;
                }
                ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad found " + n + " AMP(s) in " + this.machineName + " and created " + n3 + " FastLoadConnection(s) and " + n4 + " FastLoadPreparedStatement(s) with SESSIONS=" + n2 + ".");
                this.numBatchedRowsInPrepStmt = new int[this.fastloadPrepStmts.length];
                for (n5 = 0; n5 < this.numBatchedRowsInPrepStmt.length; ++n5) {
                    this.numBatchedRowsInPrepStmt[n5] = 0;
                }
                this.connected = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                try {
                    this.closeFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ518", this.tableName, String.valueOf(n), String.valueOf(n3), String.valueOf(n4), String.valueOf(n2));
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFastLoad() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            try {
                JDBCException jDBCException;
                int n;
                if (this.fastloadPrepStmts != null) {
                    for (n = 0; n < this.fastloadPrepStmts.length; ++n) {
                        if (this.fastloadPrepStmts[n] == null) continue;
                        try {
                            this.fastloadPrepStmts[n].close();
                            continue;
                        }
                        catch (SQLException sQLException2) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", n, this.fastloadPrepStmts.length);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        }
                    }
                }
                if (this.controlStmt != null) {
                    try {
                        this.controlStmt.close();
                    }
                    catch (SQLException sQLException3) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
                if (this.fastloadCons != null) {
                    for (n = 0; n < this.fastloadCons.length; ++n) {
                        if (this.fastloadCons[n] == null) continue;
                        try {
                            this.fastloadCons[n].close();
                            continue;
                        }
                        catch (SQLException sQLException4) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ470", n, this.fastloadCons.length);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                        }
                    }
                }
                if (this.controlCon != null) {
                    try {
                        this.controlCon.close();
                    }
                    catch (SQLException sQLException5) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                    }
                }
                Object var6_10 = null;
                this.connected = false;
                this.fastloadPrepStmts = null;
                this.controlStmt = null;
                this.fastloadCons = null;
                this.controlCon = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                this.connected = false;
                this.fastloadPrepStmts = null;
                this.controlStmt = null;
                this.fastloadCons = null;
                this.controlCon = null;
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ519", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryExecuteCreateOrDrop(Statement statement, String string) throws SQLException {
        SQLException sQLException = null;
        try {
            try {
                for (int i = 1; i <= 5; ++i) {
                    sQLException = null;
                    try {
                        statement.execute(string);
                        break;
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException2.getErrorCode() == 2631) {
                            sQLException = sQLException2;
                            ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad is ignoring retryable error " + sQLException2.getErrorCode() + ". Now sleeping for 5 seconds to allow error condition to clear...");
                            try {
                                Thread.currentThread();
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        throw sQLException2;
                    }
                }
            }
            finally {
                statement.close();
            }
        }
        finally {
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    private void executeCreateOrDrop(Statement statement, String string) throws SQLException {
        try {
            this.retryExecuteCreateOrDrop(statement, string);
        }
        catch (SQLException sQLException) {
            switch (sQLException.getErrorCode()) {
                case 3807: {
                    break;
                }
                default: {
                    throw sQLException;
                }
            }
        }
    }

    private void dropFastLoadErrorTables() throws SQLException {
        this.executeCreateOrDrop(this.controlStmt, "DROP TABLE " + this.tableNameErr1);
        this.executeCreateOrDrop(this.controlStmt, "DROP TABLE " + this.tableNameErr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFastLoadErrorTableRowCount(String string) throws SQLException {
        Object object;
        SQLException sQLException = null;
        int n = -1;
        String string2 = "LOCKING " + string + " FOR ACCESS SELECT COUNT(*) FROM " + string;
        try {
            object = this.controlStmt.executeQuery(string2);
            try {
                if (object.next()) {
                    n = object.getInt(1);
                }
            }
            finally {
                object.close();
            }
        }
        catch (SQLException sQLException2) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ517", string);
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFastLoadErrorTableRows(String string, String string2) throws SQLException {
        Object object;
        SQLException sQLException = null;
        try {
            object = this.controlStmt.executeQuery(string);
            try {
                ResultSetMetaData resultSetMetaData = object.getMetaData();
                for (int i = 1; object.next() && i <= Integer.MAX_VALUE; ++i) {
                    SQLException sQLException2;
                    String[] stringArray = new String[resultSetMetaData.getColumnCount()];
                    Object[] objectArray = new Object[resultSetMetaData.getColumnCount()];
                    for (int j = 1; j <= resultSetMetaData.getColumnCount(); ++j) {
                        stringArray[j - 1] = resultSetMetaData.getColumnName(j);
                        objectArray[j - 1] = object.getObject(j);
                    }
                    String string3 = null;
                    for (int j = 0; j < resultSetMetaData.getColumnCount(); ++j) {
                        int n;
                        Object object2;
                        if (objectArray[j] instanceof byte[]) {
                            object2 = (byte[])objectArray[j];
                            n = object2 == null ? 0 : ((Object)object2).length;
                            int n2 = n = n < 64000 ? n : 64000;
                            if (j == 0) {
                                string3 = "\n" + Log.formatPartialByteArray(stringArray[j], object2, 0, n);
                                continue;
                            }
                            string3 = string3 + "\n" + Log.formatPartialByteArray(stringArray[j], object2, 0, n);
                            continue;
                        }
                        object2 = String.valueOf(objectArray[j]);
                        n = object2.length() < 64000 ? object2.length() : 64000;
                        String string4 = "";
                        if (objectArray[j] != null && n != 0 && object2.length() > 64000) {
                            string4 = " (only showing string length " + n + " of " + object2.length() + ")";
                        }
                        string3 = j == 0 ? "\n" + stringArray[j] + "=" + object2.substring(0, n) + string4 : string3 + "\n" + stringArray[j] + "=" + object2.substring(0, n) + string4;
                    }
                    if (this.rollingback) {
                        sQLException2 = ErrorFactory.makeSQLWarning("TJ473", String.valueOf(i), string2, string3);
                        ((FastLoadManagerConnection)this.managerCon).chainSQLWarnings((SQLWarning)sQLException2);
                        continue;
                    }
                    sQLException2 = ErrorFactory.makeDriverJDBCException("TJ473", String.valueOf(i), string2, string3);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            finally {
                object.close();
            }
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ475", string2);
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
    }

    private void selectFastLoadError1TableRows() throws SQLException {
        String string = "LOCKING " + this.tableNameErr1 + " FOR ACCESS " + "SELECT ErrorCode,ErrorFieldName,BYTES(DataParcel) AS ActualDataParcelLength,CAST(DataParcel AS VARBYTE(" + 64000 + ")) FROM " + this.tableNameErr1;
        this.selectFastLoadErrorTableRows(string, this.tableNameErr1);
    }

    private void selectFastLoadError2TableRows() throws SQLException {
        String string = "LOCKING " + this.tableNameErr2 + " FOR ACCESS SELECT * FROM " + this.tableNameErr2;
        this.selectFastLoadErrorTableRows(string, this.tableNameErr2);
    }

    private void selectFastLoadErrorTables() throws SQLException {
        SQLException sQLException = null;
        try {
            int n;
            int n2 = this.getFastLoadErrorTableRowCount(this.tableNameErr1);
            if (n2 != 0) {
                SQLException sQLException2;
                if (this.rollingback) {
                    sQLException2 = ErrorFactory.makeSQLWarning("TJ562", String.valueOf(n2), this.tableNameErr1, String.valueOf(Integer.MAX_VALUE));
                    ((FastLoadManagerConnection)this.managerCon).chainSQLWarnings((SQLWarning)sQLException2);
                } else {
                    sQLException2 = ErrorFactory.makeDriverJDBCException("TJ472", String.valueOf(n2), this.tableNameErr1, String.valueOf(Integer.MAX_VALUE));
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                try {
                    this.selectFastLoadError1TableRows();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
            }
            if ((n = this.getFastLoadErrorTableRowCount(this.tableNameErr2)) != 0) {
                SQLException sQLException4;
                if (this.rollingback) {
                    sQLException4 = ErrorFactory.makeSQLWarning("TJ562", String.valueOf(n), this.tableNameErr2, String.valueOf(Integer.MAX_VALUE));
                    ((FastLoadManagerConnection)this.managerCon).chainSQLWarnings((SQLWarning)sQLException4);
                } else {
                    sQLException4 = ErrorFactory.makeDriverJDBCException("TJ472", String.valueOf(n), this.tableNameErr2, String.valueOf(Integer.MAX_VALUE));
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                }
                try {
                    this.selectFastLoadError2TableRows();
                }
                catch (SQLException sQLException5) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                }
            }
        }
        catch (SQLException sQLException6) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private void abortFastLoad() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            boolean bl = false;
            try {
                if (!this.fastloading) {
                    try {
                        this.controlStmt.executeQuery("SELECT 1 FROM " + this.tableName + " WHERE 1=2");
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException2.getErrorCode() == 2652) {
                            bl = true;
                        }
                        throw sQLException2;
                    }
                } else {
                    this.closeFastLoad();
                    this.connectFastLoad();
                }
                if (this.fastloading || bl) {
                    this.controlCon.setAutoCommit(true);
                    this.controlStmt.execute(this.beginLoading);
                    this.controlCon.setAutoCommit(false);
                    this.controlStmt.executeUpdate("END LOADING");
                    this.controlCon.commit();
                    this.controlCon.setAutoCommit(true);
                    if (this.checkFastloadErrorTables && !bl) {
                        try {
                            this.selectFastLoadErrorTables();
                        }
                        catch (SQLException sQLException3) {
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                        }
                    }
                    this.controlStmt.executeUpdate("DELETE " + this.tableName + " ALL");
                }
                this.dropFastLoadErrorTables();
            }
            catch (SQLException sQLException4) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ477", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    private void beginFastLoad() throws SQLException {
        if (this.connected && !this.fastloading) {
            SQLException sQLException = null;
            try {
                this.abortFastLoad();
                try {
                    this.controlStmt.executeUpdate("SET SESSION DateForm = IntegerDate");
                    this.controlStmt.execute(this.beginLoading);
                    this.fastloading = true;
                    this.controlCon.setAutoCommit(false);
                    this.controlStmt.executeUpdate(this.usingInsertValues);
                    this.checkFastloadErrorTables = true;
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    try {
                        this.abortFastLoad();
                    }
                    catch (SQLException sQLException3) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
            }
            catch (SQLException sQLException4) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ460", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFastLoad() throws SQLException {
        if (this.connected && this.fastloading) {
            SQLException sQLException = null;
            try {
                try {
                    this.controlStmt.executeUpdate("CHECKPOINT LOADING END");
                    this.controlCon.commit();
                    int n = this.controlStmt.executeUpdate("END LOADING");
                    if (n != this.numBatchedRowsSent) {
                        SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ476", String.valueOf(this.numBatchedRowsSent - n), this.tableName, String.valueOf(this.numBatchedRowsSent), String.valueOf(n));
                        ((FastLoadManagerConnection)this.managerCon).chainSQLWarnings(sQLWarning);
                    }
                    this.controlCon.commit();
                    this.controlCon.setAutoCommit(true);
                    try {
                        this.selectFastLoadErrorTables();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    }
                    this.dropFastLoadErrorTables();
                    this.closeFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    try {
                        this.abortFastLoad();
                    }
                    catch (SQLException sQLException4) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                    }
                    Object var5_9 = null;
                    this.fastloading = false;
                    this.numBatchedRowsSent = 0;
                    this.checkFastloadErrorTables = false;
                    if (this.closed) {
                        ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                    }
                }
                Object var5_8 = null;
                this.fastloading = false;
                this.numBatchedRowsSent = 0;
                this.checkFastloadErrorTables = false;
                if (this.closed) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.fastloading = false;
                this.numBatchedRowsSent = 0;
                this.checkFastloadErrorTables = false;
                if (this.closed) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ461", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackFastLoad() throws SQLException {
        if (this.connected && this.fastloading) {
            SQLException sQLException = null;
            try {
                block9: {
                    try {
                        this.rollingback = true;
                        this.abortFastLoad();
                        if (!this.closed) break block9;
                        this.closeFastLoad();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        Object var4_3 = null;
                        this.fastloading = false;
                        this.numBatchedRowsSent = 0;
                        this.checkFastloadErrorTables = false;
                        this.rollingback = false;
                        if (this.closed) {
                            ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                        }
                    }
                }
                Object var4_2 = null;
                this.fastloading = false;
                this.numBatchedRowsSent = 0;
                this.checkFastloadErrorTables = false;
                this.rollingback = false;
                if (this.closed) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.fastloading = false;
                this.numBatchedRowsSent = 0;
                this.checkFastloadErrorTables = false;
                this.rollingback = false;
                if (this.closed) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ478", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    protected String getLogonSequenceNumber() {
        if (this.connected) {
            return ((TeraLocalConnection)this.controlCon).getTDSession().getLogonSequenceNumber();
        }
        return "";
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected boolean isFastLoading() {
        return this.fastloading;
    }

    public void addBatch() throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        int n = this.fastloadPrepStmtIndex;
        try {
            this.fastloadPrepStmts[this.fastloadPrepStmtIndex].addBatch();
            int n2 = this.fastloadPrepStmtIndex++;
            this.numBatchedRowsInPrepStmt[n2] = this.numBatchedRowsInPrepStmt[n2] + 1;
            if (this.fastloadPrepStmtIndex >= this.fastloadPrepStmts.length) {
                this.fastloadPrepStmtIndex = 0;
            }
            ++this.numBatchedRows;
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", n, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ462", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        if (this.connected) {
            SQLException sQLException = null;
            try {
                this.fastloadPrepStmts[0].clearParameters();
            }
            catch (SQLException sQLException2) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ463", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getParameterMetaData();
    }

    private static int preferredSqlType(int n) {
        switch (n) {
            case -4: 
            case -2: {
                return -3;
            }
            case 7: 
            case 8: {
                return 6;
            }
            case 2: {
                return 3;
            }
            case -1: 
            case 1: 
            case 1111: {
                return 12;
            }
        }
        return n;
    }

    private Object automaticDataTypeConversion(int n, int n2, Object object) throws SQLException {
        ObjectWithAttributes objectWithAttributes = object instanceof ObjectWithAttributes ? (ObjectWithAttributes)object : new ObjectWithAttributes(object);
        object = objectWithAttributes.object;
        if (n2 < 1 || n2 > this.paramMetaData.size()) {
            return object;
        }
        FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)this.paramMetaData.get(n2 - 1);
        int n3 = FastLoadManagerPreparedStatement.preferredSqlType(JDBC4Constants.getJavaSQLType(fullContentMetadataItem.getDataType()));
        if (objectWithAttributes.bUserSpecifiedType) {
            objectWithAttributes.targetSqlType = FastLoadManagerPreparedStatement.preferredSqlType(objectWithAttributes.targetSqlType);
            if (objectWithAttributes.targetSqlType != n3) {
                throw ErrorFactory.makeDriverJDBCException("TJ532", String.valueOf(n2), String.valueOf(objectWithAttributes.targetSqlType), String.valueOf(n3), this.tableName);
            }
        } else {
            objectWithAttributes.targetSqlType = n3;
        }
        if (objectWithAttributes.bUserSpecifiedScale) {
            if (n3 == 3 && objectWithAttributes.targetScale != fullContentMetadataItem.getNumberOfFractionalDigits()) {
                throw ErrorFactory.makeDriverJDBCException("TJ533", String.valueOf(n2), String.valueOf(objectWithAttributes.targetScale), String.valueOf(fullContentMetadataItem.getNumberOfFractionalDigits()), this.tableName);
            }
        } else {
            objectWithAttributes.targetScale = fullContentMetadataItem.getNumberOfFractionalDigits();
        }
        try {
            if (n == 1 && object == null) {
                object = new SupportedButNull(objectWithAttributes);
            } else if (n == 2 || object instanceof String) {
                if (objectWithAttributes.targetSqlType == -6) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Byte.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == 5) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Short.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == 4) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Integer.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == -5) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Long.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == 6) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Double.valueOf((String)object);
                } else if (objectWithAttributes.targetSqlType == 3) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new BigDecimal((String)object);
                } else if (objectWithAttributes.targetSqlType == 91) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Date.valueOf((String)object);
                } else if (objectWithAttributes.targetSqlType == 92) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Time.valueOf((String)object);
                } else if (objectWithAttributes.targetSqlType == 93) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Timestamp.valueOf((String)object);
                }
            } else if (n == 3 || object instanceof Number) {
                if (objectWithAttributes.targetSqlType == 12) {
                    if (object instanceof BigDecimal && ((BigDecimal)object).scale() < 0) {
                        object = ((BigDecimal)object).movePointRight(0);
                    }
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == -6 && !(object instanceof Byte)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == 5 && !(object instanceof Short)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == 4 && !(object instanceof Integer)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == -5 && !(object instanceof Long)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == 6 && !(object instanceof Double)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Double(Double.valueOf(object.toString()));
                } else if (objectWithAttributes.targetSqlType == 3 && !(object instanceof BigDecimal)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new BigDecimal(object.toString());
                }
            } else if (n == 4 || object instanceof Date) {
                if (objectWithAttributes.targetSqlType == 12) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == 93) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Timestamp(((Date)object).getTime());
                }
            } else if (n == 5 || object instanceof Time) {
                if (objectWithAttributes.targetSqlType == 12) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == 93) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Timestamp(((Time)object).getTime());
                }
            } else if (n == 6 || object instanceof Timestamp) {
                if (objectWithAttributes.targetSqlType == 12) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == 91) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Date(((Timestamp)object).getTime());
                } else if (objectWithAttributes.targetSqlType == 92) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Time(((Timestamp)object).getTime());
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ553", n2, objectWithAttributes.targetSqlType);
            jDBCException.initCause(exception);
            throw jDBCException;
        }
        if (object instanceof BigDecimal) {
            boolean bl = false;
            if (objectWithAttributes.bUserSpecifiedScale) {
                if (objectWithAttributes.targetScale >= 0) {
                    bl = true;
                }
            } else {
                objectWithAttributes.targetScale = fullContentMetadataItem.getNumberOfFractionalDigits();
                bl = true;
            }
            if (bl) {
                object = ((BigDecimal)object).setScale(objectWithAttributes.targetScale, 4);
            }
        }
        return object;
    }

    private int getIntegralDataSize(Object object) {
        if (!(object instanceof BigDecimal)) {
            object = new BigDecimal(((Number)object).toString());
        }
        return ((BigDecimal)object).toBigInteger().bitLength() / 8 + 1;
    }

    private Object getIntegralObject(int n, Object object, int n2) throws SQLException {
        if (object instanceof BigDecimal || object instanceof Float || object instanceof Double) {
            BigInteger bigInteger = object instanceof BigDecimal ? ((BigDecimal)object).toBigInteger() : new BigDecimal(object.toString()).toBigInteger();
            switch (n2) {
                case -5: {
                    if (bigInteger.compareTo(MIN_LONG_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_LONG_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 8);
                    }
                    object = new Long(bigInteger.longValue());
                    break;
                }
                case 4: {
                    if (bigInteger.compareTo(MIN_INTEGER_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_INTEGER_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 4);
                    }
                    object = new Integer(bigInteger.intValue());
                    break;
                }
                case 5: {
                    if (bigInteger.compareTo(MIN_SHORT_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_SHORT_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 2);
                    }
                    object = new Short(bigInteger.shortValue());
                    break;
                }
                case -6: {
                    if (bigInteger.compareTo(MIN_BYTE_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_BYTE_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 1);
                    }
                    object = new Byte(bigInteger.byteValue());
                }
            }
        } else if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            long l = ((Number)object).longValue();
            switch (n2) {
                case -5: {
                    object = new Long(l);
                    break;
                }
                case 4: {
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 4);
                    }
                    object = new Integer(((Number)object).intValue());
                    break;
                }
                case 5: {
                    if (l < -32768L || l > 32767L) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 2);
                    }
                    object = new Short(((Number)object).shortValue());
                    break;
                }
                case -6: {
                    if (l < -128L || l > 127L) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 1);
                    }
                    object = new Byte(((Number)object).byteValue());
                }
            }
        }
        return object;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setArray(n, array);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, bigDecimal);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setBigDecimal(n, bigDecimal);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBlob(n, blob);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBoolean(n, bl);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Byte(by));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBytes(n, byArray);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setClob(n, clob);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(4, n, date);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setDate(n, date);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setDate(n, date, calendar);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Double(d));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Float(f));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Integer(n2));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Long(l));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(1, n, new ObjectWithAttributes(null, n2));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setNull(n, n2);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setNull(n, n2, string);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        object = this.automaticDataTypeConversion(1, n, object);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setObject(n, object);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        object = this.automaticDataTypeConversion(1, n, new ObjectWithAttributes(object, n2));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setObject(n, object, n2);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        object = this.automaticDataTypeConversion(1, n, new ObjectWithAttributes(object, n2, n3));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setObject(n, object, n2, n3);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setRef(n, ref);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Short(s));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(2, n, string);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setString(n, string);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(5, n, time);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setTime(n, time);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setTime(n, time, calendar);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(6, n, timestamp);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setTimestamp(n, timestamp);
            }
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setURL(n, uRL);
        }
        catch (SQLException sQLException2) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        this.numBatchedRows = 0;
        this.fastloadPrepStmtIndex = 0;
        if (this.connected) {
            int n;
            SQLException sQLException = null;
            for (n = 0; n < this.fastloadPrepStmts.length; ++n) {
                try {
                    this.fastloadPrepStmts[n].clearBatch();
                    continue;
                }
                catch (SQLException sQLException2) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ468", n, this.fastloadPrepStmts.length);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            for (n = 0; n < this.numBatchedRowsInPrepStmt.length; ++n) {
                this.numBatchedRowsInPrepStmt[n] = 0;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ465", this.tableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.sqlWarnings = null;
        if (this.connected) {
            this.controlStmt.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        SQLException sQLException = null;
        try {
            try {
                if (!this.fastloading) {
                    try {
                        this.closeFastLoad();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    }
                }
                this.appPstmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                Object var4_6 = null;
                this.closed = true;
                if (!this.fastloading) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
            }
            Object var4_5 = null;
            this.closed = true;
            if (!this.fastloading) {
                ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.closed = true;
            if (!this.fastloading) {
                ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
            }
            throw throwable;
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ466", this.tableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int[] executeBatch() throws SQLException {
        Object object;
        int[] nArray;
        SQLException sQLException;
        block34: {
            TDPacket[] tDPacketArray;
            block33: {
                int n;
                int n2;
                this.abortIfClosed();
                if (this.numBatchedRows == 0) {
                    throw ErrorFactory.makeDriverJDBCException("TJ416");
                }
                this.initializeFastLoad();
                sQLException = null;
                int n3 = 0;
                nArray = new int[this.numBatchedRows];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = -3;
                }
                tDPacketArray = new TDPacket[this.fastloadCons.length];
                this.clearWarnings();
                this.beginFastLoad();
                object = new boolean[this.fastloadPrepStmts.length];
                int[] nArray2 = new int[this.fastloadPrepStmts.length];
                int[] nArray3 = new int[this.fastloadPrepStmts.length];
                int[] nArray4 = new int[this.fastloadPrepStmts.length];
                int n4 = 0;
                int[][] nArrayArray = new int[this.fastloadPrepStmts.length][];
                for (n2 = 0; n2 < nArrayArray.length; ++n2) {
                    nArrayArray[n2] = new int[this.numBatchedRowsInPrepStmt[n2]];
                    for (n = 0; n < nArrayArray[n2].length; ++n) {
                        nArrayArray[n2][n] = -3;
                    }
                    if (nArrayArray[n2].length <= 0) continue;
                    ++n4;
                }
                for (n2 = 0; n2 < tDPacketArray.length; ++n2) {
                    tDPacketArray[n2] = TDPacketPool.getInstance().getTDPacket(((FastLoadManagerConnection)this.managerCon).getLog());
                }
                boolean[] blArray = new boolean[this.fastloadPrepStmts.length];
                for (n = 0; n < blArray.length; ++n) {
                    blArray[n] = true;
                }
                ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad will use " + n4 + " FastLoadPreparedStatement(s) to insert data.");
                n = 0;
                int n5 = 0;
                do {
                    JDBCException jDBCException;
                    int n6;
                    n5 = 0;
                    for (n6 = 0; n6 < this.fastloadPrepStmts.length; ++n6) {
                        nArray2[n6] = nArray3[n6];
                        if (nArray3[n6] < nArray4[n6]) {
                            nArray3[n6] = nArray4[n6];
                        }
                        if (!blArray[n6]) continue;
                        blArray[n6] = false;
                        if (sQLException != null || nArray3[n6] >= this.numBatchedRowsInPrepStmt[n6]) continue;
                        try {
                            nArray3[n6] = ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).bufferBatchedRows(tDPacketArray[n6], nArray3[n6]);
                            ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).sendBatchedRows(tDPacketArray[n6]);
                            this.numBatchedRowsSent += nArray3[n6] - nArray2[n6];
                            if (n != 0) continue;
                            n = 1;
                            continue;
                        }
                        catch (SQLException sQLException2) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ471", n6, this.fastloadPrepStmts.length, n4);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            object[n6] = true;
                        }
                    }
                    for (n6 = 0; n6 < this.fastloadPrepStmts.length; ++n6) {
                        if (sQLException != null || nArray3[n6] >= this.numBatchedRowsInPrepStmt[n6]) continue;
                        try {
                            nArray4[n6] = ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).bufferBatchedRows(tDPacketArray[n6], nArray3[n6]);
                            continue;
                        }
                        catch (SQLException sQLException3) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ520", n6, this.fastloadPrepStmts.length, n4);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                        }
                    }
                    for (n6 = 0; n6 < this.fastloadPrepStmts.length && n != 0; ++n6) {
                        if (object[n6] != false || nArray2[n6] == nArray3[n6]) continue;
                        try {
                            ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).receiveBatchedRowUpdateCounts(nArray2[n6], nArrayArray[n6]);
                            if (sQLException == null && nArray3[n6] < nArray4[n6]) {
                                ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).sendBatchedRows(tDPacketArray[n6]);
                                this.numBatchedRowsSent += nArray4[n6] - nArray3[n6];
                                if (n5 == 0) {
                                    n5 = 1;
                                }
                            }
                            int n7 = n6 % this.fastloadPrepStmts.length;
                            for (int i = nArray2[n6]; i < nArray3[n6]; ++i) {
                                nArray[i * this.fastloadPrepStmts.length + n7] = nArrayArray[n6][i];
                                if (nArrayArray[n6][i] == 1) continue;
                                ++n3;
                            }
                            continue;
                        }
                        catch (SQLException sQLException4) {
                            JDBCException jDBCException2 = ErrorFactory.makeDriverJDBCException("TJ521", n6, this.fastloadPrepStmts.length, n4);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException2);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                            object[n6] = true;
                        }
                    }
                } while ((n = n5) != 0);
                if (n3 != 0) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n3), this.tableName);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                }
                if (sQLException != null || !this.managerCon.getAutoCommit()) break block33;
                this.endFastLoad();
            }
            Object var18_28 = null;
            for (int i = 0; i < tDPacketArray.length; ++i) {
                if (tDPacketArray[i] == null) continue;
                TDPacketPool.getInstance().returnTDPacket(tDPacketArray[i], ((FastLoadManagerConnection)this.managerCon).getLog());
            }
            try {
                this.clearBatch();
            }
            catch (SQLException sQLException5) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
            }
            break block34;
            {
                catch (SQLException sQLException6) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                    Object var18_29 = null;
                    for (int i = 0; i < tDPacketArray.length; ++i) {
                        if (tDPacketArray[i] == null) continue;
                        TDPacketPool.getInstance().returnTDPacket(tDPacketArray[i], ((FastLoadManagerConnection)this.managerCon).getLog());
                    }
                    try {
                        this.clearBatch();
                    }
                    catch (SQLException sQLException7) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_30 = null;
                for (int i = 0; i < tDPacketArray.length; ++i) {
                    if (tDPacketArray[i] == null) continue;
                    TDPacketPool.getInstance().returnTDPacket(tDPacketArray[i], ((FastLoadManagerConnection)this.managerCon).getLog());
                }
                try {
                    this.clearBatch();
                }
                catch (SQLException sQLException8) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException8);
                }
                throw throwable;
            }
        }
        if (sQLException != null) {
            object = ErrorFactory.makeBatchUpdateException("TJ467", nArray, this.tableName);
            ((SQLException)object).setNextException(sQLException);
            ((Throwable)object).initCause(sQLException);
            throw object;
        }
        return nArray;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.managerCon;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        if (this.connected) {
            this.chainSQLWarnings(this.controlStmt.getWarnings());
            this.controlStmt.clearWarnings();
        }
        return this.sqlWarnings;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchSize(n);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxFieldSize(n);
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxRows(n);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    private static class SupportedButNull {
        public int targetSqlType;
        public int targetScale;

        public SupportedButNull(ObjectWithAttributes objectWithAttributes) {
            this.targetSqlType = objectWithAttributes.targetSqlType;
            this.targetScale = objectWithAttributes.targetScale;
        }
    }

    private static class ObjectWithAttributes {
        public Object object;
        public boolean bUserSpecifiedType = false;
        public int targetSqlType;
        public boolean bUserSpecifiedScale = false;
        public int targetScale;

        public ObjectWithAttributes(Object object) {
            this.object = object;
        }

        public ObjectWithAttributes(Object object, int n) {
            this(object);
            this.bUserSpecifiedType = true;
            this.targetSqlType = n;
        }

        public ObjectWithAttributes(Object object, int n, int n2) {
            this(object, n);
            this.bUserSpecifiedScale = true;
            this.targetScale = n2;
        }
    }
}

