/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.monitor;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionBase;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.monitor.MonitorPreparedStatement;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketPool;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ietf.jgss.Oid;

public class MonitorConnection
extends ConnectionBase
implements Connection,
GenericTeradataConnection,
LocalEscapeFunctions {
    private boolean autoCommit = true;
    private LogonInformation logonInformation;
    private TDPacketPool packetPool;
    private long requestNum = 1L;
    private boolean connected = false;
    private long authenticationNonce;
    private TDNetworkIOIF io;
    private Mutex sessionLock;
    private boolean encryptPassword = false;
    private GenericTeraEncrypt myEncrypt = null;
    private AuthMechanism authMethod;
    private Oid serverDefaultAuthMethodOid;
    private ArrayList serverAuthMechs = new ArrayList();
    private boolean SSOSupported = false;
    private boolean usingClientDefaultMech = false;
    private ConfigRspParcel configRsp;
    private AssignRspParcel assignRsp;
    private boolean UTF_CredentialSupported = false;

    public MonitorConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, uRLParameters);
        this.logonInformation = new LogonInformation(string2, string3);
        if (uRLParameters.getAccountId().compareTo("NO_ACCOUNT_ID") != 0) {
            this.logonInformation.setAccount(uRLParameters.getAccountId());
        }
        this.packetPool = TDPacketPool.getInstance();
        this.sessionLock = new Mutex("SessionLock", this.log);
        try {
            this.connected = true;
            GenericLogonController genericLogonController = new GenericLogonController(this.logonInformation, this);
            genericLogonController.run();
        }
        catch (SQLException sQLException) {
            this.connected = false;
            if (this.io != null) {
                this.io.close();
            }
            throw sQLException;
        }
    }

    private boolean isLobSupported() {
        return this.configRsp.getLOBSupport() && this.urlParams.isLobSupported();
    }

    public LogonInformation getLogonInformation() {
        return this.logonInformation;
    }

    public TDNetworkIOIF getIO() throws JDBCException {
        if (this.io == null) {
            this.io = new TDNetworkIOIF(this);
        }
        return this.io;
    }

    public TDPacket getPacket() {
        return this.packetPool.getTDPacket(this.log);
    }

    public TDPacket getPacket(int n) {
        return this.packetPool.getTDPacket(n, this.log);
    }

    public void returnPacket(TDPacket tDPacket) {
        this.packetPool.returnTDPacket(tDPacket, this.log);
    }

    public String getlogmech() {
        return this.urlParams.getLogMech();
    }

    public String getlogdata() {
        return this.urlParams.getLogData();
    }

    public void addServerAuthMech(AuthMechanism authMechanism) {
        this.serverAuthMechs.add(authMechanism);
    }

    public ArrayList getServerAuthMechs() {
        return this.serverAuthMechs;
    }

    public boolean serverHasAuthMechs() {
        return this.serverAuthMechs.size() > 0;
    }

    public AuthMechanism getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMechanism authMechanism) {
        this.authMethod = authMechanism;
    }

    public long getAuthenticationNonce() {
        if (++this.authenticationNonce < 0L) {
            this.authenticationNonce = 0L;
        }
        return this.authenticationNonce;
    }

    public Oid getServerDefaultAuthMethodOid() {
        return this.serverDefaultAuthMethodOid;
    }

    public void setServerDefaultAuthMethodOid(Oid oid) {
        this.serverDefaultAuthMethodOid = oid;
    }

    public boolean getUsingClientDefaultMech() {
        return this.usingClientDefaultMech;
    }

    public void setUsingClientDefaultMech(boolean bl) {
        this.usingClientDefaultMech = bl;
    }

    public String getCharSet() {
        if (this.urlParams.getCharset_Xlate_Flag()) {
            return this.urlParams.getJavaEnCoding();
        }
        return this.getSessionJavaCharSet();
    }

    public byte getTdSessionCharSetCode() throws JDBCException {
        return this.configRsp.getTDCharSetCodeFromName(this.urlParams.getCharSet());
    }

    public void setAssignRspParcel(AssignRspParcel assignRspParcel) {
        this.assignRsp = assignRspParcel;
    }

    public void setConfigResponse(ConfigRspParcel configRspParcel) {
        this.configRsp = configRspParcel;
    }

    public void setLogonSequenceNumberParcel(LogonSequenceNumberParcel logonSequenceNumberParcel) {
    }

    public boolean isUTF_CredentialSupported() {
        return this.UTF_CredentialSupported;
    }

    public void setUTF_CredentialSupported(boolean bl) {
        this.UTF_CredentialSupported = bl;
    }

    public GenericTeraEncrypt getTeraEncrypt() {
        return this.myEncrypt;
    }

    public void setTeraEncrypt(GenericTeraEncrypt genericTeraEncrypt) {
        this.myEncrypt = genericTeraEncrypt;
    }

    public boolean getSSOSupported() {
        return this.SSOSupported;
    }

    public void setSSOSupported(boolean bl) {
        this.SSOSupported = bl;
    }

    public boolean getEncryptData() {
        return this.urlParams.getEncryptData();
    }

    public boolean getEncryptPassword() {
        return this.encryptPassword;
    }

    public void setEncryptPassword(boolean bl) {
        this.encryptPassword = bl;
    }

    public int getSessionNum() {
        return this.io.getSessionNum();
    }

    public void setSessionNum(int n) {
        this.io.setSessionNum(n);
    }

    public synchronized int getRequestNum() {
        ++this.requestNum;
        if (this.requestNum == -1L) {
            this.requestNum = 0L;
        }
        return (int)this.requestNum;
    }

    public char getTransactionSemantics() {
        return this.urlParams.getTransactMode().charAt(0);
    }

    private LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public synchronized String getLogonSequenceNumber() {
        return "";
    }

    public String getAMPCount() {
        return this.configRsp == null ? "" : String.valueOf(this.configRsp.getAMPCount());
    }

    public String getLogLevel() {
        return this.getLog().getLogLevel();
    }

    public String setLogLevel(String string) {
        this.getLog().setLogLevel(string);
        return "";
    }

    public String beginCapture() {
        this.getLog().beginCapture();
        return "";
    }

    public String endCapture() {
        return this.getLog().endCapture();
    }

    public String useAnsiDate() {
        return "";
    }

    public String useIntegerDate() {
        return "";
    }

    public String getSessionNumber() {
        return this.io != null ? String.valueOf(this.io.getSessionNum()) : "";
    }

    public String getSocketInfo() {
        return this.io != null ? this.io.toString() : "";
    }

    public void close() throws SQLException {
        if (this.connected) {
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            try {
                genericLogoffController.run();
                this.io.close();
                if (this.log.isDebugEnabled()) {
                    this.packetPool.getPoolStatistics(this.log);
                }
            }
            catch (SQLException sQLException) {
                this.log.error("Exception", sQLException);
                throw sQLException;
            }
            finally {
                this.connected = false;
            }
        }
    }

    public void commit() throws SQLException {
        this.abortIfClosed();
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return new HashMap();
    }

    public boolean isClosed() throws SQLException {
        return !this.connected;
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        return new MonitorPreparedStatement(this, string);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    public void rollback() throws SQLException {
        this.abortIfClosed();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.autoCommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
    }
}

