/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.monitor;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.PreparedParameter;
import com.teradata.jdbc.TeraPreparedStatement;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc.monitor.MonitorConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class MonitorPreparedStatement
implements PreparedStatement {
    private MonitorConnection con = null;
    private String sql = null;
    private Results results = null;
    private Object[] workingRow = new Object[2000];
    private BitSet workingRowColumn = new BitSet(2000);
    private int maxDecimalPrecision = 18;
    public static final int TIME_STRING_LENGTH = 8;
    public static final int TIMESTAMP_STRING_LENGTH = 19;
    public static final int TIME_ZONE_STRING_LENGTH = 6;
    public static final int MAX_COLUMN_COUNT = 2000;

    public MonitorPreparedStatement(MonitorConnection monitorConnection, String string) throws SQLException {
        this.con = monitorConnection;
        this.sql = string;
        this.results = new Results(monitorConnection.getLog());
    }

    private void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.workingRow == null || this.workingRowColumn == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > 2000) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void initReqPacket(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind(by);
        tDPacket.setRequestNumber(n);
    }

    private void initIndicReq(TDPacket tDPacket) throws SQLException {
        IndicRequestParcel indicRequestParcel = new IndicRequestParcel(this.con.getCharSet(), this.con.getLog());
        indicRequestParcel.setRequestText(this.sql);
        tDPacket.addParcel(indicRequestParcel);
    }

    private void initIndicData(TDPacket tDPacket) throws SQLException {
        int n;
        int n2;
        int n3 = this.workingRowColumn.nextClearBit(0);
        byte[] byArray = new byte[(n3 + 7) / 8];
        PreparedParameter[] preparedParameterArray = new PreparedParameter[n3];
        for (n2 = 0; n2 < preparedParameterArray.length; ++n2) {
            preparedParameterArray[n2] = new PreparedParameter(4);
        }
        n2 = 0;
        IndicDataParcel indicDataParcel = null;
        ResponseParcel responseParcel = new ResponseParcel(this.con.getCharSet(), this.con.getLog());
        int n4 = responseParcel.toStream().limit();
        int n5 = 0;
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        n2 = byArray.length;
        for (n = 0; n < preparedParameterArray.length; ++n) {
            this.initPreparedParameter(preparedParameterArray[n], this.workingRow[n], n + 1, 1);
            n2 += preparedParameterArray[n].getLength();
            if (!preparedParameterArray[n].isNullValue()) continue;
            int n6 = (n + 8) / 8 - 1;
            byArray[n6] = (byte)(byArray[n6] | (byte)(1 << 7 - n % 8));
        }
        indicDataParcel = new IndicDataParcel(n2, this.con.getCharSet(), this.con.getLog());
        indicDataParcel.setParameters(preparedParameterArray);
        indicDataParcel.setNullIndicatorBits(byArray);
        n5 = indicDataParcel.toStream().limit();
        if (n5 > 65156 - tDPacket.getBuffer().position() - n4) {
            throw ErrorFactory.makeDriverJDBCException("TJ421", 1, n5, 65156 - tDPacket.getBuffer().position() - n4);
        }
        tDPacket.addParcel(indicDataParcel);
    }

    private void initPreparedParameter(PreparedParameter preparedParameter, Object object, int n, int n2) throws SQLException {
        boolean bl = false;
        Calendar calendar = null;
        int n3 = 0;
        if (object instanceof TypedNull) {
            object = ((TypedNull)object).getType();
            bl = true;
        }
        if (object instanceof ObjectWithCalendar) {
            calendar = ((ObjectWithCalendar)object).getCalendar();
            object = ((ObjectWithCalendar)object).getObject();
            n3 = 6;
        }
        if (object instanceof BigDecimal) {
            int n4 = 0;
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(new BigDecimal(0.0)) != 0) {
                n4 = bigDecimal.scale();
                bigDecimal = bigDecimal.movePointRight(n4);
            }
            preparedParameter.setNewValues(object, ByteConverter.putLong(bigDecimal.longValue()), 485, bl, this.maxDecimalPrecision, n4);
        } else if (object instanceof Byte) {
            preparedParameter.setNewValues(object, ByteConverter.putByte((Byte)object), 757, bl, 0, 0);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 64000) {
                throw ErrorFactory.makeTDDataTruncation("TJ424", n, true, false, byArray.length, 64000, n2);
            }
            byte[] byArray2 = new byte[byArray.length + 2];
            ByteConverter.putShort(byArray2, 0, (short)byArray.length);
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            preparedParameter.setNewValues(object, byArray2, 689, bl, 0, 0);
        } else if (object instanceof Date) {
            int n5 = 0;
            if (!bl) {
                String string = ((Date)object).toString();
                n5 = (Integer.valueOf(string.substring(0, 4)) - 1900) * 10000 + Integer.valueOf(string.substring(5, 7)) * 100 + Integer.valueOf(string.substring(8, 10));
            }
            preparedParameter.setNewValues(object, ByteConverter.putInt(n5), 497, bl, 0, 0);
        } else if (object instanceof Double) {
            preparedParameter.setNewValues(object, ByteConverter.putDouble((Double)object), 481, bl, 0, 0);
        } else if (object instanceof Integer) {
            preparedParameter.setNewValues(object, ByteConverter.putInt((Integer)object), 497, bl, 0, 0);
        } else if (object instanceof Short) {
            preparedParameter.setNewValues(object, ByteConverter.putShort((Short)object), 501, bl, 0, 0);
        } else if (object instanceof String) {
            try {
                byte[] byArray = ((String)object).getBytes(this.con.getURLParameters().getJavaEnCoding());
                if (byArray.length > 64000) {
                    throw ErrorFactory.makeTDDataTruncation("TJ410", n, true, false, byArray.length, 64000, n2);
                }
                preparedParameter.setNewValues(object, byArray, 453, bl, 0, 0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ418", String.valueOf(n), String.valueOf(n2), this.con.getURLParameters().getJavaEnCoding());
                jDBCException.initCause(unsupportedEncodingException);
                throw jDBCException;
            }
        } else if (object instanceof Time) {
            try {
                int n6 = this.con.getURLParameters().getTimeNano() < 1 ? 0 : this.con.getURLParameters().getTimeNano() + 1;
                StringBuffer stringBuffer = new StringBuffer(8 + n6 + n3);
                if (!bl) {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTimeInMillis(((Time)object).getTime());
                    int n7 = gregorianCalendar.get(14);
                    String string = String.valueOf(n7);
                    if (n7 < 10) {
                        string = "00" + n7;
                    } else if (n7 < 100) {
                        string = "0" + n7;
                    }
                    String string2 = ((Time)object).toString() + "." + string;
                    int n8 = string2.length() > stringBuffer.capacity() - n3 ? stringBuffer.capacity() - n3 : string2.length();
                    stringBuffer = stringBuffer.append(string2.toCharArray(), 0, n8);
                    for (int i = n8; i < stringBuffer.capacity() - n3; ++i) {
                        stringBuffer = stringBuffer.append('0');
                    }
                    if (calendar != null) {
                        stringBuffer = stringBuffer.append(TeraPreparedStatement.getTimeZone(calendar));
                    }
                } else {
                    for (int i = 0; i < stringBuffer.capacity(); ++i) {
                        stringBuffer = stringBuffer.append(' ');
                    }
                }
                preparedParameter.setNewValues(object, stringBuffer.toString().getBytes(this.con.getURLParameters().getJavaEnCoding()), 453, bl, 0, 0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ418", String.valueOf(n), String.valueOf(n2), this.con.getURLParameters().getJavaEnCoding());
                jDBCException.initCause(unsupportedEncodingException);
                throw jDBCException;
            }
        } else if (object instanceof Timestamp) {
            try {
                int n9 = this.con.getURLParameters().getTimestampNano() < 1 ? 0 : this.con.getURLParameters().getTimestampNano() + 1;
                StringBuffer stringBuffer = new StringBuffer(19 + n9 + n3);
                if (!bl) {
                    String string = ((Timestamp)object).toString();
                    int n10 = string.length() > stringBuffer.capacity() - n3 ? stringBuffer.capacity() - n3 : string.length();
                    stringBuffer = stringBuffer.append(string.toCharArray(), 0, n10);
                    for (int i = n10; i < stringBuffer.capacity() - n3; ++i) {
                        stringBuffer = stringBuffer.append('0');
                    }
                    if (calendar != null) {
                        stringBuffer = stringBuffer.append(TeraPreparedStatement.getTimeZone(calendar));
                    }
                } else {
                    for (int i = 0; i < stringBuffer.capacity(); ++i) {
                        stringBuffer = stringBuffer.append(' ');
                    }
                }
                preparedParameter.setNewValues(object, stringBuffer.toString().getBytes(this.con.getURLParameters().getJavaEnCoding()), 453, bl, 0, 0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ418", String.valueOf(n), String.valueOf(n2), this.con.getURLParameters().getJavaEnCoding());
                jDBCException.initCause(unsupportedEncodingException);
                throw jDBCException;
            }
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ417", String.valueOf(n), String.valueOf(n2), object.getClass().getName());
        }
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        ResponseParcel responseParcel = new ResponseParcel(this.con.getCharSet(), this.con.getLog());
        responseParcel.setMaxMsgSize(65104);
        tDPacket.addParcel(responseParcel);
    }

    private void bufferMessage(TDPacket tDPacket) throws SQLException {
        this.initReqPacket(tDPacket, (byte)5, this.con.getRequestNum());
        this.initIndicReq(tDPacket);
        this.initIndicData(tDPacket);
        this.initResp(tDPacket);
        if (this.con.getEncryptData() && this.con.getAuthMethod() != null) {
            tDPacket.setEncrypted();
        }
        tDPacket.toStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(TDPacket tDPacket) throws SQLException {
        this.con.getLog().debug(tDPacket.getBuffer());
        this.con.getLog().debug("LAN Header request number: " + tDPacket.getRequestNumber());
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireWriteLock();
        try {
            tDPacket.getBuffer().writeStream(tDNetworkIOIF, this.con.getTeraEncrypt());
        }
        finally {
            tDNetworkIOIF.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(TDPacket tDPacket) throws SQLException {
        tDPacket.clear();
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(tDNetworkIOIF, this.con.getTeraEncrypt());
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
        tDPacket.initParcelFactory(this.con.getCharSet(), this.con.getLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean receiveResults() throws SQLException {
        Parcel parcel;
        TDPacket tDPacket = null;
        try {
            tDPacket = this.con.getPacket();
            this.receiveMessage(tDPacket);
            ResultSet resultSet = null;
            parcel = null;
            block14: while (true) {
                PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator;
                Object object;
                Parcel parcel2;
                if ((parcel = tDPacket.nextParcel()) == null) {
                    parcel2 = tDPacket.getParcelFactoryPrepInfo();
                    object = null;
                    try {
                        object = this.con.getPacket();
                        this.initReqPacket((TDPacket)object, (byte)6, tDPacket.getRequestNumber());
                        this.initResp((TDPacket)object);
                        if (this.con.getEncryptData() && this.con.getAuthMethod() != null) {
                            ((TDPacket)object).setEncrypted();
                        }
                        ((TDPacket)object).toStream();
                        this.sendMessage((TDPacket)object);
                        prepInfoItemIterator = null;
                        if (object != null) {
                            this.con.returnPacket((TDPacket)object);
                        }
                    }
                    catch (Throwable throwable) {
                        prepInfoItemIterator = null;
                        if (object != null) {
                            this.con.returnPacket((TDPacket)object);
                        }
                        throw throwable;
                    }
                    this.receiveMessage(tDPacket);
                    tDPacket.setParcelFactoryPrepInfo((PrepInfoParcel)parcel2);
                    parcel = tDPacket.nextParcel();
                }
                if (parcel == null) {
                    this.con.getLog().error("Did not receive an expected parcel from the database!");
                    throw ErrorFactory.makeIoJDBCException("TJ420", "MonitorPreparedStatement.receiveResults", this.con.getIO(), null, this.con.getLog());
                }
                this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
                switch (parcel.getFlavor()) {
                    case 8: {
                        parcel2 = (SuccessParcel)parcel;
                        resultSet = ResultSet.createResultSet(null, null, this.con.getLog());
                        resultSet.setNumberOfRows(((SuccessParcel)parcel2).getActivityCount() < 0 ? Integer.MAX_VALUE : ((SuccessParcel)parcel2).getActivityCount());
                        continue block14;
                    }
                    case 71: {
                        Object object2;
                        object = (DataInfoParcel)parcel;
                        TeraResultSetMetaData teraResultSetMetaData = new TeraResultSetMetaData(null);
                        prepInfoItemIterator = ((PrepInfoParcel)object).getPrepInfoItemIterator();
                        while (prepInfoItemIterator.hasNext()) {
                            object2 = new ColumnProperties();
                            ((ColumnProperties)object2).initWithPrepInfoItem(prepInfoItemIterator.next(), this.con.getSessionJavaCharSet());
                            teraResultSetMetaData.addColumnProperties((ColumnProperties)object2);
                        }
                        resultSet.setMetaData(teraResultSetMetaData);
                        continue block14;
                    }
                    case 10: {
                        Object object2 = (RecordParcel)parcel;
                        ResultSetRow resultSetRow = new ResultSetRow();
                        RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = ((RecordParcel)object2).getRecordParcelColumnValuesIterator();
                        while (recordParcelColumnValuesIterator.hasNext()) {
                            resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                        }
                        resultSet.addResultSetRow(resultSetRow);
                        continue block14;
                    }
                    case 11: {
                        EndStatementParcel endStatementParcel = (EndStatementParcel)parcel;
                        resultSet.lastRowFetched();
                        this.results.addResult(null, new Result(resultSet));
                        tDPacket.setParcelFactoryPrepInfo(null);
                        continue block14;
                    }
                    case 9: {
                        FailureParcel failureParcel = (FailureParcel)parcel;
                        this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                    }
                    case 12: {
                        boolean bl = this.results.getResultType() == 2;
                        Object var16_16 = null;
                        if (tDPacket != null) {
                            this.con.returnPacket(tDPacket);
                        }
                        return bl;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            block23: {
                Object var16_17 = null;
                if (tDPacket == null) break block23;
                this.con.returnPacket(tDPacket);
            }
            throw throwable;
        }
        this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
        throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
    }

    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        for (int i = 0; i < this.workingRowColumn.length(); ++i) {
            this.workingRow[i] = null;
        }
        this.workingRowColumn.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        TDPacket tDPacket = null;
        boolean bl = false;
        this.results.reinit();
        try {
            try {
                if (this.workingRowColumn.length() != this.workingRowColumn.nextClearBit(0)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ526", this.workingRowColumn.nextClearBit(0) + 1);
                }
                tDPacket = this.con.getPacket();
                this.bufferMessage(tDPacket);
                this.sendMessage(tDPacket);
                bl = this.receiveResults();
            }
            catch (SQLException sQLException2) {
                sQLException = MonitorPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                Object var6_5 = null;
                if (tDPacket != null) {
                    this.con.returnPacket(tDPacket);
                }
            }
            Object var6_4 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tDPacket != null) {
                this.con.returnPacket(tDPacket);
            }
            throw throwable;
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ527");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
        return bl;
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.abortIfClosed();
            this.abortIfIndexNotValid(n);
            throw ErrorFactory.makeDriverJDBCException("TJ432", n);
        }
        this.setObject(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, new Byte(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        this.setObject(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        this.setObject(n, date);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, new Double(d));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, Double.valueOf(Float.toString(f)));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setNull(int n, int n2) throws SQLException {
        TypedNull typedNull;
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                typedNull = new TypedNull(new byte[0]);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                throw ErrorFactory.makeDriverJDBCException("TJ528", n);
            }
            case 91: {
                typedNull = new TypedNull(new Date(0L));
                break;
            }
            case 2: 
            case 3: {
                throw ErrorFactory.makeDriverJDBCException("TJ449", n);
            }
            case 6: 
            case 7: 
            case 8: {
                typedNull = new TypedNull(new Double(0.0));
                break;
            }
            case 4: {
                typedNull = new TypedNull(new Integer(0));
                break;
            }
            case 5: {
                typedNull = new TypedNull(new Short(0));
                break;
            }
            case 92: {
                typedNull = new TypedNull(new Time(0L));
                break;
            }
            case 93: {
                typedNull = new TypedNull(new Timestamp(0L));
                break;
            }
            case -6: {
                typedNull = new TypedNull(new Byte(0));
                break;
            }
            case -7: 
            case -5: 
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ429", n, n2);
            }
        }
        this.setObject(n, typedNull);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ425", n);
        }
        Object object2 = object;
        if (object2 instanceof TypedNull) {
            object2 = ((TypedNull)object2).getType();
        }
        if (object2 instanceof ObjectWithCalendar) {
            object2 = ((ObjectWithCalendar)object2).getObject();
        }
        if (object2 instanceof Time && this.con.getURLParameters().getTimeNano() < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ452", n);
        }
        if (object2 instanceof Timestamp && this.con.getURLParameters().getTimestampNano() < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ453", n);
        }
        if (object instanceof BigDecimal) {
            int n2;
            BigDecimal bigDecimal = (BigDecimal)object;
            int n3 = bigDecimal.scale();
            if (n3 < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n3 = bigDecimal.scale();
            }
            if ((n2 = ComUtil.getSignificantDigits(bigDecimal) + n3) > this.maxDecimalPrecision) {
                throw ErrorFactory.makeTDDataTruncation("TJ422", n, true, false, n2, this.maxDecimalPrecision);
            }
        } else if (object instanceof Float) {
            object = new Double(Double.valueOf(object.toString()));
        } else if (!(object instanceof Byte || object instanceof byte[] || object instanceof Date || object instanceof Double || object instanceof Integer || object instanceof Short || object instanceof String || object instanceof Time || object instanceof Timestamp || object instanceof TypedNull || object instanceof ObjectWithCalendar)) {
            throw ErrorFactory.makeDriverJDBCException("TJ426", String.valueOf(n), object.getClass().getName());
        }
        this.workingRow[n - 1] = object;
        this.workingRowColumn.set(n - 1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof byte[]) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof String) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 91: {
                if (object instanceof Date) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 2: 
            case 3: {
                if (object instanceof BigDecimal) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Double || object instanceof Float) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 4: {
                if (object instanceof Integer) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 5: {
                if (object instanceof Short) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 92: {
                if (object instanceof Time) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 93: {
                if (object instanceof Timestamp) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -6: {
                if (object instanceof Byte) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -7: 
            case -5: 
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ429", n, n2);
            }
        }
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null && (n2 == 3 || n2 == 2)) {
            if (n3 < 0 || n3 > this.maxDecimalPrecision) {
                throw ErrorFactory.makeDriverJDBCException("TJ431", n, n3, this.maxDecimalPrecision);
            }
            this.setObject(n, new TypedNull(new BigDecimal("0").setScale(n3)));
            return;
        }
        if (object == null && (n2 == 1 || n2 == 12 || n2 == -1)) {
            char[] cArray = new char[n3];
            Arrays.fill(cArray, ' ');
            this.setObject(n, new TypedNull(new String(cArray)));
            return;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n4 = bigDecimal.scale();
            if (n4 < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n4 = bigDecimal.scale();
            }
            if (n4 != n3) {
                throw ErrorFactory.makeDriverJDBCException("TJ430", n, n4, n3);
            }
        } else if (object instanceof String) {
            try {
                byte[] byArray = ((String)object).getBytes(this.con.getURLParameters().getJavaEnCoding());
                if (byArray.length > n3) {
                    throw ErrorFactory.makeTDDataTruncation("TJ529", n, true, false, byArray.length, n3);
                }
                if (byArray.length < n3) {
                    int n5 = " ".getBytes(this.con.getURLParameters().getJavaEnCoding()).length;
                    int n6 = n3 - byArray.length;
                    int n7 = n6 / n5;
                    char[] cArray = new char[n7];
                    Arrays.fill(cArray, ' ');
                    object = (String)object + new String(cArray);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ535", String.valueOf(n), this.con.getURLParameters().getJavaEnCoding());
                jDBCException.initCause(unsupportedEncodingException);
                throw jDBCException;
            }
        }
        this.setObject(n, object, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, new Short(s));
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.abortIfClosed();
            this.abortIfIndexNotValid(n);
            throw ErrorFactory.makeDriverJDBCException("TJ530", n);
        }
        this.setObject(n, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null && calendar == null) {
            this.setNull(n, 92);
            return;
        }
        if (time == null && calendar != null) {
            this.setObject(n, new TypedNull(new ObjectWithCalendar(new Time(0L), calendar)));
            return;
        }
        if (time != null && calendar != null) {
            this.setObject(n, new ObjectWithCalendar(time, calendar));
            return;
        }
        this.setObject(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null && calendar == null) {
            this.setNull(n, 93);
            return;
        }
        if (timestamp == null && calendar != null) {
            this.setObject(n, new TypedNull(new ObjectWithCalendar(new Timestamp(0L), calendar)));
            return;
        }
        if (timestamp != null && calendar != null) {
            this.setObject(n, new ObjectWithCalendar(timestamp, calendar));
            return;
        }
        this.setObject(n, timestamp);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    public void close() throws SQLException {
        this.workingRow = null;
        this.workingRowColumn = null;
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            ResultSet resultSet = this.results.getResult().getResultSet();
            TeraLocalResultSet teraLocalResultSet = new TeraLocalResultSet();
            teraLocalResultSet.setResultSet(resultSet);
            return teraLocalResultSet;
        }
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    private static class ObjectWithCalendar {
        private Object obj;
        private Calendar cal;

        public ObjectWithCalendar(Object object, Calendar calendar) {
            this.obj = object;
            this.cal = calendar;
        }

        public Object getObject() {
            return this.obj;
        }

        public Calendar getCalendar() {
            return this.cal;
        }
    }

    private static class TypedNull {
        private Object type;

        public TypedNull(Object object) {
            this.type = object;
        }

        public Object getType() {
            return this.type;
        }
    }
}

