/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc.raw.RawParameterMetaData;
import com.teradata.jdbc.jdbc.raw.RawResultSet;
import com.teradata.jdbc.jdbc.raw.RawResultSetMetaData;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacketEncrypt;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class RawPreparedStatement
implements PreparedStatement {
    private RawConnection con = null;
    private RawParameterMetaData paramMetaData = null;
    private RawResultSet resultSet = null;
    private RawResultSetMetaData resultSetMetaData = null;
    private byte[] rawMessageToSend = null;
    private int queryTimeoutSeconds = 0;

    public RawPreparedStatement(RawConnection rawConnection) throws SQLException {
        this.con = rawConnection;
        this.paramMetaData = new RawParameterMetaData(this);
        this.resultSetMetaData = new RawResultSetMetaData(this);
    }

    protected void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.paramMetaData == null || this.resultSetMetaData == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > this.paramMetaData.getParameterCount()) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            SQLException sQLException3 = sQLException;
            sQLException3.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void initMessage() throws SQLException {
        int n = Integer.parseInt(this.con.nativeSQL("{fn teradata_session_number()}"));
        this.rawMessageToSend[20] = (byte)(n >> 24 & 0xFF);
        this.rawMessageToSend[21] = (byte)(n >> 16 & 0xFF);
        this.rawMessageToSend[22] = (byte)(n >> 8 & 0xFF);
        this.rawMessageToSend[23] = (byte)(n & 0xFF);
        long l = this.con.getAuthenticationNonce();
        this.rawMessageToSend[24] = (byte)(l >> 56 & 0xFFL);
        this.rawMessageToSend[25] = (byte)(l >> 48 & 0xFFL);
        this.rawMessageToSend[26] = (byte)(l >> 40 & 0xFFL);
        this.rawMessageToSend[27] = (byte)(l >> 32 & 0xFFL);
        this.rawMessageToSend[28] = (byte)(l >> 24 & 0xFFL);
        this.rawMessageToSend[29] = (byte)(l >> 16 & 0xFFL);
        this.rawMessageToSend[30] = (byte)(l >> 8 & 0xFFL);
        this.rawMessageToSend[31] = (byte)(l & 0xFFL);
    }

    private void encryptMessage(TDPacketEncrypt tDPacketEncrypt) throws SQLException {
        if (tDPacketEncrypt == null || !this.con.getURLParameters().getEncryptData()) {
            return;
        }
        byte[] byArray = new byte[24];
        System.arraycopy(this.rawMessageToSend, 0, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[this.rawMessageToSend.length - byArray.length];
        System.arraycopy(this.rawMessageToSend, byArray.length, byArray2, 0, byArray2.length);
        byte[] byArray3 = tDPacketEncrypt.encrypt(byArray2, 0, byArray2.length);
        this.rawMessageToSend = new byte[byArray3.length + byArray.length];
        System.arraycopy(byArray, 0, this.rawMessageToSend, 0, byArray.length);
        System.arraycopy(byArray3, 0, this.rawMessageToSend, byArray.length, byArray3.length);
        this.rawMessageToSend[1] = (byte)(this.rawMessageToSend[1] | 0x80);
        int n = byArray3.length - 28;
        this.rawMessageToSend[3] = (byte)(n >> 24 & 0xFF);
        this.rawMessageToSend[4] = (byte)(n >> 16 & 0xFF);
        this.rawMessageToSend[8] = (byte)(n >> 8 & 0xFF);
        this.rawMessageToSend[9] = (byte)(n & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestResults() throws SQLException {
        TDNetworkIOIF tDNetworkIOIF = null;
        try {
            tDNetworkIOIF = this.con.getIO();
            tDNetworkIOIF.acquireWriteLock();
            try {
                this.initMessage();
                this.encryptMessage(this.con.getTeraEncrypt());
                tDNetworkIOIF.getLog().debugPartialByteArray("Raw packet to be sent", this.rawMessageToSend, 0, this.rawMessageToSend.length);
                tDNetworkIOIF.write(this.rawMessageToSend, 0, this.rawMessageToSend.length);
            }
            catch (Throwable throwable) {
                throw ErrorAnalyzer.analyzeIoError("Raw packet to be sent", tDNetworkIOIF, throwable, false, false);
            }
        }
        finally {
            if (tDNetworkIOIF != null) {
                tDNetworkIOIF.releaseWriteLock();
            }
        }
    }

    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        this.rawMessageToSend = null;
    }

    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        if (this.rawMessageToSend == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ605");
        }
        SQLException sQLException = null;
        this.resultSet = new RawResultSet(this);
        try {
            this.clearWarnings();
            this.requestResults();
        }
        catch (SQLException sQLException2) {
            sQLException = RawPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ567");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.resultSetMetaData;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        return this.paramMetaData;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (byArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ604", n);
        }
        if (byArray.length < 52) {
            throw ErrorFactory.makeDriverJDBCException("TJ606", 52, n);
        }
        if ((byArray[1] & 0x80) != 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ607", n);
        }
        int n2 = byArray[3] << 24 & 0xFF000000 | byArray[4] << 16 & 0xFF0000 | byArray[8] << 8 & 0xFF00 | byArray[9] & 0xFF;
        if (byArray.length - 52 != n2) {
            throw ErrorFactory.makeDriverJDBCException("TJ608", n, byArray.length - 52, n2);
        }
        this.rawMessageToSend = byArray;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    public void close() throws SQLException {
        this.resultSet = null;
        this.paramMetaData = null;
        this.resultSetMetaData = null;
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        this.resultSet = null;
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return this.queryTimeoutSeconds;
    }

    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return this.resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ603", n);
        }
        this.queryTimeoutSeconds = n;
    }
}

