/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraResultSet;
import com.teradata.jdbc.TeraStatement;
import com.teradata.jdbc.jdbc_3.LobStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobStream
extends LobStream {
    public ClobStream(byte[] byArray, long l, ResultSet resultSet) {
        super(byArray, l, resultSet);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ222"), "ClobStream"));
        }
        try {
            if (this.getAvailable() == 0L && this.amountRead() < this.totalLength()) {
                this.setInput(this.getMoreData());
            }
            if (this.getAvailable() > 0L) {
                return this.nextByte();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, (int)(this.totalLength - this.amountRead));
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2, this);
    }

    protected byte[] getMoreData() throws SQLException {
        String string = null;
        try {
            string = ((TeraStatement)this.rs.getStatement()).getConnectionOptions().getURLParams().getJavaEnCoding();
            byte[] byArray = ((TeraResultSet)this.rs).getBlobData(this, this.locator, this.stmtId, "ClobData");
            return new String(byArray, string).getBytes();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ComUtil.ThrowExcp(164, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), string));
            return null;
        }
    }
}

