/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraResultSet;
import com.teradata.jdbc.TeraStatement;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LobReader
extends Reader {
    String input;
    byte[] data;
    long available = 0L;
    long totalLength;
    long amountRead = 0L;
    int index = 0;
    byte[] locator;
    ResultSet rs;
    String stmtId;
    private boolean closed = false;

    public LobReader(byte[] byArray, long l, ResultSet resultSet) {
        this.locator = byArray;
        this.totalLength = l;
        this.rs = resultSet;
        this.stmtId = new String("0");
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ222"), "LobReader"));
        }
        try {
            if (this.available == 0L && this.amountRead < this.totalLength) {
                this.setInput(this.getMoreData());
            }
            if (this.available > 0L) {
                return this.nextChar();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        return -1;
    }

    protected void setInput(String string) {
        this.input = string;
        if (string != null) {
            this.available += (long)string.length();
        }
        if (this.amountRead == 0L) {
            this.index = 9;
            this.available -= 9L;
        } else {
            this.index = 0;
        }
    }

    protected int nextChar() {
        --this.available;
        ++this.amountRead;
        byte[] byArray = new byte[1];
        String string = this.input.substring(0, 1);
        return this.input.charAt(this.index++);
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, (int)(this.totalLength - this.amountRead));
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.closed) {
            throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ222"), "LobReader"));
        }
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.amountRead >= this.totalLength) {
            return -1;
        }
        while (n2 > 0 && this.amountRead < this.totalLength) {
            if (this.available == 0L && this.amountRead < this.totalLength) {
                try {
                    this.setInput(this.getMoreData());
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
            }
            int n4 = this.available > (long)n2 ? n2 : (int)this.available;
            this.input.getChars(this.index, this.index + n4, cArray, n);
            n2 -= n4;
            this.available -= (long)n4;
            this.amountRead += (long)n4;
            this.index += n4;
            n += n4;
            n3 += n4;
        }
        return n3;
    }

    public void close() {
        try {
            ((TeraResultSet)this.rs).close(this.stmtId);
            this.stmtId = "0";
            this.closed = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getStmtId() {
        return this.stmtId;
    }

    public void setStmtId(String string) {
        this.stmtId = string;
    }

    private String getMoreData() throws SQLException {
        String string = null;
        this.data = ((TeraResultSet)this.rs).getBlobData(this, this.locator, this.stmtId, "ClobData");
        if (this.data != null) {
            String string2 = ((TeraStatement)this.rs.getStatement()).getConnectionOptions().getURLParams().getJavaEnCoding();
            try {
                string = new String(this.data, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ComUtil.ThrowExcp(164, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ212"), string2));
            }
        }
        return string;
    }
}

