/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraResultSet;
import com.teradata.jdbc.jdbc_3.ClobStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LobStream
extends InputStream {
    byte[] input;
    long available = 0L;
    long totalLength;
    long amountRead = 0L;
    int index = 0;
    byte[] locator;
    ResultSet rs;
    String stmtId = "0";
    protected boolean closed = false;

    public LobStream(byte[] byArray, long l, ResultSet resultSet) {
        this.locator = byArray;
        this.totalLength = l;
        this.rs = resultSet;
        this.stmtId = new String("0");
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ222"), "LobStream"));
        }
        try {
            if (this.available == 0L && this.amountRead < this.totalLength) {
                this.setInput(this.getMoreData());
            }
            if (this.available > 0L) {
                return this.nextByte();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        return -1;
    }

    protected void setInput(byte[] byArray) {
        this.input = byArray;
        if (byArray != null) {
            this.available += (long)byArray.length;
        }
        if (this.amountRead == 0L) {
            this.index = 9;
            this.available -= 9L;
        } else {
            this.index = 0;
        }
    }

    protected int nextByte() {
        --this.available;
        ++this.amountRead;
        int n = this.input[this.index++] & 0xFF;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, (int)(this.totalLength - this.amountRead));
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2, this);
    }

    public int read(byte[] byArray, int n, int n2, Object object) throws IOException {
        int n3 = 0;
        if (this.closed) {
            throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ222"), "LobStream"));
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.amountRead >= this.totalLength) {
            return -1;
        }
        while (n2 > 0 && this.amountRead < this.totalLength) {
            if (this.available == 0L && this.amountRead < this.totalLength) {
                try {
                    if (object.getClass().getName().compareTo("com.teradata.jdbc.jdbc_3.ClobStream") == 0) {
                        this.setInput(((ClobStream)object).getMoreData());
                    } else {
                        this.setInput(((LobStream)object).getMoreData());
                    }
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
            }
            int n4 = this.available > (long)n2 ? n2 : (int)this.available;
            System.arraycopy(this.input, this.index, byArray, n, n4);
            n2 -= n4;
            this.available -= (long)n4;
            this.amountRead += (long)n4;
            this.index += n4;
            n += n4;
            n3 += n4;
        }
        return n3;
    }

    public String getStmtId() {
        return this.stmtId;
    }

    public void setStmtId(String string) {
        this.stmtId = string;
    }

    public int available() {
        return (int)(this.totalLength - this.amountRead);
    }

    public void close() {
        try {
            ((TeraResultSet)this.rs).close(this.stmtId);
            this.stmtId = "0";
            this.closed = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        return this.read(byArray, 0, (int)l);
    }

    protected long getAvailable() {
        return this.available;
    }

    protected long amountRead() {
        return this.amountRead;
    }

    protected long totalLength() {
        return this.totalLength;
    }

    private byte[] getMoreData() throws SQLException {
        return ((TeraResultSet)this.rs).getBlobData(this, this.locator, this.stmtId, "BlobData");
    }
}

