/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3.ifjdbc_4;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.PreparedParameter;
import com.teradata.jdbc.StatementParameters;
import com.teradata.jdbc.jdbc_4.Blob;
import com.teradata.jdbc.jdbc_4.Clob;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.ParameterSet;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class LocalStatementParameters
extends StatementParameters {
    private PreparedStatement prepStmt;
    private HashMap deferredLobs = new HashMap();

    LocalStatementParameters(String string, ConnectionOptions connectionOptions, PreparedStatement preparedStatement) {
        super(string, connectionOptions, preparedStatement.getConnection());
        this.setCurrentParamSet(new ParameterSet(this.getNumOfParams(), null));
        this.prepStmt = preparedStatement;
    }

    protected String buildStatement(PreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement.getConnection().outParamArgSupported()) {
            this.setOutOnlyParams();
        } else {
            this.replaceOutParams();
        }
        if (this.getNumOfParams() > 0) {
            ParameterSet parameterSet = this.getCurrentParamSet();
            this.getData(preparedStatement, parameterSet);
            this.setDataInfo(preparedStatement);
            preparedStatement.getParameterProperties().validateAndAdjustParameterSet(parameterSet, this, this.conOptions.getURLParams().getJavaEnCoding());
            preparedStatement.getParameterProperties().addParameterSet(parameterSet);
        }
        return this.getSql();
    }

    public void addBatchData(PreparedStatement preparedStatement) throws SQLException {
        if (this.getNumOfParams() > 0) {
            int n = this.getCurrentParamSet().getUnsetParameter();
            if (n != 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ184", n);
            }
            ParameterSet parameterSet = new ParameterSet(this.getCurrentParamSet(), preparedStatement.getParameterProperties());
            this.getData(preparedStatement, parameterSet);
            this.setDataInfo(preparedStatement);
            preparedStatement.getParameterProperties().addParameterSet(parameterSet);
        }
    }

    public void clearBatchData() {
        this.clearParameters();
        if (this.prepStmt != null && this.prepStmt.getParameterProperties() != null) {
            this.prepStmt.getParameterProperties().clear();
        }
    }

    public String buildBatchStatement(PreparedStatement preparedStatement) throws SQLException {
        if (this.getNumOfParams() > 0) {
            preparedStatement.getParameterProperties().adjustParameters(this, this.conOptions.getURLParams().getJavaEnCoding());
            this.calculateDataInfo();
        }
        return this.getSql();
    }

    protected void setDataInfo(PreparedStatement preparedStatement) throws SQLException {
        ParameterProperties parameterProperties = preparedStatement.getParameterProperties();
        if (parameterProperties.getDataInfoFields() == null) {
            for (int i = 1; i <= this.getNumOfParams(); ++i) {
                parameterProperties.setDataInfoField(i, this.getDataInfoField(i).getType(), this.getDataInfoField(i).getLength(), this.getDataInfoField(i).getScale(), this.getDataInfoField(i).getPrecision(), this.getDataInfoField(i).getSignificantDigits(), this.m_bUseDataInfoX);
            }
        } else {
            DataInfoField[] dataInfoFieldArray = preparedStatement.getParameterProperties().getDataInfoFields();
            for (int i = 1; i <= this.getNumOfParams(); ++i) {
                this.setDataInfoType(i, this.getColDataType(i));
                this.setDataInfoSignificantDigits(i, this.getSignificantDigits(i));
                this.setDataInfoPrec(i, this.getColPrecision(i));
                this.setDataInfoLength(i, this.getColDataLength(i));
                this.setDataInfoScale(i, this.getColScale(i));
            }
        }
    }

    private void setDataInfoLength(int n, long l) {
        ParameterProperties parameterProperties = this.prepStmt.getParameterProperties();
        if (parameterProperties.getDataInfoLength(n) < l) {
            parameterProperties.setDataInfoLength(n, l);
        }
    }

    private void setDataInfoType(int n, int n2) throws SQLException {
        ParameterProperties parameterProperties = this.prepStmt.getParameterProperties();
        short s = (short)ComUtil.teraTypesMatch(parameterProperties.getDataInfoType(n), n2);
        if (s >= 0) {
            parameterProperties.setDataInfoType(n, s);
        } else {
            ComUtil.ThrowExcp(257, ErrorMessage.Format3(ErrorMessage.messages.getString("TJ229"), String.valueOf(n), String.valueOf(n2), String.valueOf(parameterProperties.getDataInfoType(n))));
        }
    }

    private void setDataInfoScale(int n, int n2) {
        ParameterProperties parameterProperties = this.prepStmt.getParameterProperties();
        if (parameterProperties.getDataInfoScale(n) < n2) {
            parameterProperties.setDataInfoScale(n, n2);
        }
        parameterProperties.setDataInfoAdjustedScale(n, this.m_bUseDataInfoX, this.conOptions.isLargeDecimalAndBigIntSupported());
    }

    private void setDataInfoPrec(int n, int n2) {
        ParameterProperties parameterProperties = this.prepStmt.getParameterProperties();
        if (parameterProperties.getDataInfoPrec(n) < n2) {
            parameterProperties.setDataInfoPrec(n, n2);
        }
    }

    private void setDataInfoSignificantDigits(int n, int n2) {
        ParameterProperties parameterProperties = this.prepStmt.getParameterProperties();
        if (parameterProperties.getDataInfoSignificantDigits(n) < n2) {
            parameterProperties.setDataInfoSignificantDigits(n, n2);
        }
    }

    protected void getData(PreparedStatement preparedStatement, ParameterSet parameterSet) throws SQLException {
        if (this.getNumOfParams() > 0) {
            int n = parameterSet.getUnsetParameter();
            if (n != 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ184", n);
            }
            ParameterProperties parameterProperties = preparedStatement.getParameterProperties();
            if (parameterProperties == null) {
                parameterProperties = new ParameterProperties(this.getNumOfParams());
                preparedStatement.setParameterProperties(parameterProperties);
                parameterSet.setParameterProperties(parameterProperties);
            }
            parameterProperties.setNumberOfOutParams(this.getNumOfOutOnlyParams());
            parameterSet.setNullIndicatorBits(this.createNullIndicatorBitArray(parameterSet));
            parameterSet.setDeferredLobs(this.deferredLobs);
        }
    }

    protected void setOutParams() throws SQLException {
        int n = this.getNumOfParams();
        int n2 = 1;
        ParameterSet parameterSet = this.getCurrentParamSet();
        for (int i = 1; i <= n; ++i) {
            if (parameterSet.getParamType(i) != 2 && parameterSet.getParamType(i) != 3) continue;
            this.setOutParam(i, n2++);
        }
    }

    public int addLob(InputStream inputStream, long l) {
        Blob blob = new Blob(inputStream);
        blob.setLength(l);
        return this.addLob(blob);
    }

    public int addLob(Reader reader, long l) {
        Clob clob = new Clob(reader, this.m_session.getLog());
        clob.setLength(l);
        return this.addLob(clob);
    }

    private int addLob(Object object) {
        Integer n = this.m_session.getLobToken();
        this.deferredLobs.put(n, object);
        return n;
    }

    protected void calculateDataInfo() throws SQLException {
        ParameterProperties parameterProperties = this.prepStmt.getParameterProperties();
        if (parameterProperties == null) {
            return;
        }
        ArrayList arrayList = parameterProperties.getParameterSets();
        for (int i = 0; i < arrayList.size(); ++i) {
            PreparedParameter[] preparedParameterArray = ((ParameterSet)arrayList.get(i)).getPreparedParameters();
            block5: for (int j = 0; j < preparedParameterArray.length; ++j) {
                PreparedParameter preparedParameter = preparedParameterArray[j];
                switch (preparedParameter.getSqlType()) {
                    case 484: 
                    case 485: {
                        if (preparedParameter.getValue() == null || preparedParameter.getScale() == parameterProperties.getDataInfoScale(j + 1)) continue block5;
                        preparedParameter.resetDecimal(parameterProperties.getDataInfoScale(j + 1));
                        continue block5;
                    }
                    case 452: 
                    case 453: 
                    case 760: 
                    case 761: 
                    case 764: 
                    case 765: 
                    case 768: 
                    case 769: 
                    case 772: 
                    case 773: {
                        if (preparedParameter.isNullValue() && preparedParameter.getLength() != (int)parameterProperties.getDataInfoLength(j + 1)) {
                            preparedParameter.resetToSpaces((int)parameterProperties.getDataInfoLength(j + 1), this.conOptions.getURLParams().getJavaEnCoding());
                            continue block5;
                        }
                        if (preparedParameter.getScale() == parameterProperties.getDataInfoScale(j + 1)) continue block5;
                        preparedParameter.resetTimeAndTimestamp(parameterProperties.getDataInfoScale(j + 1), this.conOptions.getURLParams().getJavaEnCoding());
                        continue block5;
                    }
                }
            }
        }
    }
}

