/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3.ifjdbc_4;

import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.TeraCallableStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.LocalStatementParameters;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalResultSet;
import com.teradata.jdbc.jdbc_4.CallableStatement;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class TeraLocalCallableStatement
extends TeraCallableStatement {
    private CallableStatement tdCallableStmt;
    protected Log log;

    TeraLocalCallableStatement(TeraLocalConnection teraLocalConnection, String string, ConnectionOptions connectionOptions, int n, int n2) throws SQLException {
        super(teraLocalConnection, string, connectionOptions);
        this.log = teraLocalConnection.getTDSession().getLog();
        this.initCallableStatement(teraLocalConnection, string, n, n2);
    }

    private void initCallableStatement(TeraLocalConnection teraLocalConnection, String string, int n, int n2) throws SQLException {
        this.tdCallableStmt = teraLocalConnection.getTDSession().createCallableStatement(string, n, n2);
        this.RS = new TeraLocalResultSet();
        this.stmtParams = new LocalStatementParameters(string, this.getConnectionOptions(), this.tdCallableStmt);
        this.stmtParams.initOutputParameters();
        ((TeraLocalResultSet)this.RS).setTeraStatement(this);
        super.setParameterMarkerMetaData(this.tdCallableStmt.getParameterMarkerMetaData());
    }

    protected CallableStatement getTdCallableStmt() {
        return this.tdCallableStmt;
    }

    private void postProcessResults() throws SQLException {
        ((TeraLocalResultSet)this.RS).setResultSet(this.tdCallableStmt.getOutParamResultSet());
        this.stmtParams.setOutParams();
    }

    public ResultSet executeQuery() throws SQLException {
        String string = this.stmtParams.buildStatement(this.tdCallableStmt);
        this.tdCallableStmt.executeQuery(string);
        this.postProcessResults();
        return this.internalGetResultSet(false, false);
    }

    public int executeUpdate() throws SQLException {
        String string = this.stmtParams.buildStatement(this.tdCallableStmt);
        int n = this.tdCallableStmt.executeUpdate(string);
        this.postProcessResults();
        return n;
    }

    public boolean execute() throws SQLException {
        String string = this.stmtParams.buildStatement(this.tdCallableStmt);
        boolean bl = this.tdCallableStmt.execute(string);
        this.postProcessResults();
        return bl;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.internalGetResultSet(true, false);
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.tdCallableStmt.getMoreResults(n);
    }

    public int getUpdateCount() throws SQLException {
        return this.tdCallableStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.tdCallableStmt.getMoreResults();
    }

    public int getMaxRows() throws SQLException {
        return this.tdCallableStmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.tdCallableStmt.setMaxRows(n);
    }

    public void close() throws SQLException {
        this.tdCallableStmt.close();
    }

    public void cancel() throws SQLException {
        this.tdCallableStmt.cancel();
    }

    public void clearBatch() throws SQLException {
        this.stmtParams.clearBatchData();
    }

    public void addBatch() throws SQLException {
        this.stmtParams.addBatchData(this.tdCallableStmt);
    }

    public int[] executeBatch() throws SQLException {
        String string = this.stmtParams.buildBatchStatement(this.tdCallableStmt);
        return this.tdCallableStmt.executeBatchDMLArray(string);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.tdCallableStmt.getMetaData();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.tdCallableStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.tdCallableStmt.setMaxFieldSize(n);
    }

    public int getQueryTimeout() {
        return this.tdCallableStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) {
        this.tdCallableStmt.setQueryTimeout(n);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.tdCallableStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.tdCallableStmt.clearWarnings();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.tdCallableStmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.tdCallableStmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.tdCallableStmt.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.tdCallableStmt.getFetchSize();
    }

    public int getResultSetConcurrency() {
        return this.tdCallableStmt.getResultSetConcurrency();
    }

    public int getResultSetType() {
        return this.tdCallableStmt.getResultSetType();
    }

    protected Statement getStatementDelegate() {
        return this.tdCallableStmt;
    }
}

