/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3.ifjdbc_4;

import com.teradata.jdbc.TeraConnection;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalCallableStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalStatement;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class TeraLocalConnection
extends TeraConnection {
    private TDSession tdSession;

    public TeraLocalConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(uRLParameters);
        LogonInformation logonInformation = new LogonInformation(string2, string3);
        if (uRLParameters.getAccountId().compareTo("NO_ACCOUNT_ID") != 0) {
            logonInformation.setAccount(uRLParameters.getAccountId());
        }
        try {
            this.tdSession = new TDSession(string, logonInformation, uRLParameters, this);
        }
        catch (JDBCException jDBCException) {
            this.setErrMsg(jDBCException.getMessage());
            this.close();
            throw jDBCException;
        }
        this.setSessOpen(true);
        this.conOptions.setLobSupported(this.tdSession.isLobSupported());
        this.conOptions.setLargeDecimalAndBigIntSupported(this.tdSession.isLargeDecimalAndBigIntSupported());
    }

    public Statement createStatement() throws SQLException {
        return new TeraLocalStatement(this, this.conOptions, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.tdSession.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.tdSession.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.tdSession.commit();
    }

    public void rollback() throws SQLException {
        this.tdSession.rollBack();
    }

    public void close() throws SQLException {
        if (this.getSessOpen()) {
            this.setSessOpen(false);
            if (this.tdSession != null) {
                this.tdSession.close();
                if (!this.conOptions.getURLParams().isJavaSPDefaultConnection()) {
                    this.tdSession = null;
                }
            }
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.getTDSession().getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.getTDSession().clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return new TeraLocalStatement(this, this.conOptions, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        string = EscapeUtil.nativeSQL(string, this.tdSession.getLocalEscapeFunctions());
        return new TeraLocalPreparedStatement(this, string, this.conOptions, n, n2, null);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        string = EscapeUtil.nativeSQL(string, this.tdSession.getLocalEscapeFunctions());
        return new TeraLocalCallableStatement(this, string, this.conOptions, n, n2);
    }

    public TDSession getTDSession() {
        return this.tdSession;
    }

    public boolean isClosed() throws SQLException {
        if (this.tdSession == null) {
            return true;
        }
        return this.tdSession.isClosed();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.tdSession.getTransactionIsolation();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.tdSession.setTransactionIsolation(n);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n == 2) {
            return this.prepareStatement(string);
        }
        return this.preparedGenKeyStatement(string, new GeneratedKeys(n, this.tdSession));
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.preparedGenKeyStatement(string, new GeneratedKeys(nArray, this.tdSession));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.preparedGenKeyStatement(string, new GeneratedKeys(stringArray, this.tdSession));
    }

    private PreparedStatement preparedGenKeyStatement(String string, GeneratedKeys generatedKeys) throws SQLException {
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        string = EscapeUtil.nativeSQL(string, this.tdSession.getLocalEscapeFunctions());
        return new TeraLocalPreparedStatement(this, string, this.conOptions, 1003, 1007, generatedKeys);
    }

    public void changeURLParams(URLParameters uRLParameters) throws SQLException {
        this.getTDSession().updateURLParameters(uRLParameters);
        this.getConnectionOptions().setLobSupported(this.getTDSession().isLobSupported());
    }
}

