/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3.ifjdbc_4;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraPreparedStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.LocalStatementParameters;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class TeraLocalPreparedStatement
extends TeraPreparedStatement {
    protected PreparedStatement prepStmt;
    protected Log log;

    TeraLocalPreparedStatement(TeraLocalConnection teraLocalConnection, String string, ConnectionOptions connectionOptions, int n, int n2, GeneratedKeys generatedKeys) throws SQLException {
        super(teraLocalConnection, string, connectionOptions);
        this.log = teraLocalConnection.getTDSession().getLog();
        this.prepStmt = teraLocalConnection.getTDSession().createPreparedStatement(string, n, n2, generatedKeys);
        this.stmtParams = new LocalStatementParameters(string, connectionOptions, this.prepStmt);
        super.setParameterMarkerMetaData(this.prepStmt.getParameterMarkerMetaData());
    }

    public ResultSet executeQuery() throws SQLException {
        String string = this.stmtParams.buildStatement(this.prepStmt);
        this.prepStmt.executeQuery(string);
        return this.internalGetResultSet(false, false);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public int executeUpdate() throws SQLException {
        String string = this.stmtParams.buildStatement(this.prepStmt);
        return this.prepStmt.executeUpdate(string);
    }

    public int executeUpdate(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public boolean execute() throws SQLException {
        String string = this.stmtParams.buildStatement(this.prepStmt);
        return this.prepStmt.execute(string);
    }

    public boolean execute(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("INVALID_METHOD");
    }

    public ResultSet getResultSet() throws SQLException {
        return this.internalGetResultSet(true, false);
    }

    public int getUpdateCount() throws SQLException {
        return this.prepStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.prepStmt.getMoreResults();
    }

    public int getMaxRows() throws SQLException {
        return this.prepStmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.prepStmt.setMaxRows(n);
    }

    public void close() throws SQLException {
        this.prepStmt.close();
    }

    public void cancel() throws SQLException {
        this.prepStmt.cancel();
    }

    public PreparedStatement getPreparedStatement() {
        return this.prepStmt;
    }

    public void clearBatch() throws SQLException {
        this.stmtParams.clearBatchData();
    }

    public void addBatch() throws SQLException {
        if (!((TeraLocalConnection)this.getConnection()).getTDSession().arraySupported()) {
            ComUtil.ThrowExcp(257, ErrorMessage.messages.getString("TJ170"));
        }
        this.stmtParams.addBatchData(this.prepStmt);
    }

    public int[] executeBatch() throws SQLException {
        if (!((TeraLocalConnection)this.getConnection()).getTDSession().arraySupported()) {
            ComUtil.ThrowExcp(256, ErrorMessage.Format1(ErrorMessage.messages.getString("TJ228"), ((TeraLocalConnection)this.getConnection()).getTDSession().getTeradataDatabaseVersion()));
        }
        String string = this.stmtParams.buildBatchStatement(this.prepStmt);
        return this.prepStmt.executeBatchDMLArray(string);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.prepStmt.getMetaData();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.prepStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.prepStmt.setMaxFieldSize(n);
    }

    public int getQueryTimeout() {
        return this.prepStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) {
        this.prepStmt.setQueryTimeout(n);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.prepStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.prepStmt.clearWarnings();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.prepStmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.prepStmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.prepStmt.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.prepStmt.getFetchSize();
    }

    public int getResultSetConcurrency() {
        return this.prepStmt.getResultSetConcurrency();
    }

    public int getResultSetType() {
        return this.prepStmt.getResultSetType();
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (this.prepStmt != null) {
            return this.prepStmt.getMoreResults(n);
        }
        return false;
    }

    protected Statement getStatementDelegate() {
        return this.prepStmt;
    }
}

