/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3.ifjdbc_4;

import com.teradata.jdbc.Blob;
import com.teradata.jdbc.Clob;
import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.TeraResultSet;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalStatement;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class TeraLocalResultSet
extends TeraResultSet {
    private ResultSet resultSet;

    public TeraLocalResultSet(Statement statement, String string) {
        this.tStatement = statement;
        this.sessionJavaCharSet = string;
    }

    public TeraLocalResultSet() {
    }

    TeraLocalResultSet(TeraLocalStatement teraLocalStatement) {
        this.setTeraStatement(teraLocalStatement);
    }

    public void setTeraStatement(TeraStatement teraStatement) {
        this.tStatement = teraStatement;
        this.sessionJavaCharSet = teraStatement.getConnectionOptions().getURLParams().getJavaEnCoding();
    }

    public boolean next() throws SQLException {
        if (this.resultSet != null) {
            return this.resultSet.next();
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.getMetadataRS()) {
            this.setMetadataRS(false);
            if (this.tStatement != null) {
                this.tStatement.close();
            }
            this.tStatement = null;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.clearWarnings();
        if (this.ColJavaTypes != null) {
            this.ColJavaTypes.removeAllElements();
            this.ColJavaTypes = null;
        }
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public int getConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass().getName().compareTo("[B") == 0) {
                return new String((byte[])object, this.sessionJavaCharSet);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", this.sessionJavaCharSet);
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) != 0;
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public int getInt(int n) throws SQLException {
        return this.getInt(this.resultSet.getObject(n));
    }

    public long getLong(int n) throws SQLException {
        return this.getLong(this.resultSet.getObject(n));
    }

    public float getFloat(int n) throws SQLException {
        return this.getFloat(this.resultSet.getObject(n));
    }

    public double getDouble(int n) throws SQLException {
        return this.getDouble(this.resultSet.getObject(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(this.resultSet.getObject(n), n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getBytes(this.resultSet.getObject(n));
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(this.resultSet.getObject(n));
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, (Calendar)null);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (this.getString(n) == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(this.getString(n).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", "ASCII");
        }
        return byteArrayInputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return new ByteArrayInputStream(this.getString(n).getBytes());
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getBinaryStream(this.resultSet.getObject(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), (Calendar)null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), (Calendar)null);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        Object object = this.resultSet.getObject(n);
        int n2 = this.getMetaData().getColumnType(n);
        switch (n2) {
            case 92: {
                object = this.getTime(object, null);
                break;
            }
            case 93: {
                object = this.getTimestamp(object, null);
                break;
            }
            case 91: {
                object = this.getDate(object);
                break;
            }
            case 2004: {
                if (!(object instanceof com.teradata.jdbc.jdbc_4.Blob)) break;
                object = this.getBlob(n);
                break;
            }
            case 2005: {
                if (!(object instanceof com.teradata.jdbc.jdbc_4.Clob)) break;
                object = this.getClob(n);
                break;
            }
            case -6: 
            case 5: {
                if (!(object instanceof Short)) break;
                object = new Integer(((Short)object).intValue());
                break;
            }
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        return super.findColumn(string);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        TeraResultSetMetaData teraResultSetMetaData = resultSet == null ? null : resultSet.getMetaData();
        int n = teraResultSetMetaData == null ? 0 : teraResultSetMetaData.getColumnCount();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 1; i <= n; ++i) {
            String string = teraResultSetMetaData.getColumnName(i);
            if (string == null) {
                string = teraResultSetMetaData.getColumnLabel(i);
            }
            vector.add(i - 1, string);
        }
        this.ColNames = vector;
        Vector<String> vector2 = new Vector<String>(n);
        for (int i = 1; i <= n; ++i) {
            vector2.add(i - 1, teraResultSetMetaData.getColumnLabel(i));
        }
        this.ColLabel = vector2;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.getString(n) == null ? null : new StringReader(this.getString(n));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(this.resultSet.getObject(n), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.resultSet.getObject(n), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public java.sql.Blob getBlob(int n) throws SQLException {
        Object object = this.resultSet.getObject(n);
        if (object != null && !(object instanceof com.teradata.jdbc.jdbc_4.Blob)) {
            ComUtil.ThrowExcp(47, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ220"), "getBlob", object.getClass().getName()));
        }
        if (object != null) {
            object = new Blob(new com.teradata.jdbc.jdbc_4.Blob((com.teradata.jdbc.jdbc_4.Blob)object));
        }
        return (java.sql.Blob)object;
    }

    public java.sql.Clob getClob(int n) throws SQLException {
        Object object = this.resultSet.getObject(n);
        if (object != null && !(object instanceof com.teradata.jdbc.jdbc_4.Clob)) {
            ComUtil.ThrowExcp(47, ErrorMessage.Format2(ErrorMessage.messages.getString("TJ221"), "getClob", object.getClass().getName()));
        }
        if (object != null) {
            object = new Clob(new com.teradata.jdbc.jdbc_4.Clob((com.teradata.jdbc.jdbc_4.Clob)object));
        }
        return (java.sql.Clob)object;
    }

    public java.sql.Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public java.sql.Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public boolean absolute(int n) throws SQLException {
        return this.resultSet.absolute(n);
    }

    public void afterLast() throws SQLException {
        this.resultSet.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
    }

    public boolean first() throws SQLException {
        return this.resultSet.first();
    }

    public int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public int getType() throws SQLException {
        return this.resultSet.getType();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        return this.resultSet.relative(n);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.resultSet.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.resultSet.setFetchSize(n);
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateInt(n, n2);
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateDouble(n, d);
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateBigDecimal(n, bigDecimal);
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBlob(int n, java.sql.Blob blob) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateBlob(n, blob);
        }
    }

    public void updateBlob(String string, java.sql.Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateByte(n, by);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateBytes(n, byArray);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateClob(int n, java.sql.Clob clob) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateClob(n, clob);
        }
    }

    public void updateClob(String string, java.sql.Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateDate(n, date);
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateFloat(n, f);
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateLong(n, l);
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateNull(n);
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateShort(int n, short s) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateShort(n, s);
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateString(n, string);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateTime(n, time);
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateTimestamp(n, timestamp);
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateAsciiStream(n, inputStream, n2);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateBinaryStream(n, inputStream, n2);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateCharacterStream(n, reader, n2);
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateObject(n, object);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateObject(n, object, n2);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.updateRow();
        }
    }

    public void deleteRow() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.deleteRow();
        }
    }

    public void insertRow() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.insertRow();
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.moveToInsertRow();
        }
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.moveToCurrentRow();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.cancelRowUpdates();
        }
    }

    public Array getArray(int n) throws SQLException {
        this.resultSet.validateRowPositionForGet(String.valueOf(n));
        return super.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        this.resultSet.validateRowPositionForGet(string);
        return super.getArray(string);
    }

    public URL getURL(int n) throws SQLException {
        this.resultSet.validateRowPositionForGet(String.valueOf(n));
        return super.getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        this.resultSet.validateRowPositionForGet(string);
        return super.getURL(string);
    }

    public Ref getRef(int n) throws SQLException {
        this.resultSet.validateRowPositionForGet(String.valueOf(n));
        return super.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        this.resultSet.validateRowPositionForGet(string);
        return super.getRef(string);
    }
}

