/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_3.ifjdbc_4;

import com.teradata.jdbc.ConnectionOptions;
import com.teradata.jdbc.TeraStatement;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_3.util.jdbcVector;
import com.teradata.jdbc.jdbc_4.CreateProcedureStatement;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class TeraLocalStatement
extends TeraStatement {
    private TDSession tdSession;
    private Statement stmt = null;
    private boolean resultSetReturned = false;

    TeraLocalStatement(TeraLocalConnection teraLocalConnection, ConnectionOptions connectionOptions, int n, int n2) throws SQLException {
        super(teraLocalConnection, null, "0", connectionOptions);
        this.tdSession = teraLocalConnection.getTDSession();
        this.setStatement(this.tdSession.createCreateProcedureStatement(n, n2));
    }

    public ResultSet executeQuery(String string, byte[] byArray) throws SQLException {
        string = this.parseCreateProcedure(string);
        this.clearWarnings();
        if (!this.isCreateProcedure()) {
            this.stmt.executeQuery(string);
        } else {
            ((CreateProcedureStatement)this.stmt).executeQuery(string, this.conOptions.getURLParams().getSpl() == 4 ? (byte)78 : 89);
        }
        return this.internalGetResultSet(false, false);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.stmt.setGeneratedKeys(null);
        return this.executeQuery(string, new byte[0]);
    }

    public int executeUpdate(String string) throws SQLException {
        this.stmt.setGeneratedKeys(null);
        return this.executeUpdate(string, new byte[0]);
    }

    public int executeUpdate(String string, byte[] byArray) throws SQLException {
        int n = 0;
        string = this.parseCreateProcedure(string);
        this.clearWarnings();
        n = !this.isCreateProcedure() ? this.stmt.executeUpdate(string) : ((CreateProcedureStatement)this.stmt).executeUpdate(string, this.conOptions.getURLParams().getSpl() == 4 ? (byte)78 : 89);
        return n;
    }

    public void close() throws SQLException {
        this.stmt.close();
        this.cleanUp();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.stmt.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.stmt.setMaxRows(n);
    }

    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.stmt.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getWarnings();
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (this.stmt != null) {
            this.stmt.clearWarnings();
        }
    }

    public boolean execute(String string) throws SQLException {
        this.stmt.setGeneratedKeys(null);
        return this.execute(string, new byte[0]);
    }

    public boolean execute(String string, byte[] byArray) throws SQLException {
        string = this.parseCreateProcedure(string);
        this.clearWarnings();
        this.resultSetReturned = !this.isCreateProcedure() ? this.stmt.execute(string) : ((CreateProcedureStatement)this.stmt).execute(string, this.conOptions.getURLParams().getSpl() == 4 ? (byte)78 : 89);
        return this.resultSetReturned;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.internalGetResultSet(true, false);
    }

    public int getUpdateCount() throws SQLException {
        if (this.stmt == null) {
            return -1;
        }
        return this.stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.stmt != null) {
            this.resultSetReturned = this.stmt.getMoreResults();
            return this.resultSetReturned;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setFetchDirection(n);
        }
    }

    public int getFetchDirection() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getFetchDirection();
        }
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setFetchSize(n);
        }
    }

    public int getFetchSize() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getFetchSize();
        }
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getResultSetConcurrency();
        }
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getResultSetType();
        }
        return 1003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        this.stmt.setGeneratedKeys(null);
        try {
            jdbcVector jdbcVector2 = this.getBatchVector();
            int[] nArray = new int[jdbcVector2.size()];
            StringBuffer stringBuffer = new StringBuffer(this.getBatchLength() + 1);
            for (int i = 0; i < jdbcVector2.size(); ++i) {
                stringBuffer.append((String)jdbcVector2.elementAt(i));
            }
            this.clearWarnings();
            int[] nArray2 = nArray = this.stmt.executeBatchMSR(stringBuffer.toString(), jdbcVector2.size());
            return nArray2;
        }
        finally {
            this.clearBatch();
        }
    }

    protected void setStatement(Statement statement) {
        this.stmt = statement;
    }

    protected Statement getStatement() {
        return this.stmt;
    }

    protected String parseCreateProcedure(String string) throws SQLException {
        string = super.parseCreateProcedure(string);
        return string;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (n == 2) {
            return this.executeUpdate(string);
        }
        this.stmt.setGeneratedKeys(new GeneratedKeys(n, this.stmt.getConnection()));
        return this.executeUpdate(string, new byte[0]);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.stmt.setGeneratedKeys(new GeneratedKeys(nArray, this.stmt.getConnection()));
        return this.executeUpdate(string, new byte[0]);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.stmt.setGeneratedKeys(new GeneratedKeys(stringArray, this.stmt.getConnection()));
        return this.executeUpdate(string, new byte[0]);
    }

    public boolean execute(String string, int n) throws SQLException {
        if (n == 2) {
            return this.execute(string);
        }
        this.stmt.setGeneratedKeys(new GeneratedKeys(n, this.stmt.getConnection()));
        return this.execute(string, new byte[0]);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.stmt.setGeneratedKeys(new GeneratedKeys(nArray, this.stmt.getConnection()));
        return this.execute(string, new byte[0]);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.stmt.setGeneratedKeys(new GeneratedKeys(stringArray, this.stmt.getConnection()));
        return this.execute(string, new byte[0]);
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (this.stmt != null) {
            this.resultSetReturned = this.stmt.getMoreResults(n);
            return this.resultSetReturned;
        }
        return false;
    }

    protected Statement getStatementDelegate() {
        return this.stmt;
    }
}

